package com.tydic.datasync.event.advice;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.DataSyncConstant;
import com.tydic.datasync.event.handler.EventMsgSenderService;
import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.base.constants.MdcConstants;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.UUID;

/**
 * 标题:DataSyncLoggerAspect
 * 说明:日志切面
 * 时间:2022/2/22 12:07
 *
 * @author hegy2017
 */
@Aspect
@Component
@Order(10)
@Slf4j
public class DataSyncLoggerAspect {

    /**
     * 缓存对象
     */
    @Autowired
    private CacheClient cacheClient;

    /**
     * 消息队列
     */
    @Autowired
    private EventMsgSenderService eventMsgSenderService;


    public DataSyncLoggerAspect() {
        log.info("DataSyncLoggerAspect初始化");
    }

    @Pointcut("(execution(* com.tydic.dyc.busicommon.*.impl..*(..))) ")
    public void pointCut() {

    }

    @Around("pointCut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        String traceId = "";
        /**
         * 给参数中设置流水号，
         */

        Object[] args = pjp.getArgs();
        MethodSignature methodSignature = (MethodSignature) pjp.getSignature();
        Method method = methodSignature.getMethod();
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        String classPath = className + "." + methodName;
        if(log.isDebugEnabled()){
            log.debug("数据同步组件，应用层类路径为：" + classPath);
        }


        if (null != args && args.length > 0) {
            for (Object arg : args) {
                // 判断Bean是否包含值为null链路ID字段
                if (DataSyncAppEventByPointCutAdvice.fieldIsNull(arg, MdcConstants.REQUEST_ID)) {
                    Object object = BeanUtil.getFieldValue(arg, MdcConstants.REQUEST_ID);
                    if (Objects.isNull(object)) {
                        traceId =
                                DataSyncConstant.CACHE_PREFIX + DataSyncConstant.CONNECTOR_SYMBOL + UUID.randomUUID().toString().replace("-", "");
                        log.info("数据同步组件，应用层生成traceId:" + traceId);
                        BeanUtil.setFieldValue(arg, MdcConstants.REQUEST_ID, traceId);
                        break;
                    }
                }
            }
        }


        log.info("数据同步组件，应用层traceId为:" + traceId);


        /**
         * 执行切面
         */
        if(log.isDebugEnabled()){
            log.debug("数据同步组件，应用层入参为：" + JSON.toJSONString(args));
        }
        BaseRspBo rspObj = null;
        try {
            rspObj = (BaseRspBo) pjp.proceed();
        } catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        if(log.isDebugEnabled()){
            log.debug("数据同步组件，应用层出参为：" + JSON.toJSONString(rspObj));
        }

        /**
         * 应用层调用，需要发送MQ消息
         */
        final String eventsList = (String) cacheClient.get(traceId);
        log.info("数据同步组件，应用层从redis获取事件执行出参(traceId=" + traceId + "):" + eventsList);

        if (ObjectUtil.isEmpty(traceId)) {
            log.info("数据同步组件，traceId为空，类路径为：" + classPath);
        }
        if (ObjectUtil.isEmpty(eventsList)) {
            log.info("数据同步组件，redis获取事件执行出参为空，类路径为：" + classPath);
        }

        eventMsgSenderService.sendMsg(traceId, eventsList);

        return rspObj;
    }


}
