package com.tydic.datasync.event.config;

import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import com.tydic.datasync.event.properties.DataSyncEventProperties;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 标题：类名称:EventMqConfiguration
 * 说明：发送事件消息
 * 时间：2022/3/2 2:15 PM
 * 作者 @author hegy2017
 */
@Configuration
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class EventMqConfiguration {


    @Autowired
    private DataSyncEventProperties dataSyncEventProperties;



    @Bean("defaultExteriorProxyMessageConfig")
    public DefaultProxyMessageConfig defaultProxyMessageConfig() {
        DefaultProxyMessageConfig defaultProxyMessageConfig = new DefaultProxyMessageConfig();
        defaultProxyMessageConfig.setId(dataSyncEventProperties.getPid());
        return defaultProxyMessageConfig;
    }

    @Bean(value = "eventProvider", initMethod = "startup", destroyMethod = "shutdown")
    public ProxyProducerFactoryBean exteriorProducerFactoryBean() {
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig(defaultProxyMessageConfig());
        return proxyProducerFactoryBean;
    }
}
