/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datasync.event.handler;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.datasync.event.config.mq.EventMqProvider;
import com.tydic.dyc.base.events.Event;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import redis.clients.jedis.JedisPubSub;

public class RedisEventMessagePubSub
extends JedisPubSub {
    private static final Logger log = LoggerFactory.getLogger(RedisEventMessagePubSub.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private EventMqProvider eventMqProvider;

    public void onMessage(String channel, String message) {
        ChannelEvent channelEvent = (ChannelEvent)JSON.parseObject((String)message, ChannelEvent.class);
        Map<String, List<Event>> eventGroupMap = channelEvent.getTraceEventList().stream().collect(Collectors.groupingBy(Event::getModel));
        for (Map.Entry<String, List<Event>> entry : eventGroupMap.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append("mqEvent");
            sb.append("-");
            sb.append(entry.getKey());
            sb.append("-");
            sb.append(channelEvent.getTraceId());
            this.cacheClient.set(sb.toString(), entry.getValue());
            ChannelEvent mqMessage = new ChannelEvent();
            mqMessage.setTraceId(sb.toString());
            mqMessage.setTraceEventList(entry.getValue());
            this.eventMqProvider.provideMessage(entry.getKey(), mqMessage);
        }
    }
}

