/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dynamic.ds.advice;

import com.tydic.dynamic.ds.config.DynamicDataSourceContextHolder;
import java.lang.reflect.Field;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicDataSourceByPointCutAdvice
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceByPointCutAdvice.class);
    private final String dsTypeFieldName;

    public DynamicDataSourceByPointCutAdvice(String dsTypeFieldName) {
        this.dsTypeFieldName = dsTypeFieldName;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String dsType = "";
        Object[] arguments = invocation.getArguments();
        if (arguments != null) {
            for (Object arg : arguments) {
                Field[] fields;
                for (Field f : fields = arg.getClass().getDeclaredFields()) {
                    f.setAccessible(true);
                    String fieldName = f.getName();
                    if (!fieldName.equals(this.dsTypeFieldName)) continue;
                    dsType = String.valueOf(f.get(arg));
                }
            }
        }
        if (!DynamicDataSourceContextHolder.isContainsDataSource(dsType)) {
            log.error("\u6570\u636e\u6e90 " + dsType + " \u4e0d\u5b58\u5728");
        } else {
            log.debug("\u4f7f\u7528\u6570\u636e\u6e90\uff1a" + dsType);
            DynamicDataSourceContextHolder.setDataSourceType(dsType);
        }
        Object result = invocation.proceed();
        DynamicDataSourceContextHolder.clearDataSourceType();
        return result;
    }
}

