/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dynamic.ds.config;

import com.tydic.dynamic.ds.advice.DynamicDataSourceByPointCutAdvice;
import com.tydic.dynamic.ds.properties.MultipleDataSourceProperties;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(name={"slave.datasource.open-mds"}, havingValue="true")
@EnableConfigurationProperties(value={MultipleDataSourceProperties.class})
public class DynamicDataSourceConfigurableAdvisorConfig {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceConfigurableAdvisorConfig.class);
    private static final String PACKAGE_DELIMITER = ",";
    @Autowired
    private MultipleDataSourceProperties multipleDataSourceProperties;

    @Bean
    @Order(value=-1)
    public AspectJExpressionPointcutAdvisor multipleDataSourceAdvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        StringBuilder expressionBuilder = null;
        if (StringUtils.hasText((String)this.multipleDataSourceProperties.getPointcutPackage())) {
            if (this.multipleDataSourceProperties.getPointcutPackage().contains(PACKAGE_DELIMITER)) {
                String[] nativeRpcPackageSplit;
                for (String nativeRpcPackageString : nativeRpcPackageSplit = this.multipleDataSourceProperties.getPointcutPackage().split(PACKAGE_DELIMITER)) {
                    if (!StringUtils.hasText((String)nativeRpcPackageString)) continue;
                    if (null == expressionBuilder) {
                        expressionBuilder = new StringBuilder();
                        expressionBuilder.append("(execution(* ").append(nativeRpcPackageString).append("..*(..)))");
                        continue;
                    }
                    expressionBuilder.append(" || (execution(* ").append(nativeRpcPackageString).append("..*(..)))");
                }
            } else {
                expressionBuilder = new StringBuilder();
                expressionBuilder.append("(execution(* ").append(this.multipleDataSourceProperties.getPointcutPackage()).append("..*(..)))");
            }
        }
        String expression = String.valueOf(expressionBuilder);
        advisor.setExpression(expression);
        advisor.setAdvice((Advice)new DynamicDataSourceByPointCutAdvice(this.multipleDataSourceProperties.getDsTypeFieldName()));
        log.info("\u591a\u6570\u636e\u6e90\u5207\u9762\u914d\u7f6e\u5b8c\u6210\uff0c\u5207\u70b9\u89c4\u5219\u4e3a\uff1a{}", (Object)expression);
        return advisor;
    }
}

