/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dynamic.ds.config;

import com.tydic.dynamic.ds.config.DynamicDataSource;
import com.tydic.dynamic.ds.config.DynamicDataSourceContextHolder;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class DynamicDataSourceRegister
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceRegister.class);
    private static final String DATASOURCE_TYPE_DEFAULT = "com.zaxxer.hikari.HikariDataSource";
    private DataSource defaultDataSource;
    private Map<String, DataSource> slaveDataSources = new HashMap<String, DataSource>();
    private static final String SPLIT_SYMBOL = ",";

    public void setEnvironment(Environment environment) {
        this.initDefaultDataSource(environment);
        this.initSlaveDataSources(environment);
    }

    private void initDefaultDataSource(Environment env) {
        HashMap<String, Object> dsMap = new HashMap<String, Object>(16);
        dsMap.put("driver", env.getProperty("spring.datasource.driver"));
        dsMap.put("url", env.getProperty("spring.datasource.url"));
        dsMap.put("username", env.getProperty("spring.datasource.username"));
        dsMap.put("password", env.getProperty("spring.datasource.password"));
        this.defaultDataSource = this.buildDataSource(dsMap);
    }

    private void initSlaveDataSources(Environment env) {
        String dsNames = env.getProperty("slave.datasource.names");
        for (String dsPrefix : dsNames.split(SPLIT_SYMBOL)) {
            HashMap<String, Object> dsMap = new HashMap<String, Object>(16);
            dsMap.put("driver", env.getProperty("slave.datasource." + dsPrefix + ".driver"));
            dsMap.put("url", env.getProperty("slave.datasource." + dsPrefix + ".url"));
            dsMap.put("username", env.getProperty("slave.datasource." + dsPrefix + ".username"));
            dsMap.put("password", env.getProperty("slave.datasource." + dsPrefix + ".password"));
            DataSource ds = this.buildDataSource(dsMap);
            this.slaveDataSources.put(dsPrefix, ds);
        }
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        HashMap<String, DataSource> targetDataSources = new HashMap<String, DataSource>(16);
        targetDataSources.put("dataSource", this.defaultDataSource);
        DynamicDataSourceContextHolder.dataSourceIds.add("dataSource");
        targetDataSources.putAll(this.slaveDataSources);
        for (String key : this.slaveDataSources.keySet()) {
            DynamicDataSourceContextHolder.dataSourceIds.add(key);
        }
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(DynamicDataSource.class);
        beanDefinition.setSynthetic(true);
        MutablePropertyValues mpv = beanDefinition.getPropertyValues();
        mpv.addPropertyValue("defaultTargetDataSource", (Object)this.defaultDataSource);
        mpv.addPropertyValue("targetDataSources", targetDataSources);
        beanDefinitionRegistry.registerBeanDefinition("dataSource", (BeanDefinition)beanDefinition);
        log.info("Dynamic DataSource Registry success...");
    }

    public DataSource buildDataSource(Map<String, Object> dataSourceMap) {
        try {
            Object type = dataSourceMap.get("type");
            if (type == null) {
                type = DATASOURCE_TYPE_DEFAULT;
            }
            Class<?> dataSourceType = Class.forName((String)type);
            String driverClassName = dataSourceMap.get("driver").toString();
            String url = dataSourceMap.get("url").toString();
            String username = dataSourceMap.get("username").toString();
            String password = dataSourceMap.get("password").toString();
            DataSourceBuilder factory = DataSourceBuilder.create().driverClassName(driverClassName).url(url).username(username).password(password).type(dataSourceType);
            return factory.build();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

