/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.license.creator.service;

import com.ohaotian.license.core.model.LicenseCreatorManager;
import com.ohaotian.license.core.model.LicenseCreatorParam;
import com.ohaotian.license.core.model.LicenseResult;
import com.ohaotian.license.core.result.ResponseResult;
import com.ohaotian.license.core.utils.DateUtils;
import java.text.MessageFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LicenseCreatorService {
    private static final Logger log = LoggerFactory.getLogger(LicenseCreatorService.class);

    public ResponseResult generateLicense(LicenseCreatorParam param) {
        LicenseCreatorManager licenseCreator = new LicenseCreatorManager(param);
        LicenseResult licenseResult = licenseCreator.generateLicense();
        if (licenseResult.getResult().booleanValue()) {
            String message = MessageFormat.format("\u8bc1\u4e66\u751f\u6210\u6210\u529f\uff0c\u8bc1\u4e66\u6709\u6548\u671f\uff1a{0} - {1}", DateUtils.date2Str((Date)param.getIssuedTime()), DateUtils.date2Str((Date)param.getExpiryTime()));
            log.debug(message);
            return ResponseResult.ok((String)message, (Object)param);
        }
        return ResponseResult.fail((String)"\u8bc1\u4e66\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff01");
    }
}

