/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.license.verify.interceptor;

import com.ohaotian.license.core.exception.CommonException;
import com.ohaotian.license.core.model.LicenseResult;
import com.ohaotian.license.core.model.LicenseVerifyManager;
import com.ohaotian.license.core.result.ResultCode;
import com.ohaotian.license.verify.annotion.VLicense;
import com.ohaotian.license.verify.config.LicenseVerifyProperties;
import com.ohaotian.license.verify.listener.AbstractCustomVerifyListener;
import de.schlichtherle.license.LicenseContent;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class LicenseVerifyInterceptor
implements HandlerInterceptor {
    private final String LICENSE_MSG = "licenseMsg";
    @Autowired
    private LicenseVerifyProperties properties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod;
        Method method;
        VLicense annotation;
        if (handler instanceof HandlerMethod && !ObjectUtils.isEmpty((Object)(annotation = (method = (handlerMethod = (HandlerMethod)handler).getMethod()).getAnnotation(VLicense.class)))) {
            LicenseVerifyManager licenseVerifyManager = new LicenseVerifyManager();
            LicenseResult verifyResult = licenseVerifyManager.verify(this.properties.getVerifyParam());
            if (!verifyResult.getResult().booleanValue()) {
                throw new CommonException(verifyResult.getMessage());
            }
            LicenseContent content = verifyResult.getContent();
            if (verifyResult.getResult().booleanValue()) {
                List<AbstractCustomVerifyListener> customListenerList = AbstractCustomVerifyListener.getCustomListenerList();
                boolean compare = true;
                for (AbstractCustomVerifyListener listener : customListenerList) {
                    LicenseResult licenseResult = listener.verify(content);
                    if (!StringUtils.isEmpty((Object)licenseResult.getMessage())) {
                        response.setHeader("licenseMsg", licenseResult.getMessage());
                    }
                    boolean verify = licenseResult.getResult();
                    compare = compare && verify;
                }
                return compare;
            }
            throw new CommonException(ResultCode.FAIL, verifyResult.getException().getMessage());
        }
        return true;
    }
}

