/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.license.verify.listener;

import com.ohaotian.license.core.exception.CommonException;
import com.ohaotian.license.core.model.LicenseExtraParam;
import com.ohaotian.license.core.model.LicenseResult;
import com.ohaotian.license.core.utils.DateUtils;
import com.ohaotian.license.verify.listener.AbstractCustomVerifyListener;
import de.schlichtherle.license.LicenseContent;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExpirationReminderVerifyListener
extends AbstractCustomVerifyListener {
    private static final Logger log = LoggerFactory.getLogger(ExpirationReminderVerifyListener.class);

    @Override
    public LicenseResult verify(LicenseContent content) throws CommonException {
        log.debug("======= \u81ea\u5b9a\u4e49\u8bc1\u4e66\u9a8c\u8bc1\u76d1\u542c\u5668,\u9a8c\u8bc1\u5230\u671f\u63d0\u9192\u65f6\u95f4\uff0c\u5b9e\u73b0verify\u65b9\u6cd5  =======");
        LicenseExtraParam licenseCheck = (LicenseExtraParam)content.getExtra();
        Date reminderTime = licenseCheck.getReminderTime();
        Date notAfter = content.getNotAfter();
        Date now = new Date();
        if (now.after(reminderTime)) {
            int days = DateUtils.differentDays((Date)notAfter, (Date)now);
            String remindMsg = String.valueOf(days);
            return new LicenseResult(remindMsg, content);
        }
        return new LicenseResult();
    }
}

