/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.license.verify.listener;

import com.ohaotian.license.core.model.LicenseResult;
import com.ohaotian.license.core.model.LicenseVerifyManager;
import com.ohaotian.license.core.utils.FileUtils;
import com.ohaotian.license.verify.config.LicenseVerifyProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

@Component
@EnableScheduling
public class LicenseVerifyListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(LicenseVerifyListener.class);
    @Autowired
    private LicenseVerifyProperties properties;
    @Value(value="${license.refresh:true}")
    private boolean refresh;
    private static String md5 = "";
    private static boolean isLoad = false;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!StringUtils.isEmpty((Object)this.properties.getLicensePath())) {
            this.install();
            try {
                String readMd5 = this.getMd5(this.properties.getLicensePath());
                isLoad = true;
                if (md5 == null || "".equals(md5)) {
                    md5 = readMd5;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Scheduled(cron="0 0/2 * * * ?")
    protected void timer() throws Exception {
        if (!this.refresh) {
            return;
        }
        if (!isLoad) {
            return;
        }
        String readMd5 = this.getMd5(this.properties.getLicensePath());
        if (!readMd5.equals(md5)) {
            this.install();
            md5 = readMd5;
        }
    }

    private void install() {
        log.debug("++++++++ \u5f00\u59cb\u5b89\u88c5\u8bc1\u4e66 ++++++++");
        LicenseVerifyManager licenseVerifyManager = new LicenseVerifyManager();
        LicenseResult result = licenseVerifyManager.install(this.properties.getVerifyParam());
        if (result.getResult().booleanValue()) {
            log.debug("++++++++ \u8bc1\u4e66\u5b89\u88c5\u6210\u529f ++++++++");
        } else {
            log.debug("++++++++ \u8bc1\u4e66\u5b89\u88c5\u5931\u8d25 ++++++++");
        }
    }

    public String getMd5(String filePath) throws Exception {
        String md5 = "";
        try {
            File file = FileUtils.getFile((String)filePath);
            if (file.exists()) {
                FileInputStream is = new FileInputStream(file);
                byte[] data = new byte[is.available()];
                is.read(data);
                md5 = DigestUtils.md5DigestAsHex((byte[])data);
                is.close();
                if (this.properties.getLicensePath().startsWith("http:") || this.properties.getLicensePath().startsWith("https:")) {
                    file.delete();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return md5;
    }
}

