/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.ohaotian.abilitycommon.api.AppApi;
import com.ohaotian.abilitycommon.config.zookeeper.NodeInfoConfig;
import com.ohaotian.abilitycommon.model.bo.AppSecretBO;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.MD5Util;
import com.ohaotian.plugin.bo.ZSCheckPluginAccessTokenReq;
import com.ohaotian.plugin.bo.ZSCheckPluginResultData;
import com.ohaotian.plugin.service.ZSCheckPluginAccessTokenService;
import com.ohaotian.plugin.util.ZSCheckPluginKeyUtil;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

@Service
public class ZSCheckPluginAccessTokenServiceImpl
implements ZSCheckPluginAccessTokenService {
    @Resource
    private ReactiveRedisTemplate<String, String> reactiveRedisTemplate;
    @Resource
    private NodeInfoConfig nodeInfoConfig;
    @Resource
    private AppApi appApi;

    @Override
    public Mono<ZSCheckPluginResultData> accessToken(ZSCheckPluginAccessTokenReq ZSCheckPluginAccessTokenReq2) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        AppSecretBO appSecretBO = this.appApi.selectByAppCodeandClusterId(ZSCheckPluginAccessTokenReq2.getUsername(), this.nodeInfoConfig.getClusterId());
        if (appSecretBO == null) {
            return Mono.just((Object)ZSCheckPluginResultData.error("\u5e94\u7528\u4e0d\u5408\u6cd5"));
        }
        String appSecret = appSecretBO.getAppSecret();
        StringBuilder signO = new StringBuilder();
        signO.append(ZSCheckPluginAccessTokenReq2.getUsername());
        signO.append(appSecret);
        signO.append(ZSCheckPluginAccessTokenReq2.getTimestamp());
        signO.append(appSecret);
        String sign = MD5Util.md5((String)signO.toString());
        if (!sign.equals(ZSCheckPluginAccessTokenReq2.getSign())) {
            return Mono.just((Object)ZSCheckPluginResultData.error("\u5e94\u7528\u4e0d\u5408\u6cd5"));
        }
        String token_new = UUID.randomUUID().toString().replaceAll("-", "");
        String key_new = ZSCheckPluginKeyUtil.getTokenKey(token_new, this.nodeInfoConfig.getClusterId());
        String value = GsonUtil.toJson((Object)appSecretBO);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(10, 12);
        return this.reactiveRedisTemplate.opsForValue().set((Object)key_new, (Object)value, Duration.ofHours(12L)).flatMap(b -> {
            if (b.booleanValue()) {
                StringBuilder sb = new StringBuilder("zs_check_plugin_redis_token_key_");
                sb.append(ZSCheckPluginAccessTokenReq2.getUsername());
                String tokenKey = sb.toString();
                this.reactiveRedisTemplate.opsForValue().get((Object)tokenKey).subscribe(s -> {
                    if (!StringUtils.isEmpty((Object)s)) {
                        this.reactiveRedisTemplate.delete((Object[])new String[]{s}).subscribe();
                    }
                });
                return this.reactiveRedisTemplate.opsForValue().set((Object)tokenKey, (Object)key_new, Duration.ofHours(13L)).flatMap(b1 -> {
                    if (b1.booleanValue()) {
                        return Mono.just((Object)ZSCheckPluginResultData.success(token_new, cal.getTime()));
                    }
                    return Mono.just((Object)ZSCheckPluginResultData.error("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01"));
                });
            }
            return Mono.just((Object)ZSCheckPluginResultData.error("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01"));
        }).onErrorResume(e -> {
            e.printStackTrace();
            return Mono.just((Object)ZSCheckPluginResultData.error("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01"));
        });
    }
}

