/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.catalog.CatalogNode;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.model.health.Service;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableCatalogNode
extends CatalogNode {
    private final Node node;
    private final ImmutableMap<String, Service> services;

    private ImmutableCatalogNode(Node node, ImmutableMap<String, Service> services) {
        this.node = node;
        this.services = services;
    }

    @Override
    @JsonProperty(value="Node")
    public Node getNode() {
        return this.node;
    }

    @JsonProperty(value="Services")
    public ImmutableMap<String, Service> getServices() {
        return this.services;
    }

    public final ImmutableCatalogNode withNode(Node value) {
        if (this.node == value) {
            return this;
        }
        return new ImmutableCatalogNode((Node)Preconditions.checkNotNull((Object)value, (Object)"node"), this.services);
    }

    public final ImmutableCatalogNode withServices(Map<String, ? extends Service> entries) {
        if (this.services == entries) {
            return this;
        }
        ImmutableMap value = ImmutableMap.copyOf(entries);
        return new ImmutableCatalogNode(this.node, (ImmutableMap<String, Service>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogNode && this.equalTo((ImmutableCatalogNode)another);
    }

    private boolean equalTo(ImmutableCatalogNode another) {
        return this.node.equals(another.node) && this.services.equals(another.services);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.services.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CatalogNode").omitNullValues().add("node", (Object)this.node).add("services", this.services).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableCatalogNode fromJson(Json json) {
        Builder builder = ImmutableCatalogNode.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.services != null) {
            builder.putAllServices(json.services);
        }
        return builder.build();
    }

    public static ImmutableCatalogNode copyOf(CatalogNode instance) {
        if (instance instanceof ImmutableCatalogNode) {
            return (ImmutableCatalogNode)instance;
        }
        return ImmutableCatalogNode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private long initBits = 1L;
        @Nullable
        private Node node;
        private ImmutableMap.Builder<String, Service> servicesBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public final Builder from(CatalogNode instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.node(instance.getNode());
            this.putAllServices(instance.getServices());
            return this;
        }

        public final Builder node(Node node) {
            this.node = (Node)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putServices(String key, Service value) {
            this.servicesBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putServices(Map.Entry<String, ? extends Service> entry) {
            this.servicesBuilder.put(entry);
            return this;
        }

        public final Builder services(Map<String, ? extends Service> entries) {
            this.servicesBuilder = ImmutableMap.builder();
            return this.putAllServices(entries);
        }

        public final Builder putAllServices(Map<String, ? extends Service> entries) {
            this.servicesBuilder.putAll(entries);
            return this;
        }

        public ImmutableCatalogNode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCatalogNode(this.node, this.servicesBuilder.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            return "Cannot build CatalogNode, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends CatalogNode {
        @Nullable
        Node node;
        @Nullable
        Map<String, Service> services;

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(Node node) {
            this.node = node;
        }

        @JsonProperty(value="Services")
        public void setServices(Map<String, Service> services) {
            this.services = services;
        }

        @Override
        public Node getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Service> getServices() {
            throw new UnsupportedOperationException();
        }
    }
}

