/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.util.failover.strategy;

import com.google.common.net.HostAndPort;
import com.orbitz.consul.util.failover.strategy.ConsulFailoverStrategy;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;

public class BlacklistingConsulFailoverStrategy
implements ConsulFailoverStrategy {
    private Map<HostAndPort, Instant> blacklist = new HashMap<HostAndPort, Instant>();
    private Collection<HostAndPort> targets;
    private long timeout;

    public BlacklistingConsulFailoverStrategy(Collection<HostAndPort> targets, long timeout) {
        this.targets = targets;
        this.timeout = timeout;
    }

    @Override
    public Optional<Request> computeNextStage(Request previousRequest, Response previousResponse) {
        HostAndPort initialTarget = this.fromRequest(previousRequest);
        if (previousResponse != null && !previousResponse.isSuccessful()) {
            this.blacklist.put(initialTarget, Instant.now());
        }
        if (this.blacklist.containsKey(initialTarget)) {
            HostAndPort next = this.targets.stream().filter(target -> {
                if (this.blacklist.containsKey(target)) {
                    Instant blacklistWhen = this.blacklist.get(target);
                    if (!Duration.between(blacklistWhen, Instant.now()).minusMillis(this.timeout).isNegative()) {
                        this.blacklist.remove(target);
                        return true;
                    }
                    return false;
                }
                return true;
            }).findAny().get();
            HttpUrl nextURL = previousRequest.url().newBuilder().host(next.getHost()).port(next.getPort()).build();
            return Optional.ofNullable(previousRequest.newBuilder().url(nextURL).build());
        }
        HttpUrl nextURL = previousRequest.url().newBuilder().host(initialTarget.getHost()).port(initialTarget.getPort()).build();
        return Optional.ofNullable(previousRequest.newBuilder().url(nextURL).build());
    }

    @Override
    public boolean isRequestViable(Request current) {
        return this.targets.size() > this.blacklist.size() || !this.blacklist.containsKey(this.fromRequest(current));
    }

    private HostAndPort fromRequest(Request request) {
        return HostAndPort.fromParts((String)request.url().host(), (int)request.url().port());
    }

    @Override
    public void markRequestFailed(Request current) {
        this.blacklist.put(this.fromRequest(current), Instant.now());
    }
}

