/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.emv.comm.api;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.media.AudioManager;
import android.util.Log;
import com.landicorp.emv.comm.api.AudioJackManager;
import com.landicorp.emv.comm.api.BluetoothManager;
import com.landicorp.emv.comm.api.CalibrateParamCallback;
import com.landicorp.emv.comm.api.CommParameter;
import com.landicorp.emv.comm.api.CommunicationCallBack;
import com.landicorp.emv.comm.api.DeviceInfo;
import com.landicorp.emv.comm.api.DownloadCallback;
import com.landicorp.emv.comm.api.UsbManager_HID;
import com.landicorp.emv.comm.api.UsbManager_TLV;
import com.landicorp.util.ICommDebug;
import com.landicorp.util.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class CommunicationManagerBase {
    private static DeviceSearchListener a = null;
    private static Context b = null;
    private static short c = Short.MIN_VALUE;
    private static short d = Short.MAX_VALUE;
    private static boolean e = false;

    public static CommunicationManagerBase getInstance(DeviceCommunicationChannel channel, Context ctx) {
        Log.i((String)"CommunicationManagerBase", (String)"landi android SDK version=V2.5.21.1212");
        if (channel == DeviceCommunicationChannel.AUDIOJACK) {
            return AudioJackManager.getInstance(ctx);
        }
        if (channel == DeviceCommunicationChannel.BLUETOOTH) {
            return BluetoothManager.getInstance(ctx);
        }
        if (channel == DeviceCommunicationChannel.USB_TLV) {
            return UsbManager_TLV.getInstance(ctx);
        }
        return UsbManager_HID.getInstance(ctx);
    }

    public static CommunicationManagerBase getInstance(DeviceCommunicationChannel channel) {
        if (channel == DeviceCommunicationChannel.AUDIOJACK) {
            return AudioJackManager.getInstance();
        }
        if (channel == DeviceCommunicationChannel.BLUETOOTH) {
            return BluetoothManager.getInstance();
        }
        if (channel == DeviceCommunicationChannel.USB_TLV) {
            return UsbManager_TLV.getInstance();
        }
        return UsbManager_HID.getInstance();
    }

    public static synchronized int searchDevices(DeviceSearchListener dsl, SearchMode mode, Context ctx, long timeout, short lowRSSI, short highRSSI) {
        Log.d((String)"CommunicationManagerBase", (String)("search Devices -- 0... lowRSSI:" + lowRSSI + ",highRSSI" + highRSSI));
        c = lowRSSI;
        d = highRSSI;
        e = true;
        return CommunicationManagerBase.searchDevices(dsl, mode, ctx, timeout);
    }

    public static synchronized int searchDevices(DeviceSearchListener dsl, SearchMode mode, Context ctx, long timeout) {
        Log.d((String)"CommunicationManagerBase", (String)("search Devices -- 1... mode:" + (Object)((Object)mode)));
        if (ctx == null || dsl == null) {
            Log.e((String)"CommunicationManagerBase", (String)"search Devices--ctx==null||dsl==null");
            e = false;
            return -4;
        }
        if (!e) {
            c = Short.MIN_VALUE;
            d = Short.MAX_VALUE;
        }
        BluetoothManager bluetoothManager = BluetoothManager.getInstance(ctx);
        bluetoothManager.SetRSSIParam(c, d);
        b = ctx;
        a = dsl;
        if (mode == SearchMode.USB) {
            UsbManager_TLV usbManager_TLV = UsbManager_TLV.getInstance(ctx);
            Map<String, String> map = usbManager_TLV.startDiscovery(ctx);
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string = entry.getKey();
                    String string2 = entry.getValue();
                    Log.d((String)"CommunicationManagerBase", (String)("Key = " + string + ", Value = " + string2));
                    DeviceInfo deviceInfo = new DeviceInfo();
                    deviceInfo.setDevChannel(DeviceCommunicationChannel.USB_TLV);
                    deviceInfo.setName(string2);
                    deviceInfo.setIdentifier(string);
                    a.discoverOneDevice(deviceInfo);
                }
            }
            a.discoverComplete();
        } else if (mode == SearchMode.AUDIOJACK) {
            CommunicationManagerBase.searchDevices(dsl, true, false, timeout, ctx);
        } else if (mode == SearchMode.BLUETOOTH) {
            CommunicationManagerBase.searchDevices(dsl, false, true, timeout, ctx);
        } else if (mode == SearchMode.AUDIOJACK_BLUETOOTH) {
            CommunicationManagerBase.searchDevices(dsl, true, true, timeout, ctx);
        } else if (mode == SearchMode.AUDIOJACK_USB) {
            UsbManager_TLV usbManager_TLV = UsbManager_TLV.getInstance(ctx);
            Map<String, String> map = usbManager_TLV.startDiscovery(ctx);
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string = entry.getKey();
                    String string3 = entry.getValue();
                    Log.d((String)"CommunicationManagerBase", (String)("Key = " + string + ", Value = " + string3));
                    DeviceInfo deviceInfo = new DeviceInfo();
                    deviceInfo.setDevChannel(DeviceCommunicationChannel.USB_TLV);
                    deviceInfo.setName(string3);
                    deviceInfo.setIdentifier(string);
                    a.discoverOneDevice(deviceInfo);
                }
            }
            CommunicationManagerBase.searchDevices(dsl, true, false, timeout, ctx);
        } else if (mode == SearchMode.BLUETOOTH_USB) {
            UsbManager_TLV usbManager_TLV = UsbManager_TLV.getInstance(ctx);
            Map<String, String> map = usbManager_TLV.startDiscovery(ctx);
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string = entry.getKey();
                    String string4 = entry.getValue();
                    Log.d((String)"CommunicationManagerBase", (String)("Key = " + string + ", Value = " + string4));
                    DeviceInfo deviceInfo = new DeviceInfo();
                    deviceInfo.setDevChannel(DeviceCommunicationChannel.USB_TLV);
                    deviceInfo.setName(string4);
                    deviceInfo.setIdentifier(string);
                    a.discoverOneDevice(deviceInfo);
                }
            }
            CommunicationManagerBase.searchDevices(dsl, false, true, timeout, ctx);
        } else if (mode == SearchMode.AUDIOJACK_BLUETOOTH_USB) {
            UsbManager_TLV usbManager_TLV = UsbManager_TLV.getInstance(ctx);
            Map<String, String> map = usbManager_TLV.startDiscovery(ctx);
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string = entry.getKey();
                    String string5 = entry.getValue();
                    Log.d((String)"CommunicationManagerBase", (String)("Key = " + string + ", Value = " + string5));
                    DeviceInfo deviceInfo = new DeviceInfo();
                    deviceInfo.setDevChannel(DeviceCommunicationChannel.USB_TLV);
                    deviceInfo.setName(string5);
                    deviceInfo.setIdentifier(string);
                    a.discoverOneDevice(deviceInfo);
                }
            }
            CommunicationManagerBase.searchDevices(dsl, true, true, timeout, ctx);
        }
        e = false;
        return 0;
    }

    public static synchronized int searchDevices(DeviceSearchListener dsl, boolean detectAudioDevice, boolean detectBluetoothDevice, long timeout, Context ctx) {
        Object object;
        Log.d((String)"CommunicationManagerBase", (String)"search Devices -- 3");
        if (ctx == null || dsl == null) {
            Log.e((String)"CommunicationManagerBase", (String)"searchDevices--ctx==null||dsl==null");
            return -4;
        }
        b = ctx;
        a = dsl;
        if (detectAudioDevice) {
            Log.e((String)"CommunicationManagerBase", (String)"search audioDevices...");
            AudioManager audioManager = (AudioManager)b.getSystemService("audio");
            Log.e((String)"CommunicationManagerBase", (String)("isWiredHeadsetOn:" + audioManager.isWiredHeadsetOn()));
            if (audioManager.isWiredHeadsetOn()) {
                object = new DeviceInfo();
                ((DeviceInfo)object).setDevChannel(DeviceCommunicationChannel.AUDIOJACK);
                ((DeviceInfo)object).setName(null);
                ((DeviceInfo)object).setIdentifier(null);
                a.discoverOneDevice((DeviceInfo)object);
            }
        }
        if (detectBluetoothDevice) {
            Log.e((String)"CommunicationManagerBase", (String)"search bluetoothDevices...");
            int n2 = 0;
            object = BluetoothManager.getInstance(ctx);
            n2 = ((BluetoothManager)object).startDiscovery(dsl, timeout, ctx);
            if (n2 != 0) {
                return n2;
            }
        } else {
            a.discoverComplete();
        }
        return 0;
    }

    public static synchronized void stopSearchDevices() {
        BluetoothManager bluetoothManager = BluetoothManager.getInstance();
        if (bluetoothManager == null) {
            Log.e((String)"CommunicationManagerBase", (String)"stopSearchDevices--bm==null,you not start search before stopSearch");
        } else {
            bluetoothManager.stopDiscovery();
        }
    }

    public static String getLibVersion() {
        return "V2.5.21.1212";
    }

    public int printer(String devAddr, byte[] message) {
        if (!BluetoothAdapter.checkBluetoothAddress((String)devAddr)) {
            Log.e((String)"CommunicationManagerBase", (String)("bluetooth device is not legal," + devAddr));
            return -1;
        }
        if (!BluetoothAdapter.getDefaultAdapter().isEnabled() && !BluetoothAdapter.getDefaultAdapter().enable()) {
            return -2;
        }
        BluetoothDevice bluetoothDevice = BluetoothAdapter.getDefaultAdapter().getRemoteDevice(devAddr);
        int n2 = 0;
        while (true) {
            try {
                BluetoothAdapter.getDefaultAdapter().cancelDiscovery();
                BluetoothSocket bluetoothSocket = bluetoothDevice.createRfcommSocketToServiceRecord(UUID.fromString("00001101-0000-1000-8000-00805F9B34FB"));
                bluetoothSocket.connect();
                byte[] byArray = new byte[message.length + 1];
                System.arraycopy(message, 0, byArray, 0, message.length);
                byArray[message.length] = 10;
                bluetoothSocket.getOutputStream().write(byArray);
                bluetoothSocket.getOutputStream().flush();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                bluetoothSocket.close();
                return 0;
            }
            catch (IOException iOException) {
                Log.e((String)"CommunicationManagerBase", (String)("Error" + iOException.toString() + "\n" + "REPEAT"));
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (++n2 < 3) continue;
                return -1;
            }
            break;
        }
    }

    public abstract int openDevice(String var1);

    public abstract int openDevice(String var1, CommParameter var2);

    public abstract int openDeviceWithSetpin(String var1, String var2, CommunicationCallBack var3);

    public abstract int openDeviceWithSetpin(String var1, String var2, CommunicationCallBack var3, CommunicationMode var4);

    public abstract int exchangeData(List<Byte> var1, long var2, CommunicationCallBack var4);

    public abstract int openDevice(String var1, CommunicationCallBack var2);

    public abstract int openDevice(String var1, CommunicationCallBack var2, CommunicationMode var3);

    public abstract int exchangeData(List<Byte> var1, long var2);

    public abstract int cancelExchange();

    public abstract void closeDevice();

    public abstract void closeResource();

    public abstract boolean calibrateCommParameter(String var1, CalibrateParamCallback var2);

    public abstract void stopCalibrate();

    public abstract boolean isConnected();

    public static ICommDebug getLogCtrl() {
        return Logger.shareInstance();
    }

    public abstract void downLoad(String var1, DownloadCallback var2);

    public abstract void newDownload(String var1, DownloadCallback var2);

    public abstract void cancelDownload();

    public abstract void breakOpenProcess();

    public abstract int openDevice(String var1, CommParameter var2, CommunicationCallBack var3, CommunicationMode var4);

    public abstract ArrayList<DeviceInfo> getBondedDevices();

    public abstract int getCommunicationMode();

    public abstract DeviceCommunicationChannel getDeviceCommunicationChannel();

    public abstract void setCallBack(CommunicationCallBack var1);

    public abstract CommunicationCallBack getCallBack();

    public static enum CommunicationMode {
        MODE_MASTERSLAVE,
        MODE_DUPLEX;

    }

    public static enum DeviceCommunicationChannel {
        AUDIOJACK,
        BLUETOOTH,
        USB_HID,
        USB_TLV;

    }

    public static interface DeviceSearchListener {
        public void discoverOneDevice(DeviceInfo var1);

        public void discoverComplete();
    }

    public static enum SearchMode {
        AUDIOJACK,
        BLUETOOTH,
        USB,
        AUDIOJACK_BLUETOOTH,
        AUDIOJACK_USB,
        BLUETOOTH_USB,
        AUDIOJACK_BLUETOOTH_USB;

    }
}

