/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.emv.comm.api;

import android.content.Context;
import android.util.Log;
import com.landicorp.emv.comm.api.CalibrateParamCallback;
import com.landicorp.emv.comm.api.CommParameter;
import com.landicorp.emv.comm.api.CommunicationCallBack;
import com.landicorp.emv.comm.api.CommunicationManagerBase;
import com.landicorp.emv.comm.api.DeviceInfo;
import com.landicorp.emv.comm.api.DownloadCallback;
import com.landicorp.usb.manager.UsbCallback;
import com.landicorp.usb.manager.UsbManagerAPI;
import com.landicorp.usb.parser.ParserThread;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UsbManager_HID
extends CommunicationManagerBase
implements UsbCallback {
    private static String a = "1.1.7.0815";
    private static UsbManager_HID b = null;
    public static final int MAX_SEND_LENGTH = 2048;
    public static final int TIME_OUT = 3000;
    protected CommunicationManagerBase.CommunicationMode mCommMode = CommunicationManagerBase.CommunicationMode.MODE_DUPLEX;
    protected CommunicationCallBack mCallBack = null;
    protected UsbManagerAPI mUsbManager = null;
    protected static Context mContext = null;
    protected boolean mOpenFlag = false;
    protected boolean mbIsconnected = false;
    public static final int FRAME_SUCCESS = 0;
    public static final int FRAME_STX_ERROR = -1;
    public static final int FRAME_VERSION_ERROR = -2;
    public static final int FRAME_LENGTH_ERROR = -3;
    public static final int FRAME_LRC_ERROR = -4;
    public static final int FRAME_ETX_ERROR = -5;
    public static final int FRAME_DATA_LENGTH_ERROR = -6;
    public static final int FRAME_USB_UNPLUG_ERROR = -10;
    public static final int FRAME_LOST_PACKAGE = -11;
    public static final int CANCEL_SUCCESS = 12;

    @Override
    public void setCallBack(CommunicationCallBack cb) {
        this.mCallBack = cb;
    }

    @Override
    public CommunicationCallBack getCallBack() {
        return this.mCallBack;
    }

    public static String getLibVersion() {
        return a;
    }

    protected UsbManager_HID(Context context) {
        mContext = context;
    }

    public static synchronized UsbManager_HID getInstance(Context context) {
        Log.d((String)"UsbManager_HID", (String)("UsbManager_HID version=" + a));
        if (b != null) {
            return b;
        }
        if (context != null) {
            b = new UsbManager_HID(context);
            return b;
        }
        return null;
    }

    public static synchronized UsbManager_HID getInstance() {
        if (b != null) {
            return b;
        }
        return null;
    }

    @Override
    public void onError(int arg0) {
        Log.d((String)"UsbManager_HID", (String)("onError! " + arg0));
        if (this.mCallBack == null) {
            Log.e((String)"UsbManager_HID", (String)"onError: fail, CallBack is null");
            return;
        }
        if (arg0 == -1) {
            this.mCallBack.onError(arg0, "protocol stx error");
            Log.d((String)"UsbManager_HID", (String)("onError: code[" + arg0 + "]" + " protocol stx error"));
        } else if (arg0 == -2) {
            this.mCallBack.onError(arg0, "protocol version error");
            Log.d((String)"UsbManager_HID", (String)("onError: code[" + arg0 + "]" + " protocol version error"));
        } else if (arg0 == -3) {
            this.mCallBack.onError(arg0, "protocol length error");
            Log.d((String)"UsbManager_HID", (String)("onError: code[" + arg0 + "]" + " protocol length error"));
        } else if (arg0 == -4) {
            this.mCallBack.onError(arg0, "protocol lrc error");
            Log.d((String)"UsbManager_HID", (String)("onError: code[" + arg0 + "]" + " protocol lrc error"));
        } else if (arg0 == -5) {
            this.mCallBack.onError(arg0, "protocol etx error");
            Log.d((String)"UsbManager_HID", (String)("onError: code[" + arg0 + "]" + " protocol etx error"));
        } else if (arg0 == -10) {
            this.closeDevice();
            this.mCallBack.onError(arg0, "usb device unpluged");
            Log.d((String)"UsbManager_HID", (String)("onError: code[" + arg0 + "]" + " usb device unpluged"));
        } else if (arg0 == -11) {
            this.mCallBack.onError(arg0, "package lost");
            Log.d((String)"UsbManager_HID", (String)("onError: code[" + arg0 + "]" + " package lost"));
        }
    }

    @Override
    public void onReceive(byte arg0, int arg1, byte[] arg2) {
        Log.i((String)"UsbManager_HID", (String)("HID onReceive: suceess! type:[" + arg0 + "]" + "len:[" + arg1 + "]" + "data:[" + arg2 + "]"));
        if (this.mCallBack == null) {
            Log.e((String)"UsbManager_HID", (String)"HID onReceive: fail, CallBack is null");
            return;
        }
        this.mCallBack.onReceive(arg2);
        Log.i((String)"UsbManager_HID", (String)("HID onReceive recvData=" + arg2));
    }

    public synchronized Map<String, String> startDiscovery(Context ctx) {
        Log.d((String)"UsbManager_HID", (String)"USB startDiscovery...");
        if (this.mUsbManager == null) {
            this.mUsbManager = UsbManagerAPI.getInstance(mContext);
        }
        return this.mUsbManager.StartDiscovery();
    }

    @Override
    public int openDevice(String identifiers) {
        return this.openDevice(identifiers, (CommParameter)null);
    }

    @Override
    public int openDevice(String identifier, CommParameter param) {
        return this.openDevice(identifier, param, null, CommunicationManagerBase.CommunicationMode.MODE_DUPLEX);
    }

    @Override
    public synchronized int openDeviceWithSetpin(String identifier, String pinCode, CommunicationCallBack cb) {
        return 0;
    }

    @Override
    public synchronized int openDeviceWithSetpin(String identifier, String pinCode, CommunicationCallBack cb, CommunicationManagerBase.CommunicationMode mode) {
        return 0;
    }

    protected int WriteDevice(byte[] sendData) {
        int n2 = this.mUsbManager.writeDevice_hid(sendData, 3000);
        if (n2 < 0) {
            Log.e((String)"UsbManager_HID", (String)("HID exchangeData: fail, ret=" + n2));
            return n2;
        }
        Log.d((String)"UsbManager_HID", (String)"HID exchangeData: success");
        this.mCallBack.onSendOK();
        return 0;
    }

    @Override
    public synchronized int exchangeData(List<Byte> data, long timeout, CommunicationCallBack cb) {
        Log.d((String)"UsbManager_HID", (String)("exchangeData data:" + data + ", timeout:" + timeout));
        if (!this.mbIsconnected) {
            Log.e((String)"UsbManager_HID", (String)"usb device is not connected!");
            return -1;
        }
        if (!this.mOpenFlag) {
            Log.e((String)"UsbManager_HID", (String)"exchangeData: fail, is not open");
            return -1;
        }
        if (CommunicationManagerBase.CommunicationMode.MODE_DUPLEX != this.mCommMode || cb == null) {
            Log.e((String)"UsbManager_HID", (String)"exchangeData: fail, the communication mode is not duplex, or the CallBack parameter is null");
            return -2;
        }
        this.mCallBack = cb;
        int n2 = 0;
        int n3 = data.size();
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            byArray[n4] = data.get(n4);
            ++n4;
        }
        n2 = this.WriteDevice(byArray);
        return n2;
    }

    @Override
    public synchronized int openDevice(String identifier, CommunicationCallBack cb) {
        return this.openDevice(identifier, null, cb, CommunicationManagerBase.CommunicationMode.MODE_DUPLEX);
    }

    @Override
    public int openDevice(String identifier, CommunicationCallBack cb, CommunicationManagerBase.CommunicationMode mode) {
        return this.openDevice(identifier, null, cb, mode);
    }

    @Override
    public synchronized int exchangeData(List<Byte> data, long timeout) {
        return this.exchangeData(data, timeout, this.mCallBack);
    }

    @Override
    public synchronized int cancelExchange() {
        Log.d((String)"UsbManager_HID", (String)"cancelExchange()");
        if (!this.mbIsconnected) {
            Log.e((String)"UsbManager_HID", (String)"cancelExchange: usb device is not connected!");
            return -1;
        }
        if (!this.mOpenFlag) {
            Log.e((String)"UsbManager_HID", (String)"cancelExchange: fail, is not open");
            return -1;
        }
        if (CommunicationManagerBase.CommunicationMode.MODE_DUPLEX != this.mCommMode) {
            Log.e((String)"UsbManager_HID", (String)"cancelExchange: fail, the communication mode is not duplex");
            return -2;
        }
        int n2 = this.mUsbManager.writeDevice((byte)22, 0, null, 3000);
        if (n2 < 0) {
            Log.e((String)"UsbManager_HID", (String)("cancelExchange: send fail, ret=" + n2));
            return n2;
        }
        Log.d((String)"UsbManager_HID", (String)"cancelExchange: success");
        this.mCallBack.onError(12, "Cancel success.");
        return n2;
    }

    @Override
    public synchronized void closeDevice() {
        if (this.mOpenFlag) {
            this.mUsbManager.closeDevice();
            this.mOpenFlag = false;
            Log.d((String)"UsbManager_HID", (String)"closeDevice: success");
            this.mbIsconnected = false;
        }
    }

    @Override
    public synchronized void closeResource() {
    }

    @Override
    public synchronized boolean calibrateCommParameter(String identifiers, CalibrateParamCallback cpcb) {
        return true;
    }

    @Override
    public synchronized void stopCalibrate() {
    }

    @Override
    public synchronized boolean isConnected() {
        return this.mbIsconnected;
    }

    @Override
    public void downLoad(String path, DownloadCallback dlCB) {
    }

    @Override
    public void newDownload(String path, DownloadCallback dlCB) {
    }

    @Override
    public void cancelDownload() {
    }

    @Override
    public void breakOpenProcess() {
    }

    protected int openDevice(CommunicationCallBack cb, CommunicationManagerBase.CommunicationMode mode) {
        int n2 = this.mUsbManager.openDevice(this, ParserThread.UsbMode.MODE_HID);
        if (n2 == 0) {
            this.mOpenFlag = true;
            this.mCallBack = cb;
            this.mCommMode = mode;
            Log.d((String)"UsbManager_HID", (String)"HID OpenDevice: success");
            this.mbIsconnected = true;
            return 0;
        }
        Log.e((String)"UsbManager_HID", (String)("HID OpenDevice: fail, ret=" + n2));
        return n2;
    }

    @Override
    public int openDevice(String identifier, CommParameter param, CommunicationCallBack cb, CommunicationManagerBase.CommunicationMode mode) {
        Log.d((String)"UsbManager_HID", (String)"OpenDevice");
        if (this.mOpenFlag) {
            Log.e((String)"UsbManager_HID", (String)"OpenDevice: already open");
            return 0;
        }
        if (mode != CommunicationManagerBase.CommunicationMode.MODE_DUPLEX) {
            Log.e((String)"UsbManager_HID", (String)"OpenDevice: fail, the communication mode is not duplex");
            return -5;
        }
        this.mUsbManager = UsbManagerAPI.getInstance(mContext);
        int n2 = this.openDevice(cb, mode);
        return n2;
    }

    @Override
    public ArrayList<DeviceInfo> getBondedDevices() {
        return null;
    }

    @Override
    public int getCommunicationMode() {
        if (this.mCommMode == CommunicationManagerBase.CommunicationMode.MODE_DUPLEX) {
            return 1;
        }
        Log.e((String)"UsbManager_HID", (String)"getCommunicationMode: the communication mode is not duplex");
        return 0;
    }

    @Override
    public CommunicationManagerBase.DeviceCommunicationChannel getDeviceCommunicationChannel() {
        return CommunicationManagerBase.DeviceCommunicationChannel.USB_HID;
    }
}

