/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.liu.comm.api;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import com.landicorp.liu.comm.api.BluetoothLog;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;

public class ClsUtils {
    public static boolean createBond(Class<? extends BluetoothDevice> btClass, BluetoothDevice btDevice) throws Exception {
        Method method = btClass.getMethod("createBond", new Class[0]);
        Boolean bl = (Boolean)method.invoke((Object)btDevice, new Object[0]);
        return bl;
    }

    public static boolean removeBond(Class<?> btClass, BluetoothDevice btDevice) throws Exception {
        Method method = btClass.getMethod("removeBond", new Class[0]);
        Boolean bl = (Boolean)method.invoke((Object)btDevice, new Object[0]);
        return bl;
    }

    public static boolean setPin(Class<? extends BluetoothDevice> btClass, BluetoothDevice btDevice, String str) throws Exception {
        try {
            Method method = btClass.getDeclaredMethod("setPin", byte[].class);
            Boolean bl = (Boolean)method.invoke((Object)btDevice, new Object[]{str.getBytes()});
            BluetoothLog.e("ClsUtils", "setPin returnValue=" + bl);
        }
        catch (SecurityException securityException) {
            BluetoothLog.e("ClsUtils", "setPin--SecurityException");
            securityException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BluetoothLog.e("ClsUtils", "setPin--IllegalArgumentException");
            illegalArgumentException.printStackTrace();
        }
        catch (Exception exception) {
            BluetoothLog.e("ClsUtils", "setPin--Exception");
            exception.printStackTrace();
        }
        return true;
    }

    public static boolean setPasskey(Class<? extends BluetoothDevice> btClass, BluetoothDevice btDevice, String str) throws Exception {
        try {
            Method method = btClass.getDeclaredMethod("setPasskey", Integer.TYPE);
            Boolean bl = (Boolean)method.invoke((Object)btDevice, new Integer(str));
            BluetoothLog.e("ClsUtils", "setPasskey returnValue=" + bl);
        }
        catch (SecurityException securityException) {
            BluetoothLog.e("ClsUtils", "setPasskey--SecurityException");
            securityException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BluetoothLog.e("ClsUtils", "setPasskey--IllegalArgumentException");
            illegalArgumentException.printStackTrace();
        }
        catch (Exception exception) {
            BluetoothLog.e("ClsUtils", "setPasskey--Exception");
            exception.printStackTrace();
        }
        return true;
    }

    public static boolean setPairingConfirmation(Class<? extends BluetoothDevice> btClass, BluetoothDevice btDevice, boolean value) throws Exception {
        try {
            Method method = btClass.getDeclaredMethod("setPairingConfirmation", Boolean.TYPE);
            Boolean bl = (Boolean)method.invoke((Object)btDevice, new Boolean(value));
            BluetoothLog.e("ClsUtils", "setPairingConfirmation=" + bl);
        }
        catch (SecurityException securityException) {
            BluetoothLog.e("ClsUtils", "setPairingConfirmation--SecurityException");
            securityException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BluetoothLog.e("ClsUtils", "setPairingConfirmation--IllegalArgumentException");
            illegalArgumentException.printStackTrace();
        }
        catch (Exception exception) {
            BluetoothLog.e("ClsUtils", "setPairingConfirmation--Exception");
            exception.printStackTrace();
        }
        return true;
    }

    public static boolean setRemoteOutOfBandData(Class<? extends BluetoothDevice> btClass, BluetoothDevice btDevice, String str) throws Exception {
        try {
            Method method = btClass.getDeclaredMethod("setRemoteOutOfBandData", new Class[0]);
            Boolean bl = (Boolean)method.invoke((Object)btDevice, new Object[0]);
            BluetoothLog.e("ClsUtils", "setRemoteOutOfBandData+" + bl);
        }
        catch (SecurityException securityException) {
            BluetoothLog.e("ClsUtils", "setRemoteOutOfBandData--SecurityException");
            securityException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BluetoothLog.e("ClsUtils", "setRemoteOutOfBandData--IllegalArgumentException");
            illegalArgumentException.printStackTrace();
        }
        catch (Exception exception) {
            BluetoothLog.e("ClsUtils", "setRemoteOutOfBandData--Exception");
            exception.printStackTrace();
        }
        return true;
    }

    public static boolean cancelPairingUserInput(Class<?> btClass, BluetoothDevice device) throws Exception {
        Method method = btClass.getMethod("cancelPairingUserInput", new Class[0]);
        Boolean bl = (Boolean)method.invoke((Object)device, new Object[0]);
        return bl;
    }

    public static boolean cancelBondProcess(Class<?> btClass, BluetoothDevice device) throws Exception {
        Method method = btClass.getMethod("cancelBondProcess", new Class[0]);
        Boolean bl = (Boolean)method.invoke((Object)device, new Object[0]);
        return bl;
    }

    public static void printAllInform(Class<?> clsShow) {
        try {
            Method[] methodArray = clsShow.getMethods();
            int n2 = 0;
            while (n2 < methodArray.length) {
                BluetoothLog.e("ClsUtils", "method name=" + methodArray[n2].getName() + ";and the i is:" + n2);
                ++n2;
            }
            Field[] fieldArray = clsShow.getFields();
            n2 = 0;
            while (n2 < fieldArray.length) {
                BluetoothLog.e("ClsUtils", "Field name=" + fieldArray[n2].getName());
                ++n2;
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean pair(String strAddr, String strPsw) {
        BluetoothDevice bluetoothDevice;
        boolean bl = false;
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        bluetoothAdapter.cancelDiscovery();
        if (!bluetoothAdapter.isEnabled()) {
            bluetoothAdapter.enable();
        }
        if (!BluetoothAdapter.checkBluetoothAddress((String)strAddr)) {
            BluetoothLog.w("ClsUtils", "devAdd un effient!");
        }
        if ((bluetoothDevice = bluetoothAdapter.getRemoteDevice(strAddr)).getBondState() != 12) {
            try {
                BluetoothLog.e("ClsUtils", "NOT BOND_BONDED");
                ClsUtils.setPin(bluetoothDevice.getClass(), bluetoothDevice, strPsw);
                ClsUtils.createBond(bluetoothDevice.getClass(), bluetoothDevice);
                ClsUtils.setPin(bluetoothDevice.getClass(), bluetoothDevice, strPsw);
                bl = true;
            }
            catch (Exception exception) {
                BluetoothLog.w("ClsUtils", "setPiN failed!");
                exception.printStackTrace();
            }
        } else {
            BluetoothLog.e("ClsUtils", "HAS BOND_BONDED");
            try {
                ClsUtils.createBond(bluetoothDevice.getClass(), bluetoothDevice);
                ClsUtils.setPin(bluetoothDevice.getClass(), bluetoothDevice, strPsw);
                ClsUtils.createBond(bluetoothDevice.getClass(), bluetoothDevice);
                bl = true;
            }
            catch (Exception exception) {
                BluetoothLog.w("ClsUtils", "setPiN failed!");
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public static BluetoothSocket createInsecureRfcommSocketToServiceRecord(Class<?> btClass, BluetoothDevice device, UUID uuid) throws IOException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException, IllegalAccessException {
        BluetoothLog.w("ClsUtils", "ClsUtils--createInsecureRfcommSocketToServiceRecord...");
        Method method = btClass.getMethod("createInsecureRfcommSocketToServiceRecord", UUID.class);
        BluetoothSocket bluetoothSocket = (BluetoothSocket)method.invoke((Object)device, uuid);
        BluetoothLog.w("ClsUtils", "ClsUtils--createInsecureRfcommSocketToServiceRecord returnValue:" + bluetoothSocket);
        return bluetoothSocket;
    }

    public static BluetoothSocket createRfcommSocketToServiceRecord(Class<?> btClass, BluetoothDevice device, UUID uuid) throws IOException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException, IllegalAccessException {
        BluetoothLog.w("ClsUtils", "ClsUtils--createRfcommSocketToServiceRecord...");
        Method method = btClass.getMethod("createRfcommSocketToServiceRecord", UUID.class);
        BluetoothSocket bluetoothSocket = (BluetoothSocket)method.invoke((Object)device, uuid);
        BluetoothLog.w("ClsUtils", "ClsUtils--createRfcommSocketToServiceRecord returnValue:" + bluetoothSocket);
        return bluetoothSocket;
    }

    public static BluetoothSocket createInsecureRfcommSocket(Class<?> btClass, BluetoothDevice device, int channel) throws IOException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        BluetoothLog.w("ClsUtils", "ClsUtils--createInsecureRfcommSocket...");
        Method method = btClass.getMethod("createInsecureRfcommSocket", Integer.TYPE);
        BluetoothSocket bluetoothSocket = (BluetoothSocket)method.invoke((Object)device, channel);
        BluetoothLog.w("ClsUtils", "createInsecureRfcommSocket returnValue:" + bluetoothSocket);
        return bluetoothSocket;
    }

    public static BluetoothSocket createRfcommSocket(Class<?> btClass, BluetoothDevice device, int channel) throws IOException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        BluetoothLog.w("ClsUtils", "ClsUtils--createRfcommSocket...");
        Method method = btClass.getMethod("createRfcommSocket", Integer.TYPE);
        BluetoothSocket bluetoothSocket = (BluetoothSocket)method.invoke((Object)device, channel);
        BluetoothLog.w("ClsUtils", "createRfcommSocket returnValue:" + bluetoothSocket);
        return bluetoothSocket;
    }

    public static boolean setScanMode(Class<?> baClass, BluetoothAdapter adapter, int mode, int duration) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = baClass.getMethod("setScanMode", Integer.TYPE, Integer.TYPE);
        Boolean bl = (Boolean)method.invoke((Object)adapter, mode, duration);
        BluetoothLog.e("ClsUtils", "setScanModeMethod returnValue=" + bl);
        return bl;
    }

    public static boolean setScanMode(Class<?> baClass, BluetoothAdapter adapter, int mode) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = baClass.getMethod("setScanMode", Integer.TYPE);
        Boolean bl = (Boolean)method.invoke((Object)adapter, mode);
        BluetoothLog.e("ClsUtils", "setScanModeMethod returnValue=" + bl);
        return bl;
    }

    public static int getScanMode(Class<?> baClass, BluetoothAdapter adapter) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = baClass.getMethod("getScanMode", new Class[0]);
        Integer n2 = (Integer)method.invoke((Object)adapter, new Object[0]);
        BluetoothLog.e("ClsUtils", "getScanModeMethod returnValue=" + n2);
        return n2;
    }
}

