/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.liu.comm.api;

import android.os.Build;
import android.util.Xml;
import com.landicorp.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class CommParamLoader<T> {
    private String a = Build.MANUFACTURER;
    private String b = Build.MODEL;
    private String c = null;
    private String d = Build.BRAND;
    private String e = Build.VERSION.SDK;
    private String f = Build.BOOTLOADER;
    private String g = Build.DEVICE;
    private String h = Build.HARDWARE;
    private String i = Build.PRODUCT;
    private String j = Build.ID;
    protected static final String PREFIX_METHOD_SET_STRING = "XCP_set";
    protected static final String PREFIX_METHOD_GET_STRING = "XCP_get";
    protected static final String TAG_PARAMS_STRING = "params";
    protected static final String TAG_AUDIO_STRING = "audio";
    protected static final String TAG_PHONE_STRING = "phone";
    protected static final String ATTR_MANUFACTURER_STRING = "manufacturer";
    protected static final String ATTR_BRAND_STRING = "brand";
    protected static final String ATTR_MODEL_STRING = "model";
    protected static final String ATTR_TYPE_STRING = "type";
    protected static final String ATTR_CLASS_STRING = "class";
    protected static final String ATTR_PRODUCT_STRING = "product";
    protected static final String ATTR_ID_STRING = "id";
    protected static final String ATTR_BOOTLOADER_STRING = "bootloader";
    protected static final String ATTR_DEVICE_STRING = "device";
    protected static final String ATTR_HARDWARE_STRING = "hardware";
    protected static final String ATTR_SDK_STRING = "sdk";
    protected static final String VAL_UNKNOWN_STRING = "unknown";

    public CommParamLoader(String commName) {
        this.c = commName;
        if (commName == null) {
            throw new IllegalArgumentException("CommParamLoader : Invalid Arguments,commName = " + commName);
        }
    }

    public boolean SaveToFileSystem(String path, T param) {
        if (path != null) {
            File file = new File(path);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            if (fileOutputStream != null) {
                boolean bl = this.buildXMLStream(fileOutputStream, param, this.a, this.b);
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return bl;
            }
        }
        return false;
    }

    public T LoadFromFileSystem(String path) {
        if (path != null) {
            File file = new File(path);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            if (fileInputStream != null) {
                T t = this.parseXMLStream(fileInputStream, this.a, this.b);
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return t;
            }
        }
        return null;
    }

    public T LoadFromResource(String path) {
        InputStream inputStream;
        if (path != null && (inputStream = CommParamLoader.class.getClassLoader().getResourceAsStream(path)) != null) {
            T t = this.parseXMLStream(inputStream, this.a, this.b);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return t;
        }
        return null;
    }

    protected boolean buildXMLStream(OutputStream outStream, T commParam, String manufacturer, String model) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        try {
            xmlSerializer.setOutput(outStream, "UTF-8");
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag(null, TAG_PARAMS_STRING);
            xmlSerializer.startTag(null, this.c);
            xmlSerializer.attribute(null, ATTR_CLASS_STRING, commParam.getClass().getName());
            xmlSerializer.startTag(null, TAG_PHONE_STRING);
            xmlSerializer.attribute(null, ATTR_MANUFACTURER_STRING, manufacturer);
            xmlSerializer.attribute(null, ATTR_MODEL_STRING, model);
            xmlSerializer.attribute(null, ATTR_BRAND_STRING, this.d);
            xmlSerializer.attribute(null, ATTR_BOOTLOADER_STRING, this.f);
            xmlSerializer.attribute(null, ATTR_DEVICE_STRING, this.g);
            xmlSerializer.attribute(null, ATTR_HARDWARE_STRING, this.h);
            xmlSerializer.attribute(null, ATTR_ID_STRING, this.j);
            xmlSerializer.attribute(null, ATTR_PRODUCT_STRING, this.i);
            xmlSerializer.attribute(null, ATTR_SDK_STRING, this.e);
            this.a(xmlSerializer, commParam);
            xmlSerializer.endTag(null, TAG_PHONE_STRING);
            xmlSerializer.endTag(null, this.c);
            xmlSerializer.endTag(null, TAG_PARAMS_STRING);
            xmlSerializer.endDocument();
            xmlSerializer.flush();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            Logger.shareInstance().writeLog("I-CommParamLoader.txt", "buildXMLStream : IllegalArgumentException " + illegalArgumentException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            Logger.shareInstance().writeLog("I-CommParamLoader.txt", "buildXMLStream : IllegalStateException " + illegalStateException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Logger.shareInstance().writeLog("I-CommParamLoader.txt", "buildXMLStream : IOException " + iOException.getMessage());
        }
        return true;
    }

    protected T parseXMLStream(InputStream inStream, String manufacturer, String model) {
        T t = null;
        XmlPullParser xmlPullParser = Xml.newPullParser();
        try {
            xmlPullParser.setInput(inStream, "utf-8");
            int n2 = xmlPullParser.getEventType();
            while (n2 != 1) {
                switch (n2) {
                    case 2: {
                        Object object;
                        String string;
                        String string2 = xmlPullParser.getName();
                        if (string2.equals(this.c)) {
                            string = xmlPullParser.getAttributeValue(null, ATTR_CLASS_STRING);
                            try {
                                object = Class.forName(string);
                                t = this.a((Class<?>)object);
                                break;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                Logger.shareInstance().writeLog("I-CommParamLoader.txt", "parseXMLStream : Class.forName(" + string + ") Exception = " + exception.getMessage());
                                return t;
                            }
                        }
                        if (!string2.equals(TAG_PHONE_STRING)) break;
                        string = xmlPullParser.getAttributeValue(null, ATTR_MANUFACTURER_STRING);
                        object = xmlPullParser.getAttributeValue(null, ATTR_MODEL_STRING);
                        boolean bl = false;
                        if (model.equalsIgnoreCase((String)object)) {
                            if (string != null && manufacturer != null) {
                                if (string.equalsIgnoreCase(manufacturer)) {
                                    bl = true;
                                }
                            } else {
                                bl = true;
                            }
                        }
                        if (!bl) break;
                        this.a(xmlPullParser, t);
                        return t;
                    }
                    case 3: {
                        String string2 = xmlPullParser.getName();
                        if (!string2.equals(this.c)) break;
                        return t;
                    }
                    case 4: {
                        break;
                    }
                }
                n2 = xmlPullParser.next();
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
            Logger.shareInstance().writeLog("I-CommParamLoader.txt", "parseXMLStream XmlPullParserException : " + xmlPullParserException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Logger.shareInstance().writeLog("I-CommParamLoader.txt", "parseXMLStream IOException : " + iOException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.shareInstance().writeLog("I-CommParamLoader.txt", "parseXMLStream exception : " + exception.getMessage());
        }
        return t;
    }

    private T a(Class<?> clazz) throws IllegalAccessException, InstantiationException {
        return (T)clazz.newInstance();
    }

    private boolean a(XmlSerializer xmlSerializer, T t) {
        try {
            Method[] methodArray;
            Method[] methodArray2 = methodArray = t.getClass().getMethods();
            int n2 = methodArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Method method = methodArray2[n3];
                String string = method.getName();
                if (string.length() > PREFIX_METHOD_GET_STRING.length() && method.getParameterTypes().length == 0 && method.getReturnType().isPrimitive() && string.substring(0, PREFIX_METHOD_GET_STRING.length()).equals(PREFIX_METHOD_GET_STRING)) {
                    Class<?> clazz = method.getReturnType();
                    String string2 = method.getName().substring(PREFIX_METHOD_GET_STRING.length());
                    if (clazz == Integer.TYPE) {
                        xmlSerializer.startTag(null, string2);
                        xmlSerializer.attribute(null, ATTR_TYPE_STRING, "int");
                        xmlSerializer.text("" + method.invoke(t, new Object[0]));
                        xmlSerializer.endTag(null, string2);
                    } else if (clazz == Short.TYPE) {
                        xmlSerializer.startTag(null, string2);
                        xmlSerializer.attribute(null, ATTR_TYPE_STRING, "short");
                        xmlSerializer.text("" + method.invoke(t, new Object[0]));
                        xmlSerializer.endTag(null, string2);
                    } else if (clazz == Float.TYPE) {
                        xmlSerializer.startTag(null, string2);
                        xmlSerializer.attribute(null, ATTR_TYPE_STRING, "float");
                        xmlSerializer.text("" + method.invoke(t, new Object[0]));
                        xmlSerializer.endTag(null, string2);
                    } else {
                        Logger.shareInstance().writeLog("I-CommParamLoader.txt", "saveParams method return type unknow :" + clazz);
                    }
                }
                ++n3;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.shareInstance().writeLog("I-CommParamLoader.txt", "saveParams exception:" + exception.getMessage());
            return false;
        }
    }

    private void a(XmlPullParser xmlPullParser, T t) throws XmlPullParserException, IOException {
        String string;
        if (t == null || xmlPullParser == null) {
            return;
        }
        int n2 = xmlPullParser.getEventType();
        if (n2 != 2 || (string = xmlPullParser.getName()) == null || !string.equals(TAG_PHONE_STRING)) {
            return;
        }
        n2 = xmlPullParser.next();
        while (n2 != 1) {
            switch (n2) {
                case 2: {
                    string = xmlPullParser.getName();
                    String string2 = xmlPullParser.getAttributeValue(null, ATTR_TYPE_STRING);
                    String string3 = xmlPullParser.nextText();
                    this.a(t, string2, string, string3);
                    break;
                }
                case 3: {
                    string = xmlPullParser.getName();
                    if (!string.equals(TAG_PHONE_STRING)) break;
                    return;
                }
            }
            n2 = xmlPullParser.next();
        }
    }

    private void a(Object object, String string, String string2, String string3) {
        try {
            Method method = null;
            Number number = null;
            if ("int".equals(string)) {
                number = Integer.parseInt(string3);
                String string4 = PREFIX_METHOD_SET_STRING + string2;
                method = object.getClass().getMethod(string4, Integer.TYPE);
                method.invoke(object, number);
            } else if ("short".equals(string)) {
                number = Short.parseShort(string3);
                String string5 = PREFIX_METHOD_SET_STRING + string2;
                method = object.getClass().getMethod(string5, Short.TYPE);
                method.invoke(object, number);
            } else if ("float".equals(string)) {
                number = Float.valueOf(Float.parseFloat(string3));
                String string6 = PREFIX_METHOD_SET_STRING + string2;
                method = object.getClass().getMethod(string6, Float.TYPE);
                method.invoke(object, number);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.shareInstance().writeLog("I-CommParamLoader.txt", "setParams exception:" + exception.getMessage());
        }
    }
}

