/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.liu.comm.api;

import com.landicorp.liu.comm.api.BluetoothLog;
import com.landicorp.liu.comm.api.CommData;
import com.landicorp.liu.comm.api.CommFrame;
import com.landicorp.liu.comm.api.FrameParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeoutException;

public class FrameUtil {
    public static final String DEBUG_TAG = "FRAMEUTIL";
    public static final int SUCCESS = 0;
    public static final short FRAME_NUMBER_INCRESE_FACTOR = 8;
    public static final int FRAME_STX_ERROR = -1;
    public static final int FRAME_LENGTH_ERROR = -2;
    public static final int FRAME_TYPE_ERROR = -3;
    public static final int FRAME_LRC_ERROR = -4;
    public static final int FRAME_ETX_ERROR = -5;
    public static final int FRAME_IGNORE_ERROR = -11;
    public static final int FRAME_NUMBER_ERROR = -12;
    public static final int FRAME_PROTOCOL_ERROR = -13;
    public static final int FRAME_DATA_ERROR = -14;
    public static final int FRAME_NOT_OVER = 1;
    public static final int FRAME_REPEAT = 11;
    public static final int FRAME_SUB = 12;
    public static final int BIT_LENGTH_ERROR = -6;
    public static final int BIT_INVAILEDCHAR_ERROR = -7;
    public static final int BIT_STX_ERROR = -8;
    public static final int BIT_LRC_ERROR = -9;
    public static final int BIT_ETX_ERROR = -10;
    public static final int BIT_INVALID_DATA = -11;
    private static int a = 0;
    private static int b = 0;
    private static int c = 0;
    private static byte d = 0;
    private static final List<Byte> e = new ArrayList<Byte>();
    private static Queue<CommFrame> f = new LinkedList<CommFrame>();
    private static boolean g = true;
    private static int h = 0;
    private static /* synthetic */ int[] i;

    public static void init(int maxFrameSize, short sendFrameNumber, short recvFrameNumber, byte commProtocol) {
        FrameUtil.setMaxFrameSize(maxFrameSize);
        FrameUtil.setSendFrameNumber(sendFrameNumber);
        FrameUtil.a(recvFrameNumber);
        FrameUtil.setCommProtocol(commProtocol);
        e.clear();
        int n2 = 0;
        while (n2 < 10) {
            e.add((byte)5);
            ++n2;
        }
    }

    public static void setCommProtocol(byte commProtocol) {
        d = commProtocol;
    }

    public static byte getCommProtocol() {
        return d;
    }

    public static void setMaxFrameSize(int maxFrameSize) {
        a = maxFrameSize;
    }

    public static int getMaxFrameSize() {
        return a;
    }

    public static int getSendFrameNumber() {
        return b;
    }

    public static void setSendFrameNumber(short sendFrameNumber) {
        b = sendFrameNumber & 0xFFFF;
    }

    public static int getRecvFrameNumber() {
        return c;
    }

    private static void a(short s) {
        c = s & 0xFFFF;
    }

    public static void resetRecvDataFlag() {
        g = true;
        h = 0;
    }

    public static boolean getRecvDataFlag() {
        return g;
    }

    public static List<CommFrame> PackFrame(CommData audiodata) {
        ArrayList<CommFrame> arrayList = new ArrayList<CommFrame>();
        if (FrameUtil.getCommProtocol() == 0) {
            BluetoothLog.w("FrameUtil", "old protocol");
            short s = 0;
            byte by = audiodata.getType();
            byte by2 = 0;
            int n2 = 23130;
            if (by == 68) {
                if (audiodata.getData() != null) {
                    s = (short)audiodata.getData().size();
                }
                BluetoothLog.w(DEBUG_TAG, "PackFrame Data Lenght=" + s);
            } else if (by == 83) {
                s = 0;
                BluetoothLog.w(DEBUG_TAG, "PackFrame ShutDown");
                if (audiodata.getData() != null) {
                    BluetoothLog.e(DEBUG_TAG, "Data and type not match");
                    return null;
                }
            } else if (by == 67) {
                s = 0;
                BluetoothLog.w(DEBUG_TAG, "PackFrame Cancel");
                if (audiodata.getData() != null) {
                    BluetoothLog.e(DEBUG_TAG, "Data and type not match");
                    return null;
                }
            } else if (by == 65 || by == 78) {
                s = 0;
                BluetoothLog.w(DEBUG_TAG, "PackFrame Command");
                if (audiodata.getData() != null) {
                    BluetoothLog.e(DEBUG_TAG, "Data and type not match");
                    return null;
                }
            } else if (by == 80) {
                if (audiodata.getData() != null) {
                    s = (short)audiodata.getData().size();
                }
                BluetoothLog.w(DEBUG_TAG, "PackFrame Paramater Length=" + s);
            }
            if (by != 65 && by != 78) {
                BluetoothLog.e("LRC", "Clear Frame Queue");
                f.clear();
            }
            CommFrame commFrame = new CommFrame();
            commFrame.setSTX((byte)2);
            commFrame.setFrameType(by);
            by2 = (byte)(by2 ^ by);
            commFrame.setFrameNumber(n2);
            by2 = (byte)(by2 ^ (byte)(n2 >> 8 & 0xFF));
            by2 = (byte)(by2 ^ (byte)(n2 & 0xFF));
            commFrame.setFrameLength(s);
            by2 = (byte)(by2 ^ (byte)(s >> 8 & 0xFF));
            by2 = (byte)(by2 ^ (byte)(s & 0xFF));
            commFrame.setFrameData(audiodata.getData());
            if (audiodata.getData() != null) {
                int n3 = 0;
                while (n3 < audiodata.getData().size()) {
                    by2 = (byte)(by2 ^ audiodata.getData().get(n3));
                    ++n3;
                }
            }
            commFrame.setFrameLRC(by2);
            commFrame.setETX((byte)3);
            commFrame.setFrameExtension(e);
            arrayList.add(commFrame);
        } else if (FrameUtil.getCommProtocol() == 1) {
            int n4;
            BluetoothLog.w("FrameUtil", "new protocol");
            List<Byte> list = null;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            byte by = audiodata.getType();
            byte by3 = 0;
            byte by4 = 0;
            int n8 = n4 = (int)(8 + FrameUtil.getSendFrameNumber());
            FrameUtil.setSendFrameNumber((short)n4);
            BluetoothLog.e("LRC", "firstFrameNum = " + n8);
            if (by == 68) {
                if (audiodata.getData() != null) {
                    n6 = audiodata.getData().size();
                }
                BluetoothLog.w(DEBUG_TAG, "PackFrame DATA Length=" + n6);
            } else if (by == 83) {
                n6 = 0;
                BluetoothLog.w("LRC", "++ sendFrameNum(S) = " + FrameUtil.getSendFrameNumber());
                BluetoothLog.w(DEBUG_TAG, "PackFrame ShutDown");
            } else if (by == 67) {
                n6 = 0;
                BluetoothLog.w("LRC", "++ sendFrameNum(C) = " + FrameUtil.getSendFrameNumber());
                BluetoothLog.w(DEBUG_TAG, "PackFrame Cancel");
            } else if (by == 65 || by == 78) {
                BluetoothLog.e("LRC", "=============ACK/NAK=============");
                n6 = 0;
                n8 = n4 = (short)FrameUtil.getRecvFrameNumber();
                BluetoothLog.w(DEBUG_TAG, "PackFrame Command");
            } else if (by == 80) {
                if (audiodata.getData() != null) {
                    n6 = (short)audiodata.getData().size();
                }
                BluetoothLog.w(DEBUG_TAG, "PackFrame Paramater Lenght=" + n6);
            } else {
                return null;
            }
            n7 = n6;
            BluetoothLog.w(DEBUG_TAG, "before pack data remainderLen:" + n7);
            do {
                if (n7 > 0) {
                    if (n7 - FrameUtil.getMaxFrameSize() >= 0) {
                        list = audiodata.getData().subList(n5, n5 + FrameUtil.getMaxFrameSize());
                        n5 += list.size();
                    } else {
                        list = audiodata.getData().subList(n5, n5 + n7);
                        n5 += list.size();
                    }
                    n7 -= list.size();
                } else {
                    list = null;
                }
                BluetoothLog.w(DEBUG_TAG, "remainder data length:" + n7);
                CommFrame commFrame = new CommFrame();
                commFrame.setSTX((byte)2);
                commFrame.setFrameType(by);
                commFrame.setFrameNumber(n4);
                ++n4;
                if (list != null) {
                    commFrame.setFrameLength((short)list.size());
                } else {
                    commFrame.setFrameLength((short)0);
                }
                commFrame.setFrameData(list);
                commFrame.setETX((byte)23);
                commFrame.setFrameExtension(e);
                by4 = 0;
                BluetoothLog.w("LRC", "======SUB LRC=====");
                by4 = (byte)(by4 ^ commFrame.getFrameType());
                BluetoothLog.w("LRC", "LRC ^ Type:" + by + " LRC =" + by4);
                by4 = (byte)(by4 ^ (byte)(commFrame.getFrameNumber() >> 8 & 0xFF));
                BluetoothLog.w("LRC", "LRC ^ Num:" + (byte)(commFrame.getFrameNumber() >> 8 & 0xFF) + " LRC =" + by4);
                by4 = (byte)(by4 ^ (byte)(commFrame.getFrameNumber() & 0xFF));
                BluetoothLog.w("LRC", "LRC ^ Num:" + (byte)(commFrame.getFrameNumber() & 0xFF) + " LRC =" + by4);
                by4 = (byte)(by4 ^ (byte)(commFrame.getFrameLength() >> 8 & 0xFF));
                BluetoothLog.w("LRC", "LRC ^ Type:" + (byte)(commFrame.getFrameLength() >> 8 & 0xFF) + " LRC =" + by4);
                by4 = (byte)(by4 ^ (byte)(commFrame.getFrameLength() & 0xFF));
                BluetoothLog.w("LRC", "LRC ^ Type:" + (byte)(commFrame.getFrameLength() & 0xFF) + " LRC =" + by4);
                if (commFrame.getFrameData() != null) {
                    BluetoothLog.w(DEBUG_TAG, "commFrame:byteSize = [" + commFrame.getFrameData().size() + "]");
                    int n9 = 0;
                    while (n9 < commFrame.getFrameData().size()) {
                        by4 = (byte)(by4 ^ commFrame.getFrameData().get(n9));
                        ++n9;
                    }
                }
                BluetoothLog.w("LRC", "LRC = " + by4);
                commFrame.setFrameLRC(by4);
                BluetoothLog.e(DEBUG_TAG, "send framNumber:" + FrameUtil.getSendFrameNumber() + " except receive framNumber:" + (byte)(FrameUtil.getSendFrameNumber() + 1));
                arrayList.add(commFrame);
            } while (n7 > 0);
            ((CommFrame)arrayList.get(arrayList.size() - 1)).setETX((byte)3);
            BluetoothLog.w("LRC", "======LRC=====");
            by3 = 0;
            by3 = (byte)(by3 ^ by);
            BluetoothLog.w("LRC", "LRC ^ " + by + " LRC =" + by3);
            by3 = (byte)(by3 ^ (byte)(n8 >> 8 & 0xFF));
            BluetoothLog.w("LRC", "LRC ^ framNumber:" + (byte)(n8 >> 8 & 0xFF) + " LRC =" + by3);
            by3 = (byte)(by3 ^ (byte)(n8 & 0xFF));
            BluetoothLog.w("LRC", "LRC ^ framNumber:" + (byte)(n8 & 0xFF) + " LRC =" + by3);
            by3 = (byte)(by3 ^ (byte)(n6 >> 8 & 0xFF));
            BluetoothLog.w("LRC", "LRC ^ len:" + (byte)(n6 >> 8 & 0xFF) + " LRC =" + by3);
            by3 = (byte)(by3 ^ (byte)(n6 & 0xFF));
            BluetoothLog.w("LRC", "LRC ^len:" + (byte)(n6 & 0xFF) + " LRC =" + by3);
            int n10 = 0;
            while (n10 < n6) {
                by3 = (byte)(by3 ^ audiodata.getData().get(n10));
                ++n10;
            }
            BluetoothLog.w("LRC", "LRC = " + by3);
            ((CommFrame)arrayList.get(arrayList.size() - 1)).setFrameLRC(by3);
        } else {
            arrayList = null;
        }
        return arrayList;
    }

    public static int UnPackFrame(List<Byte> packlist, CommData frameAudioData) {
        if (FrameUtil.getCommProtocol() == 0) {
            int n2 = 0;
            short s = 0;
            byte by = 0;
            short s2 = 0;
            byte by2 = 0;
            ArrayList<Byte> arrayList = null;
            if (packlist.size() < 2) {
                return -2;
            }
            if (2 != packlist.get(n2++)) {
                return -1;
            }
            if (65 != (by2 = packlist.get(n2++).byteValue()) && 68 != by2 && 80 != by2 && 67 != by2 && 83 != by2 && 77 != by2 && 78 != by2) {
                return -3;
            }
            by = (byte)(by ^ by2);
            if (packlist.size() < 8) {
                if (by2 != 77) {
                    return -2;
                }
                return -11;
            }
            by = (byte)(by ^ packlist.get(n2));
            s2 = (short)(packlist.get(n2++) << 8);
            by = (byte)(by ^ packlist.get(n2));
            s2 = (short)(s2 | packlist.get(n2++) & 0xFF);
            by = (byte)(by ^ packlist.get(n2));
            s = (short)(packlist.get(n2++) << 8);
            by = (byte)(by ^ packlist.get(n2));
            s = (short)(s | packlist.get(n2++) & 0xFF);
            BluetoothLog.w(DEBUG_TAG, "length" + s);
            if (65 == by2 || 67 == by2 || 83 == by2 || 78 == by2) {
                if (s != 0) {
                    if (by2 != 77) {
                        return -2;
                    }
                    BluetoothLog.e(DEBUG_TAG, "type is MESSAGE,ignore the error");
                    return -11;
                }
            } else if (s != packlist.size() - 8) {
                if (by2 != 77) {
                    BluetoothLog.w(DEBUG_TAG, "PACKLIST SIZE=" + packlist.size() + "Length=" + s);
                    return -2;
                }
                BluetoothLog.e(DEBUG_TAG, "type is MESSAGE,ignore the error");
                return -11;
            }
            arrayList = new ArrayList<Byte>();
            while (n2 < s + 6) {
                by = (byte)(by ^ packlist.get(n2));
                arrayList.add(packlist.get(n2));
                ++n2;
            }
            if (by != packlist.get(n2++)) {
                if (by2 != 77) {
                    return -4;
                }
                BluetoothLog.e(DEBUG_TAG, "type is MESSAGE,ignore the error");
                return -11;
            }
            if (3 != packlist.get(n2++)) {
                if (by2 != 77) {
                    return -5;
                }
                BluetoothLog.e(DEBUG_TAG, "type is MESSAGE,ignore the error");
                return -11;
            }
            if (by2 == 68) {
                BluetoothLog.w(DEBUG_TAG, "Receive Data");
                frameAudioData.setType(by2);
                frameAudioData.setData(arrayList);
            } else if (by2 == 67) {
                BluetoothLog.w(DEBUG_TAG, "Receive Cancel");
                frameAudioData.setType(by2);
                frameAudioData.setData(null);
            } else if (by2 == 83) {
                BluetoothLog.w(DEBUG_TAG, "Receive ShutDown");
                frameAudioData.setType(by2);
                frameAudioData.setData(null);
            } else if (by2 == 65 || by2 == 78) {
                BluetoothLog.w(DEBUG_TAG, "Receive Command or NAK");
                frameAudioData.setType(by2);
                frameAudioData.setData(null);
            } else if (by2 == 80) {
                BluetoothLog.w(DEBUG_TAG, "Receive Paramater");
                frameAudioData.setType(by2);
                frameAudioData.setData(arrayList);
            } else if (by2 == 77) {
                BluetoothLog.w(DEBUG_TAG, "Receive Message");
                frameAudioData.setType(by2);
                frameAudioData.setData(arrayList);
            } else {
                frameAudioData.setType(by2);
                frameAudioData.setData(arrayList);
            }
            return 0;
        }
        if (FrameUtil.getCommProtocol() == 1) {
            int n3;
            int n4 = 0;
            short s = 0;
            short s3 = 0;
            int n5 = 0;
            short s4 = 0;
            int n6 = 0;
            byte by = 0;
            byte by3 = 0;
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<Byte> arrayList = null;
            CommFrame commFrame = new CommFrame();
            if (packlist.size() < 2) {
                BluetoothLog.e("WAV2CMD", "Unpack FRAME_LENGTH_ERROR");
                return -2;
            }
            if (2 != packlist.get(n5++)) {
                BluetoothLog.e("WAV2CMD", "Unpack FRAME_STX_ERROR");
                return -1;
            }
            commFrame.setSTX((byte)2);
            by = packlist.get(n5++);
            if (65 != by && 68 != by && 80 != by && 67 != by && 83 != by && 77 != by && 78 != by) {
                BluetoothLog.e("WAV2CMD", "Unpack FRAME_TYPE_ERROR");
                return -3;
            }
            commFrame.setFrameType(by);
            if (packlist.size() < 8) {
                if (by != 77) {
                    BluetoothLog.e("WAV2CMD", "Unpack FRAME_TYPE_ERROR [2]");
                    return -2;
                }
                BluetoothLog.e("WAV2CMD", "Unpack FRAME_IGNORE_ERROR");
                return -11;
            }
            n6 = packlist.get(n5++) << 8 & 0xFF00;
            BluetoothLog.e(DEBUG_TAG, "current FrameNumber:" + (n6 |= packlist.get(n5++) & 0xFF) + " expect FrameNumber:" + FrameUtil.getRecvFrameNumber());
            if (65 == by) {
                if ((short)(n6 - FrameUtil.getSendFrameNumber()) == 1) {
                    bl = true;
                    n4 = 1;
                    s = (short)n6;
                } else {
                    bl = false;
                    if ((short)(FrameUtil.getSendFrameNumber() - n6) == 0) {
                        bl2 = true;
                        BluetoothLog.e(DEBUG_TAG, "\u63a5\u6536\u91cd\u53d1\u5e94\u7b54\u5e27...\u63a5\u6536\u5230\u7684 frame = " + n6 + " \u4fdd\u5b58\u7684sendframe = " + FrameUtil.getSendFrameNumber());
                    } else {
                        bl2 = false;
                        BluetoothLog.e(DEBUG_TAG, "\u63a5\u6536\u9519\u8bef\u5e94\u7b54\u5e27...\u63a5\u6536\u5230\u7684 frame = " + n6 + " \u4fdd\u5b58\u7684sendframe = " + FrameUtil.getSendFrameNumber());
                    }
                }
            } else if (68 == by) {
                if (g) {
                    n4 = 2;
                    s3 = (short)(n6 + 1);
                    bl = true;
                } else if ((short)(n6 - FrameUtil.getRecvFrameNumber()) == 0) {
                    bl = true;
                    n4 = 2;
                    s3 = (short)(n6 + 1);
                } else {
                    bl = false;
                    if ((short)(FrameUtil.getRecvFrameNumber() - n6) == 1) {
                        BluetoothLog.e(DEBUG_TAG, "\u63a5\u6536DATA\u91cd\u53d1\u5e27...\u63a5\u6536\u5230\u7684 frame = " + n6 + " \u4fdd\u5b58\u7684recvframe = " + FrameUtil.getRecvFrameNumber());
                        bl2 = true;
                    } else {
                        BluetoothLog.e(DEBUG_TAG, "\u63a5\u6536DATA\u5e27\u9519\u8bef...\u63a5\u6536\u5230\u7684 frame = " + n6 + " \u4fdd\u5b58\u7684recvframe = " + FrameUtil.getRecvFrameNumber());
                        bl2 = false;
                    }
                }
            } else if (80 == by) {
                bl = true;
                n4 = 1;
                s = (short)(FrameUtil.getSendFrameNumber() + 1);
            } else {
                bl = true;
                BluetoothLog.e(DEBUG_TAG, "\u63a5\u6536\u5176\u4ed6\u7c7b\u578b\u4e0d\u5224\u65ad...\u63a5\u6536frame = " + n6 + " \u4fdd\u5b58recvframe = " + FrameUtil.getRecvFrameNumber() + " \u4fdd\u5b58sendframe = " + FrameUtil.getSendFrameNumber());
            }
            commFrame.setFrameNumber(n6);
            s4 = (short)(packlist.get(n5++) << 8);
            s4 = (short)(s4 | packlist.get(n5++) & 0xFF);
            BluetoothLog.w(DEBUG_TAG, "length" + s4);
            if (65 == by || 67 == by || 83 == by || 78 == by) {
                if (s4 != 0) {
                    if (by != 77) {
                        return -2;
                    }
                    return -11;
                }
            } else if (s4 != packlist.size() - 8) {
                BluetoothLog.w(DEBUG_TAG, "PACKLIST SIZE=" + packlist.size() + "Length=" + s4);
                if (by != 77) {
                    return -2;
                }
                return -11;
            }
            commFrame.setFrameLength(s4);
            arrayList = new ArrayList<Byte>();
            while (n5 < s4 + 6) {
                arrayList.add(packlist.get(n5));
                ++n5;
            }
            commFrame.setFrameData(arrayList);
            by3 = packlist.get(n5++);
            commFrame.setFrameLRC(by3);
            if (23 != packlist.get(n5) && 3 != packlist.get(n5)) {
                if (by != 77) {
                    return -5;
                }
                return -11;
            }
            commFrame.setETX(packlist.get(n5));
            BluetoothLog.w("LRC", "^^^^^^^recv data^^^^^^");
            if (23 == packlist.get(n5)) {
                BluetoothLog.w(DEBUG_TAG, "Recv Frame ETB");
                byte by4 = 0;
                List<Byte> list = commFrame.getFrameData();
                by4 = (byte)(by4 ^ commFrame.getFrameType());
                by4 = (byte)(by4 ^ (byte)(commFrame.getFrameNumber() >> 8 & 0xFF));
                by4 = (byte)(by4 ^ (byte)(commFrame.getFrameNumber() & 0xFF));
                by4 = (byte)(by4 ^ (byte)(commFrame.getFrameLength() >> 8 & 0xFF));
                by4 = (byte)(by4 ^ (byte)(commFrame.getFrameLength() & 0xFF));
                int n7 = 0;
                while (n7 < list.size()) {
                    by4 = (byte)(by4 ^ list.get(n7));
                    ++n7;
                }
                if (by4 != commFrame.getFrameLRC()) {
                    BluetoothLog.e("LRC", "ETB LRC WRONG " + commFrame.getFrameType() + " LRC=" + by4 + ":" + commFrame.getFrameLRC());
                    return -4;
                }
                BluetoothLog.w("LRC", "ETB LRC OK" + commFrame.getFrameType() + " LRC=" + by4);
                frameAudioData.setFrameOver(false);
                if (bl) {
                    BluetoothLog.e("LRC", "ETB Add queue");
                    f.offer(commFrame);
                    frameAudioData.setType(commFrame.getFrameType());
                    frameAudioData.setData(commFrame.getFrameData());
                    frameAudioData.setFrameNum(commFrame.getFrameNumber());
                    BluetoothLog.e(DEBUG_TAG, "ETB \u6b63\u786e");
                    if ((n4 & 1) == 1) {
                        FrameUtil.setSendFrameNumber(s);
                        BluetoothLog.e(DEBUG_TAG, "\u53d1\u9001\u5e27\u53f7\u66f4\u65b0 = " + FrameUtil.getSendFrameNumber());
                    }
                    if ((n4 & 2) == 2) {
                        FrameUtil.a(s3);
                        BluetoothLog.e(DEBUG_TAG, "\u63a5\u6536\u5e27\u53f7\u66f4\u65b0 = " + FrameUtil.getRecvFrameNumber());
                    }
                    if (68 == by && g) {
                        g = false;
                        h = (short)n6;
                        BluetoothLog.e(DEBUG_TAG, "\u91cd\u7f6e\u9996\u5e27  = " + h);
                    }
                    return 1;
                }
                if (bl2) {
                    return 11;
                }
                BluetoothLog.e(DEBUG_TAG, "FrameNumber is Wrong");
                return -12;
            }
            BluetoothLog.w(DEBUG_TAG, "Recv Frame ETX");
            frameAudioData.setFrameOver(true);
            if (bl) {
                ArrayList<Byte> arrayList2 = new ArrayList<Byte>();
                CommFrame commFrame22 = null;
                boolean bl3 = true;
                byte by5 = 0;
                BluetoothLog.e("LRC", "ETB num = " + f.size());
                for (CommFrame commFrame22 : f) {
                    if (commFrame22.getFrameData() != null) {
                        if (commFrame22.getFrameType() != commFrame.getFrameType()) {
                            BluetoothLog.e("LRC", "\u53d1\u73b0\u4e0d\u540cTYPE \uff1a " + commFrame.getFrameType() + " frameType = " + commFrame22.getFrameType());
                            continue;
                        }
                        arrayList2.addAll(commFrame22.getFrameData());
                    }
                    if (!bl3) continue;
                    bl3 = false;
                    by5 = (byte)(by5 ^ commFrame22.getFrameType());
                    by5 = (byte)(by5 ^ (byte)(commFrame22.getFrameNumber() >> 8 & 0xFF));
                    by5 = (byte)(by5 ^ (byte)(commFrame22.getFrameNumber() & 0xFF));
                }
                if (commFrame.getFrameData() != null) {
                    arrayList2.addAll(commFrame.getFrameData());
                }
                if (bl3) {
                    by5 = (byte)(by5 ^ commFrame.getFrameType());
                    by5 = (byte)(by5 ^ (byte)(commFrame.getFrameNumber() >> 8 & 0xFF));
                    by5 = (byte)(by5 ^ (byte)(commFrame.getFrameNumber() & 0xFF));
                }
                by5 = (byte)(by5 ^ (byte)(arrayList2.size() >> 8 & 0xFF));
                by5 = (byte)(by5 ^ (byte)(arrayList2.size() & 0xFF));
                BluetoothLog.e(DEBUG_TAG, "All Frame Size" + arrayList2.size());
                int n8 = 0;
                while (n8 < arrayList2.size()) {
                    by5 = (byte)(by5 ^ (Byte)arrayList2.get(n8));
                    ++n8;
                }
                BluetoothLog.w(DEBUG_TAG, "clacLRC:" + by5 + " compareLRC:" + by3);
                if (by5 == by3) {
                    BluetoothLog.e("LRC", "Clear Frame Queue");
                    BluetoothLog.e(DEBUG_TAG, "ETX \u6b63\u786e");
                    f.clear();
                    frameAudioData.setType(commFrame.getFrameType());
                    frameAudioData.setData(arrayList2);
                    if ((n4 & 1) == 1) {
                        FrameUtil.setSendFrameNumber(s);
                        BluetoothLog.e(DEBUG_TAG, "\u53d1\u9001\u5e27\u53f7\u66f4\u65b0 = " + FrameUtil.getSendFrameNumber());
                    }
                    if ((n4 & 2) == 2) {
                        FrameUtil.a(s3);
                        BluetoothLog.e(DEBUG_TAG, "\u63a5\u6536\u5e27\u53f7\u66f4\u65b0 = " + FrameUtil.getRecvFrameNumber());
                    }
                    if (68 == by && g) {
                        g = false;
                        h = (short)n6;
                        BluetoothLog.e(DEBUG_TAG, "\u91cd\u7f6e\u9996\u5e27  = " + h);
                    }
                    BluetoothLog.w("LRC", "ETX LRC OK " + commFrame.getFrameType() + " LRC = " + by5);
                    return 0;
                }
                BluetoothLog.e("LRC", "ETX LRC WRONG " + commFrame.getFrameType());
                if (by != 77) {
                    return -4;
                }
                return -11;
            }
            BluetoothLog.e(DEBUG_TAG, "FrameNumber is Wrong");
            byte by6 = 0;
            by6 = (byte)(by6 ^ commFrame.getFrameType());
            by6 = (byte)(by6 ^ (byte)(commFrame.getFrameNumber() >> 8 & 0xFF));
            by6 = (byte)(by6 ^ (byte)(commFrame.getFrameNumber() & 0xFF));
            by6 = (byte)(by6 ^ (byte)(commFrame.getFrameLength() >> 8 & 0xFF));
            by6 = (byte)(by6 ^ (byte)(commFrame.getFrameLength() & 0xFF));
            if (commFrame.getFrameData() != null) {
                n3 = 0;
                while (n3 < commFrame.getFrameData().size()) {
                    by6 = (byte)(by6 ^ commFrame.getFrameData().get(n3));
                    ++n3;
                }
            }
            if (by6 == by3) {
                n3 = 11;
                if (bl2) {
                    n3 = 11;
                } else {
                    BluetoothLog.e(DEBUG_TAG, "ETX \u5e27\u53f7\u9519\u8bef\uff0c\u4ecd\u7136SUCCESS");
                    if ((n4 & 1) == 1) {
                        FrameUtil.setSendFrameNumber(s);
                        BluetoothLog.e(DEBUG_TAG, "\u53d1\u9001\u5e27\u53f7\u66f4\u65b0 = " + FrameUtil.getSendFrameNumber());
                    }
                    if ((n4 & 2) == 2) {
                        FrameUtil.a(s3);
                        BluetoothLog.e(DEBUG_TAG, "\u63a5\u6536\u5e27\u53f7\u66f4\u65b0 = " + FrameUtil.getRecvFrameNumber());
                    }
                    if (68 == by && g) {
                        g = false;
                        h = (short)n6;
                        BluetoothLog.e(DEBUG_TAG, "\u91cd\u7f6e\u9996\u5e27  = " + h);
                    }
                    n3 = 0;
                }
                BluetoothLog.w("LRC", " - ETX LRC OK " + commFrame.getFrameType() + " LRC = " + by6);
                BluetoothLog.e("LRC", "Clear Frame Queue");
                f.clear();
                frameAudioData.setType(commFrame.getFrameType());
                frameAudioData.setData(commFrame.getFrameData());
                frameAudioData.setFrameNum(commFrame.getFrameNumber());
                return n3;
            }
            BluetoothLog.e("LRC", " - ETX LRC FAIL " + commFrame.getFrameType());
            if (by != 77) {
                return -4;
            }
            return -11;
        }
        return -13;
    }

    public static CommFrame PackBluetoothFrame(CommData commdata) {
        int n2 = 0;
        byte by = commdata.getType();
        byte by2 = 0;
        BluetoothLog.w(DEBUG_TAG, "PackBluetoothFrame--commFrameType=" + by);
        if (by == 68) {
            if (commdata.getData() != null) {
                n2 = commdata.getData().size();
            }
            BluetoothLog.w(DEBUG_TAG, "PackFrame DATA Length=" + n2);
        } else if (by == 83) {
            n2 = 0;
            BluetoothLog.w(DEBUG_TAG, "PackFrame ShutDown");
        } else if (by == 67) {
            n2 = 0;
            BluetoothLog.w(DEBUG_TAG, "PackFrame Cancel");
        } else if (by == 65) {
            n2 = 0;
            BluetoothLog.w(DEBUG_TAG, "PackFrame Command");
        } else if (by == 78) {
            n2 = 0;
            BluetoothLog.w(DEBUG_TAG, "PackFrame NAK");
        } else if (by == 80) {
            if (commdata.getData() != null) {
                n2 = (short)commdata.getData().size();
            }
            BluetoothLog.w(DEBUG_TAG, "PackFrame Paramater Lenght=" + n2);
        } else {
            return null;
        }
        by2 = (byte)(by2 ^ by);
        by2 = (byte)(by2 ^ (byte)(FrameUtil.getSendFrameNumber() >> 8 & 0xFF));
        by2 = (byte)(by2 ^ (byte)(FrameUtil.getSendFrameNumber() & 0xFF));
        by2 = (byte)(by2 ^ (byte)(n2 >> 8 & 0xFF));
        by2 = (byte)(by2 ^ (byte)(n2 & 0xFF));
        int n3 = 0;
        while (n3 < n2) {
            by2 = (byte)(by2 ^ commdata.getData().get(n3));
            ++n3;
        }
        CommFrame commFrame = new CommFrame();
        commFrame.setSTX((byte)2);
        commFrame.setFrameType(by);
        commFrame.setFrameNumber(FrameUtil.getSendFrameNumber());
        if (commdata.getData() != null) {
            commFrame.setFrameLength((short)commdata.getData().size());
        } else {
            commFrame.setFrameLength((short)0);
        }
        commFrame.setFrameData(commdata.getData());
        commFrame.setFrameLRC(by2);
        commFrame.setETX((byte)3);
        commFrame.setFrameExtension(null);
        short s = (short)FrameUtil.getSendFrameNumber();
        BluetoothLog.w(DEBUG_TAG, "sendFrameNumber_this=" + (s & 0xFFFF));
        s = (short)(s + 8);
        BluetoothLog.w(DEBUG_TAG, "sendFrameNumber_next=" + (s & 0xFFFF));
        if (s == 0) {
            FrameUtil.setSendFrameNumber((short)0);
        } else {
            FrameUtil.setSendFrameNumber(s);
        }
        return commFrame;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int bluetoothReadMsg(InputStream input, byte[] receiveMsg, int length, int timeout) {
        int n2 = 0;
        long l2 = System.currentTimeMillis();
        byte[] byArray = new byte[length];
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        short s = 0;
        BluetoothLog.w(DEBUG_TAG, "bluetoothReadMsg read...");
        try {
            while (System.currentTimeMillis() - l2 < (long)timeout && n2 < length) {
                int n4;
                block14: {
                    block13: {
                        n4 = input.available();
                        if (n4 == 0) break block13;
                        if (!bl) {
                            n3 = input.read(byArray);
                            if (n3 < 6) {
                                BluetoothLog.w(DEBUG_TAG, "head length is less than 6");
                                return 0;
                            }
                            s = (short)(byArray[4] << 8);
                            s = (short)(s | byArray[5] & 0xFF);
                            BluetoothLog.w(DEBUG_TAG, "framHeadBuf--recv len=" + n3 + ",frameLength=" + s);
                            System.arraycopy(byArray, 0, receiveMsg, 0, 6);
                            length = s + 2;
                            if (n3 >= 8) {
                                if (n3 >= s + 8) {
                                    BluetoothLog.w(DEBUG_TAG, "all frame in one read");
                                    System.arraycopy(byArray, 0, receiveMsg, 0, s + 8);
                                    return n3;
                                }
                                BluetoothLog.w(DEBUG_TAG, "the readed data len less than frameLength+8,continue read...");
                                bl2 = true;
                                System.arraycopy(byArray, 0, receiveMsg, 0, n3);
                            }
                        }
                        break block14;
                    }
                    Thread.sleep(10L);
                }
                if (!bl && n4 != 0) {
                    n4 = input.available();
                    bl = true;
                }
                if (n4 != 0) {
                    byte[] byArray2 = n4 < 0 || n2 + n4 > length ? new byte[length - n2] : new byte[n4];
                    n4 = input.read(byArray2);
                    BluetoothLog.w(DEBUG_TAG, "input.read() success,len=" + n4);
                    if (n4 == 0) continue;
                    if (bl2) {
                        System.arraycopy(byArray2, 0, receiveMsg, n2 + n3, n4);
                    } else {
                        System.arraycopy(byArray2, 0, receiveMsg, n2 + 6, n4);
                    }
                    n2 += n4;
                    continue;
                }
                Thread.sleep(10L);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            if (n2 == 0) {
                n2 = -1;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        BluetoothLog.w(DEBUG_TAG, "receive length:" + n2 + n3);
        return n2 + n3;
    }

    public static CommData UnPackBluetoothFrame(InputStream inStream, long timeout) throws FrameParseException, TimeoutException, IOException {
        boolean bl = false;
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        a a2 = com.landicorp.liu.comm.api.FrameUtil$a.a;
        CommFrame commFrame = new CommFrame();
        int n2 = 0;
        byte by = 0;
        short s = 0;
        int n3 = 0;
        int n4 = 0;
        long l2 = System.currentTimeMillis();
        block11: while (true) {
            Object object;
            if (System.currentTimeMillis() - l2 > timeout) {
                BluetoothLog.w(DEBUG_TAG, "Timeout");
                object = new TimeoutException("Unpack frame timeout");
                throw object;
            }
            object = new byte[65543];
            n2 = FrameUtil.bluetoothReadMsg(inStream, object, 65543, (int)timeout);
            n4 = 0;
            BluetoothLog.w(DEBUG_TAG, "receive data");
            while (true) {
                if (n2 <= 0) continue block11;
                switch (FrameUtil.a()[a2.ordinal()]) {
                    case 1: {
                        BluetoothLog.w(DEBUG_TAG, "STX");
                        if (object[n4] != 2) {
                            FrameParseException frameParseException = new FrameParseException("STX is wrong!");
                            frameParseException.setErrorType(-1);
                            throw frameParseException;
                        }
                        commFrame.setSTX(object[n4]);
                        a2 = com.landicorp.liu.comm.api.FrameUtil$a.b;
                        break;
                    }
                    case 2: {
                        BluetoothLog.w(DEBUG_TAG, "FRAMETYPE");
                        if (object[n4] != 80 && object[n4] != 83 && object[n4] != 65 && object[n4] != 78 && object[n4] != 77 && object[n4] != 68 && object[n4] != 67) {
                            FrameParseException frameParseException = new FrameParseException("FrameType is wrong!");
                            frameParseException.setErrorType(-3);
                            throw frameParseException;
                        }
                        BluetoothLog.w(DEBUG_TAG, "FRAMETYPE=" + object[n4]);
                        by = (byte)(by ^ object[n4]);
                        commFrame.setFrameType(object[n4]);
                        a2 = com.landicorp.liu.comm.api.FrameUtil$a.c;
                        break;
                    }
                    case 3: {
                        BluetoothLog.w(DEBUG_TAG, "FRAMENUMBER_HI");
                        by = (byte)(by ^ object[n4]);
                        n3 = (short)(object[n4] << 8);
                        a2 = com.landicorp.liu.comm.api.FrameUtil$a.d;
                        break;
                    }
                    case 4: {
                        BluetoothLog.w(DEBUG_TAG, "FRAMENUMBER_LO");
                        n3 = (short)(n3 | object[n4] & 0xFF);
                        if (n3 < 0) {
                            FrameParseException frameParseException = new FrameParseException("FrameNumber is wrong!");
                            frameParseException.setErrorType(-12);
                            throw frameParseException;
                        }
                        BluetoothLog.w(DEBUG_TAG, "RcvFrameNumber=" + n3);
                        by = (byte)(by ^ object[n4]);
                        commFrame.setFrameNumber(n3);
                        a2 = com.landicorp.liu.comm.api.FrameUtil$a.e;
                        break;
                    }
                    case 5: {
                        BluetoothLog.w(DEBUG_TAG, "FRAMELENGTH_HI");
                        by = (byte)(by ^ object[n4]);
                        s = (short)(object[n4] << 8);
                        a2 = com.landicorp.liu.comm.api.FrameUtil$a.f;
                        break;
                    }
                    case 6: {
                        BluetoothLog.w(DEBUG_TAG, "FRAMELENGTH_LO");
                        s = (short)(s | object[n4] & 0xFF);
                        if (s < 0 || s > 2048) {
                            FrameParseException frameParseException = new FrameParseException("FrameLength is wrong!");
                            frameParseException.setErrorType(-2);
                            throw frameParseException;
                        }
                        BluetoothLog.w(DEBUG_TAG, "frameLength=" + s);
                        by = (byte)(by ^ object[n4]);
                        commFrame.setFrameLength(s);
                        a2 = com.landicorp.liu.comm.api.FrameUtil$a.g;
                        break;
                    }
                    case 7: {
                        if (arrayList.size() < s) {
                            by = (byte)(by ^ object[n4]);
                            arrayList.add(object[n4]);
                        }
                        if (arrayList.size() != s) break;
                        BluetoothLog.w(DEBUG_TAG, "FRAMEDATA");
                        commFrame.setFrameData(arrayList);
                        a2 = com.landicorp.liu.comm.api.FrameUtil$a.h;
                        break;
                    }
                    case 8: {
                        BluetoothLog.w(DEBUG_TAG, "FRAMELRC");
                        byte by2 = object[n4];
                        BluetoothLog.e(DEBUG_TAG, "offset:" + n4);
                        if (by != by2) {
                            FrameParseException frameParseException = new FrameParseException("FrameLRC is wrong! calcLRC:" + by + " compareLRC:" + by2);
                            frameParseException.setErrorType(-4);
                            throw frameParseException;
                        }
                        commFrame.setFrameLRC(by2);
                        a2 = com.landicorp.liu.comm.api.FrameUtil$a.i;
                        break;
                    }
                    case 9: {
                        BluetoothLog.w(DEBUG_TAG, "FRAMEETX");
                        if (object[n4] != 3) {
                            FrameParseException frameParseException = new FrameParseException("ETX is wrong!");
                            frameParseException.setErrorType(-5);
                            throw frameParseException;
                        }
                        commFrame.setETX(object[n4]);
                        CommData commData = new CommData(commFrame.getFrameType(), commFrame.getFrameData());
                        commData.setFrameNum(commFrame.getFrameNumber());
                        return commData;
                    }
                }
                if (a2 == com.landicorp.liu.comm.api.FrameUtil$a.h && s == 0) continue;
                ++n4;
                --n2;
            }
            break;
        }
    }

    public static BitSet Frame2Bit(List<Byte> frameData) {
        BitSet bitSet = new BitSet();
        Byte by = new Byte(0);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < frameData.size()) {
            by = frameData.get(n4);
            bitSet.set(n3, false);
            int n5 = 0;
            n5 = 0;
            while (n5 < 8) {
                ++n3;
                if ((1 << n5 & by) != 0) {
                    bitSet.set(n3, true);
                    ++n2;
                } else {
                    bitSet.set(n3, false);
                }
                ++n5;
            }
            ++n3;
            if (n2 % 2 == 0) {
                bitSet.set(n3, false);
            } else {
                bitSet.set(n3, true);
            }
            n2 = 0;
            bitSet.set(++n3, true);
            ++n3;
            ++n4;
        }
        return bitSet;
    }

    public static int Bit2Frame(int[] data, int length, List<Byte> frameData) {
        byte by = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[11];
        if (length % 11 != 0) {
            n5 = length - length % 11;
        }
        if (n5 == 0 || n5 % 11 != 0) {
            return -6;
        }
        int n6 = 0;
        while (n3 < n5) {
            System.arraycopy(data, n3, nArray, 0, 11);
            n4 = 0;
            n4 = 0;
            while (n4 < nArray.length) {
                if (n4 == 0 && nArray[n4] != 0) {
                    n6 = -8;
                    break;
                }
                if (n4 == 9) {
                    if (n2 % 2 == 0 && nArray[n4] != 0 && n2 % 2 == 1 && nArray[n4] != 1) {
                        n6 = -9;
                        break;
                    }
                } else {
                    if (n4 == 10 && nArray[n4] != 1) {
                        n6 = -10;
                        break;
                    }
                    if (nArray[n4] == 1) {
                        ++n2;
                        by = (byte)(by | 1 << n4 - 1);
                    }
                }
                ++n4;
            }
            if (n6 != 0) break;
            frameData.add(by);
            by = 0;
            n3 += 11;
        }
        if (n6 != 0) {
            BluetoothLog.e(DEBUG_TAG, "BIT2FRAME FAILED:" + n6 + " " + n3);
        }
        if (n6 != 0 && n3 < 50) {
            n6 = -11;
        }
        return n6;
    }

    public static int Bit2Frame(String bitString, List<Byte> frameData) {
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = null;
        byte by = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (bitString.length() % 11 != 0) {
            n5 = bitString.length() - bitString.length() % 11;
            bitString = bitString.substring(0, n5);
        }
        if (bitString.length() == 0 || bitString.length() % 11 != 0) {
            return -6;
        }
        n4 = 0;
        while (n4 < bitString.length()) {
            if (bitString.charAt(n4) == '1') {
                bitSet.set(n4, true);
            } else if (bitString.charAt(n4) == '0') {
                bitSet.set(n4, false);
            } else {
                return -7;
            }
            ++n4;
        }
        while (n3 < bitString.length()) {
            bitSet2 = bitSet.get(n3, n3 + 11);
            n4 = 0;
            n4 = 0;
            while (n4 < bitSet2.length()) {
                if (n4 == 0 && bitSet2.get(n4)) {
                    return -8;
                }
                if (n4 == 9) {
                    if (n2 % 2 == 0 && bitSet2.get(n4) && n2 % 2 == 1 && !bitSet2.get(n4)) {
                        return -9;
                    }
                } else {
                    if (n4 == 10 && !bitSet2.get(n4)) {
                        return -10;
                    }
                    if (bitSet2.get(n4)) {
                        ++n2;
                        by = (byte)(by | 1 << n4 - 1);
                    }
                }
                ++n4;
            }
            frameData.add(by);
            by = 0;
            bitSet2.clear();
            n3 += 11;
        }
        return 0;
    }

    static /* synthetic */ int[] a() {
        if (i != null) {
            return i;
        }
        int[] nArray = new int[com.landicorp.liu.comm.api.FrameUtil$a.values().length];
        try {
            nArray[com.landicorp.liu.comm.api.FrameUtil$a.g.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.landicorp.liu.comm.api.FrameUtil$a.i.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.landicorp.liu.comm.api.FrameUtil$a.e.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.landicorp.liu.comm.api.FrameUtil$a.f.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.landicorp.liu.comm.api.FrameUtil$a.h.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.landicorp.liu.comm.api.FrameUtil$a.c.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.landicorp.liu.comm.api.FrameUtil$a.d.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.landicorp.liu.comm.api.FrameUtil$a.b.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.landicorp.liu.comm.api.FrameUtil$a.a.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        i = nArray;
        return nArray;
    }

    private static enum a {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h,
        i;

    }
}

