/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.adapter;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.landicorp.robert.comm.adapter.CommAdapter;
import com.landicorp.robert.comm.control.CCommController;
import com.landicorp.robert.comm.control.CCommControllerEx;
import com.landicorp.robert.comm.setting.AudioCommParam;
import com.landicorp.util.Logger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;

public class AudioCommAdapter
extends CommAdapter<AudioCommParam>
implements CCommController.ICommControllerListener {
    protected CCommController mController = null;
    protected Context mContext = null;
    protected CommAdapter.ICommAdapterListener<AudioCommParam> mCommAdapterListener = null;
    protected CommAdaptThread mCommAdaptThread = null;
    protected CommAdaptListenHandler mCommAdaptListenHandler = null;
    protected HandlerThread mCommAdaptListenHandlerThread = null;
    protected Object mTestTaskLock = new Object();
    protected int mLastError = 0;
    protected AudioCommParam mCommParam = new AudioCommParam();
    protected TreeMap<Double, TestParam> mTestParamMap = new TreeMap();
    protected static final short TEST_EXCHANGE_SIZE_MAX = 512;
    protected static final short TEST_BAUDRATE_STANDARD = 3675;
    protected List<byte[]> mTestExchangeDataList = new ArrayList<byte[]>();
    protected byte[] mTestExchangeData = new byte[512];
    protected byte[] mTestExchangeDataHalf = new byte[256];
    protected byte[] mTestExchangeDataQuarter = new byte[128];
    protected List<Integer> mSampleFrequencyList = new ArrayList<Integer>();
    protected List<Integer> mRecvBaudRateList = new ArrayList<Integer>();
    protected List<Integer> mVoltageList = new ArrayList<Integer>();
    protected List<Integer> mWaveList = new ArrayList<Integer>();
    protected List<Integer> mAudioSourceList = new ArrayList<Integer>();
    protected List<Float> mSendVolumeList = new ArrayList<Float>();
    protected int mCurrentTestProgress = 0;
    protected int mTotalTestProgress = 0;
    protected int mOneTestProgress = 0;
    protected boolean mInterrupted = false;
    protected boolean mWaitFlag = false;
    protected Object mWaitLock = new Object();
    protected boolean mParamFlag = false;
    protected boolean mDataFlag = false;
    protected static final int WAIT_TIMEOUT_MIN = 3000;
    protected static final int WAIT_TIMEOUT_LAUNCH = 6000;
    protected boolean mIsLaunchFlag = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean waitfor(long timeout) {
        Object object = this.mWaitLock;
        synchronized (object) {
            long l2;
            this.mWaitFlag = true;
            long l3 = l2 = System.currentTimeMillis();
            do {
                try {
                    this.mWaitLock.wait(timeout);
                    l3 = System.currentTimeMillis();
                    if (l3 - l2 >= timeout) {
                        this.mWaitFlag = false;
                        return false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } while (this.mWaitFlag);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signalfor() {
        Object object = this.mWaitLock;
        synchronized (object) {
            this.mWaitFlag = false;
            this.mWaitLock.notify();
        }
    }

    public AudioCommAdapter(CCommController controller, Context context) {
        this.mController = controller;
        this.mContext = context;
        if (this.mContext == null) {
            throw new IllegalArgumentException("AudioCommAdapter : constructor arguments are invalid ; context = " + context);
        }
        if (this.mController == null) {
            this.mController = new CCommControllerEx();
        }
        this.initTestEnvironment();
    }

    protected void buildTransferData(byte[] data) {
        if (data == null) {
            return;
        }
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(data);
        if (data.length < 6) {
            return;
        }
        data[3] = -1;
        data[2] = -1;
        data[1] = -1;
        data[0] = -1;
        short s = (short)(data.length - 6);
        data[4] = (byte)(s >> 8 & 0xFF);
        data[5] = (byte)(s & 0xFF);
    }

    protected void initTestEnvironment() {
        this.buildTransferData(this.mTestExchangeData);
        this.buildTransferData(this.mTestExchangeDataHalf);
        this.buildTransferData(this.mTestExchangeDataQuarter);
        this.mTestExchangeDataList.clear();
        this.mTestExchangeDataList.add(this.mTestExchangeData);
        this.mTestExchangeDataList.add(this.mTestExchangeDataHalf);
        this.mTestExchangeDataList.add(this.mTestExchangeDataQuarter);
        this.mSampleFrequencyList.add(44100);
        this.mSampleFrequencyList.add(48000);
        this.mSampleFrequencyList.add(22050);
        this.mSampleFrequencyList.add(96000);
        this.mSampleFrequencyList.add(50000);
        this.mSampleFrequencyList.add(32000);
        this.mSampleFrequencyList.add(47250);
        this.mSampleFrequencyList.add(50400);
        this.mRecvBaudRateList.add(3675);
        this.mRecvBaudRateList.add(1837);
        this.mRecvBaudRateList.add(918);
        this.mVoltageList.add(1000);
        this.mVoltageList.add(3300);
        this.mVoltageList.add(250);
        this.mVoltageList.add(60);
        this.mVoltageList.add(15);
        this.mAudioSourceList.add(1);
        this.mAudioSourceList.add(6);
        this.mSendVolumeList.add(Float.valueOf(1.0f));
        this.mSendVolumeList.add(Float.valueOf(0.2f));
        this.mCurrentTestProgress = 0;
        this.mOneTestProgress = 22 * this.mTestExchangeDataList.size();
        this.mTotalTestProgress = this.mRecvBaudRateList.size() * this.mVoltageList.size() * this.mAudioSourceList.size() * this.mSendVolumeList.size() * this.mOneTestProgress + 1;
    }

    @Override
    public synchronized boolean registerAdapterListener(CommAdapter.ICommAdapterListener<AudioCommParam> lsn) {
        if (this.mCommAdaptThread != null && this.mCommAdaptThread.isAlive()) {
            return false;
        }
        this.mCommAdapterListener = lsn;
        return true;
    }

    @Override
    public synchronized boolean startAdapt() {
        if (this.mCommAdapterListener == null) {
            return false;
        }
        if (this.mCommAdaptThread != null && this.mCommAdaptThread.isAlive()) {
            return false;
        }
        if (this.mController != null && this.mContext != null) {
            this.initialize();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void stopAdapt() {
        this.release();
    }

    protected synchronized void initialize() {
        this.mInterrupted = false;
        this.mTestParamMap.clear();
        this.mCurrentTestProgress = 0;
        this.mCommAdaptListenHandlerThread = new HandlerThread("Robert.AudioCommAdapter.CommAdaptListenHandlerThread");
        this.mCommAdaptListenHandlerThread.setDaemon(true);
        this.mCommAdaptListenHandlerThread.start();
        this.mCommAdaptListenHandler = new CommAdaptListenHandler(this.mCommAdaptListenHandlerThread.getLooper());
        this.mCommAdaptThread = new CommAdaptThread();
        this.mCommAdaptThread.setDaemon(true);
        this.mCommAdaptThread.start();
    }

    protected synchronized void release() {
        this.mInterrupted = true;
        this.signalfor();
        if (this.mCommAdaptListenHandlerThread != null) {
            this.mCommAdaptListenHandlerThread.getLooper().quit();
            this.mCommAdaptListenHandlerThread = null;
        }
        if (this.mCommAdaptThread != null) {
            if (Thread.currentThread().getId() != this.mCommAdaptThread.getId() && this.mCommAdaptThread.isAlive()) {
                try {
                    this.mCommAdaptThread.join(20000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.mCommAdaptThread = null;
        }
        if (this.mTestParamMap != null) {
            this.mTestParamMap.clear();
        }
    }

    protected int tryOpen(AudioCommParam acp) {
        for (Integer n2 : this.mSampleFrequencyList) {
            if (this.mInterrupted) {
                return -2;
            }
            if (n2 / acp.XCP_getSendBaud() < 4) continue;
            acp.XCP_setPlaySampleFrequency(n2);
            acp.XCP_setRecordSampleFrequency(n2);
            this.mCommAdaptListenHandler.SendMessageForInfo("Try open controller.", acp.clone());
            if (this.mController.Open(acp, this.mContext, this, CCommController.CommProject.PRJ_COMM_F2F) != 0) continue;
            this.mCommAdaptListenHandler.SendMessageForInfo("Open controller success.", acp.clone());
            Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "try open success." + n2);
            this.mSampleFrequencyList.clear();
            this.mSampleFrequencyList.add(n2);
            return 0;
        }
        this.mCommAdaptListenHandler.SendMessageForInfo("Open controller failure.", acp.clone());
        return -1;
    }

    private void a() {
        this.mParamFlag = false;
        this.mDataFlag = false;
        this.mLastError = 0;
    }

    protected int calcElapseTime(int baudRate, int byteCount) {
        return ((byteCount + 10) * 11 + 46) * 1000 / baudRate;
    }

    protected int calcExchangeTime(AudioCommParam acp, int dataLen) {
        short s = acp.XCP_getRecvBaud();
        short s2 = acp.XCP_getSendBaud();
        int n2 = this.calcElapseTime(s2, dataLen) + this.calcElapseTime(s2, 8);
        int n3 = this.calcElapseTime(s, dataLen) + this.calcElapseTime(s, 8);
        return n2 + n3 + 3000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int tryOpenDevice(AudioCommParam acp) {
        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryOpenDevice");
        int n2 = this.calcExchangeTime(acp, 64);
        if (this.mIsLaunchFlag) {
            n2 += 6000;
        }
        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "Calc OpenDevice Wait Timeout = " + n2);
        int n3 = 0;
        Object object = this.mWaitLock;
        synchronized (object) {
            block10: {
                block14: {
                    block12: {
                        block13: {
                            block11: {
                                this.mCommAdaptListenHandler.SendMessageForInfo("Try open device.", acp);
                                if (!this.mController.isOpened()) break block10;
                                if (!this.mInterrupted) break block11;
                                Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryOpenDevice but Interrupted.");
                                return -2;
                            }
                            this.a();
                            Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryOpenDevice SendParameter.");
                            n3 = this.mController.SendParameter();
                            if (n3 == 0) break block12;
                            if (n3 != -10) break block13;
                            Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryOpenDevice SendParameter fail, because of NODEVICEDETECTED.");
                            return -2;
                        }
                        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryOpenDevice SendParameter fail...");
                        return -1;
                    }
                    Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryOpenDevice wait result.");
                    if (!this.waitfor(n2)) {
                        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryOpenDevice waitfor timeout...");
                    }
                    Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryOpenDevice wait result = " + this.mParamFlag);
                    if (!this.mParamFlag) break block14;
                    this.mCommAdaptListenHandler.SendMessageForInfo("Open device success.", acp.clone());
                    return 0;
                }
                this.mCommAdaptListenHandler.SendMessageForInfo("Open device failure.", acp.clone());
                return -1;
            }
            Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryOpenDevice is not opened...");
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int tryExchangeData(byte[] data, int waitTime) {
        int n2 = 0;
        Object object = this.mWaitLock;
        synchronized (object) {
            block9: {
                block12: {
                    block11: {
                        block10: {
                            if (!this.mController.isOpened()) break block9;
                            if (!this.mInterrupted) break block10;
                            return -3000;
                        }
                        this.a();
                        n2 = this.mController.SendData(data);
                        if (n2 != 0) {
                            return n2;
                        }
                        if (this.waitfor(waitTime)) break block11;
                        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryExchangeData waitfor timeout..." + waitTime);
                        return -3000;
                    }
                    if (!this.mDataFlag) break block12;
                    return 0;
                }
                if (this.mLastError != 0) {
                    return this.mLastError;
                }
                return -3000;
            }
            return -7;
        }
    }

    protected int tryExchangeDataTest(byte[] data, TestParam tp) {
        tp.reset();
        int n2 = this.calcExchangeTime(tp.mAudioCommParam, data.length);
        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "Calc ExchangeData Wait Timeout = " + n2);
        int n3 = 0;
        int n4 = 0;
        do {
            n4 = this.tryExchangeData(data, n2);
            this.mCommAdaptListenHandler.SendMessageForProgress(this.mCurrentTestProgress + ++n3, this.mTotalTestProgress);
            if (this.mInterrupted) {
                return -2;
            }
            switch (n4) {
                case -10: 
                case -9: {
                    return -2;
                }
                case 0: {
                    ++tp.mTestSuccessCount;
                    break;
                }
            }
            ++tp.mTestTotalCount;
            tp.mTestSuccessRate = (double)tp.mTestSuccessCount / (double)tp.mTestTotalCount;
            double d2 = (double)(20 - tp.mTestTotalCount + tp.mTestSuccessCount) / 20.0;
            double d3 = (double)tp.mTestSuccessCount / 20.0;
            if (tp.mTestSuccessCount == 0 && tp.mTestTotalCount >= 3) {
                Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryExchangeDataTest : test continue failure");
                return -1;
            }
            if (tp.mTestTotalCount < 10) continue;
            if (d3 >= (double)0.9f) {
                Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryExchangeDataTest : test success early and new param = " + tp.toString());
                this.mTestParamMap.put(tp.mTestSuccessRate, tp.clone());
                return 0;
            }
            if (!(d2 < (double)0.9f)) continue;
            TestParam testParam = this.mTestParamMap.get(tp.mTestSuccessRate);
            if (testParam != null) {
                if (testParam.mTestTotalCount < tp.mTestTotalCount) {
                    this.mTestParamMap.put(tp.mTestSuccessRate, tp.clone());
                    Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryExchangeDataTest : fail but higher rate param = " + tp.toString());
                }
            } else {
                this.mTestParamMap.put(tp.mTestSuccessRate, tp.clone());
                Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryExchangeDataTest : fail but first rate param  = " + tp.toString());
            }
            Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryExchangeDataTest : test fail and new param = " + tp.toString());
            return -1;
        } while (tp.mTestTotalCount < 20);
        this.mTestParamMap.put(tp.mTestSuccessRate, tp.clone());
        if (tp.mTestSuccessRate >= (double)0.9f) {
            Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryExchangeDataTest : test max count for success and new param = " + tp.toString());
            return 0;
        }
        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryExchangeDataTest : test mac count for failure and new param = " + tp.toString());
        return -1;
    }

    protected int tryExchangeDataOverallTest(AudioCommParam commParam) {
        TestParam testParam = new TestParam();
        int n2 = 0;
        for (byte[] byArray : this.mTestExchangeDataList) {
            commParam.XCP_setFrameLength((short)byArray.length);
            testParam.mAudioCommParam = commParam.clone();
            this.mCommAdaptListenHandler.SendMessageForInfo("Try test exchange data.", commParam.clone());
            n2 = this.tryExchangeDataTest(byArray, testParam);
            this.mCommAdaptListenHandler.SendMessageForProgress(this.mCurrentTestProgress + 20, this.mTotalTestProgress);
            switch (n2) {
                case -1: {
                    this.mCommAdaptListenHandler.SendMessageForInfo("Test exchange data fail," + testParam.toString(), testParam.mAudioCommParam.clone());
                    break;
                }
                case 0: {
                    this.mCommAdaptListenHandler.SendMessageForInfo("Test exchange data success," + testParam.toString(), testParam.mAudioCommParam.clone());
                    return n2;
                }
                case -2: {
                    this.mCommAdaptListenHandler.SendMessageForInfo("Test exchange data interrupted," + testParam.toString(), testParam.mAudioCommParam.clone());
                    return n2;
                }
                default: {
                    Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "tryExchangeDataOverallTest : tryExchangeDataTest return value error : " + n2);
                }
            }
        }
        return n2;
    }

    protected int overallTestTask() {
        int n2 = -1;
        int n3 = 0;
        this.mIsLaunchFlag = true;
        for (float f2 : this.mSendVolumeList) {
            for (int n4 : this.mAudioSourceList) {
                for (int n5 : this.mRecvBaudRateList) {
                    for (int n6 : this.mVoltageList) {
                        this.mCommParam.XCP_setSendVolume(f2);
                        this.mCommParam.XCP_setAudioSource(n4);
                        this.mCommParam.XCP_setRecvBaud((short)n5);
                        this.mCommParam.XCP_setVoltage((short)n6);
                        this.mCommParam.XCP_setFrameLength((short)512);
                        n3 = 0;
                        n2 = this.tryOpen(this.mCommParam);
                        this.mCommAdaptListenHandler.SendMessageForProgress(this.mCurrentTestProgress + ++n3, this.mTotalTestProgress);
                        if (n2 == 0) {
                            n2 = this.tryOpenDevice(this.mCommParam);
                            this.mCommAdaptListenHandler.SendMessageForProgress(this.mCurrentTestProgress + ++n3, this.mTotalTestProgress);
                            if (n2 == 0) {
                                this.mIsLaunchFlag = false;
                                n2 = this.tryExchangeDataOverallTest(this.mCommParam);
                                if (n2 == 0) {
                                    return 0;
                                }
                            }
                        }
                        this.mCurrentTestProgress += this.mOneTestProgress;
                        this.mCommAdaptListenHandler.SendMessageForProgress(this.mCurrentTestProgress, this.mTotalTestProgress);
                        if (-2 != n2) continue;
                        return n2;
                    }
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onParameter(byte[] data) {
        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "onParameter");
        Object object = this.mWaitLock;
        synchronized (object) {
            if (this.mWaitFlag) {
                this.mParamFlag = true;
                this.signalfor();
                Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "onParameter len = " + data.length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onData(byte[] data) {
        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "onData");
        Object object = this.mWaitLock;
        synchronized (object) {
            if (this.mWaitFlag) {
                this.mDataFlag = true;
                this.signalfor();
                Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "onData len = " + data.length);
            }
        }
    }

    @Override
    public void onCancel(byte[] data) {
        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "onCancel");
    }

    @Override
    public void onShutdown(byte[] data) {
        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "onShutdown");
    }

    @Override
    public void onMessage(byte[] data) {
        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "onMessage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(int code, String details) {
        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "onError");
        Object object = this.mWaitLock;
        synchronized (object) {
            this.mLastError = code;
            switch (code) {
                case -10: 
                case -9: {
                    break;
                }
            }
            this.signalfor();
            Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "onError - code = " + code + " " + details);
        }
    }

    @Override
    public void onDevicePlugged() {
        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "onDevicePlugged");
    }

    @Override
    public void onDeviceUnplugged() {
        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "onDeviceUnplugged");
    }

    @Override
    public void onSend(byte type) {
        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "onSend type = " + type);
    }

    protected class CommAdaptListenHandler
    extends Handler {
        public static final int HANDLER_WHAT_PROGRESS = 0;
        public static final int HANDLER_WHAT_INFO = 1;
        public static final int HANDLER_WHAT_COMPLETE = 2;
        public static final int HANDLER_WHAT_RELEASE = 3;

        public CommAdaptListenHandler(Looper looper) {
            super(looper);
        }

        public void SendMessageForProgress(int currProgress, int totalProgress) {
            this.obtainMessage(0, currProgress, totalProgress).sendToTarget();
        }

        public void SendMessageForInfo(String msg, AudioCommParam cp) {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(msg);
            arrayList.add(cp);
            this.obtainMessage(1, arrayList).sendToTarget();
        }

        public void SendMessageForComplete(int result2, AudioCommParam cp) {
            this.obtainMessage(2, result2, 0, cp).sendToTarget();
        }

        public void SendMessageForRelease() {
            this.obtainMessage(3).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            AudioCommAdapter audioCommAdapter = AudioCommAdapter.this;
            synchronized (audioCommAdapter) {
                if (AudioCommAdapter.this.mCommAdapterListener != null) {
                    switch (msg.what) {
                        case 0: {
                            double d2 = (double)msg.arg1 / (double)msg.arg2;
                            if (d2 > 1.0) {
                                Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "CommAdaptListenHandler : HANDLER_WHAT_PROGRESS rate error = " + d2);
                                d2 = 1.0;
                            }
                            AudioCommAdapter.this.mCommAdapterListener.onProgress(d2);
                            break;
                        }
                        case 1: {
                            try {
                                List list = (List)msg.obj;
                                if (list == null) break;
                                String string = (String)list.get(0);
                                AudioCommParam audioCommParam = (AudioCommParam)list.get(1);
                                AudioCommAdapter.this.mCommAdapterListener.onInformation(string, audioCommParam);
                            }
                            catch (Exception exception) {
                                Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "CommAdaptListenHandler : HANDLER_WHAT_INFO Exception = " + exception.getMessage());
                            }
                            break;
                        }
                        case 2: {
                            try {
                                AudioCommParam audioCommParam = (AudioCommParam)msg.obj;
                                AudioCommAdapter.this.mCommAdapterListener.onComplete(msg.arg1, audioCommParam);
                            }
                            catch (Exception exception) {
                                Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "CommAdaptListenHandler : HANDLER_WHAT_COMPLETE Exception = " + exception.getMessage());
                            }
                            break;
                        }
                        case 3: {
                            AudioCommAdapter.this.release();
                            break;
                        }
                    }
                }
            }
        }
    }

    protected class CommAdaptThread
    extends Thread {
        protected CommAdaptThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            Object object = AudioCommAdapter.this.mTestTaskLock;
            synchronized (object) {
                int n2 = -1;
                Date date = new Date();
                Date date2 = null;
                n2 = AudioCommAdapter.this.overallTestTask();
                date2 = new Date();
                long l2 = date2.getTime() - date.getTime();
                long l3 = l2 / 1000L / 60L / 60L % 60L;
                long l4 = l2 / 1000L / 60L % 60L;
                long l5 = l2 / 1000L % 60L;
                long l6 = l2 % 1000L;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Elapse time : ");
                stringBuilder.append(l3);
                stringBuilder.append(":");
                stringBuilder.append(l4);
                stringBuilder.append(":");
                stringBuilder.append(l5);
                stringBuilder.append(".");
                stringBuilder.append(l6);
                switch (n2) {
                    case -1: {
                        AudioCommAdapter.this.mCommAdaptListenHandler.SendMessageForInfo(stringBuilder.toString(), new AudioCommParam());
                        AudioCommAdapter.this.mCommAdaptListenHandler.SendMessageForProgress(AudioCommAdapter.this.mTotalTestProgress, AudioCommAdapter.this.mTotalTestProgress);
                        AudioCommAdapter.this.mCommAdaptListenHandler.SendMessageForComplete(-1, new AudioCommParam());
                        break;
                    }
                    case -2: {
                        AudioCommAdapter.this.mCommAdaptListenHandler.SendMessageForInfo(stringBuilder.toString(), new AudioCommParam());
                        AudioCommAdapter.this.mCommAdaptListenHandler.SendMessageForComplete(-2, new AudioCommParam());
                        break;
                    }
                    case 0: {
                        TestParam testParam = AudioCommAdapter.this.mTestParamMap.get(AudioCommAdapter.this.mTestParamMap.lastKey());
                        AudioCommAdapter.this.mCommAdaptListenHandler.SendMessageForInfo(stringBuilder.toString(), testParam.mAudioCommParam);
                        AudioCommAdapter.this.mCommAdaptListenHandler.SendMessageForProgress(AudioCommAdapter.this.mTotalTestProgress, AudioCommAdapter.this.mTotalTestProgress);
                        AudioCommAdapter.this.mCommAdaptListenHandler.SendMessageForComplete(0, testParam.mAudioCommParam);
                        break;
                    }
                    default: {
                        Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "CommAdaptThread : overallTestTask return unknow code : " + n2);
                    }
                }
                AudioCommAdapter.this.mCommAdaptListenHandler.SendMessageForRelease();
            }
        }
    }

    protected class TestParam
    implements Cloneable {
        public static final double TEST_SUCCESS_RATE = (double)0.9f;
        public static final int TEST_TOTAL_MIN_COUNT = 10;
        public static final int TEST_TOTAL_MAX_COUNT = 20;
        public static final int TEST_FAILURE_CONTINUOUS_COUNT = 3;
        public int mTestSuccessCount = 0;
        public int mTestTotalCount = 0;
        public double mTestSuccessRate = 0.0;
        public AudioCommParam mAudioCommParam = new AudioCommParam();

        protected TestParam() {
        }

        public String toString() {
            String string = String.valueOf(super.toString()) + " { successCount = " + this.mTestSuccessCount + " totalCount = " + this.mTestTotalCount + " successRate = " + this.mTestSuccessRate;
            if (this.mAudioCommParam != null) {
                string = String.valueOf(string) + this.mAudioCommParam.toString();
            }
            string = String.valueOf(string) + " } ";
            return string;
        }

        public TestParam clone() {
            try {
                TestParam testParam = (TestParam)super.clone();
                testParam.mAudioCommParam = this.mAudioCommParam != null ? this.mAudioCommParam.clone() : null;
                return testParam;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                Logger.shareInstance().writeLog("W-AudioCommAdapter.txt", "TestParam clone throw CloneNotSupportedException : " + cloneNotSupportedException.getMessage());
                return null;
            }
        }

        public void reset() {
            this.mTestSuccessCount = 0;
            this.mTestTotalCount = 0;
            this.mTestSuccessRate = 0.0;
        }
    }
}

