/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.adapter;

import android.content.Context;
import com.landicorp.robert.comm.adapter.AudioCommAdapter;
import com.landicorp.robert.comm.control.CCommController;
import com.landicorp.robert.comm.setting.AudioCommParam;
import com.landicorp.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class AudioMHCommAdapter
extends AudioCommAdapter {
    protected static final short TEST_SEND_SIZE_MAX = 100;
    protected static final short TEST_RECV_SIZE_MAX = 236;
    protected static final short TEST_SUPPORT_SIZE_MAX = 236;
    protected byte[] mTestSendData;
    protected List<MHCommTestParam> mMHCommTestParamList;

    public AudioMHCommAdapter(CCommController controller, Context context) {
        super(controller, context);
    }

    @Override
    protected void initTestEnvironment() {
        this.mTestSendData = new byte[100];
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(this.mTestSendData);
        this.mTestSendData[0] = -27;
        this.mTestSendData[1] = 3;
        this.mTestSendData[2] = 97;
        this.mSampleFrequencyList.add(44100);
        this.mSampleFrequencyList.add(48000);
        this.mSampleFrequencyList.add(22050);
        this.mSampleFrequencyList.add(96000);
        this.mSampleFrequencyList.add(50000);
        this.mSampleFrequencyList.add(32000);
        this.mSampleFrequencyList.add(47250);
        this.mSampleFrequencyList.add(50400);
        this.mMHCommTestParamList = new ArrayList<MHCommTestParam>();
        MHCommTestParam mHCommTestParam = new MHCommTestParam();
        mHCommTestParam.SendBaud = 2500;
        mHCommTestParam.SendVolume = 0.4f;
        mHCommTestParam.Voltage = 0;
        this.mMHCommTestParamList.add(mHCommTestParam);
        MHCommTestParam mHCommTestParam2 = new MHCommTestParam();
        mHCommTestParam2.SendBaud = 3675;
        mHCommTestParam2.SendVolume = 1.0f;
        mHCommTestParam2.Voltage = 1;
        this.mMHCommTestParamList.add(mHCommTestParam2);
        MHCommTestParam mHCommTestParam3 = new MHCommTestParam();
        mHCommTestParam3.SendBaud = 2500;
        mHCommTestParam3.SendVolume = 0.4f;
        mHCommTestParam3.Voltage = 2;
        this.mMHCommTestParamList.add(mHCommTestParam3);
        MHCommTestParam mHCommTestParam4 = new MHCommTestParam();
        mHCommTestParam4.SendBaud = 2500;
        mHCommTestParam4.SendVolume = 0.4f;
        mHCommTestParam4.Voltage = 1;
        this.mMHCommTestParamList.add(mHCommTestParam4);
        MHCommTestParam mHCommTestParam5 = new MHCommTestParam();
        mHCommTestParam5.SendBaud = 3675;
        mHCommTestParam5.SendVolume = 1.0f;
        mHCommTestParam5.Voltage = 0;
        this.mMHCommTestParamList.add(mHCommTestParam5);
        MHCommTestParam mHCommTestParam6 = new MHCommTestParam();
        mHCommTestParam6.SendBaud = 3675;
        mHCommTestParam6.SendVolume = 1.0f;
        mHCommTestParam6.Voltage = 2;
        this.mMHCommTestParamList.add(mHCommTestParam6);
        MHCommTestParam mHCommTestParam7 = new MHCommTestParam();
        mHCommTestParam7.Voltage = 0;
        mHCommTestParam7.RecvBaud = 2500;
        this.mMHCommTestParamList.add(mHCommTestParam7);
        MHCommTestParam mHCommTestParam8 = new MHCommTestParam();
        mHCommTestParam8.Voltage = 0;
        mHCommTestParam8.RecvBaud = 1800;
        this.mMHCommTestParamList.add(mHCommTestParam8);
        MHCommTestParam mHCommTestParam9 = new MHCommTestParam();
        mHCommTestParam9.Voltage = 1;
        mHCommTestParam9.RecvBaud = 2500;
        this.mMHCommTestParamList.add(mHCommTestParam9);
        MHCommTestParam mHCommTestParam10 = new MHCommTestParam();
        mHCommTestParam10.Voltage = 1;
        mHCommTestParam10.RecvBaud = 1800;
        this.mMHCommTestParamList.add(mHCommTestParam10);
        MHCommTestParam mHCommTestParam11 = new MHCommTestParam();
        mHCommTestParam11.Voltage = 2;
        mHCommTestParam11.RecvBaud = 2500;
        this.mMHCommTestParamList.add(mHCommTestParam11);
        MHCommTestParam mHCommTestParam12 = new MHCommTestParam();
        mHCommTestParam12.Voltage = 2;
        mHCommTestParam12.RecvBaud = 1800;
        this.mMHCommTestParamList.add(mHCommTestParam12);
        MHCommTestParam mHCommTestParam13 = new MHCommTestParam();
        mHCommTestParam13.Voltage = 3;
        this.mMHCommTestParamList.add(mHCommTestParam13);
        MHCommTestParam mHCommTestParam14 = new MHCommTestParam();
        mHCommTestParam14.Voltage = 3;
        mHCommTestParam14.SendBaud = 2500;
        mHCommTestParam14.SendVolume = 0.4f;
        this.mMHCommTestParamList.add(mHCommTestParam14);
        this.mCurrentTestProgress = 0;
        this.mOneTestProgress = 22;
        this.mTotalTestProgress = this.mMHCommTestParamList.size() * this.mOneTestProgress + 1;
    }

    @Override
    protected int overallTestTask() {
        int n2 = -1;
        int n3 = 0;
        this.mIsLaunchFlag = true;
        for (MHCommTestParam mHCommTestParam : this.mMHCommTestParamList) {
            this.mCommParam.XCP_setSendBaud((short)mHCommTestParam.SendBaud);
            this.mCommParam.XCP_setVoltage((short)mHCommTestParam.Voltage);
            this.mCommParam.XCP_setSendVolume(mHCommTestParam.SendVolume);
            this.mCommParam.XCP_setRecvBaud((short)mHCommTestParam.RecvBaud);
            this.mCommParam.XCP_setFrameLength((short)mHCommTestParam.FrameLength);
            n3 = 0;
            n2 = this.tryOpen(this.mCommParam);
            this.mCommAdaptListenHandler.SendMessageForProgress(this.mCurrentTestProgress + ++n3, this.mTotalTestProgress);
            if (n2 == 0) {
                n2 = this.tryOpenDevice(this.mCommParam);
                this.mCommAdaptListenHandler.SendMessageForProgress(this.mCurrentTestProgress + ++n3, this.mTotalTestProgress);
                if (n2 == 0) {
                    this.mIsLaunchFlag = false;
                    n2 = this.tryExchangeDataOverallTest(this.mCommParam);
                    if (n2 == 0) {
                        return 0;
                    }
                }
            }
            this.mCurrentTestProgress += this.mOneTestProgress;
            this.mCommAdaptListenHandler.SendMessageForProgress(this.mCurrentTestProgress, this.mTotalTestProgress);
            if (-2 != n2) continue;
            return n2;
        }
        return n2;
    }

    @Override
    protected int tryExchangeDataOverallTest(AudioCommParam commParam) {
        AudioCommAdapter.TestParam testParam = new AudioCommAdapter.TestParam();
        int n2 = 0;
        byte[] byArray = this.mTestSendData;
        Logger.shareInstance().writeLog("W-AudioMHCommAdapter.txt", "tryExchangeDataOverallTest:test frame len = " + byArray.length);
        testParam.mAudioCommParam = commParam.clone();
        this.mCommAdaptListenHandler.SendMessageForInfo("Try test exchange data.", commParam.clone());
        n2 = this.tryExchangeDataTest(byArray, testParam);
        this.mCommAdaptListenHandler.SendMessageForProgress(this.mCurrentTestProgress + 20, this.mTotalTestProgress);
        switch (n2) {
            case -1: {
                this.mCommAdaptListenHandler.SendMessageForInfo("Test exchange data fail," + testParam.toString(), testParam.mAudioCommParam.clone());
                break;
            }
            case 0: {
                this.mCommAdaptListenHandler.SendMessageForInfo("Test exchange data success," + testParam.toString(), testParam.mAudioCommParam.clone());
                return n2;
            }
            case -2: {
                this.mCommAdaptListenHandler.SendMessageForInfo("Test exchange data interrupted," + testParam.toString(), testParam.mAudioCommParam.clone());
                return n2;
            }
            default: {
                Logger.shareInstance().writeLog("W-AudioMHCommAdapter.txt", "tryExchangeDataOverallTest : tryExchangeDataTest return value error : " + n2);
            }
        }
        return n2;
    }

    @Override
    protected int tryOpen(AudioCommParam acp) {
        for (Integer n2 : this.mSampleFrequencyList) {
            if (this.mInterrupted) {
                return -2;
            }
            if (n2 / acp.XCP_getSendBaud() < 2) continue;
            acp.XCP_setPlaySampleFrequency(n2);
            acp.XCP_setRecordSampleFrequency(n2);
            this.mCommAdaptListenHandler.SendMessageForInfo("Try open controller.", acp.clone());
            if (this.mController.Open(acp, this.mContext, this, CCommController.CommProject.PRJ_COMM_MH) != 0) continue;
            this.mCommAdaptListenHandler.SendMessageForInfo("Open controller success.", acp.clone());
            Logger.shareInstance().writeLog("W-AudioMHCommAdapter.txt", "try open success." + n2);
            this.mSampleFrequencyList.clear();
            this.mSampleFrequencyList.add(n2);
            return 0;
        }
        this.mCommAdaptListenHandler.SendMessageForInfo("Open controller failure.", acp.clone());
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onData(byte[] data) {
        Logger.shareInstance().writeLog("W-AudioMHCommAdapter.txt", "onData");
        Object object = this.mWaitLock;
        synchronized (object) {
            if (this.mWaitFlag) {
                Logger.shareInstance().writeLog("W-AudioMHCommAdapter.txt", "onData len = " + data.length);
                this.mDataFlag = false;
                if (data != null && data.length > 2 && data[0] == -112 && data[1] == 0) {
                    Logger.shareInstance().writeLog("W-AudioMHCommAdapter.txt", "onData : response ok");
                    this.mDataFlag = true;
                }
                this.signalfor();
            }
        }
    }

    protected class MHCommTestParam {
        public static final float PARAM_1_SEND_VOLUME = 1.0f;
        public static final float PARAM_2_SEND_VOLUME = 0.4f;
        public static final int PARAM_1_SEND_BAUDRATE = 3675;
        public static final int PARAM_2_SEND_BAUDRATE = 2500;
        public static final int PARAM_1_OUTPUT_VOLTAGE = 0;
        public static final int PARAM_2_OUTPUT_VOLTAGE = 1;
        public static final int PARAM_3_OUTPUT_VOLTAGE = 2;
        public static final int PARAM_4_OUTPUT_VOLTAGE = 3;
        public static final int PARAM_1_RECV_BAUDRATE = 3675;
        public static final int PARAM_2_RECV_BAUDRATE = 2500;
        public static final int PARAM_3_RECV_BAUDRATE = 1800;
        public float SendVolume = 1.0f;
        public int SendBaud = 3675;
        public int Voltage = 0;
        public int RecvBaud = 3675;
        public final int FrameLength = 236;

        protected MHCommTestParam() {
        }
    }
}

