/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.control;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import com.landicorp.robert.comm.link.CRoutineHandler;
import com.landicorp.robert.comm.link.CommPackage;
import com.landicorp.robert.comm.link.DecodeThread;
import com.landicorp.robert.comm.link.IToolPack;
import com.landicorp.robert.comm.link.IToolPackContext;
import com.landicorp.robert.comm.link.IToolUnPack;
import com.landicorp.robert.comm.link.PackageTool;
import com.landicorp.robert.comm.link.PlayThread;
import com.landicorp.robert.comm.link.SyncQueue;
import com.landicorp.robert.comm.setting.AudioCommParam;
import com.landicorp.robert.comm.setting.CSetting;
import com.landicorp.robert.comm.setting.CSettingFactory;
import com.landicorp.util.Logger;
import com.landicorp.util.StringUtil;

public class CCommController {
    protected static final int SLEEP_TIME_JOIN_THREADEXIT = 10000;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_CTRL_SEND_DATA_FAIL = -1;
    public static final int ERROR_CTRL_SEND_DATA_TIMEOUT = -2;
    public static final int ERROR_CTRL_AUDIOTRACK_WRITE = -3;
    public static final int ERROR_CTRL_AUDIORECORD_READ = -4;
    public static final int ERROR_CTRL_AUDIORECORD_INIT = -5;
    public static final int ERROR_CTRL_AUDIOTRACK_INIT = -6;
    public static final int ERROR_CTRL_UNOPEN = -7;
    public static final int ERROR_CTRL_ILLEGALARGUMENTS = -8;
    public static final int ERROR_CTRL_LOSSAUDIOFOCUS = -9;
    public static final int ERROR_CTRL_NODEVICEDETECTED = -10;
    public static final int ERROR_CTRL_UNPACK = -11;
    public static final int ERROR_CTRL_UNKNOWE = -3000;
    protected static final String STR_ERROR_AUDIOTRACK_INIT = "Initial or start AudioTrack occur error.";
    protected static final String STR_ERROR_AUDIORECORD_INIT = "Initial or start AudioRecord occur error.";
    protected static final String STR_ERROR_AUDIORECORD_READ = "AudioRecord record data fail.";
    protected static final String STR_ERROR_AUDIOTRACK_WRITE = "AudioTrack write data fail.";
    protected static final String STR_ERROR_SEND_WAIT_ACK_TIIMEOUT = "Wait ack of sended sub data timeout.";
    protected static final String STR_ERROR_SEND_DEAL_ACK_ERROR = "Deal with ACK of sended sub data wrong.";
    protected static final String STR_ERROR_NODEVICEDETECTED = "No device detected.";
    protected static final String STR_ERROR_LOSSAUDIOFOCUS = "Can't keep holding the AudioFocus.";
    protected static final String STR_ERROR_UNPACK = "Unpack data failure.";
    protected static final String STR_ERROR_UNKNOW = "Unknow error.";
    protected ICommControllerListener mListener = null;
    protected Context mContext = null;
    protected AudioManager mAudioManager = null;
    protected Handler mListenHandler = null;
    protected HandlerThread mListenThread = null;
    protected PlayThread mPlayThread = null;
    protected DecodeThread mDecodeThread = null;
    protected CSetting mSetting = null;
    protected Handler mRoutiHandler = null;
    protected boolean mHaveOpened = false;
    protected HandlerThread mSendThread = null;
    protected SendHandler mSendHandler = null;
    protected RecvThread mRecvThread = null;
    protected SyncQueue<HandoutNotify> mHandoutNotifyQueue = new SyncQueue();
    protected Object mListenerProtectLock = new Object();
    protected int mPreSysMediaVolume = 0;

    public synchronized boolean isOpened() {
        return this.mHaveOpened;
    }

    public synchronized int Open(AudioCommParam param, Context cx, ICommControllerListener listener, CommProject cp) {
        int n2;
        if (listener == null || cx == null) {
            throw new IllegalArgumentException("CCommController : Open arguments are invalid ; listener=" + listener + " cx=" + cx);
        }
        if (this.mHaveOpened) {
            this.Close();
        }
        if ((n2 = this.init(param, cx, listener, cp)) == 0) {
            this.mHaveOpened = true;
        } else {
            this.release();
            this.mHaveOpened = false;
        }
        return n2;
    }

    private void a(int n2) {
        int n3;
        if (this.mAudioManager == null) {
            return;
        }
        int n4 = 3;
        int n5 = this.mAudioManager.getStreamVolume(n4);
        if (n2 == n5) {
            return;
        }
        this.mAudioManager.setStreamVolume(n4, n2, 0);
        int n6 = this.mAudioManager.getStreamVolume(n4);
        if (n6 != n2) {
            int n7 = Math.abs(n6 - n2);
            n3 = n6 < n2 ? 1 : -1;
            int n8 = 0;
            while (n8 < n7) {
                this.mAudioManager.adjustStreamVolume(n4, n3, 0);
                ++n8;
            }
        }
        if ((n3 = this.mAudioManager.getStreamVolume(n4)) != n2) {
            Logger.shareInstance().writeLog("I-CCommController.txt", "setMediaStreamVolumn fail." + n2);
        }
    }

    protected void initSysMediaVolumn() {
        if (this.mAudioManager == null) {
            return;
        }
        int n2 = this.mAudioManager.getStreamMaxVolume(3);
        this.a(n2);
        Logger.shareInstance().writeLog("I-CCommController.txt", "initSysMediaVolumn complete.");
    }

    protected void saveCurrentSysMediaVolumn() {
        if (this.mAudioManager == null) {
            return;
        }
        this.mPreSysMediaVolume = this.mAudioManager.getStreamVolume(3);
    }

    protected void restoreSysMediaVolumn() {
        if (this.mAudioManager == null) {
            return;
        }
        this.a(this.mPreSysMediaVolume);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int init(AudioCommParam param, Context cx, ICommControllerListener listener, CommProject cp) {
        this.mContext = cx;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.saveCurrentSysMediaVolumn();
        Object object = this.mListenerProtectLock;
        synchronized (object) {
            this.mListener = listener;
        }
        this.mSetting = CommProject.PRJ_COMM_MH == cp ? CSettingFactory.MHCreate(param) : CSettingFactory.F2FCreate(param);
        this.mRoutiHandler = new CCtrlRoutineHandler(Looper.getMainLooper());
        this.mSetting.setRoutineHandler(this.mRoutiHandler);
        this.mPlayThread = this.mSetting.getPlayThread();
        this.mDecodeThread = this.mSetting.getDecodeThread();
        this.mPlayThread.setDaemon(true);
        this.mDecodeThread.setDaemon(true);
        this.mListenThread = new HandlerThread("Robert.CCommController.ListenThread");
        this.mListenThread.setDaemon(true);
        this.mListenThread.start();
        this.mListenHandler = new ListenHandler(this.mListenThread.getLooper());
        this.mSendThread = new HandlerThread("Robert.CCommController.SendThread");
        this.mSendThread.setDaemon(true);
        this.mSendThread.start();
        this.mSendHandler = new SendHandler(this.mSendThread.getLooper());
        Process.setThreadPriority((int)this.mSendThread.getThreadId(), (int)-1);
        this.mRecvThread = new RecvThread();
        this.mRecvThread.setDaemon(true);
        this.mRecvThread.start();
        this.mPlayThread.Reset();
        this.mPlayThread.start();
        this.mDecodeThread.start();
        if (!this.mPlayThread.ResumePlay()) {
            return -6;
        }
        if (!this.mDecodeThread.ResumeDecode()) {
            return -5;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        if (this.mDecodeThread != null) {
            Logger.shareInstance().writeLog("I-CCommController.txt", "ready release decodeThread");
            this.mDecodeThread.Stop();
            try {
                this.mDecodeThread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.mSendThread != null) {
            Logger.shareInstance().writeLog("I-CCommController.txt", "ready release sendThread");
            this.mSendHandler.getLooper().quit();
            this.mSendHandler.Exit();
            try {
                this.mSendThread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.mRecvThread != null) {
            Logger.shareInstance().writeLog("I-CCommController.txt", "ready release recvThread");
            this.mRecvThread.Exit();
            try {
                this.mRecvThread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.mPlayThread != null) {
            Logger.shareInstance().writeLog("I-CCommController.txt", "ready release playThread");
            this.mPlayThread.Flush();
            this.mPlayThread.Stop();
            try {
                this.mPlayThread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.mListenThread != null) {
            Logger.shareInstance().writeLog("I-CCommController.txt", "ready release listenThread");
            this.mListenThread.getLooper().quit();
        }
        this.mPlayThread = null;
        this.mDecodeThread = null;
        this.mSendHandler = null;
        this.mSendThread = null;
        this.mRecvThread = null;
        this.restoreSysMediaVolumn();
        this.mContext = null;
        Logger.shareInstance().writeLog("I-CCommController.txt", "ready wait listenThread quit");
        Object object = this.mListenerProtectLock;
        synchronized (object) {
            this.mListener = null;
        }
        Logger.shareInstance().writeLog("I-CCommController.txt", "release complete.");
    }

    protected boolean checkDeviceExist() {
        Logger.shareInstance().writeLog("I-CCommController.txt", "checkDeviceExist");
        if (this.mAudioManager != null) {
            return this.mAudioManager.isWiredHeadsetOn();
        }
        return false;
    }

    protected void flushForSend() {
        if (!this.mHaveOpened) {
            return;
        }
        byte[] byArray = CommPackage.COMMPACKTYPE;
        int n2 = CommPackage.COMMPACKTYPE.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray[n3];
            if (by != 65 && by != 78 && this.mSendHandler != null) {
                this.mSendHandler.removeMessages(by);
            }
            ++n3;
        }
        if (this.mHandoutNotifyQueue != null) {
            this.mHandoutNotifyQueue.increase(new HandoutNotify(3, -1, -1, null));
        }
    }

    public synchronized void Close() {
        if (!this.mHaveOpened) {
            return;
        }
        this.release();
        this.mHaveOpened = false;
    }

    public synchronized int SendParameter() {
        byte[] byArray = Build.MODEL.getBytes();
        int n2 = byArray.length;
        int n3 = 10 + n2;
        if (n3 > 64) {
            int n4 = n3 - 64;
            if ((n2 -= n4) < 0) {
                Logger.shareInstance().writeLog("I-CCommController.txt", "SendParameter model len is negative!");
                return -3000;
            }
            n3 -= n4;
        }
        byte[] byArray2 = new byte[n3];
        int n5 = 0;
        byArray2[n5++] = 0;
        byArray2[n5++] = (byte)(this.mSetting.getPlayBaudRate() >> 8 & 0xFF);
        byArray2[n5++] = (byte)(this.mSetting.getPlayBaudRate() & 0xFF);
        byArray2[n5++] = (byte)(this.mSetting.getRecordBaudRate() >> 8 & 0xFF);
        byArray2[n5++] = (byte)(this.mSetting.getRecordBaudRate() & 0xFF);
        byArray2[n5++] = (byte)(this.mSetting.getDeviceOuputVoltage() >> 8 & 0xFF);
        byArray2[n5++] = (byte)(this.mSetting.getDeviceOuputVoltage() & 0xFF);
        byArray2[n5++] = 1;
        byArray2[n5++] = (byte)(this.mSetting.getFrameMaxLength() >> 8 & 0xFF);
        byArray2[n5++] = (byte)(this.mSetting.getFrameMaxLength() & 0xFF);
        System.arraycopy(byArray, 0, byArray2, n5, n2);
        return this.SendNow((byte)80, byArray2);
    }

    public synchronized int SendData(byte[] data) {
        return this.SendNow((byte)68, data);
    }

    public synchronized int SendCancel() {
        return this.SendNow((byte)67, null);
    }

    public synchronized int SendShutDown() {
        return this.SendNow((byte)83, null);
    }

    public synchronized boolean EnableRetry(boolean enable) {
        if (this.mHaveOpened && this.mSendHandler != null) {
            this.mSendHandler.enableRetry(enable);
            return true;
        }
        return false;
    }

    public synchronized CTRL_STATE GetCurrentState() {
        if (!this.mHaveOpened) {
            return CTRL_STATE.STATE_CLOSE;
        }
        byte[] byArray = CommPackage.COMMPACKTYPE;
        int n2 = CommPackage.COMMPACKTYPE.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray[n3];
            if (by != 65 && by != 78 && this.mSendHandler.hasMessages(by)) {
                return CTRL_STATE.STATE_SENDING;
            }
            ++n3;
        }
        return CTRL_STATE.STATE_IDLE;
    }

    public synchronized void flushSending() {
        this.flushForSend();
    }

    public synchronized boolean isDevicePresent() {
        Logger.shareInstance().writeLog("I-CCommController.txt", "isDevicePresent");
        return this.checkDeviceExist();
    }

    public synchronized int Send(byte packType, byte[] data) {
        if (!this.mHaveOpened) {
            return -7;
        }
        if (!this.checkDeviceExist()) {
            return -10;
        }
        byte[] byArray = CommPackage.COMMPACKTYPE;
        int n2 = CommPackage.COMMPACKTYPE.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray[n3];
            if (by == packType && by != 65 && by != 78) {
                byte[] byArray2 = null;
                if (data != null) {
                    byArray2 = (byte[])data.clone();
                }
                Message message = this.mSendHandler.obtainMessage(packType, byArray2);
                message.sendToTarget();
                return 0;
            }
            ++n3;
        }
        return -8;
    }

    public synchronized int SendNow(byte packType, byte[] data) {
        this.flushSending();
        return this.Send(packType, data);
    }

    protected class CCtrlRoutineHandler
    extends CRoutineHandler {
        public CCtrlRoutineHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case -1: {
                    Logger.shareInstance().writeLog("I-CCommController.txt", "CCtrlRoutineHandler - EVENT_PLAY_WRITE_FAIL");
                    if (msg.arg1 == -1) break;
                    int n2 = msg.arg1;
                    int n3 = msg.arg2;
                    switch (n2) {
                        case 65: 
                        case 78: {
                            return;
                        }
                    }
                    break;
                }
                case 0: {
                    Logger.shareInstance().writeLog("I-CCommController.txt", "CCtrlRoutineHandler - EVENT_PLAY_WRITE_COMPLETE");
                    if (msg.arg1 == -1 || msg.arg1 == 65 || msg.arg1 == 78) break;
                    Logger.shareInstance().writeLog("I-CCommController.txt", "EVENT_PLAY_WRITE_COMPLETE - write ok but no send to listenHandler!");
                    break;
                }
                case -2: {
                    Logger.shareInstance().writeLog("I-CCommController.txt", "CCtrlRoutineHandler - EVENT_RECORD_INIT_FAIL:Initial or start AudioRecord occur error.");
                    Message message = CCommController.this.mListenHandler.obtainMessage(6, -5, 0, (Object)CCommController.STR_ERROR_AUDIORECORD_INIT);
                    message.sendToTarget();
                    break;
                }
                case -4: {
                    Logger.shareInstance().writeLog("I-CCommController.txt", "CCtrlRoutineHandler - EVENT_PLAY_INIT_FAIL:Initial or start AudioTrack occur error.");
                    Message message = CCommController.this.mListenHandler.obtainMessage(6, -6, 0, (Object)CCommController.STR_ERROR_AUDIOTRACK_INIT);
                    message.sendToTarget();
                    break;
                }
            }
        }
    }

    public static enum CTRL_STATE {
        STATE_SENDING,
        STATE_IDLE,
        STATE_CLOSE;

    }

    public static enum CommProject {
        PRJ_COMM_F2F,
        PRJ_COMM_MH;

    }

    protected class HandoutNotify {
        public static final int REQ_SUCC = 0;
        public static final int REQ_WRITE_FAIL = 1;
        public static final int REQ_READ_FAIL = 2;
        public static final int REQ_EXIT = 3;
        public static final int PARAM_INVALID = -1;
        private int b = 0;
        private int c = 0;
        private int d = 3;
        private byte[] e = null;

        public HandoutNotify(int request, int packType, int packNum, byte[] data) {
            this.d = request;
            this.c = packType;
            this.b = packNum;
            this.e = data;
        }

        public int GetPackNum() {
            return this.b;
        }

        public byte[] GetPackData() {
            return this.e;
        }

        public int GetRequest() {
            return this.d;
        }

        public int GetPackType() {
            return this.c;
        }
    }

    public static interface ICommControllerListener {
        public void onSend(byte var1);

        public void onParameter(byte[] var1);

        public void onData(byte[] var1);

        public void onCancel(byte[] var1);

        public void onShutdown(byte[] var1);

        public void onMessage(byte[] var1);

        public void onError(int var1, String var2);

        public void onDevicePlugged();

        public void onDeviceUnplugged();
    }

    protected class ListenHandler
    extends Handler {
        public static final int LISTEN_CALLBACK_ONSEND = 0;
        public static final int LISTEN_CALLBACK_ONPARAMETER = 1;
        public static final int LISTEN_CALLBACK_ONDATA = 2;
        public static final int LISTEN_CALLBACK_ONCANCEL = 3;
        public static final int LISTEN_CALLBACK_ONSHUTDOWN = 4;
        public static final int LISTEN_CALLBACK_ONMESSAGE = 5;
        public static final int LISTEN_CALLBACK_ONERROR = 6;
        public static final int LISTEN_CALLBACK_DEVICEPLUGGED = 7;
        public static final int LISTEN_CALLBACK_DEVICEUNPLUGGED = 8;

        public ListenHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            ICommControllerListener iCommControllerListener = null;
            Object object = CCommController.this.mListenerProtectLock;
            synchronized (object) {
                if (CCommController.this.mListener == null || !CCommController.this.mHaveOpened) {
                    return;
                }
                iCommControllerListener = CCommController.this.mListener;
            }
            if (iCommControllerListener == null) {
                return;
            }
            switch (msg.what) {
                case 0: {
                    Logger.shareInstance().writeLog("I-CCommController.txt", "ListenCallback - onSend - ");
                    iCommControllerListener.onSend((byte)msg.arg1);
                    break;
                }
                case 1: {
                    object = msg.obj == null ? new byte[]{} : (byte[])msg.obj;
                    Logger.shareInstance().writeLog("I-CCommController.txt", "ListenCallback - onParameter - " + ((Object)object).length + " " + object);
                    iCommControllerListener.onParameter((byte[])object);
                    break;
                }
                case 2: {
                    object = msg.obj == null ? new byte[]{} : (byte[])msg.obj;
                    Logger.shareInstance().writeLog("I-CCommController.txt", "ListenCallback - onData - " + ((Object)object).length + " " + object);
                    iCommControllerListener.onData((byte[])object);
                    break;
                }
                case 3: {
                    object = msg.obj == null ? new byte[]{} : (byte[])msg.obj;
                    Logger.shareInstance().writeLog("I-CCommController.txt", "ListenCallback - onCancel - " + ((Object)object).length + " " + object);
                    iCommControllerListener.onCancel((byte[])object);
                    break;
                }
                case 4: {
                    object = msg.obj == null ? new byte[]{} : (byte[])msg.obj;
                    Logger.shareInstance().writeLog("I-CCommController.txt", "ListenCallback - onShutDown - " + ((Object)object).length + " " + object);
                    iCommControllerListener.onShutdown((byte[])object);
                    break;
                }
                case 5: {
                    object = msg.obj == null ? new byte[]{} : (byte[])msg.obj;
                    Logger.shareInstance().writeLog("I-CCommController.txt", "ListenCallback - onMessage - " + ((Object)object).length + " " + object);
                    iCommControllerListener.onMessage((byte[])object);
                    break;
                }
                case 6: {
                    object = (String)(msg.obj == null ? new String(CCommController.STR_ERROR_UNKNOW) : msg.obj);
                    Logger.shareInstance().writeLog("I-CCommController.txt", "ListenCallback - onError - " + (String)object);
                    iCommControllerListener.onError(msg.arg1, (String)object);
                    break;
                }
                case 7: {
                    Logger.shareInstance().writeLog("I-CCommController.txt", "ListenCallback - devicePlugged");
                    iCommControllerListener.onDevicePlugged();
                    break;
                }
                case 8: {
                    Logger.shareInstance().writeLog("I-CCommController.txt", "ListenCallback - deviceUnplugged");
                    iCommControllerListener.onDeviceUnplugged();
                    break;
                }
            }
        }
    }

    protected class RecvThread
    extends Thread {
        protected boolean mExit = false;
        protected static final long PACK_WAIT_ALWAYSE = 0L;
        protected PackageTool mUnPackageTool = new PackageTool();
        protected PackageTool mPackageTool = new PackageTool();
        protected IToolUnPack mToolUnPack = this.mUnPackageTool;
        protected IToolPackContext mToolUnPackContext = this.mUnPackageTool;
        protected IToolPack mToolPack = this.mPackageTool;
        protected IToolPackContext mToolPackContext = this.mPackageTool;

        protected RecvThread() {
        }

        public void Exit() {
            this.mExit = true;
            this.interrupt();
        }

        private void a(byte by, short s, byte[] byArray) {
            Logger.shareInstance().writeLog("I-CCommController.txt", "RecvThread SendDataWithoutACK [" + by + "]" + "[" + s + "]");
            this.mToolPackContext.ResetContext();
            this.mToolPackContext.SetPackSize(CCommController.this.mSetting.getFrameMaxLength());
            this.mToolPackContext.SetPackNum(s);
            int n2 = this.mToolPack.PackData(by, byArray);
            int n3 = 0;
            while (n3 < n2) {
                CCommController.this.mPlayThread.Play(this.mToolPack.GetPackByIndex(n3).getPackData());
                ++n3;
            }
        }

        @Override
        public void run() {
            super.run();
            int n2 = 0;
            byte by = 0;
            short s = 0;
            int n3 = 0;
            byte[] byArray = null;
            byte[] byArray2 = null;
            CCommController.this.mDecodeThread.Reset();
            do {
                Message message;
                byte[] byArray3;
                if ((byArray3 = CCommController.this.mDecodeThread.GetDataFromDecodeQueue(0L)) == null) continue;
                CommPackage commPackage = new CommPackage(byArray3);
                n2 = this.mToolUnPack.AddPack(commPackage);
                by = commPackage.getFrameType();
                s = commPackage.getFrameNumber();
                byArray = commPackage.getFrameData();
                n3 = commPackage.getFrameLength();
                if (n2 == 0) {
                    byArray2 = this.mToolUnPack.UnPackData();
                    Logger.shareInstance().writeLog("I-CCommController.txt", "RecvThread - FRAME_SUCCESS - " + by);
                    CCommController.this.mHandoutNotifyQueue.increase(new HandoutNotify(0, by, s, byArray2));
                    if (by == 77) {
                        message = CCommController.this.mListenHandler.obtainMessage(5, (Object)byArray2);
                        message.sendToTarget();
                        continue;
                    }
                    if (by == 68) {
                        this.a((byte)65, (short)(s + 1), null);
                        message = CCommController.this.mListenHandler.obtainMessage(2, (Object)byArray2);
                        message.sendToTarget();
                        continue;
                    }
                    Logger.shareInstance().writeLog("I-CCommController.txt", "RecvThread - FRAME_SUCCESS - ??? " + by);
                    continue;
                }
                if (-10 == n2 || -11 == n2) {
                    Logger.shareInstance().writeLog("I-CCommController.txt", "RecvThread - FRAME_NOT_OVER or REPEAT " + n2);
                    if (commPackage.getFrameType() != 68) continue;
                    this.a((byte)65, (short)(s + 1), null);
                    continue;
                }
                Logger.shareInstance().writeLog("I-CCommController.txt", "RecvThread - FRAME_FAIL " + n2 + " and SEND NAK " + (s + 1));
                if (commPackage.getFrameType() == 68) {
                    this.a((byte)78, (short)(s + 1), null);
                }
                message = CCommController.this.mListenHandler.obtainMessage(6, -11, 0, (Object)CCommController.STR_ERROR_UNPACK);
                message.sendToTarget();
            } while (!this.mExit);
            CCommController.this.mHandoutNotifyQueue.increase(new HandoutNotify(3, -1, -1, null));
        }
    }

    protected class SendHandler
    extends Handler {
        private boolean b;
        private short c;
        private int d;
        private PackageTool e;
        private IToolPack f;
        private IToolPackContext g;

        public void enableRetry(boolean enable) {
            this.d = enable ? 3 : 0;
        }

        public SendHandler(Looper looper) {
            super(looper);
            this.b = false;
            this.c = 0;
            this.d = 3;
            this.e = new PackageTool();
            this.f = this.e;
            this.g = this.e;
        }

        public void Exit() {
            this.b = true;
            this.getLooper().getThread().interrupt();
            CCommController.this.mHandoutNotifyQueue.increase(new HandoutNotify(3, -1, -1, null));
            Logger.shareInstance().writeLog("I-CCommController.txt", "curThreadID = " + this.getLooper().getThread().getId() + " name:" + this.getLooper().getThread().getName());
        }

        public void handleMessage(Message msg) {
            int n2;
            super.handleMessage(msg);
            if (this.b) {
                Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - mExit is true,return and loss all msgs");
                return;
            }
            byte[] byArray = (byte[])msg.obj;
            byte[] byArray2 = null;
            byte by = 0;
            int n3 = 0;
            switch (msg.what) {
                case 67: 
                case 68: 
                case 80: 
                case 83: {
                    by = (byte)msg.what;
                    break;
                }
                default: {
                    return;
                }
            }
            this.g.ResetContext();
            this.g.SetPackSize(CCommController.this.mSetting.getFrameMaxLength());
            this.g.SetPackNum(this.c);
            int n4 = this.f.PackData(by, byArray);
            this.c = (short)(this.g.GetPackNum() + 8);
            if (!CCommController.this.checkDeviceExist()) {
                Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - Ready send but isDevicePresent = false,return");
                return;
            }
            Logger.shareInstance().writeLog("I-CCommController.txt", "ready clear NotifyQueue.");
            CCommController.this.mHandoutNotifyQueue.clear();
            Logger.shareInstance().writeLog("I-CCommController.txt", "clear NotifyQueue complete.");
            int n5 = 0;
            while (n5 < n4) {
                n3 = 0;
                short[] sArray = CCommController.this.mPlayThread.EncodeData(this.f.GetPackByIndex(n5).getPackData());
                int n6 = CCommController.this.mPlayThread.PlayTime(sArray);
                int n7 = n6 + 2000;
                Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - sub frame data [" + n5 + "]:" + StringUtil.byte2HexStr(this.f.GetPackByIndex(n5).getPackData(), true));
                while (true) {
                    CCommController.this.initSysMediaVolumn();
                    if (!CCommController.this.checkDeviceExist()) {
                        Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - Sending but isDevicePresent = false,return");
                        return;
                    }
                    Logger.shareInstance().writeLog("I-CCommController.txt", "ready play [" + n5 + "]" + this.f.GetPackByIndex(n5));
                    CCommController.this.mPlayThread.Play(sArray, (int)by, (int)this.f.GetPackByIndex(n5).getFrameNumber());
                    Logger.shareInstance().writeLog("I-CCommController.txt", "play ok to queue");
                    if (by == 65 || by == 78) continue;
                    HandoutNotify handoutNotify = CCommController.this.mHandoutNotifyQueue.decrease(n7);
                    if (this.b) {
                        Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - mExit is true,return");
                        return;
                    }
                    if (handoutNotify != null) {
                        if (handoutNotify.GetRequest() == 3) {
                            Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - HanoutNotify.REQ_EXIT");
                            return;
                        }
                        if (handoutNotify.GetRequest() == 0) {
                            if (by == 68 && handoutNotify.GetPackType() == 65 && handoutNotify.GetPackNum() == (short)(this.f.GetPackByIndex(n5).getFrameNumber() + 1)) {
                                Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - HanoutNotify.REQ_SUCC recv ACK");
                                break;
                            }
                            if (by != 68 && by == handoutNotify.GetPackType()) {
                                byArray2 = handoutNotify.GetPackData();
                                Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - HanoutNotify.REQ_SUCC recv " + by);
                                break;
                            }
                            if (by == 68 && (handoutNotify.GetPackType() == 68 || handoutNotify.GetPackType() == 77) && n4 - n5 <= 1) {
                                Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - HanoutNotify.REQ_SUCC recv D/M " + handoutNotify.GetPackType());
                                break;
                            }
                        } else {
                            if (handoutNotify.GetRequest() == 1) {
                                Message message = CCommController.this.mListenHandler.obtainMessage(6, -3, 0, (Object)CCommController.STR_ERROR_AUDIOTRACK_WRITE);
                                message.sendToTarget();
                                Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - HanoutNotify.REQ_WRITE_FAIL");
                                return;
                            }
                            Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - HanoutNotify.FAIL");
                        }
                    } else {
                        if (this.b) {
                            Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - mHandoutNotifyQueue.decrease null but mExit = true");
                            return;
                        }
                        Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - mHandoutNotifyQueue.decrease null but mExit = false");
                    }
                    if (++n3 > this.d) {
                        if (handoutNotify == null) {
                            Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - resend max times - timeout");
                            Message message = CCommController.this.mListenHandler.obtainMessage(6, -2, 0, (Object)CCommController.STR_ERROR_SEND_WAIT_ACK_TIIMEOUT);
                            message.sendToTarget();
                        } else {
                            Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - resend max times - ACK ERROR");
                            Message message = CCommController.this.mListenHandler.obtainMessage(6, -1, 0, (Object)CCommController.STR_ERROR_SEND_DEAL_ACK_ERROR);
                            message.sendToTarget();
                        }
                        return;
                    }
                    Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - resend - " + n3);
                }
                ++n5;
            }
            Message message = CCommController.this.mListenHandler.obtainMessage(0, (int)by, 0);
            message.sendToTarget();
            switch (by) {
                case 80: {
                    n2 = 1;
                    break;
                }
                case 67: {
                    n2 = 3;
                    break;
                }
                case 83: {
                    n2 = 4;
                    break;
                }
                default: {
                    return;
                }
            }
            Message message2 = CCommController.this.mListenHandler.obtainMessage(n2, byArray2);
            message2.sendToTarget();
            Logger.shareInstance().writeLog("I-CCommController.txt", "SendHandler - send to ListenHandler - " + n2);
        }
    }
}

