/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.decode;

import com.landicorp.robert.comm.decode.Decode;
import com.landicorp.robert.comm.setting.CSetting;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class SquareDecode
extends Decode {
    protected int mFirst = 1;
    protected int mSamplePerBit = 0;
    protected native_WaveData mNativeWaveData = null;
    protected byte[] mCmdBuffer = new byte[10240];
    protected native_Command mNativeCommand = new native_Command(this.mCmdBuffer, this.mCmdBuffer.length);
    protected List<Byte> frame = new ArrayList<Byte>();
    protected Queue<byte[]> mDecodeResult = new LinkedList<byte[]>();
    public static final int SUCCESS = 0;
    public static final int BIT_LENGTH_ERROR = -6;
    public static final int BIT_INVAILEDCHAR_ERROR = -7;
    public static final int BIT_STX_ERROR = -8;
    public static final int BIT_LRC_ERROR = -9;
    public static final int BIT_ETX_ERROR = -10;
    public static final int BIT_INVALID_DATA = -11;
    protected static final int TRANS_SUCCESS = 0;
    protected static final int TRANS_ERROR_NOT_OVER = -1;
    protected static final int TRANS_ERROR_ALREADY_OVER = -2;
    protected static final int TRANS_ERROR_HAS_NOISE = -3;
    protected static final int TRANS_ERROR_MALLOC_MEMORY = -4;
    protected static final int TRANS_ERROR_WAVDATA_EXCEED = -5;
    protected static final int TRANS_ERROR_PARAMS_INVALID = -6;

    static {
        try {
            System.loadLibrary("landimposaudio");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public synchronized void InitDecoder(CSetting setting) {
        this.mFirst = 1;
        this.mSamplePerBit = setting.getRecordSampleRate() / setting.getRecordBaudRate();
        this.frame.clear();
        this.mDecodeResult.clear();
    }

    @Override
    public synchronized int DecodeDataStream(short[] wave) {
        byte[] byArray = null;
        native_WaveData native_WaveData2 = new native_WaveData(wave, wave.length, 0);
        this.mDecodeResult.clear();
        while (native_WaveData2.mDataPos < native_WaveData2.mDataLength) {
            int n2 = this.Wave2Cmd(native_WaveData2, this.mFirst, this.mNativeCommand);
            this.mFirst = 0;
            switch (n2) {
                case -2: {
                    break;
                }
                case -3: {
                    break;
                }
                case -4: {
                    throw new OutOfMemoryError("SquareDecode : TRANS_ERROR_MALLOC_MEMORY.");
                }
                case -5: {
                    throw new IllegalArgumentException("SquareDecode : TRANS_ERROR_WAVDATA_EXCEED.");
                }
                case -6: {
                    throw new IllegalArgumentException("SquareDecode : TRANS_ERROR_PARAMS_INVALID.");
                }
                case -1: {
                    byArray = null;
                    break;
                }
                case 0: {
                    int n3 = SquareDecode.Bit2Frame(this.mNativeCommand.mCommand, this.mNativeCommand.mCmdLength, this.frame);
                    if (n3 == 0) {
                        byArray = new byte[this.frame.size()];
                        int n4 = 0;
                        for (Byte by : this.frame) {
                            byArray[n4++] = by;
                        }
                        this.mDecodeResult.offer(byArray);
                    }
                    this.frame.clear();
                    break;
                }
            }
        }
        return this.mDecodeResult.size();
    }

    @Override
    public synchronized byte[] GetDecodeResult() {
        return this.mDecodeResult.poll();
    }

    public static int Bit2Frame(byte[] data, int length, List<Byte> frameData) {
        byte by = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray = new byte[11];
        if (length % 11 != 0) {
            n5 = length - length % 11;
        }
        if (n5 == 0 || n5 % 11 != 0) {
            return -6;
        }
        int n6 = 0;
        while (n3 < n5) {
            System.arraycopy(data, n3, byArray, 0, 11);
            n4 = 0;
            n4 = 0;
            while (n4 < byArray.length) {
                if (n4 == 0 && byArray[n4] != 0) {
                    n6 = -8;
                    break;
                }
                if (n4 == 9) {
                    if (n2 % 2 == 0 && byArray[n4] != 0 && n2 % 2 == 1 && byArray[n4] != 1) {
                        n6 = -9;
                        break;
                    }
                } else {
                    if (n4 == 10 && byArray[n4] != 1) {
                        n6 = -10;
                        break;
                    }
                    if (byArray[n4] == 1) {
                        ++n2;
                        by = (byte)(by | 1 << n4 - 1);
                    }
                }
                ++n4;
            }
            if (n6 != 0) break;
            frameData.add(by);
            by = 0;
            n3 += 11;
        }
        if (n6 != 0 && n3 < 50) {
            n6 = -11;
        }
        return n6;
    }

    private native int Wave2Cmd(native_WaveData var1, int var2, native_Command var3);

    public class native_Command {
        public byte[] mCommand;
        public int mCmdLength;

        public native_Command(byte[] cmdData, int cmdLength) {
            this.mCommand = cmdData;
            this.mCmdLength = 0;
        }
    }

    public class native_WaveData {
        public short[] mWaveData;
        public int mDataLength;
        public int mDataPos;

        public native_WaveData(short[] waveData, int dataLength, int dataPos) {
            this.mWaveData = waveData;
            this.mDataLength = dataLength;
            this.mDataPos = dataPos;
        }
    }
}

