/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.encode;

import com.landicorp.robert.comm.encode.Encode;
import com.landicorp.robert.comm.setting.CSetting;

public class MHEncode
extends Encode {
    public static final int BIT0 = 0;
    public static final int BIT1 = 1;
    protected static final byte HEAD = -55;
    protected short[] bit1_1 = null;
    protected short[] bit1_2 = null;
    protected short[] bit0_1 = null;
    protected short[] bit0_2 = null;
    protected int playBaudRate = 0;
    protected int playSampleRate = 0;
    protected int moduleWidth = 0;

    public MHEncode(CSetting setting) {
        this.playBaudRate = setting.getPlayBaudRate();
        this.playSampleRate = setting.getPlaySampleRate();
        this.moduleWidth = this.playSampleRate / this.playBaudRate;
        this.initWaveBuffer(this.moduleWidth);
    }

    protected int ACEncodeBit(short[] lpAudioBuf, int iPos, int bitVal) {
        if (bitVal != 0) {
            short[] sArray = this.bit1_1;
            if (iPos > 1 && lpAudioBuf[iPos - 2] > 0) {
                sArray = this.bit1_2;
            }
            System.arraycopy(sArray, 0, lpAudioBuf, iPos, sArray.length);
            iPos += sArray.length;
        } else {
            short[] sArray = this.bit0_1;
            if (iPos > 1 && lpAudioBuf[iPos - 2] > 0) {
                sArray = this.bit0_2;
            }
            System.arraycopy(sArray, 0, lpAudioBuf, iPos, sArray.length);
            iPos += sArray.length;
        }
        return iPos;
    }

    protected int ACEncodeByte(short[] lpAudioBuf, int iPos, byte byteData) {
        int n2 = iPos;
        byte by = 0;
        if (lpAudioBuf != null) {
            int n3 = 7;
            while (n3 >= 0) {
                by = (byte)(byteData >> n3 & 1);
                n2 = this.ACEncodeBit(lpAudioBuf, n2, by);
                --n3;
            }
        }
        return n2;
    }

    protected int ACEncodeByteStream(short[] lpAudioBuf, int iPos, byte[] bytedata, int iLen) {
        int n2 = iPos;
        if (lpAudioBuf != null) {
            int n3 = 0;
            while (n3 < iLen) {
                n2 = this.ACEncodeByte(lpAudioBuf, n2, bytedata[n3]);
                ++n3;
            }
        }
        return n2;
    }

    protected int FillLeadGuideData(short[] lpAudioBuf, int iPos) {
        byte[] byArray = new byte[8];
        iPos = this.ACEncodeByteStream(lpAudioBuf, iPos, byArray, byArray.length);
        byte[] byArray2 = new byte[]{-55};
        iPos = this.ACEncodeByteStream(lpAudioBuf, iPos, byArray2, byArray2.length);
        return iPos;
    }

    protected int FillBackGuideData(short[] lpAudioBuf, int iPos) {
        byte[] byArray = new byte[8];
        iPos = this.ACEncodeByteStream(lpAudioBuf, iPos, byArray, byArray.length);
        return iPos;
    }

    protected void initWaveBuffer(int moduleWidth) {
        if (moduleWidth < 2) {
            throw new IllegalArgumentException("SineEncodeForProtocol Exception:NOT SUPPORT ARGUMENTS [moduleWidth = " + moduleWidth + "]");
        }
        int n2 = moduleWidth * 2;
        this.bit1_1 = new short[n2];
        this.bit1_2 = new short[n2];
        this.bit0_1 = new short[n2];
        this.bit0_2 = new short[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.bit1_1[n3] = (short)(32767.0 * Math.sin(4.71238898038469 + Math.PI * 2 * ((double)n3 / (double)n2)));
            this.bit1_2[n3] = (short)(32767.0 * Math.sin(1.5707963267948966 + Math.PI * 2 * ((double)n3 / (double)n2)));
            n3 += 2;
        }
        n3 = 0;
        while (n3 < n2) {
            this.bit0_1[n3] = (short)(32767.0 * Math.sin(4.71238898038469 + Math.PI * ((double)n3 / (double)n2)));
            this.bit0_2[n3] = (short)(32767.0 * Math.sin(1.5707963267948966 + Math.PI * ((double)n3 / (double)n2)));
            n3 += 2;
        }
    }

    protected int ACEncodeMuteStream(short[] lpAudioBuf, int iPos, int iLen) {
        int n2 = iPos;
        int n3 = iLen;
        while (n3 > 0) {
            lpAudioBuf[n2++] = 0;
            --n3;
        }
        return n2;
    }

    @Override
    public int LengthOfEncodeData(byte[] data) {
        int n2 = (9 + data.length + 8) * 8 * this.moduleWidth * 2;
        return n2;
    }

    @Override
    public int EncodeData(short[] lpAudioBuf, int iPos, byte[] data, int iLen) {
        int n2 = iPos;
        if (lpAudioBuf != null) {
            n2 = this.FillLeadGuideData(lpAudioBuf, n2);
            n2 = this.ACEncodeByteStream(lpAudioBuf, n2, data, iLen);
            n2 = this.FillBackGuideData(lpAudioBuf, n2);
        }
        return n2;
    }

    @Override
    public int EncodeMuteStream(short[] lpAudioBuf, int iPos, int iLen) {
        return this.ACEncodeMuteStream(lpAudioBuf, iPos, iLen);
    }
}

