/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.encode;

import com.landicorp.robert.comm.encode.MHEncode;
import com.landicorp.robert.comm.setting.CSetting;

public class MHEncodeForProtocol
extends MHEncode {
    protected short[] mSquareWaveForLaunch = null;
    protected static final int LAUNCH_BAUND_RATE = 2400;
    protected static final int LAUNCH_DURATION_TIME = 100;

    public MHEncodeForProtocol(CSetting setting) {
        super(setting);
        this.buildLaunchWave(setting);
    }

    protected void buildLaunchWave(CSetting setting) {
        int n2 = setting.getPlayBaudRate();
        int n3 = (int)((double)n2 * 0.1);
        int n4 = (n3 + 7) / 8;
        int n5 = n4 * 8 * this.moduleWidth;
        byte[] byArray = new byte[n4];
        this.mSquareWaveForLaunch = new short[n5 * 2];
        int n6 = this.ACEncodeByteStream(this.mSquareWaveForLaunch, 0, byArray, byArray.length);
    }

    protected int EncodeLaunchWave(short[] lpAudioBuf, int iPos, int iLen) {
        System.arraycopy(this.mSquareWaveForLaunch, 0, lpAudioBuf, iPos, this.mSquareWaveForLaunch.length);
        return iPos += this.mSquareWaveForLaunch.length;
    }

    @Override
    public int EncodeData(short[] lpAudioBuf, int iPos, byte[] data, int iLen) {
        if (data.length >= 2 && data[1] == 80) {
            iPos = this.EncodeLaunchWave(lpAudioBuf, iPos, iLen);
        }
        return super.EncodeData(lpAudioBuf, iPos, data, iLen);
    }

    @Override
    public int LengthOfEncodeData(byte[] data) {
        int n2 = 0;
        if (data.length >= 2 && data[1] == 80) {
            n2 = this.mSquareWaveForLaunch.length;
        }
        return n2 + super.LengthOfEncodeData(data);
    }
}

