/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.encode;

import com.landicorp.robert.comm.encode.MHEncode;
import com.landicorp.robert.comm.setting.CSetting;

public class MHEncodeMono
extends MHEncode {
    public MHEncodeMono(CSetting setting) {
        super(setting);
    }

    @Override
    protected void initWaveBuffer(int moduleWidth) {
        if (moduleWidth < 2) {
            throw new IllegalArgumentException("SineEncodeForProtocol Exception:NOT SUPPORT ARGUMENTS [moduleWidth = " + moduleWidth + "]");
        }
        int n2 = moduleWidth;
        this.bit1_1 = new short[n2];
        this.bit1_2 = new short[n2];
        this.bit0_1 = new short[n2];
        this.bit0_2 = new short[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.bit1_1[n3] = (short)(32767.0 * Math.sin(4.71238898038469 + Math.PI * 2 * ((double)n3 / (double)n2)));
            this.bit1_2[n3] = (short)(32767.0 * Math.sin(1.5707963267948966 + Math.PI * 2 * ((double)n3 / (double)n2)));
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            this.bit0_1[n3] = (short)(32767.0 * Math.sin(4.71238898038469 + Math.PI * ((double)n3 / (double)n2)));
            this.bit0_2[n3] = (short)(32767.0 * Math.sin(1.5707963267948966 + Math.PI * ((double)n3 / (double)n2)));
            ++n3;
        }
    }

    @Override
    protected int ACEncodeBit(short[] lpAudioBuf, int iPos, int bitVal) {
        if (bitVal != 0) {
            short[] sArray = this.bit1_1;
            if (iPos > 0 && lpAudioBuf[iPos - 1] > 0) {
                sArray = this.bit1_2;
            }
            System.arraycopy(sArray, 0, lpAudioBuf, iPos, sArray.length);
            iPos += sArray.length;
        } else {
            short[] sArray = this.bit0_1;
            if (iPos > 0 && lpAudioBuf[iPos - 1] > 0) {
                sArray = this.bit0_2;
            }
            System.arraycopy(sArray, 0, lpAudioBuf, iPos, sArray.length);
            iPos += sArray.length;
        }
        return iPos;
    }

    @Override
    protected int FillLeadGuideData(short[] lpAudioBuf, int iPos) {
        byte[] byArray = new byte[8];
        iPos = this.ACEncodeByteStream(lpAudioBuf, iPos, byArray, byArray.length);
        byte[] byArray2 = new byte[]{-55};
        iPos = this.ACEncodeByteStream(lpAudioBuf, iPos, byArray2, byArray2.length);
        return iPos;
    }

    @Override
    public int LengthOfEncodeData(byte[] data) {
        int n2 = (9 + data.length + 8) * 8 * this.moduleWidth;
        return n2;
    }
}

