/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.encode;

import com.landicorp.robert.comm.encode.MHEncode;
import com.landicorp.robert.comm.setting.CSetting;
import com.landicorp.util.Logger;

public class MHPowerEncode
extends MHEncode {
    public static final String LOG_FILENAME = "I-MHPowerEncode.txt";
    protected short[] powerAudioBuffer = null;
    protected short[] power_wave = null;

    public MHPowerEncode(CSetting setting) {
        super(setting);
        this.playSampleRate = setting.getPlaySampleRate();
        int n2 = this.playSampleRate / 2400;
        int n3 = n2 * 2;
        this.power_wave = new short[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.power_wave[n4 + 1] = (short)(32767.0 * Math.sin(Math.PI * 2 * ((double)n4 / (double)n3)));
            n4 += 2;
        }
    }

    @Override
    protected void initWaveBuffer(int moduleWidth) {
        super.initWaveBuffer(moduleWidth);
    }

    @Override
    public int EncodeData(short[] lpAudioBuf, int iPos, byte[] data, int iLen) {
        int n2 = iPos;
        n2 = super.EncodeData(lpAudioBuf, iPos, data, iLen);
        iPos = this.ACEncodeMuteStream(lpAudioBuf, iPos, n2 - iPos);
        return iPos;
    }

    @Override
    protected int ACEncodeMuteStream(short[] lpAudioBuf, int iPos, int iLen) {
        if ((iLen & 1) != 0) {
            Logger.shareInstance().writeLog(LOG_FILENAME, "ACEncodeMuteStream iLen is ODD." + iLen);
        }
        int n2 = iPos;
        int n3 = n2 + iLen;
        int n4 = n2 + 1;
        int n5 = 1;
        while (n4 < n3) {
            if (n5 >= this.power_wave.length) {
                n5 = 1;
            }
            lpAudioBuf[n4] = this.power_wave[n5];
            n4 += 2;
            n5 += 2;
        }
        return n2 += iLen;
    }
}

