/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.encode;

import com.landicorp.robert.comm.encode.SquareEncodeForProtocol;
import com.landicorp.robert.comm.setting.CSetting;

public class SineEncodeForProtocol
extends SquareEncodeForProtocol {
    public SineEncodeForProtocol(CSetting setting) {
        super(setting);
    }

    @Override
    protected void initWaveBuffer(int moduleWidth) {
        if (moduleWidth < 4) {
            throw new IllegalArgumentException("SineEncodeForProtocol Exception:NOT SUPPORT ARGUMENTS [moduleWidth = " + moduleWidth + "]");
        }
        this.bit1_1 = new short[moduleWidth];
        this.bit1_2 = new short[moduleWidth];
        this.bit0_1 = new short[moduleWidth];
        this.bit0_2 = new short[moduleWidth];
        int n2 = 0;
        while (n2 < moduleWidth) {
            this.bit1_1[n2] = (short)(32767.0 * Math.sin(Math.PI * 2 * ((double)n2 / (double)moduleWidth)));
            this.bit1_2[n2] = -this.bit1_1[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < moduleWidth) {
            this.bit0_1[n2] = (short)(32767.0 * Math.sin(Math.PI * ((double)n2 / (double)moduleWidth)));
            this.bit0_2[n2] = -this.bit0_1[n2];
            ++n2;
        }
    }
}

