/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.encode;

import com.landicorp.robert.comm.encode.Encode;
import com.landicorp.robert.comm.setting.CSetting;

public class SquareEncode
extends Encode {
    public static final int BIT0 = 0;
    public static final int BIT1 = 1;
    protected short[] bit1_1 = null;
    protected short[] bit1_2 = null;
    protected short[] bit0_1 = null;
    protected short[] bit0_2 = null;
    protected final int COUNT_PREGUIDE = 40;
    protected final int COUNT_POSTGUIDE = 6;
    protected byte[] mPaddingChars = new byte[10];
    protected int playBaudRate = 0;
    protected int playSampleRate = 0;
    protected int moduleWidth = 0;

    public SquareEncode(CSetting setting) {
        this.playBaudRate = setting.getPlayBaudRate();
        this.playSampleRate = setting.getPlaySampleRate();
        this.moduleWidth = this.playSampleRate / this.playBaudRate;
        int n2 = 0;
        while (n2 < this.mPaddingChars.length) {
            this.mPaddingChars[n2] = 5;
            ++n2;
        }
        this.initWaveBuffer(this.moduleWidth);
    }

    protected void initWaveBuffer(int moduleWidth) {
        if (moduleWidth < 4) {
            throw new IllegalArgumentException("SquareEncode Exception:NOT SUPPORT ARGUMENTS [moduleWidth = " + moduleWidth + "]");
        }
        int n2 = Short.MAX_VALUE;
        short s = (short)((double)n2 * 0.6);
        int n3 = Short.MIN_VALUE;
        short s2 = (short)((double)n3 * 0.6);
        int n4 = moduleWidth / 2;
        this.bit1_1 = new short[moduleWidth];
        this.bit1_2 = new short[moduleWidth];
        this.bit0_1 = new short[moduleWidth];
        this.bit0_2 = new short[moduleWidth];
        int n5 = 0;
        while (n5 < n4) {
            this.bit1_1[n5] = n2;
            this.bit1_2[n5] = n3;
            this.bit0_1[n5] = n2;
            this.bit0_2[n5] = n3;
            ++n5;
        }
        n5 = n4;
        while (n5 < moduleWidth) {
            this.bit1_1[n5] = n3;
            this.bit1_2[n5] = n2;
            this.bit0_1[n5] = n2;
            this.bit0_2[n5] = n3;
            ++n5;
        }
        short s3 = s;
        this.bit1_1[n4 - 1] = s3;
        this.bit1_1[0] = s3;
        short s4 = s2;
        this.bit1_1[moduleWidth - 1] = s4;
        this.bit1_1[n4] = s4;
        short s5 = s2;
        this.bit1_2[n4 - 1] = s5;
        this.bit1_2[0] = s5;
        short s6 = s;
        this.bit1_2[moduleWidth - 1] = s6;
        this.bit1_2[n4] = s6;
        short s7 = s;
        this.bit0_1[moduleWidth - 1] = s7;
        this.bit0_1[0] = s7;
        short s8 = s2;
        this.bit0_2[moduleWidth - 1] = s8;
        this.bit0_2[0] = s8;
    }

    protected int FillLeadGuideData(short[] lpAudioBuf, int iPos, int iLen) {
        return this.FillGuideData(lpAudioBuf, iPos, iLen, 1);
    }

    protected int FillBackGuideData(short[] lpAudioBuf, int iPos, int iLen) {
        return this.FillGuideData(lpAudioBuf, iPos, iLen, 0);
    }

    protected int FillGuideData(short[] lpAudioBuf, int iPos, int iLen, int iBitType) {
        short[] sArray = null;
        int n2 = 0;
        if (iPos > 0) {
            n2 = lpAudioBuf[iPos - 1] > 0 ? 1 : 0;
        }
        if (iBitType == 0) {
            int n3 = 0;
            while (n3 < iLen) {
                sArray = (n3 & 1) == n2 ? this.bit0_1 : this.bit0_2;
                System.arraycopy(sArray, 0, lpAudioBuf, iPos, sArray.length);
                iPos += sArray.length;
                ++n3;
            }
        } else if (iBitType == 1) {
            sArray = n2 == 1 ? this.bit1_2 : this.bit1_1;
            int n4 = 0;
            while (n4 < iLen) {
                System.arraycopy(sArray, 0, lpAudioBuf, iPos, sArray.length);
                iPos += sArray.length;
                ++n4;
            }
        } else {
            return iPos;
        }
        return iPos;
    }

    protected int ACEncodeBit(short[] lpAudioBuf, int iPos, int bitVal) {
        if (bitVal != 0) {
            short[] sArray = this.bit1_1;
            if (iPos > 0 && lpAudioBuf[iPos - 1] > 0) {
                sArray = this.bit1_2;
            }
            System.arraycopy(sArray, 0, lpAudioBuf, iPos, sArray.length);
            iPos += sArray.length;
        } else {
            short[] sArray = this.bit0_1;
            if (iPos > 0 && lpAudioBuf[iPos - 1] > 0) {
                sArray = this.bit0_2;
            }
            System.arraycopy(sArray, 0, lpAudioBuf, iPos, sArray.length);
            iPos += sArray.length;
        }
        return iPos;
    }

    protected int ACEncodeByte(short[] lpAudioBuf, int iPos, byte byteData) {
        int n2 = iPos;
        byte by = 0;
        int n3 = 0;
        if (lpAudioBuf != null) {
            n2 = this.ACEncodeBit(lpAudioBuf, n2, 0);
            int n4 = 0;
            while (n4 < 8) {
                by = (byte)(byteData >> n4 & 1);
                n2 = this.ACEncodeBit(lpAudioBuf, n2, by);
                n3 += by;
                ++n4;
            }
            n3 = n3 & true ? 1 : 0;
            n2 = this.ACEncodeBit(lpAudioBuf, n2, n3);
            n2 = this.ACEncodeBit(lpAudioBuf, n2, 1);
        }
        return n2;
    }

    protected int ACEncodeByteStream(short[] lpAudioBuf, int iPos, byte[] bytedata, int iLen) {
        int n2 = iPos;
        if (lpAudioBuf != null) {
            int n3 = 0;
            while (n3 < iLen) {
                n2 = this.ACEncodeByte(lpAudioBuf, n2, bytedata[n3]);
                ++n3;
            }
        }
        return n2;
    }

    protected int ACEncodeData(short[] lpAudioBuf, int iPos, byte[] data, int iLen) {
        int n2 = iPos;
        if (lpAudioBuf != null) {
            n2 = this.FillLeadGuideData(lpAudioBuf, n2, 40);
            n2 = this.ACEncodeByteStream(lpAudioBuf, n2, data, iLen);
            n2 = this.ACEncodeByteStream(lpAudioBuf, n2, this.mPaddingChars, this.mPaddingChars.length);
            n2 = this.FillBackGuideData(lpAudioBuf, n2, 6);
        }
        return n2;
    }

    protected int ACEncodeMuteStream(short[] lpAudioBuf, int iPos, int iLen) {
        int n2 = iPos;
        int n3 = iLen;
        while (n3 > 0) {
            lpAudioBuf[n2++] = 0;
            --n3;
        }
        return n2;
    }

    @Override
    public int EncodeData(short[] lpAudioBuf, int iPos, byte[] data, int iLen) {
        return this.ACEncodeData(lpAudioBuf, iPos, data, iLen);
    }

    @Override
    public int EncodeMuteStream(short[] lpAudioBuf, int iPos, int iLen) {
        return this.ACEncodeMuteStream(lpAudioBuf, iPos, iLen);
    }

    @Override
    public int LengthOfEncodeData(byte[] data) {
        int n2 = 0;
        n2 = this.bit0_1.length * 40 + this.bit0_1.length * 11 * data.length + this.bit0_1.length * 11 * this.mPaddingChars.length + this.bit0_1.length * 6;
        return n2;
    }
}

