/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.encode;

import com.landicorp.robert.comm.encode.SquareEncode;
import com.landicorp.robert.comm.setting.CSetting;

public class SquareEncodeForProtocol
extends SquareEncode {
    protected short[] mSineWave = new short[13200];
    protected final int SINE_WAVE_SIZE = 13200;

    public SquareEncodeForProtocol(CSetting setting) {
        super(setting);
        int n2 = 0;
        while (n2 < 13200) {
            this.mSineWave[n2] = n2 % 4 == 0 ? 0 : (n2 % 4 == 1 ? 30000 : (n2 % 4 == 2 ? 0 : -30000));
            ++n2;
        }
    }

    protected int EncodeSineWave(short[] lpAudioBuf, int iPos, int iLen) {
        System.arraycopy(this.mSineWave, 0, lpAudioBuf, iPos, this.mSineWave.length);
        return iPos += this.mSineWave.length;
    }

    @Override
    public int EncodeData(short[] lpAudioBuf, int iPos, byte[] data, int iLen) {
        if (data.length >= 2 && data[1] == 80) {
            iPos = this.EncodeSineWave(lpAudioBuf, iPos, iLen);
        }
        return super.EncodeData(lpAudioBuf, iPos, data, iLen);
    }

    @Override
    public int LengthOfEncodeData(byte[] data) {
        int n2 = 0;
        if (data.length >= 2 && data[1] == 80) {
            n2 = this.mSineWave.length;
        }
        return n2 + super.LengthOfEncodeData(data);
    }
}

