/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.link;

public class CommPackage {
    public static final int FRAME_SUCCESS = 0;
    public static final int FRAME_STX_ERROR = -1;
    public static final int FRAME_LENGTH_ERROR = -2;
    public static final int FRAME_TYPE_ERROR = -3;
    public static final int FRAME_LRC_ERROR = -4;
    public static final int FRAME_ETX_ERROR = -5;
    public static final int FRAME_IGNORE_ERROR = -6;
    public static final int FRAME_NUMBER_ERROR = -7;
    public static final int FRAME_PROTOCOL_ERROR = -8;
    public static final int FRAME_DATA_ERROR = -9;
    public static final int FRAME_NOT_OVER = -10;
    public static final int FRAME_REPEAT = -11;
    public static final int BIT_LENGTH_ERROR = -6;
    public static final int BIT_INVAILEDCHAR_ERROR = -7;
    public static final int BIT_STX_ERROR = -8;
    public static final int BIT_LRC_ERROR = -9;
    public static final int BIT_ETX_ERROR = -10;
    public static final int BIT_INVALID_DATA = -11;
    public static final byte STX = 2;
    public static final byte ETB = 23;
    public static final byte ETX = 3;
    public static final byte ACK = 65;
    public static final byte NAK = 78;
    public static final byte DATA = 68;
    public static final byte PARAMATER = 80;
    public static final byte CANCEL = 67;
    public static final byte SHUTDOWN = 83;
    public static final byte MESSAGE = 77;
    public static final byte[] COMMPACKTYPE = new byte[]{65, 78, 68, 80, 67, 83, 77};
    private byte a = (byte)2;
    private byte b = 0;
    private short c = 0;
    private int d = 0;
    private byte e = 0;
    private byte f = 0;
    private byte[] g = null;
    private byte[] h = null;
    private int i = 0;

    public static byte CalcLRC(byte[] data, int iPos, int iLen) {
        byte by = 0;
        int n2 = iPos + iLen;
        int n3 = iPos;
        while (n3 < data.length && n3 < n2) {
            by = (byte)(by ^ data[n3]);
            ++n3;
        }
        return by;
    }

    public CommPackage() {
    }

    public CommPackage(byte[] commData, byte frameType, short frameNum, boolean isETX) {
        this.createCommPack(commData, frameType, frameNum, isETX);
    }

    public CommPackage(byte[] commPack) {
        this.i = this.analyseCommData(commPack);
    }

    public int GetLastError() {
        return this.i;
    }

    protected byte[] createCommPack(byte[] commData, byte frameType, short frameNum, boolean isETX) {
        this.e = frameType;
        this.c = frameNum;
        if (commData != null) {
            this.g = commData;
            this.d = (short)this.g.length;
        } else {
            this.g = null;
            this.d = 0;
        }
        this.b = isETX ? (byte)3 : (byte)23;
        this.f = 0;
        this.f = (byte)(this.f ^ frameType);
        this.f = (byte)(this.f ^ this.c >> 8 & 0xFF);
        this.f = (byte)(this.f ^ this.c & 0xFF);
        this.f = (byte)(this.f ^ this.d >> 8 & 0xFF);
        this.f = (byte)(this.f ^ this.d & 0xFF);
        if (this.g != null) {
            this.f = (byte)(this.f ^ CommPackage.CalcLRC(this.g, 0, this.g.length));
        }
        this.h = new byte[8 + this.d];
        int n2 = 0;
        this.h[n2++] = this.a;
        this.h[n2++] = this.e;
        this.h[n2++] = (byte)(this.c >> 8 & 0xFF);
        this.h[n2++] = (byte)(this.c & 0xFF);
        this.h[n2++] = (byte)(this.d >> 8 & 0xFF);
        this.h[n2++] = (byte)(this.d & 0xFF);
        if (this.g != null) {
            System.arraycopy(this.g, 0, this.h, n2, this.g.length);
            n2 += this.g.length;
        }
        this.h[n2++] = this.f;
        this.h[n2++] = this.b;
        return this.h;
    }

    protected int analyseCommData(byte[] commData) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < commData.length) {
            if (commData[n3] == 2) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 >= 0) {
            if (commData.length >= n2 + 8) {
                this.a = commData[n2++];
                n3 = n2;
                this.e = commData[n2++];
                if (this.e == 65 || this.e == 78 || this.e == 68 || this.e == 80 || this.e == 67 || this.e == 83 || this.e == 77) {
                    this.c = (short)(commData[n2++] << 8 & 0xFF00);
                    this.c = (short)(this.c | (short)(commData[n2++] & 0xFF));
                    this.d = (short)(commData[n2++] << 8 & 0xFF00);
                    this.d |= (short)(commData[n2++] & 0xFF);
                    if (this.d < 0) {
                        return -2;
                    }
                    if (this.d + n2 + 2 <= commData.length) {
                        this.g = new byte[this.d];
                        System.arraycopy(commData, n2, this.g, 0, this.d);
                        n2 += this.d;
                        this.f = commData[n2++];
                        this.b = commData[n2++];
                        if (this.b == 23) {
                            if (CommPackage.CalcLRC(commData, n3, 6 + this.d) == 0) {
                                return -10;
                            }
                            return -4;
                        }
                        if (this.b == 3) {
                            return 0;
                        }
                        return -5;
                    }
                    return -2;
                }
                return -3;
            }
            return -2;
        }
        return -1;
    }

    public byte getFrameType() {
        return this.e;
    }

    public void setFrameType(byte frameType) {
        this.e = frameType;
    }

    public short getFrameNumber() {
        return this.c;
    }

    public int getFrameLength() {
        return this.d;
    }

    public byte getFrameLRC() {
        return this.f;
    }

    public void setFrameLRC(byte lrc) {
        this.f = lrc;
    }

    public byte getSTX() {
        return this.a;
    }

    public byte getETX() {
        return this.b;
    }

    public byte[] getFrameData() {
        return this.g;
    }

    public void setFrameData(byte[] data) {
        this.g = data;
        if (this.g != null) {
            this.d = (short)data.length;
        }
    }

    public byte[] rePackData() {
        return this.createCommPack(this.g, this.e, this.c, this.b == 3);
    }

    public byte[] getPackData() {
        if (this.b == 3 && this.h != null && this.h.length >= 2) {
            this.h[this.h.length - 2] = this.getFrameLRC();
        }
        return this.h;
    }
}

