/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.link;

import com.landicorp.robert.comm.link.CommPackage;
import com.landicorp.robert.comm.link.IToolPack;
import com.landicorp.robert.comm.link.IToolPackContext;
import com.landicorp.robert.comm.link.IToolUnPack;
import java.util.ArrayList;
import java.util.List;

public class PackageTool
implements IToolPack,
IToolPackContext,
IToolUnPack {
    protected List<CommPackage> mPackList = new ArrayList<CommPackage>();
    protected int mPackSize = 256;
    protected short mPackNum = 0;

    public PackageTool() {
    }

    public PackageTool(int packSize) {
        this.SetPackSize(packSize);
    }

    @Override
    public void SetPackSize(int packSize) {
        this.mPackSize = packSize;
    }

    @Override
    public int GetPackSize() {
        return this.mPackSize;
    }

    @Override
    public void ResetContext() {
        this.mPackList.clear();
        this.mPackNum = 0;
    }

    @Override
    public void SetPackNum(short packNum) {
        this.mPackNum = packNum;
    }

    @Override
    public short GetPackNum() {
        return this.mPackNum;
    }

    protected byte CalcLRCForPacks(List<CommPackage> packList) {
        int n2 = 0;
        short s = 0;
        byte by = 0;
        if (packList.size() > 0) {
            s = packList.get(0).getFrameNumber();
            by = (byte)(by ^ packList.get(0).getFrameType());
            by = (byte)(by ^ (byte)(s >> 8 & 0xFF));
            by = (byte)(by ^ (byte)(s & 0xFF));
            int n3 = 0;
            while (n3 < packList.size()) {
                n2 += packList.get(n3).getFrameLength();
                by = (byte)(by ^ CommPackage.CalcLRC(packList.get(n3).getFrameData(), 0, packList.get(n3).getFrameData().length));
                ++n3;
            }
            by = (byte)(by ^ (byte)(n2 >> 8 & 0xFF));
            by = (byte)(by ^ (byte)(n2 & 0xFF));
        }
        return by;
    }

    protected byte CalcLRCForPacks(List<CommPackage> packList, CommPackage packETX) {
        int n2 = packETX.getFrameLength();
        short s = packETX.getFrameNumber();
        byte by = 0;
        by = (byte)(by ^ CommPackage.CalcLRC(packETX.getFrameData(), 0, packETX.getFrameData().length));
        if (packList.size() > 0) {
            s = packList.get(0).getFrameNumber();
            int n3 = 0;
            while (n3 < packList.size()) {
                n2 += packList.get(n3).getFrameLength();
                by = (byte)(by ^ CommPackage.CalcLRC(packList.get(n3).getFrameData(), 0, packList.get(n3).getFrameData().length));
                ++n3;
            }
        }
        by = (byte)(by ^ packETX.getFrameType());
        by = (byte)(by ^ (byte)(s >> 8 & 0xFF));
        by = (byte)(by ^ (byte)(s & 0xFF));
        by = (byte)(by ^ (byte)(n2 >> 8 & 0xFF));
        by = (byte)(by ^ (byte)(n2 & 0xFF));
        return by;
    }

    protected byte CalcLRCForSingleFrame(CommPackage pack) {
        byte by = 0;
        byte by2 = pack.getFrameType();
        short s = pack.getFrameNumber();
        int n2 = pack.getFrameLength();
        byte[] byArray = pack.getFrameData();
        by = (byte)(by ^ by2);
        by = (byte)(by ^ (byte)(s >> 8 & 0xFF));
        by = (byte)(by ^ (byte)(s & 0xFF));
        by = (byte)(by ^ (byte)(n2 >> 8 & 0xFF));
        by = (byte)(by ^ (byte)(n2 & 0xFF));
        by = (byte)(by ^ CommPackage.CalcLRC(byArray, 0, n2));
        return by;
    }

    @Override
    public int PackData(byte packType, byte[] data) {
        this.mPackList.clear();
        if (data == null) {
            CommPackage commPackage = new CommPackage(null, packType, this.mPackNum, true);
            this.mPackList.add(commPackage);
        } else {
            Object object;
            int n2 = (data.length + this.mPackSize - 1) / this.mPackSize;
            int n3 = n2 - 1;
            int n4 = data.length % this.mPackSize;
            int n5 = n4 == 0 ? this.mPackSize : n4;
            int n6 = 0;
            while (n6 < n3) {
                object = new byte[this.mPackSize];
                System.arraycopy(data, n6 * this.mPackSize, object, 0, this.mPackSize);
                CommPackage commPackage = new CommPackage((byte[])object, packType, this.mPackNum, false);
                this.mPackList.add(commPackage);
                this.mPackNum = (short)(this.mPackNum + 1);
                ++n6;
            }
            if (n2 > 0) {
                byte[] byArray = new byte[n5];
                System.arraycopy(data, (n2 - 1) * this.mPackSize, byArray, 0, n5);
                object = new CommPackage(byArray, packType, this.mPackNum, true);
                this.mPackList.add((CommPackage)object);
                this.mPackNum = (short)(this.mPackNum + 1);
                byte by = this.CalcLRCForPacks(this.mPackList);
                this.mPackList.get(this.mPackList.size() - 1).setFrameLRC(by);
            }
        }
        return this.mPackList.size();
    }

    @Override
    public int GetPackCount() {
        return this.mPackList.size();
    }

    @Override
    public CommPackage GetPackByIndex(int index) {
        if (index < this.mPackList.size()) {
            return this.mPackList.get(index);
        }
        return null;
    }

    @Override
    public byte[] UnPackData() {
        if (this.mPackList.size() > 0 && this.mPackList.get(this.mPackList.size() - 1).getETX() == 3) {
            byte by = this.mPackList.get(this.mPackList.size() - 1).getFrameType();
            if (65 == by || 78 == by) {
                byte[] byArray = this.mPackList.get(this.mPackList.size() - 1).getFrameData();
                if (byArray != null) {
                    byArray = (byte[])byArray.clone();
                }
                this.mPackList.remove(this.mPackList.size() - 1);
                return byArray;
            }
            short s = 0;
            int n2 = this.mPackList.get(0).getFrameLength();
            s = (short)(n2 * (this.mPackList.size() - 1));
            s = (short)(s + this.mPackList.get(this.mPackList.size() - 1).getFrameLength());
            byte[] byArray = new byte[s];
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.mPackList.size()) {
                System.arraycopy(this.mPackList.get(n4).getFrameData(), 0, byArray, n3, this.mPackList.get(n4).getFrameData().length);
                n3 = (short)(n3 + this.mPackList.get(n4).getFrameData().length);
                ++n4;
            }
            this.mPackList.clear();
            return byArray;
        }
        return null;
    }

    @Override
    public int AddPack(CommPackage commPack) {
        int n2 = commPack.GetLastError();
        if (n2 == 0 || -10 == n2) {
            short s = commPack.getFrameNumber();
            short s2 = this.mPackNum;
            short s3 = (short)(s - s2);
            if (commPack.getFrameType() == 80) {
                this.mPackList.clear();
                s3 = 1;
            } else if (commPack.getFrameType() == 65 || commPack.getFrameType() == 78) {
                byte by = this.CalcLRCForSingleFrame(commPack);
                if (by == commPack.getFrameLRC()) {
                    this.mPackList.add(commPack);
                    return 0;
                }
                return -4;
            }
            if (s3 != 0) {
                short s4 = 0;
                if (this.mPackList.size() > 0 && (s4 = (short)(commPack.getFrameNumber() - this.mPackNum)) != 1) {
                    this.mPackList.clear();
                }
                if (commPack.getETX() == 3 && n2 == 0) {
                    byte by = this.CalcLRCForPacks(this.mPackList, commPack);
                    if (by == commPack.getFrameLRC()) {
                        this.mPackNum = commPack.getFrameNumber();
                        this.mPackList.add(commPack);
                        return 0;
                    }
                    return -4;
                }
                if (commPack.getETX() != 23 || n2 != -10) {
                    throw new IllegalStateException("PackageTool:AddPack ETX state [" + commPack.getETX() + "] or CommPackage state [" + n2 + "] is wrong.");
                }
                this.mPackNum = commPack.getFrameNumber();
                this.mPackList.add(commPack);
                return -10;
            }
            return -11;
        }
        return n2;
    }

    @Override
    public int AddPack(byte[] pack) {
        CommPackage commPackage = new CommPackage(pack);
        return this.AddPack(commPackage);
    }

    @Override
    public boolean IsUnPack() {
        return this.mPackList.size() > 0 && this.mPackList.get(this.mPackList.size() - 1).getETX() == 3;
    }
}

