/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.link;

import android.media.AudioTrack;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import com.landicorp.robert.comm.encode.Encode;
import com.landicorp.robert.comm.link.SyncQueue;
import com.landicorp.robert.comm.setting.CSetting;
import com.landicorp.util.Logger;

public class PlayThread
extends Thread {
    public static final String LOG_FILENAME = "I-PlayThread.txt";
    public static final int TAG_NONE = -1;
    protected static final float MUTE_TIME = 0.1f;
    protected int m_sampleRate = 44100;
    protected int m_playBufRate = 2;
    protected int m_playBaudRate = 3675;
    protected AudioTrack audioTrack = null;
    protected int playBufSize = 0;
    protected boolean bExit = false;
    protected SyncQueue<PlayData> playQueue = new SyncQueue();
    protected float m_leftVolumn = AudioTrack.getMaxVolume();
    protected float m_rightVolumn = AudioTrack.getMaxVolume();
    protected float m_minVolumn = AudioTrack.getMinVolume();
    protected float m_maxVolumn = AudioTrack.getMaxVolume();
    protected Encode encode = null;
    protected Handler mRoutineHandler = null;
    protected short[] mMuteData = null;
    protected boolean bSuspend = true;
    protected Object lockObject = new Object();

    public PlayThread(CSetting setting) {
        this.m_sampleRate = setting.getPlaySampleRate();
        this.m_playBaudRate = setting.getPlayBaudRate();
        this.m_playBufRate = setting.getPlayBufRate();
        this.m_leftVolumn = setting.getPlayVolume();
        this.m_rightVolumn = setting.getPlayVolume();
        this.m_maxVolumn = setting.getPlayVolume();
        this.encode = setting.getEncode();
        this.mRoutineHandler = setting.getRoutineHandler();
        this.initForAudioTrack();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void init() {
        Process.setThreadPriority((int)-16);
        int n2 = this.m_playBufRate * this.playBufSize;
        if (n2 == 0) {
            throw new IllegalArgumentException("Arguments Error: PlayThread init() EncodeMuteData throw Exception");
        }
        this.mMuteData = this.EncodeMuteData(n2);
        this.Play(this.mMuteData);
    }

    protected boolean tryForStartAudioTrack() {
        if (!this.startForAudioTrack()) {
            this.releaseAudioTrack();
            this.initForAudioTrack();
            return this.startForAudioTrack();
        }
        return true;
    }

    protected boolean initForAudioTrack() {
        try {
            this.playBufSize = AudioTrack.getMinBufferSize((int)this.m_sampleRate, (int)4, (int)2);
            this.audioTrack = new AudioTrack(3, this.m_sampleRate, 4, 2, this.m_playBufRate * this.playBufSize, 1);
            if (1 == this.audioTrack.getState()) {
                return true;
            }
        }
        catch (Exception exception) {
            Log.e((String)"PlayThread", (String)"PlayThread : initForAudioTrack exception...");
            exception.printStackTrace();
        }
        return false;
    }

    protected boolean startForAudioTrack() {
        try {
            if (this.audioTrack != null && 1 == this.audioTrack.getState()) {
                this.audioTrack.play();
                if (this.audioTrack.getPlayState() == 3) {
                    if (this.audioTrack.setStereoVolume(AudioTrack.getMaxVolume(), AudioTrack.getMaxVolume()) != 0) {
                        Log.e((String)"AudioTrack", (String)"setStereoVolume fail...");
                    }
                    return true;
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            Log.e((String)"PlayThread", (String)"audioTrack play() fail...throw exception(1)");
            illegalStateException.printStackTrace();
        }
        return false;
    }

    protected void stopAudioTrack() {
        try {
            if (this.audioTrack != null && this.audioTrack.getPlayState() != 1) {
                try {
                    this.audioTrack.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    illegalStateException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void releaseAudioTrack() {
        try {
            if (this.audioTrack != null) {
                if (this.audioTrack.getPlayState() != 1) {
                    this.audioTrack.stop();
                }
                this.audioTrack.release();
                this.audioTrack = null;
            }
        }
        catch (Exception exception) {
            Log.e((String)"PlayThread", (String)"PlayThread : releaseAudioTrack exception...");
            exception.printStackTrace();
        }
    }

    protected void release() {
        this.releaseAudioTrack();
        if (this.playQueue != null) {
            this.playQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SuspendPlay() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.bSuspend) {
                this.bSuspend = true;
            }
            PlayThread playThread = this;
            synchronized (playThread) {
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ResumePlay() {
        Object object = this.lockObject;
        synchronized (object) {
            block9: {
                if (this.bSuspend) {
                    PlayThread playThread = this;
                    synchronized (playThread) {
                        if (this.tryForStartAudioTrack()) {
                            this.bSuspend = false;
                            this.notify();
                            break block9;
                        }
                        if (this.mRoutineHandler != null) {
                            Message message = this.mRoutineHandler.obtainMessage(-4, 0, 0, null);
                            message.sendToTarget();
                        }
                        return false;
                    }
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void SetSoftVolumn(float leftVolumn, float rightVolumn) {
        Object object = this.lockObject;
        synchronized (object) {
            try {
                this.m_leftVolumn = leftVolumn;
                this.m_rightVolumn = rightVolumn;
                if (this.audioTrack != null) {
                    this.audioTrack.setStereoVolume(leftVolumn, rightVolumn);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void SetSoftMute() {
        this.SetSoftVolumn(this.m_minVolumn, this.m_minVolumn);
    }

    public void SetSoftPower() {
        this.SetSoftVolumn(this.m_maxVolumn, this.m_maxVolumn);
    }

    public void Play(byte[] playData) {
        Logger.shareInstance().writeLog(LOG_FILENAME, "call play data [1]..." + playData.length);
        short[] sArray = this.EncodeData(playData);
        this.playQueue.increase(new PlayData(sArray));
    }

    public void Play(short[] encodeData) {
        Logger.shareInstance().writeLog(LOG_FILENAME, "call play encoded data [2]..." + encodeData.length);
        this.playQueue.increase(new PlayData(encodeData));
    }

    public void Play(byte[] playData, int playTag1, int playTag2) throws IllegalArgumentException {
        short[] sArray = this.EncodeData(playData);
        PlayData playData2 = new PlayData(sArray);
        playData2.tag1 = playTag1;
        playData2.tag2 = playTag2;
        playData2.bCallBack = true;
        this.playQueue.increase(playData2);
    }

    public void Play(short[] encodeData, int playTag1, int playTag2) throws IllegalArgumentException {
        PlayData playData = new PlayData(encodeData);
        playData.tag1 = playTag1;
        playData.tag2 = playTag2;
        playData.bCallBack = true;
        this.playQueue.increase(playData);
    }

    public int PlayTime(byte[] playData) {
        int n2;
        if (playData != null && this.m_sampleRate > 0 && (n2 = this.lengthOfEncodeData(playData)) > 0) {
            return (int)((double)n2 / (double)this.m_sampleRate * 1000.0);
        }
        return 0;
    }

    public int PlayTime(short[] encodeData) {
        if (encodeData != null && this.m_sampleRate > 0) {
            return (int)((double)encodeData.length / (double)this.m_sampleRate * 1000.0);
        }
        return 0;
    }

    public void PlayMuteStream(int length) {
        short[] sArray = this.EncodeMuteData(length);
        this.playQueue.increase(new PlayData(sArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Stop() {
        Logger.shareInstance().writeLog(LOG_FILENAME, "Stop...");
        this.SuspendPlay();
        this.bExit = true;
        this.interrupt();
        PlayThread playThread = this;
        synchronized (playThread) {
        }
    }

    public void Flush() {
        Logger.shareInstance().writeLog(LOG_FILENAME, "Call Flush...");
        if (this.bSuspend || this.bExit) {
            return;
        }
        Logger.shareInstance().writeLog(LOG_FILENAME, "Flushing...");
        while (this.playQueue.getCurrentCount() > 0) {
            this.SuspendPlay();
            this.ResumePlay();
            try {
                PlayThread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void Reset() {
        Logger.shareInstance().writeLog(LOG_FILENAME, "Reset...");
        if (this.playQueue != null) {
            this.playQueue.clear();
        }
    }

    protected int lengthOfMuteData() {
        return (int)((float)this.m_sampleRate * 0.1f);
    }

    protected int lengthOfEncodeData(byte[] sendData) {
        int n2 = this.encode.LengthOfEncodeData(sendData);
        int n3 = this.lengthOfMuteData();
        return n2 + n3;
    }

    public short[] EncodeData(byte[] sendData) {
        int n2 = this.lengthOfEncodeData(sendData);
        short[] sArray = new short[n2];
        int n3 = 0;
        n3 = this.encode.EncodeMuteStream(sArray, n3, this.lengthOfMuteData());
        n3 = this.encode.EncodeData(sArray, n3, sendData, sendData.length);
        Logger.shareInstance().writeLog("playQueue.pcm", sArray);
        return sArray;
    }

    protected short[] EncodeMuteData(int length) {
        int n2 = length;
        short[] sArray = new short[n2];
        int n3 = 0;
        n3 = this.encode.EncodeMuteStream(sArray, n3, n2);
        return sArray;
    }

    @Override
    public synchronized void start() {
        this.bExit = false;
        this.bSuspend = true;
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PlayThread playThread = this;
        synchronized (playThread) {
            block17: {
                super.run();
                try {
                    try {
                        this.init();
                        int n2 = 0;
                        int n3 = -1;
                        int n4 = -1;
                        boolean bl = false;
                        int n5 = 0;
                        int n6 = 0;
                        int n7 = 0;
                        int n8 = this.m_playBufRate * this.playBufSize;
                        PlayData playData = null;
                        short[] sArray = null;
                        while (!this.bExit) {
                            if (this.bSuspend) {
                                this.stopAudioTrack();
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if (this.bExit) break;
                                if (this.bSuspend) continue;
                                this.startForAudioTrack();
                            }
                            if ((playData = this.getPlayData()) != null) {
                                sArray = playData.data;
                                n3 = playData.tag1;
                                n4 = playData.tag2;
                                bl = playData.bCallBack;
                                Logger.shareInstance().writeLog(LOG_FILENAME, "Play data...");
                            } else {
                                sArray = this.mMuteData;
                                n3 = -1;
                                n4 = -1;
                                bl = false;
                            }
                            if (sArray == null || sArray.length <= 0) continue;
                            n7 = sArray.length;
                            n5 = 0;
                            n6 = 0;
                            n2 = 0;
                            while ((n2 = this.audioTrack.write(sArray, n5, n6 = n7 > n8 ? n8 : n7)) > 0) {
                                n5 += n2;
                                if ((n7 -= n2) > 0) continue;
                            }
                            if (n7 <= 0) {
                                if (this.mRoutineHandler == null || !bl) continue;
                                this.mRoutineHandler.obtainMessage(0, n3, n4, (Object)sArray).sendToTarget();
                                continue;
                            }
                            this.releaseAudioTrack();
                            this.tryForStartAudioTrack();
                            if (this.mRoutineHandler == null || !bl) continue;
                            this.mRoutineHandler.obtainMessage(-1, n3, n4, (Object)sArray).sendToTarget();
                        }
                    }
                    catch (Exception exception) {
                        Log.e((String)"PlayThread", (String)"PlayThread-Exception...");
                        exception.printStackTrace();
                        this.release();
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    this.release();
                    throw throwable;
                }
                this.release();
            }
        }
    }

    protected PlayData getPlayData() {
        PlayData playData = null;
        playData = this.playQueue.getCurrentCount() > 0 ? this.playQueue.decrease(1L) : null;
        return playData;
    }

    public class PlayData {
        public int tag1 = -1;
        public int tag2 = -1;
        public boolean bCallBack = false;
        public short[] data = null;

        public PlayData(short[] data) {
            this.data = data;
        }
    }
}

