/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.link;

import android.media.AudioRecord;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import com.landicorp.robert.comm.link.SyncQueue;
import com.landicorp.robert.comm.setting.CSetting;
import com.landicorp.util.Logger;
import java.util.Date;

public class RecordThread
extends Thread {
    protected int m_sampleRate = 44100;
    protected int m_recordBufRate = 4;
    protected int recordBufSize = 0;
    protected AudioRecord audioRecord = null;
    protected int readSize = 0;
    protected SyncQueue<short[]> recordQueue = new SyncQueue();
    protected boolean bExit = false;
    protected boolean bSuspend = true;
    protected long blockTimeout = 3000L;
    protected Handler mRoutineHandler = null;
    protected Object audioLockObject = new Object();
    protected Object lockObject = new Object();
    protected int audioSource = 1;
    public static final String LOG_FILENAME = "I-RecordThread.txt";

    public RecordThread(CSetting setting) {
        this.m_sampleRate = setting.getRecordSampleRate();
        this.m_recordBufRate = setting.getRecordBufRate();
        this.mRoutineHandler = setting.getRoutineHandler();
        this.audioSource = this.checkAudioSource(setting.getRecordSource());
    }

    protected int checkAudioSource(int source) {
        switch (source) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                source = 1;
            }
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SuspendRecord() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.bSuspend) {
                this.bSuspend = true;
            }
            RecordThread recordThread = this;
            synchronized (recordThread) {
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ResumeRecord() {
        Object object = this.lockObject;
        synchronized (object) {
            block11: {
                if (this.bSuspend) {
                    RecordThread recordThread = this;
                    synchronized (recordThread) {
                        if (this.blockForStartAudioRecord(this.blockTimeout)) {
                            this.bSuspend = false;
                            this.notify();
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                            break block11;
                        }
                        if (this.mRoutineHandler != null) {
                            Message message = this.mRoutineHandler.obtainMessage(-2, 0, 0, null);
                            message.sendToTarget();
                        }
                        return false;
                    }
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Stop() {
        this.SuspendRecord();
        this.bExit = true;
        this.interrupt();
        RecordThread recordThread = this;
        synchronized (recordThread) {
        }
    }

    public short[] GetDataFromRecordQueue() {
        return this.recordQueue.decrease();
    }

    public void reset() {
        if (this.recordQueue != null) {
            this.recordQueue.clear();
        }
    }

    @Override
    public synchronized void start() {
        this.bExit = false;
        this.bSuspend = true;
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RecordThread recordThread = this;
        synchronized (recordThread) {
            block18: {
                super.run();
                try {
                    try {
                        this.init();
                        while (true) {
                            short[] sArray;
                            block16: {
                                if (this.bSuspend) {
                                    this.stopAudioRecord();
                                    if (this.recordQueue != null) {
                                        this.recordQueue.clear();
                                    }
                                    try {
                                        this.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        if (!this.bExit) break block16;
                                        sArray = null;
                                        break;
                                    }
                                }
                            }
                            if (this.bExit) {
                                sArray = null;
                                break;
                            }
                            int n2 = this.readSize;
                            int n3 = 0;
                            int n4 = 0;
                            sArray = new short[n2];
                            while ((n3 = this.audioRecord.read(sArray, n4, n2)) != -3 && n3 != -2 && n3 != 0) {
                                n4 += n3;
                                if ((n2 -= n3) > 0) continue;
                            }
                            if (n3 > 0) {
                                this.recordQueue.increase(sArray);
                                continue;
                            }
                            if (this.bSuspend || this.bExit) continue;
                            if (this.mRoutineHandler != null) {
                                Message message = this.mRoutineHandler.obtainMessage(-3, 0, 0, null);
                                message.sendToTarget();
                            }
                            this.releaseAudioRecord();
                            this.tryForStartAudioRecord();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.release();
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    this.release();
                    throw throwable;
                }
                this.release();
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void initForAudioRecord() {
        try {
            this.readSize = this.recordBufSize = AudioRecord.getMinBufferSize((int)this.m_sampleRate, (int)16, (int)2);
            this.audioRecord = new AudioRecord(this.audioSource, this.m_sampleRate, 16, 2, this.m_recordBufRate * this.recordBufSize);
        }
        catch (Exception exception) {
            Logger.shareInstance().writeLog(LOG_FILENAME, "RecordThread : initForAudioRecord exception :" + exception.toString());
            exception.printStackTrace();
        }
    }

    protected boolean startForAudioRecord() {
        block7: {
            block8: {
                if (this.audioRecord == null) break block7;
                if (this.audioRecord.getRecordingState() != 3) break block8;
                return true;
            }
            try {
                if (this.audioRecord.getState() == 1) {
                    this.audioRecord.startRecording();
                    if (this.audioRecord.getRecordingState() == 3) {
                        return true;
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                try {
                    Logger.shareInstance().writeLog(LOG_FILENAME, "startForAudioRecord start Exception:" + illegalStateException.toString());
                    illegalStateException.printStackTrace();
                }
                catch (Exception exception) {
                    Logger.shareInstance().writeLog(LOG_FILENAME, "RecordThread : startForAudioRecord exception :" + exception.toString());
                    exception.printStackTrace();
                }
            }
        }
        return false;
    }

    protected boolean tryForStartAudioRecord() {
        if (!this.startForAudioRecord()) {
            this.releaseAudioRecord();
            this.initForAudioRecord();
            return this.startForAudioRecord();
        }
        return true;
    }

    protected boolean blockForStartAudioRecord(long timeout) {
        if (this.startForAudioRecord()) {
            return true;
        }
        this.releaseAudioRecord();
        Date date = new Date();
        Date date2 = null;
        do {
            this.releaseAudioRecord();
            this.initForAudioRecord();
            if (this.startForAudioRecord()) {
                return true;
            }
            date2 = new Date();
            if (date2.getTime() - date.getTime() < timeout) continue;
            Logger.shareInstance().writeLog(LOG_FILENAME, "blockForStartAudioRecord Timeout :" + timeout);
            return false;
        } while (!this.bExit);
        return false;
    }

    protected void stopAudioRecord() {
        try {
            if (this.audioRecord != null && this.audioRecord.getState() != 1) {
                try {
                    this.audioRecord.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    Logger.shareInstance().writeLog(LOG_FILENAME, "audioRecord stop fail,state is wrong :" + illegalStateException.toString());
                    illegalStateException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            Logger.shareInstance().writeLog(LOG_FILENAME, "RecordThread : stopAudioRecord exception :" + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseAudioRecord() {
        Object object = this.audioLockObject;
        synchronized (object) {
            try {
                if (this.audioRecord != null) {
                    this.stopAudioRecord();
                    this.audioRecord.release();
                    this.audioRecord = null;
                }
            }
            catch (Exception exception) {
                Logger.shareInstance().writeLog(LOG_FILENAME, "RecordThread : releaseAudioRecord exception:" + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    protected void init() {
        Process.setThreadPriority((int)-16);
        this.initForAudioRecord();
    }

    protected void release() {
        this.releaseAudioRecord();
        if (this.recordQueue != null) {
            this.recordQueue.clear();
        }
    }
}

