/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.robert.comm.setting;

import android.os.Handler;
import com.landicorp.robert.comm.decode.Decode;
import com.landicorp.robert.comm.decode.SquareDecode;
import com.landicorp.robert.comm.encode.Encode;
import com.landicorp.robert.comm.encode.SineEncodeForProtocol;
import com.landicorp.robert.comm.encode.SquareEncodeForProtocol;
import com.landicorp.robert.comm.link.DecodeThread;
import com.landicorp.robert.comm.link.PlayThread;
import com.landicorp.robert.comm.link.PlayThreadEfficient;
import com.landicorp.robert.comm.setting.AudioCommParam;

public class CSetting {
    public static final int WAVE_SHAPE_SINE = 0;
    public static final int WAVE_SHAPE_SQUARE = 1;
    public static final int FRAME_LENGTH_MIN = 64;
    protected int waveShape = 1;
    protected int playBaudRate = 3675;
    protected int playSampleRate = 44100;
    protected float playVolume = 1.0f;
    protected int recordBaudRate = 3675;
    protected int recordSampleRate = 44100;
    protected int deviceOutputVoltage = 3300;
    protected int playBufRate = 1;
    protected int recordBufRate = 2;
    protected int frameMaxLength = 256;
    protected int recordSource = 1;
    protected Handler mRountineHandler = null;

    public CSetting() {
        this.initSetting(null);
    }

    public CSetting(AudioCommParam param) {
        this.initSetting(param);
    }

    public CSetting(CSetting setting) {
        this.deviceOutputVoltage = setting.deviceOutputVoltage;
        this.frameMaxLength = setting.frameMaxLength;
        this.mRountineHandler = setting.mRountineHandler;
        this.playBaudRate = setting.playBaudRate;
        this.playBufRate = setting.playBufRate;
        this.playSampleRate = setting.playSampleRate;
        this.playVolume = setting.playVolume;
        this.recordBaudRate = setting.recordBaudRate;
        this.recordSampleRate = setting.recordSampleRate;
        this.recordSource = setting.recordSource;
        this.recordBufRate = setting.recordBufRate;
        this.waveShape = setting.waveShape;
    }

    public int getPlaySampleRate() {
        return this.playSampleRate;
    }

    public int getRecordSampleRate() {
        return this.recordSampleRate;
    }

    public int getRecordBufRate() {
        return this.recordBufRate;
    }

    public int getPlayBufRate() {
        return this.playBufRate;
    }

    public int getRecordBaudRate() {
        return this.recordBaudRate;
    }

    public int getRecordSource() {
        return this.recordSource;
    }

    public int getPlayBaudRate() {
        return this.playBaudRate;
    }

    public int getWaveShape() {
        return this.waveShape;
    }

    public float getPlayVolume() {
        return this.playVolume;
    }

    public int getDeviceOuputVoltage() {
        return this.deviceOutputVoltage;
    }

    public int getFrameMaxLength() {
        return this.frameMaxLength;
    }

    public Handler getRoutineHandler() {
        return this.mRountineHandler;
    }

    public void setPlaySampleRate(int sampleRate) {
        this.playSampleRate = sampleRate;
    }

    public void setRecordSampleRate(int sampleRate) {
        this.recordSampleRate = sampleRate;
    }

    public void setRecordBufRate(int bufRate) {
        this.recordBufRate = bufRate;
    }

    public void setPlayBufRate(int bufRate) {
        this.playBufRate = bufRate;
    }

    public void setRecordBaudRate(int baudRate) {
        this.recordBaudRate = baudRate;
    }

    public void setRecordSource(int source) {
        this.recordSource = source;
    }

    public void setPlayBaudRate(int baudRate) {
        this.playBaudRate = baudRate;
    }

    public void setWaveShape(int shape) {
        this.waveShape = shape;
    }

    public void setPlayVolume(float volume) {
        this.playVolume = volume;
    }

    public void setDeviceOuputVoltage(int voltage) {
        this.deviceOutputVoltage = voltage;
    }

    public void setFrameMaxLength(int length) {
        this.frameMaxLength = length;
    }

    public void setRoutineHandler(Handler handler) {
        this.mRountineHandler = handler;
    }

    public Decode getDecode() {
        return new SquareDecode();
    }

    public Encode getEncode() {
        SquareEncodeForProtocol squareEncodeForProtocol = null;
        switch (this.getWaveShape()) {
            case 0: {
                squareEncodeForProtocol = new SineEncodeForProtocol(this);
                break;
            }
            default: {
                squareEncodeForProtocol = new SquareEncodeForProtocol(this);
            }
        }
        return squareEncodeForProtocol;
    }

    public PlayThread getPlayThread() {
        return new PlayThreadEfficient(this);
    }

    public DecodeThread getDecodeThread() {
        return new DecodeThread(this);
    }

    public void initSetting(AudioCommParam param) {
        if (param == null) {
            param = new AudioCommParam();
        }
        if (param.XCP_getFrameLength() < 64) {
            throw new IllegalArgumentException("CSetting : initSetting argument param's framelength is too small,it should be larger than 64");
        }
        this.setPlayBaudRate(param.XCP_getSendBaud());
        this.setRecordBaudRate(param.XCP_getRecvBaud());
        this.setPlayVolume(param.XCP_getSendVolume());
        this.setWaveShape(param.XCP_getWave());
        this.setDeviceOuputVoltage(param.XCP_getVoltage());
        this.setFrameMaxLength(param.XCP_getFrameLength());
        this.setRecordSource(param.XCP_getAudioSource());
        this.setPlaySampleRate(param.XCP_getPlaySampleFrequency());
        this.setRecordSampleRate(param.XCP_getRecordSampleFrequency());
        param = null;
    }

    public String toString() {
        String string = " setting: wave = " + this.waveShape + "; sendBaudrate = " + this.playBaudRate + "; sendVolume = " + this.playVolume + "; recvBaudrate = " + this.recordBaudRate + "; " + "; voltage = " + this.deviceOutputVoltage + "; AudioSource = " + this.recordSource + "; FrameLength = " + this.frameMaxLength + "; sendSampleRate = " + this.playSampleRate + "; recvSampleRate = " + this.recordSampleRate;
        return String.valueOf(super.toString()) + string;
    }
}

