/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.usb.manager;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.landicorp.usb.driver.usbDeviceDriver;
import com.landicorp.usb.manager.UsbCallback;
import com.landicorp.usb.parser.CommPackage;
import com.landicorp.usb.parser.ParserThread;
import java.util.Map;

public class UsbManagerAPI {
    private static String a = "1.1.3.1011";
    private static Context b = null;
    private static UsbManagerAPI c = null;
    private static usbDeviceDriver d = null;
    private ParserThread e = null;
    private boolean f = false;
    private UsbCallback g = null;

    public UsbManagerAPI(Context ctx) {
        b = ctx;
    }

    public static UsbManagerAPI getInstance(Context ctx) {
        Log.d((String)"UsbManager_API", (String)("getInstance(Context ctx) begin!Context=" + ctx));
        if (c == null) {
            Log.d((String)"UsbManager_API", (String)"mUsbManager=null, creat a new mUsbManager!");
            c = new UsbManagerAPI(ctx);
        } else if (ctx != b) {
            Log.d((String)"UsbManager_API", (String)"context is not equal last, refresh it!");
            b = ctx;
        }
        d = usbDeviceDriver.getInstance(ctx);
        return c;
    }

    public static String getLibVersion() {
        return a;
    }

    public synchronized Map<String, String> StartDiscovery() {
        return d.searchDevice();
    }

    public synchronized int openDevice(UsbCallback callback, ParserThread.UsbMode mode) {
        Log.d((String)"UsbManager_API", (String)"openDevice");
        if (this.f) {
            Log.d((String)"UsbManager_API", (String)"UsbManager has opened");
            return 0;
        }
        this.g = callback;
        this.e = new ParserThread(callback, mode);
        this.e.start();
        d.setParserThread(this.e);
        d.setCallback(callback);
        int n2 = d.openDeviceUSB();
        if (n2 != 0) {
            Log.d((String)"UsbManager_API", (String)("mUsbDeviceDriver.openDeviceUSB() failed,ret=" + n2));
            Message message = Message.obtain((Handler)this.e.getHandler(), (int)106);
            message.sendToTarget();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return n2;
        }
        this.f = true;
        Log.d((String)"UsbManager_API", (String)"UsbManager open successful");
        return n2;
    }

    public synchronized int closeDevice() {
        Log.d((String)"UsbManager_API", (String)"closeDevice");
        if (!this.f) {
            Log.d((String)"UsbManager_API", (String)"UsbManager not open");
            return 0;
        }
        int n2 = d.closeDeviceUSB();
        Message message = Message.obtain((Handler)this.e.getHandler(), (int)106);
        message.sendToTarget();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.f = false;
        return n2;
    }

    public synchronized int writeDevice(byte tlvType, int tlvLength, byte[] tlvData, int timeOut) {
        Log.d((String)"UsbManager_API", (String)"writeDevice");
        if (!this.f) {
            Log.d((String)"UsbManager_API", (String)"UsbManager not open");
            return -1;
        }
        byte[] byArray = new byte[tlvLength];
        int n2 = 0;
        while (n2 < tlvLength) {
            byArray[n2] = tlvData[n2];
            ++n2;
        }
        CommPackage commPackage = new CommPackage(byArray, tlvType);
        int n3 = this.writeDevice_hid(commPackage.getPackData(), timeOut);
        return n3;
    }

    public synchronized int writeDevice_hid(byte[] bData, int timeOut) {
        int n2;
        String string;
        byte[] byArray;
        Log.d((String)"UsbManager_API", (String)"writeDevice_HID");
        if (!this.f) {
            Log.d((String)"UsbManager_API", (String)"UsbManager not open");
            return -1;
        }
        int n3 = -1;
        int n4 = bData.length / 63;
        int n5 = bData.length % 63;
        int n6 = 0;
        while (n4 > 0) {
            byArray = new byte[64];
            byArray[0] = 63;
            System.arraycopy(bData, n6, byArray, 1, 63);
            n3 = d.writeDevice_sync(byArray, 64, timeOut);
            string = "";
            n2 = 0;
            while (n2 < byArray.length) {
                string = String.valueOf(string) + Integer.toHexString(byArray[n2] & 0xFF) + " ";
                ++n2;
            }
            Log.d((String)"UsbManager_API", (String)("send 63 byte:" + string));
            if (n3 <= 0) {
                Log.d((String)"UsbManager_API", (String)("send error:" + n3));
                return -2;
            }
            n6 += 63;
            --n4;
        }
        if (n5 > 0) {
            byArray = new byte[64];
            byArray[0] = (byte)n5;
            System.arraycopy(bData, n6, byArray, 1, n5);
            n3 = d.writeDevice_sync(byArray, 64, timeOut);
            string = "";
            n2 = 0;
            while (n2 < byArray.length) {
                string = String.valueOf(string) + Integer.toHexString(byArray[n2] & 0xFF) + " ";
                ++n2;
            }
            Log.d((String)"UsbManager_API", (String)("send " + n5 + " byte:" + string));
            if (n3 <= 0) {
                Log.d((String)"UsbManager_API", (String)("send error:" + n3));
                return -2;
            }
        }
        return 0;
    }
}

