/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.util;

public class ByteUtils {
    public static byte[] hexString2ByteArray(String hexStr) {
        if (hexStr == null) {
            return null;
        }
        if ((hexStr = hexStr.replaceAll(" ", "")).length() % 2 != 0) {
            return null;
        }
        byte[] byArray = new byte[hexStr.length() / 2];
        int n2 = 0;
        while (n2 < hexStr.length() / 2) {
            char c2 = hexStr.charAt(2 * n2);
            char c3 = hexStr.charAt(2 * n2 + 1);
            byte by = ByteUtils.hexChar2Byte(c2);
            byte by2 = ByteUtils.hexChar2Byte(c3);
            if (by < 0 || by2 < 0) {
                return null;
            }
            int n3 = by << 4;
            byArray[n2] = (byte)(n3 + by2);
            ++n2;
        }
        return byArray;
    }

    public static byte hexChar2Byte(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return (byte)(c2 - 48);
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return (byte)(c2 - 97 + 10);
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return (byte)(c2 - 65 + 10);
        }
        return -1;
    }

    public static String byteArray2HexString(byte[] arr) {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = arr;
        int n2 = arr.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray[n3];
            String string = Integer.toHexString(0xFF & by);
            if (string.length() < 2) {
                string = "0" + string;
            }
            stringBuilder.append(string);
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static String byteArray2HexStringWithSpace(byte[] arr) {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = arr;
        int n2 = arr.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray[n3];
            String string = Integer.toHexString(0xFF & by);
            if (string.length() < 2) {
                string = "0" + string;
            }
            stringBuilder.append(string);
            stringBuilder.append(" ");
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static byte[] getData(byte[] data, int start, int end) {
        byte[] byArray = new byte[end - start + 1];
        System.arraycopy(data, start, byArray, 0, byArray.length);
        return byArray;
    }

    public static String getBCDString(byte[] data, int start, int end) {
        byte[] byArray = new byte[end - start + 1];
        System.arraycopy(data, start, byArray, 0, byArray.length);
        return ByteUtils.byteArray2HexString(byArray);
    }

    public static String getHexString(byte[] data, int start, int end) {
        byte[] byArray = new byte[end - start + 1];
        System.arraycopy(data, start, byArray, 0, byArray.length);
        return ByteUtils.byteArray2HexString(byArray);
    }
}

