/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.text.SimpleDateFormat;

@TargetApi(value=9)
@SuppressLint(value={"NewApi"})
public final class Util {
    private static final char[] a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Util() {
    }

    public static boolean isNotBlank(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static byte[] toBytes(int a2) {
        return new byte[]{(byte)(0xFF & a2 >>> 24), (byte)(0xFF & a2 >>> 16), (byte)(0xFF & a2 >>> 8), (byte)(0xFF & a2)};
    }

    public static boolean testBit(byte data, int bit) {
        byte by = (byte)(1 << bit & 0xFF);
        return (data & by) == by;
    }

    public static int toInt(byte[] b2, int s, int n2) {
        int n3 = 0;
        int n4 = s + n2;
        int n5 = s;
        while (n5 < n4) {
            n3 <<= 8;
            n3 |= b2[n5] & 0xFF;
            ++n5;
        }
        return n3;
    }

    public static int toIntR(byte[] b2, int s, int n2) {
        int n3 = 0;
        int n4 = s;
        while (n4 >= 0 && n2 > 0) {
            n3 <<= 8;
            n3 |= b2[n4] & 0xFF;
            --n4;
            --n2;
        }
        return n3;
    }

    public static int toInt(byte ... b2) {
        int n2 = 0;
        byte[] byArray = b2;
        int n3 = b2.length;
        int n4 = 0;
        while (n4 < n3) {
            byte by = byArray[n4];
            n2 <<= 8;
            n2 |= by & 0xFF;
            ++n4;
        }
        return n2;
    }

    public static int toIntR(byte ... b2) {
        return Util.toIntR(b2, b2.length - 1, b2.length);
    }

    public static String toGBKString(byte[] data, int start, int length) {
        try {
            return new String(data, start, length, "GBK");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static String toBCDString(byte[] data) {
        return Util.toBCDString(data, 0, data.length);
    }

    public static byte[] StringtoBCD(String str) {
        str.length();
        if (str.contains(".")) {
            int n2 = str.indexOf(46);
            String string = String.valueOf(str.substring(0, n2)) + str.substring(n2 + 1, str.length());
            byte[] byArray = string.getBytes();
            int n3 = 0;
            n3 = byArray.length % 2 == 0 ? byArray.length / 2 : byArray.length / 2 + 1;
            byte[] byArray2 = new byte[n3];
            int n4 = 0;
            while (n4 < n3) {
                byArray2[n4] = byArray.length % 2 == 0 ? (byte)(byArray[n4 * 2] - 48 << 4 | byArray[n4 * 2 + 1] - 48) : (n4 == 0 ? (byte)(byArray[n4 * 2] - 48) : (byte)(byArray[n4 * 2 - 1] - 48 << 4 | byArray[n4 * 2] - 48));
                ++n4;
            }
            return byArray2;
        }
        byte[] byArray = str.getBytes();
        int n5 = 0;
        n5 = byArray.length % 2 == 0 ? byArray.length / 2 : byArray.length / 2 + 1;
        byte[] byArray3 = new byte[n5];
        int n6 = 0;
        while (n6 < n5) {
            byArray3[n6] = byArray.length % 2 == 0 ? (byte)(byArray[n6 * 2] - 48 << 4 | byArray[n6 * 2 + 1] - 48) : (n6 == 0 ? (byte)(byArray[n6 * 2] - 48) : (byte)(byArray[n6 * 2 - 1] - 48 << 4 | byArray[n6 * 2] - 48));
            ++n6;
        }
        return byArray3;
    }

    public static String toBCDString(byte[] data, int start, int length) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = start;
        while (n2 < start + length) {
            byte by = data[n2];
            char c2 = (char)((by >> 4 & 0xF) + 48);
            char c3 = (char)((by & 0xF) + 48);
            stringBuffer.append(c2);
            stringBuffer.append(c3);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String toGBKString(byte[] data) {
        try {
            return new String(data, 0, data.length, "GBK");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static String toHexString(byte ... d2) {
        return d2 == null || d2.length == 0 ? "" : Util.toHexString(d2, 0, d2.length);
    }

    public static String toHexString(byte[] d2, int s, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = s + n2;
        int n4 = 0;
        int n5 = s;
        while (n5 < n3) {
            byte by = d2[n5];
            cArray[n4++] = a[0xF & by >> 4];
            cArray[n4++] = a[0xF & by];
            ++n5;
        }
        return new String(cArray);
    }

    public static String toHexStringR(byte[] d2, int s, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        int n4 = s + n2 - 1;
        while (n4 >= s) {
            byte by = d2[n4];
            cArray[n3++] = a[0xF & by >> 4];
            cArray[n3++] = a[0xF & by];
            --n4;
        }
        return new String(cArray);
    }

    public static String ensureString(String str) {
        return str == null ? "" : str;
    }

    public static String toStringR(int n2) {
        StringBuilder stringBuilder = new StringBuilder(16).append('0');
        long l2 = 0xFFFFFFFFL & (long)n2;
        while (l2 != 0L) {
            stringBuilder.append((int)(l2 % 100L));
            l2 /= 100L;
        }
        return stringBuilder.toString();
    }

    public static int parseInt(String txt, int radix, int def) {
        int n2;
        try {
            n2 = Integer.valueOf(txt, radix);
        }
        catch (Exception exception) {
            n2 = def;
        }
        return n2;
    }

    public static int BCDtoInt(byte[] b2, int s, int n2) {
        int n3 = 0;
        int n4 = s + n2;
        int n5 = s;
        while (n5 < n4) {
            int n6 = b2[n5] >> 4 & 0xF;
            int n7 = b2[n5] & 0xF;
            if (n6 > 9 || n7 > 9) {
                return -1;
            }
            n3 = n3 * 100 + n6 * 10 + n7;
            ++n5;
        }
        return n3;
    }

    public static int BCDtoInt(byte ... b2) {
        return Util.BCDtoInt(b2, 0, b2.length);
    }

    public static String byte2string(byte[] data, Boolean hexFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        if (data == null) {
            return string;
        }
        if (hexFormat.booleanValue()) {
            int n2 = 0;
            while (n2 < data.length) {
                stringBuilder.append(String.valueOf(Integer.toHexString(data[n2] & 0xFF)) + " ");
                ++n2;
            }
            string = "0x" + new String(stringBuilder.toString());
        } else {
            string = new String(data, 0, data.length);
        }
        stringBuilder = null;
        return string;
    }

    public static String getFileMethodLine() {
        StackTraceElement stackTraceElement = new Exception().getStackTrace()[1];
        StringBuffer stringBuffer = new StringBuffer("[").append(stackTraceElement.getFileName()).append("|").append(stackTraceElement.getMethodName()).append("|").append(stackTraceElement.getLineNumber()).append("] ");
        return stringBuffer.toString();
    }

    public static String getMethodLine() {
        StackTraceElement stackTraceElement = new Exception().getStackTrace()[1];
        StringBuffer stringBuffer = new StringBuffer("[").append(stackTraceElement.getMethodName()).append("|").append(stackTraceElement.getLineNumber()).append("] ");
        return stringBuffer.toString();
    }

    public static String _FILE_() {
        StackTraceElement stackTraceElement = new Exception().getStackTrace()[1];
        return stackTraceElement.getFileName();
    }

    public static String _FUNC_() {
        StackTraceElement stackTraceElement = new Exception().getStackTrace()[1];
        return stackTraceElement.getMethodName();
    }

    public static int _LINE_() {
        StackTraceElement stackTraceElement = new Exception().getStackTrace()[1];
        return stackTraceElement.getLineNumber();
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String _TIME_() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return simpleDateFormat.format(date);
    }

    public static String getSDPath() {
        File file = null;
        boolean bl = Environment.getExternalStorageState().equals("mounted");
        if (bl) {
            file = Environment.getExternalStorageDirectory();
            Log.e((String)"landi_Util", (String)("sdCard path=" + file.toString()));
            Log.e((String)"landi_Util", (String)("DataDirectory path=" + Environment.getDataDirectory().toString()));
            Log.e((String)"landi_Util", (String)("RootDirectory path=" + Environment.getRootDirectory().toString()));
            Log.e((String)"landi_Util", (String)("DownloadCacheDirectory path=" + Environment.getDownloadCacheDirectory().toString()));
            return file.toString();
        }
        Log.e((String)"landi_Util", (String)"sdCard is not Exist");
        return null;
    }

    @TargetApi(value=9)
    @SuppressLint(value={"NewApi"})
    public static void saveDataToFile(byte[] data, String dirName, String fileName) {
        String string = Util.getSDPath();
        File file = new File(String.valueOf(string) + File.separator + dirName);
        File file2 = new File(String.valueOf(string) + File.separator + dirName + File.separator + fileName);
        if (!file.exists()) {
            Log.w((String)"landi_Util", (String)("dir=" + file.getAbsolutePath() + "/ not exist,creat it"));
            file.mkdirs();
            file.setReadable(true);
            file.setWritable(true);
        } else {
            Log.w((String)"landi_Util", (String)("dir=" + file.getAbsolutePath() + "/ exist"));
        }
        if (!file2.exists()) {
            Log.w((String)"landi_Util", (String)("file=" + file2.getAbsolutePath() + " not exist,creat it"));
            try {
                file2.createNewFile();
                file2.setReadable(true);
                file2.setWritable(true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Log.e((String)"landi_Util", (String)"File.createNewFile() failed!---IOException");
                return;
            }
        } else {
            Log.w((String)"landi_Util", (String)("file=" + file2.getAbsolutePath() + " exist"));
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            ((OutputStream)fileOutputStream).write(data);
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

