/*
 * Decompiled with CFR 0.152.
 */
package com.roam.roamreaderunifiedapi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.roam.roamreaderunifiedapi.BaseDeviceManager;
import com.roam.roamreaderunifiedapi.ConfigurationManager;
import com.roam.roamreaderunifiedapi.DeviceManager;
import com.roam.roamreaderunifiedapi.RoamReaderUnifiedAPI;
import com.roam.roamreaderunifiedapi.TransactionManager;
import com.roam.roamreaderunifiedapi.callback.AudioJackPairingListener;
import com.roam.roamreaderunifiedapi.callback.AudioJackPairingListenerWithDevice;
import com.roam.roamreaderunifiedapi.callback.CalibrationListener;
import com.roam.roamreaderunifiedapi.callback.DeviceResponseHandler;
import com.roam.roamreaderunifiedapi.callback.DeviceStatusHandler;
import com.roam.roamreaderunifiedapi.callback.DeviceStatusHandlerWithAudioJackDetection;
import com.roam.roamreaderunifiedapi.callback.ReleaseHandler;
import com.roam.roamreaderunifiedapi.callback.SearchListener;
import com.roam.roamreaderunifiedapi.callback.TurnOnDeviceCallback;
import com.roam.roamreaderunifiedapi.constants.CalibrationResult;
import com.roam.roamreaderunifiedapi.constants.CommunicationType;
import com.roam.roamreaderunifiedapi.constants.DeviceStatus;
import com.roam.roamreaderunifiedapi.constants.DeviceType;
import com.roam.roamreaderunifiedapi.constants.Parameter;
import com.roam.roamreaderunifiedapi.constants.ProgressMessage;
import com.roam.roamreaderunifiedapi.constants.ResponseCode;
import com.roam.roamreaderunifiedapi.data.CalibrationParameters;
import com.roam.roamreaderunifiedapi.data.ReaderVersionInfo;
import com.roam.roamreaderunifiedapi.emvreaders.LandiReader;
import com.roam.roamreaderunifiedapi.utils.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class AutoDetectDeviceManager
extends BaseDeviceManager {
    private static final String a = AutoDetectDeviceManager.class.getSimpleName();
    private Context b;
    private List<DeviceType> c;
    private DeviceManager d;
    private int e;
    private DeviceStatusHandler f;
    private a g;
    private boolean h;
    private boolean i;
    private boolean j;
    private b k;
    private CalibrationParameters l;

    public AutoDetectDeviceManager(List<DeviceType> preferredDeviceTypes) {
        LogUtils.write(a, "Construct AutoDetectDeviceManager");
        this.c = new ArrayList<DeviceType>(preferredDeviceTypes);
        this.g = new a();
        this.k = new b();
    }

    private void b() {
        if (this.e >= this.c.size()) {
            LogUtils.write(a, "End of the preferred device types list, stop detection");
            this.e();
            return;
        }
        LogUtils.write(a, "initialize(" + this.e + ")");
        this.d = RoamReaderUnifiedAPI.getDeviceManager(this.c.get(this.e));
        if (this.d != null) {
            LogUtils.write(a, "DM.init: " + this.d.getType().getDisplayName());
            if (this.l != null) {
                this.d.initialize(this.b, this.g, this.l);
            } else {
                this.d.initialize(this.b, this.g);
            }
        }
    }

    private boolean c() {
        if (null != this.d) {
            this.d.release(new ReleaseHandler(){

                @Override
                public void done() {
                    AutoDetectDeviceManager.this.d = null;
                    AutoDetectDeviceManager.this.h = false;
                    AutoDetectDeviceManager.this.b();
                }
            });
        }
        return true;
    }

    private void d() {
        if (this.f instanceof DeviceStatusHandlerWithAudioJackDetection && !this.i) {
            this.i = true;
            ((DeviceStatusHandlerWithAudioJackDetection)this.f).onDetectionStarted();
        }
    }

    private void e() {
        if (this.f instanceof DeviceStatusHandlerWithAudioJackDetection && this.i) {
            this.i = false;
            ((DeviceStatusHandlerWithAudioJackDetection)this.f).onDetectionStopped();
        }
    }

    @Override
    public boolean initialize(Context context, DeviceStatusHandler statusHandler) {
        if (null != this.b && this.j) {
            this.unregisterAudioJackListener(this.b, this.k);
        }
        this.b = context.getApplicationContext();
        this.f = statusHandler;
        this.registerAudioJackListener(this.b, this.k);
        this.j = true;
        return true;
    }

    @Override
    public boolean initialize(Context context, DeviceStatusHandler statusHandler, CalibrationParameters calibrationParams) {
        this.l = calibrationParams;
        return this.initialize(context, statusHandler);
    }

    @Override
    public boolean initialize(Context context, boolean noDelay, DeviceStatusHandler statusHandler) {
        return this.initialize(context, statusHandler);
    }

    @Override
    public ConfigurationManager getConfigurationManager() {
        if (this.d != null) {
            return this.d.getConfigurationManager();
        }
        return null;
    }

    @Override
    public DeviceStatus getStatus() {
        if (this.d != null) {
            return this.d.getStatus();
        }
        return null;
    }

    @Override
    public TransactionManager getTransactionManager() {
        if (this.d != null) {
            return this.d.getTransactionManager();
        }
        return null;
    }

    @Override
    public DeviceType getType() {
        if (this.d != null) {
            return this.d.getType();
        }
        return null;
    }

    @Override
    public boolean isReady() {
        if (this.d != null) {
            return this.d.isReady();
        }
        return false;
    }

    @Override
    public boolean release() {
        LogUtils.write(a, "release");
        this.l = null;
        this.unregisterAudioJackListener(this.b, this.k);
        if (null != this.d) {
            this.d.registerDeviceStatusHandler(null);
            this.d.release();
        }
        return true;
    }

    @Override
    public void release(ReleaseHandler releaseHandler) {
        LogUtils.write(a, "release with ReleaseHandler");
        this.l = null;
        this.unregisterAudioJackListener(this.b, this.k);
        if (this.d != null) {
            LogUtils.write(a, "release: doing like release() & calling currentDeviceManager.release()");
            this.d.registerDeviceStatusHandler(null);
            this.d.release(releaseHandler);
        } else {
            LogUtils.write(a, "release: NOT calling currentDeviceManager.release()");
            if (null != releaseHandler) {
                releaseHandler.done();
            }
        }
    }

    @Override
    public void requestPairing(AudioJackPairingListener pairListener) {
        if (this.d != null) {
            this.d.requestPairing(pairListener);
        }
    }

    @Override
    public void requestPairing(AudioJackPairingListenerWithDevice pairListener) {
        if (this.d != null) {
            this.d.requestPairing(pairListener);
        }
    }

    @Override
    public void confirmPairing(Boolean isMatching) {
        if (this.d != null) {
            this.d.confirmPairing(isMatching);
        }
    }

    @Override
    public void startCalibration(Context context, CalibrationListener listener) {
        listener.onComplete(CalibrationResult.Ignored, null);
    }

    @Override
    public void stopCalibration(Context context) {
    }

    @Override
    public void turnOnDeviceViaAudioJack(Context context, TurnOnDeviceCallback handler) {
        if (this.d != null) {
            this.d.turnOnDeviceViaAudioJack(context, handler);
        }
    }

    @Override
    public CommunicationType getActiveCommunicationType() {
        if (this.d != null) {
            return this.d.getActiveCommunicationType();
        }
        return CommunicationType.UNKNOWN;
    }

    @Override
    public void searchDevices(Context ctx, Boolean includeBondedDevices, Long durationInMilliseconds, SearchListener searchListener) {
        if (this.d != null) {
            this.d.searchDevices(ctx, includeBondedDevices, durationInMilliseconds, searchListener);
        }
    }

    @Override
    public void searchDevices(Context ctx, Boolean includeBondedDevices, SearchListener searchListener) {
        if (this.d != null) {
            this.d.searchDevices(ctx, includeBondedDevices, searchListener);
        }
    }

    @Override
    public void searchDevices(Context ctx, SearchListener searchListener) {
        this.searchDevices(ctx, true, searchListener);
    }

    @Override
    public void cancelSearch() {
        if (this.d != null) {
            this.d.cancelSearch();
        }
    }

    @Override
    public void registerDeviceStatusHandler(DeviceStatusHandler statusHandler) {
        this.f = statusHandler;
    }

    @Override
    public void enableFirmwareUpdateMode(DeviceResponseHandler deviceResponseHandler) {
        if (this.d != null) {
            this.d.enableFirmwareUpdateMode(deviceResponseHandler);
        }
    }

    @Override
    public void updateFirmware(String firmwareFilePath, DeviceResponseHandler handler) {
        if (this.d != null) {
            this.d.updateFirmware(firmwareFilePath, handler);
        }
    }

    @Override
    public void getBatteryStatus(DeviceResponseHandler handler) {
        if (this.d != null) {
            this.d.getBatteryStatus(handler);
        }
    }

    @Override
    public void getBatteryLevelWithChargingStatus(DeviceResponseHandler handler) {
        if (this.d != null) {
            this.d.getBatteryLevelWithChargingStatus(handler);
        }
    }

    @Override
    public void getDeviceStatistics(DeviceResponseHandler handler) {
        if (this.d != null) {
            this.d.getDeviceStatistics(handler);
        }
    }

    @Override
    public void searchDevices(Context ctx, Boolean includeBondedDevices, Long durationInMilliseconds, Short lowRssi, Short highRssi, SearchListener searchListener) {
        if (this.d != null) {
            this.d.searchDevices(ctx, includeBondedDevices, durationInMilliseconds, lowRssi, highRssi, searchListener);
        }
    }

    @Override
    public void stopInitialization() {
        if (this.d != null) {
            this.d.stopInitialization();
        }
    }

    @Override
    public void cancelFirmwareUpdate() {
        if (this.d != null) {
            this.d.cancelFirmwareUpdate();
        }
    }

    private final class com.roam.roamreaderunifiedapi.AutoDetectDeviceManager$a
    implements DeviceStatusHandler {
        private com.roam.roamreaderunifiedapi.AutoDetectDeviceManager$a() {
        }

        @Override
        public void onConnected() {
            LogUtils.write(a, "onConnected() " + this.b());
            if (AutoDetectDeviceManager.this.d instanceof LandiReader) {
                AutoDetectDeviceManager.this.d.getConfigurationManager().readVersion(new a());
            } else {
                this.a();
            }
        }

        private void a() {
            LogUtils.write(a, "onReallyConnected() " + this.b());
            if (AutoDetectDeviceManager.this.d != null) {
                AutoDetectDeviceManager.this.h = true;
                if (AutoDetectDeviceManager.this.f != null) {
                    AutoDetectDeviceManager.this.i = false;
                    AutoDetectDeviceManager.this.f.onConnected();
                }
            }
        }

        @Override
        public void onDisconnected() {
            LogUtils.write(a, "onDisconnected() " + this.b());
            if (AutoDetectDeviceManager.this.h) {
                AutoDetectDeviceManager.this.h = false;
                if (AutoDetectDeviceManager.this.f != null) {
                    AutoDetectDeviceManager.this.f.onDisconnected();
                }
                AutoDetectDeviceManager.this.c.add(0, AutoDetectDeviceManager.this.c.remove(AutoDetectDeviceManager.this.e));
                AutoDetectDeviceManager.this.e = 0;
            }
        }

        @Override
        public void onError(String message) {
            LogUtils.write(a, "onError() " + this.b());
            AutoDetectDeviceManager.this.e++;
            AutoDetectDeviceManager.this.c();
        }

        private String b() {
            return AutoDetectDeviceManager.this.d == null ? "null" : AutoDetectDeviceManager.this.d.getType().getDisplayName();
        }

        private final class a
        implements DeviceResponseHandler {
            private a() {
            }

            @Override
            public void onResponse(Map<Parameter, Object> data) {
                if (ResponseCode.Error != data.get((Object)Parameter.ResponseCode)) {
                    ReaderVersionInfo readerVersionInfo = (ReaderVersionInfo)data.get((Object)Parameter.ReaderVersionInfo);
                    if (readerVersionInfo != null) {
                        if (AutoDetectDeviceManager.this.d.getType().matchesHardwareType(readerVersionInfo.getHardwareType())) {
                            a.this.a();
                        } else if (AutoDetectDeviceManager.this.f != null) {
                            a.this.onError("Hardware Type Mismatch");
                        }
                    } else {
                        a.this.onError("ReadVersionInfo tag not in response");
                    }
                }
            }

            @Override
            public void onProgress(ProgressMessage message, String additionalMessage) {
            }
        }
    }

    private final class b
    extends BroadcastReceiver {
        private b() {
        }

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if ("android.intent.action.HEADSET_PLUG".equals(string)) {
                int n2 = intent.getIntExtra("state", -1);
                switch (n2) {
                    case 0: {
                        LogUtils.write(a, "Headset is unplugged");
                        AutoDetectDeviceManager.this.e();
                        break;
                    }
                    case 1: {
                        LogUtils.write(a, "Headset is plugged");
                        AutoDetectDeviceManager.this.d();
                        if (AutoDetectDeviceManager.this.e >= AutoDetectDeviceManager.this.c.size()) {
                            AutoDetectDeviceManager.this.e = 0;
                        }
                        AutoDetectDeviceManager.this.b();
                        break;
                    }
                }
            }
        }
    }
}

