/*
 * Decompiled with CFR 0.152.
 */
package com.roam.roamreaderunifiedapi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import com.roam.roamreaderunifiedapi.DeviceManager;
import com.roam.roamreaderunifiedapi.DisplayControl;
import com.roam.roamreaderunifiedapi.KeyPadControl;
import com.roam.roamreaderunifiedapi.RoamReaderUnifiedAPI;
import com.roam.roamreaderunifiedapi.callback.DeviceResponseHandler;
import com.roam.roamreaderunifiedapi.callback.DeviceStatusHandler;
import com.roam.roamreaderunifiedapi.callback.ProgressHandler;
import com.roam.roamreaderunifiedapi.constants.Command;
import com.roam.roamreaderunifiedapi.constants.DisplayTextCharset;
import com.roam.roamreaderunifiedapi.constants.ErrorCode;
import com.roam.roamreaderunifiedapi.constants.LanguageCode;
import com.roam.roamreaderunifiedapi.constants.Parameter;
import com.roam.roamreaderunifiedapi.constants.ProgressMessage;
import com.roam.roamreaderunifiedapi.constants.ResponseCode;
import com.roam.roamreaderunifiedapi.utils.LogUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

public abstract class BaseDeviceManager
implements DeviceManager {
    private static final String a = BaseDeviceManager.class.getSimpleName();
    private final List<ProgressHandler> b = new ArrayList<ProgressHandler>();
    protected boolean isInitialized;
    private DisplayControl c = new DisplayControl(){

        @Override
        public void enableBackLight(boolean enable, DeviceResponseHandler handler) {
            BaseDeviceManager.this.sendCommandNotSupportedError(Command.DisplayControl, handler);
        }

        @Override
        public void clearDisplay(DeviceResponseHandler handler) {
            BaseDeviceManager.this.sendCommandNotSupportedError(Command.DisplayControl, handler);
        }

        @Override
        public void writeText(Integer row, Integer column, DisplayTextCharset charset, String text, DeviceResponseHandler handler) {
            BaseDeviceManager.this.sendCommandNotSupportedError(Command.DisplayControl, handler);
        }
    };
    private KeyPadControl d = new KeyPadControl(){

        @Override
        public void promptPinTDESBlockWithEncryptedPAN(LanguageCode languageCode, String pinBlockFormat, String keyLocator, String cardLast4Digits, String macData, Boolean clearOnlyLastDigitEntered, Integer interDigitTimeout, DeviceResponseHandler handler) {
            BaseDeviceManager.this.sendCommandNotSupportedError(Command.KeyPadControl, handler);
        }

        @Override
        public void promptPinMasterSessionKeyWithEncryptedPAN(LanguageCode languageCode, String pinBlockFormat, String keyLocator, String cardLast4Digits, Boolean clearOnlyLastDigitEntered, Integer interDigitTimeout, DeviceResponseHandler handler) {
            BaseDeviceManager.this.sendCommandNotSupportedError(Command.KeyPadControl, handler);
        }

        @Override
        public void collectKeyedCardData(DeviceResponseHandler handler) {
            BaseDeviceManager.this.sendCommandNotSupportedError(Command.KeyPadControl, handler);
        }

        @Override
        public void collectZipCode(DeviceResponseHandler handler) {
            BaseDeviceManager.this.sendCommandNotSupportedError(Command.KeyPadControl, handler);
        }
    };

    protected EnumMap<Parameter, Object> createErrorResponseMap(Object command, ErrorCode errorCode) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        enumMap.put(Parameter.Command, command);
        enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
        enumMap.put(Parameter.ErrorCode, (Object)errorCode);
        return enumMap;
    }

    protected void notifyHandlerOfError(Object command, ErrorCode errorCode, DeviceResponseHandler handler) {
        if (null != handler) {
            handler.onResponse(this.createErrorResponseMap(command, errorCode));
        } else {
            LogUtils.write(BaseDeviceManager.class.getSimpleName(), "failed to notify handler of error:" + errorCode.toString() + " for cmd: " + command);
        }
    }

    protected void registerAudioJackListener(Context context, BroadcastReceiver broadcastReceiver) {
        if (null != context && null != broadcastReceiver) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.HEADSET_PLUG");
            intentFilter.addAction("android.media.AUDIO_BECOMING_NOISY");
            context.registerReceiver(broadcastReceiver, intentFilter);
        }
    }

    protected void unregisterAudioJackListener(Context context, BroadcastReceiver broadcastReceiver) {
        if (null != context && null != broadcastReceiver) {
            try {
                context.unregisterReceiver(broadcastReceiver);
            }
            catch (Exception exception) {
                LogUtils.write("unregisterAudioJackListener", exception);
            }
        }
    }

    protected boolean isUiThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    protected void postRunnableOnUiThread(Runnable work) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(work);
    }

    protected void sendCommandNotSupportedError(Command command, DeviceResponseHandler deviceResponseHandler) {
        this.notifyHandlerOfError((Object)command, ErrorCode.NOT_SUPPORTED_BY_READER, deviceResponseHandler);
    }

    @Override
    public void registerProgressHandler(ProgressHandler progressHandler) {
        if (!this.b.contains(progressHandler)) {
            this.b.add(progressHandler);
        }
    }

    @Override
    public void unregisterProgressHandler(ProgressHandler progressHandler) {
        if (this.b.contains(progressHandler)) {
            this.b.remove(progressHandler);
        }
    }

    private void a(ProgressMessage progressMessage, String string) {
        if (!this.b.isEmpty()) {
            for (ProgressHandler progressHandler : this.b) {
                progressHandler.onProgress(progressMessage, string);
            }
        }
    }

    protected void postDeviceStatusOnStatusHandler(DeviceStatusHandler statusHandler, boolean connected, String errorMessage) {
        if (connected) {
            statusHandler.onConnected();
        } else {
            statusHandler.onDisconnected();
        }
        if (null != errorMessage) {
            statusHandler.onError(errorMessage);
        }
    }

    protected void postDeviceStatusOnUiThread(final DeviceStatusHandler statusHandler, final boolean connected, final String errorMessage) {
        if (null == statusHandler) {
            LogUtils.write(a, "null status handler cannot post status::" + connected + "::error::" + errorMessage);
            return;
        }
        if (RoamReaderUnifiedAPI.postResponseOnUIThread().booleanValue() && !this.isUiThread()) {
            this.postRunnableOnUiThread(new Runnable(){

                @Override
                public void run() {
                    BaseDeviceManager.this.postDeviceStatusOnStatusHandler(statusHandler, connected, errorMessage);
                }
            });
        } else {
            this.postDeviceStatusOnStatusHandler(statusHandler, connected, errorMessage);
        }
    }

    protected void postResponseOnUiThread(final DeviceResponseHandler responseHandler, final EnumMap<Parameter, Object> responseData) {
        if (null == responseHandler) {
            return;
        }
        if (!this.isInitialized) {
            return;
        }
        if (RoamReaderUnifiedAPI.postResponseOnUIThread().booleanValue() && !this.isUiThread()) {
            this.postRunnableOnUiThread(new Runnable(){

                @Override
                public void run() {
                    responseHandler.onResponse(responseData);
                }
            });
        } else {
            responseHandler.onResponse(responseData);
        }
    }

    protected void postProgressOnUiThread(final DeviceResponseHandler responseHandler, final ProgressMessage progressMessage, final String additionalMessage) {
        if (!this.isInitialized) {
            return;
        }
        if (RoamReaderUnifiedAPI.postResponseOnUIThread().booleanValue() && !this.isUiThread()) {
            this.postRunnableOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (responseHandler != null) {
                        responseHandler.onProgress(progressMessage, additionalMessage);
                    }
                    BaseDeviceManager.this.a(progressMessage, additionalMessage);
                }
            });
        } else {
            if (responseHandler != null) {
                responseHandler.onProgress(progressMessage, additionalMessage);
            }
            this.a(progressMessage, additionalMessage);
        }
    }

    protected DisplayControl getNotSupportedDisplayControl() {
        return this.c;
    }

    protected KeyPadControl getNotSupportedKeyPadControl() {
        return this.d;
    }
}

