/*
 * Decompiled with CFR 0.152.
 */
package com.roam.roamreaderunifiedapi;

import android.annotation.SuppressLint;
import android.os.AsyncTask;
import android.util.Log;
import com.landicorp.uns.unsUtil;
import com.roam.roamreaderunifiedapi.AutoDetectDeviceManager;
import com.roam.roamreaderunifiedapi.DeviceManager;
import com.roam.roamreaderunifiedapi.callback.RepackageUnsFileCallback;
import com.roam.roamreaderunifiedapi.constants.DeviceType;
import com.roam.roamreaderunifiedapi.data.FileVersionInfo;
import com.roam.roamreaderunifiedapi.data.ReaderVersionInfo;
import com.roam.roamreaderunifiedapi.emvreaders.MOBY3000DeviceManager;
import com.roam.roamreaderunifiedapi.emvreaders.MOBY8500DeviceManager;
import com.roam.roamreaderunifiedapi.emvreaders.RP350XDeviceManager;
import com.roam.roamreaderunifiedapi.emvreaders.RP450cDeviceManager;
import com.roam.roamreaderunifiedapi.emvreaders.RP45BTDeviceManager;
import com.roam.roamreaderunifiedapi.emvreaders.RP45USBDeviceManager;
import com.roam.roamreaderunifiedapi.emvreaders.RP750XDeviceManager;
import com.roam.roamreaderunifiedapi.magstripereaders.G4XDeviceManager;
import com.roam.roamreaderunifiedapi.utils.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class RoamReaderUnifiedAPI {
    private static final List<DeviceType> a = new ArrayList<DeviceType>();
    private static Boolean b;

    private RoamReaderUnifiedAPI() {
    }

    public static Boolean postResponseOnUIThread() {
        return b;
    }

    public static void setPostResponseOnUIThread(Boolean postResponseOnUIThread) {
        b = postResponseOnUIThread;
    }

    public static List<DeviceType> getSupportedDevices() {
        return a;
    }

    public static DeviceManager getDeviceManager(DeviceType type) {
        LogUtils.write("RoamReaderUnifiedAPI", "API version::1.7.2.3");
        if (type == null) {
            return null;
        }
        switch (type) {
            case G4x: {
                return G4XDeviceManager.getInstance();
            }
            case RP350x: {
                return RP350XDeviceManager.getInstance();
            }
            case RP450c: {
                return RP450cDeviceManager.getInstance();
            }
            case RP750x: {
                return RP750XDeviceManager.getInstance();
            }
            case MOBY3000: {
                return MOBY3000DeviceManager.getInstance();
            }
            case RP45BT: {
                return RP45BTDeviceManager.getInstance();
            }
            case MOBY8500: {
                return MOBY8500DeviceManager.getInstance();
            }
            case RP45USB: {
                return RP45USBDeviceManager.getInstance();
            }
        }
        return null;
    }

    public static DeviceManager getDeviceManager(List<DeviceType> types) {
        return types == null || types.size() == 0 ? null : new AutoDetectDeviceManager(types);
    }

    public static void setProductionMode(Boolean enable) {
        LogUtils.setProductionMode(enable);
    }

    public static void enableDebugLogging(Boolean enable) {
        LogUtils.enableLogging(enable);
    }

    public static String getApiVersion() {
        return "1.7.2.3";
    }

    public static List<FileVersionInfo> getUnsFileVersionInfo(String filePath) {
        unsUtil unsUtil2 = new unsUtil();
        int n2 = unsUtil2.unsUtil_GetSubFileCount(filePath);
        if (n2 < 0) {
            n2 = 0;
        }
        ArrayList<FileVersionInfo> arrayList = new ArrayList<FileVersionInfo>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            FileVersionInfo fileVersionInfo = FileVersionInfo.newInstance(unsUtil2.unsUtil_GetSubFileVersionInfo(filePath, i2));
            if (fileVersionInfo == null) continue;
            arrayList.add(fileVersionInfo);
        }
        return arrayList;
    }

    public static boolean isValidUnsFile(String filePath) {
        if (filePath != null) {
            return new unsUtil().unsUtil_CheckValid(filePath) == 0;
        }
        return false;
    }

    public static void repackageUnsFile(String fromFilePath, String toFilePath, ReaderVersionInfo readerVersionInfo, RepackageUnsFileCallback callback) {
        if (null == callback) {
            LogUtils.write("REPACKAGE_UNS", "RepackageUnsFileCallback cannot be null");
            return;
        }
        new a(fromFilePath, toFilePath, readerVersionInfo, callback).a();
    }

    private static boolean b(FileVersionInfo fileVersionInfo, ReaderVersionInfo readerVersionInfo) {
        String string;
        switch (string = fileVersionInfo.fileType.trim()) {
            case "BOOT": {
                return fileVersionInfo.compareWith(readerVersionInfo.getBootFileVersion()) == 0;
            }
            case "CTRL": {
                return fileVersionInfo.compareWith(readerVersionInfo.getControlFileVersion()) == 0;
            }
            case "USER": {
                return fileVersionInfo.compareWith(readerVersionInfo.getUserFileVersions().get(0)) == 0;
            }
        }
        for (FileVersionInfo fileVersionInfo2 : readerVersionInfo.getParameterFileVersions()) {
            if (!fileVersionInfo2.fileType.trim().equals(string)) continue;
            return fileVersionInfo.compareWith(fileVersionInfo2) == 0;
        }
        return false;
    }

    static {
        a.add(DeviceType.G4x);
        a.add(DeviceType.MOBY3000);
        a.add(DeviceType.RP350x);
        a.add(DeviceType.RP450c);
        a.add(DeviceType.RP750x);
        a.add(DeviceType.RP45BT);
        a.add(DeviceType.MOBY8500);
        a.add(DeviceType.RP45USB);
        b = true;
    }

    private static class a
    extends AsyncTask<Void, Void, Boolean> {
        final String a;
        final String b;
        final ReaderVersionInfo c;
        RepackageUnsFileCallback d;

        public a(String string, String string2, ReaderVersionInfo readerVersionInfo, RepackageUnsFileCallback repackageUnsFileCallback) {
            this.a = string;
            this.b = string2;
            this.c = readerVersionInfo;
            this.d = repackageUnsFileCallback;
        }

        protected Boolean a(Void ... voidArray) {
            try {
                Object object;
                int n2;
                FileInputStream fileInputStream = new FileInputStream(this.a);
                int n3 = fileInputStream.available();
                byte[] byArray = new byte[n3];
                int n4 = fileInputStream.read(byArray);
                fileInputStream.close();
                if (n4 != n3) {
                    Log.e((String)"REPACKAGE_UNS", (String)("File from filePath::" + this.a + " was not completely read!"));
                    return false;
                }
                unsUtil unsUtil2 = new unsUtil();
                int n5 = unsUtil2.unsUtil_GetSubFileCount(byArray, n3);
                long l2 = 0L;
                for (n2 = 0; n2 < n5; ++n2) {
                    object = FileVersionInfo.newInstance(unsUtil2.unsUtil_GetSubFileVersionInfo(byArray, n3, n2));
                    if (RoamReaderUnifiedAPI.b((FileVersionInfo)object, this.c)) continue;
                    Log.d((String)"REPACKAGE_UNS", (String)("Added file type::" + ((FileVersionInfo)object).fileType.trim()));
                    l2 = unsUtil2.unsUtil_UNSFileRuleIndexSetAdd(l2, n2);
                }
                if (l2 == 0L) {
                    Log.e((String)"REPACKAGE_UNS", (String)"No delta detected");
                    return false;
                }
                n2 = unsUtil2.unsUtil_CreateNewUNSFileFromOtherOne(byArray, n3, null, 0, l2);
                if (n2 < 0) {
                    Log.e((String)"REPACKAGE_UNS", (String)"Invalid repackaged file size");
                    return false;
                }
                object = new byte[n2];
                unsUtil2.unsUtil_CreateNewUNSFileFromOtherOne(byArray, n3, (byte[])object, n2, l2);
                unsUtil2.unsUtil_UNSFileRuleIndexSetRelease(l2);
                File file = new File(this.b);
                file.createNewFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write((byte[])object, 0, ((Object)object).length);
                fileOutputStream.close();
                return true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }

        protected void a(Boolean bl) {
            this.d.done(bl);
            this.d = null;
        }

        @SuppressLint(value={"NewApi"})
        public void a() {
            this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((Boolean)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Void[])objectArray);
        }
    }
}

