/*
 * Decompiled with CFR 0.152.
 */
package com.roam.roamreaderunifiedapi.constants;

import java.util.Locale;

public enum DeviceType {
    G4x("G4x/G5x", new String[0]),
    RP350x("RP3xx", "RP35"),
    RP750x("RP7xx", "RP75"),
    UNKNOWN("Unknown", new String[0]),
    RP450c("RP4xx", "RP45"),
    MOBY3000("MOBY3000", "MOBY-3000"),
    RP45BT("RP45BT", new String[0]),
    MOBY8500("MOBY8500", "MOBY-8500"),
    RP45USB("RP45USB", new String[0]);

    private String a;
    private String[] b;

    private DeviceType(String displayName, String ... hardwareMatchingStrings) {
        this.a = displayName;
        this.b = new String[hardwareMatchingStrings.length];
        for (int i2 = hardwareMatchingStrings.length - 1; i2 >= 0; --i2) {
            this.b[i2] = hardwareMatchingStrings[i2].toUpperCase(Locale.US);
        }
    }

    public String getDisplayName() {
        return this.a;
    }

    public boolean matchesHardwareType(String hardwareType) {
        if (hardwareType != null && (hardwareType = hardwareType.toUpperCase(Locale.US)) != null) {
            for (String string : this.b) {
                if (!hardwareType.contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static DeviceType getEnum(String deviceType) {
        try {
            return DeviceType.valueOf(deviceType);
        }
        catch (Exception exception) {
            return UNKNOWN;
        }
    }
}

