/*
 * Decompiled with CFR 0.152.
 */
package com.roam.roamreaderunifiedapi.constants;

import com.roam.roamreaderunifiedapi.utils.LogUtils;

public enum ErrorCode {
    FailedToDecodeAudioWaveform(3),
    NotEnoughMemory(4),
    ReaderTimeout(5),
    ByteFormatError(6),
    FrameFormatError(7),
    UnknownError(8),
    AudioTrackWriteDataError(9),
    AudioRecordReadDataError(16),
    ExchangeStateError(17),
    InvalidCommandResponse(18),
    CommandCancelFailedUponReceiptOfACancelWaitCommand(13),
    NOT_SUPPORTED_BY_READER(39169),
    MISSING_MANDATORY_PARAMETERS(39170),
    ERROR_READING_KSN(39171),
    ERROR_READING_VERSION(39172),
    G4X_FAILED_TO_GET_KSN(39184),
    G4X_DECODE_SWIPE_FAIL(39185),
    G4X_DECODE_TAP_FAIL(39186),
    G4X_DECODE_CRC_ERROR(39187),
    G4X_DECODE_COMM_ERROR(39188),
    G4X_DECODE_CARD_NOT_SUPPORTED(39189),
    G4x_DECODE_UNKNOWN_ERROR(39190),
    ReaderInterrupted(39191),
    ReaderGeneralError(39192),
    ReaderNotInitialized(39201),
    CardReaderNotConnected(39193),
    InvalidTransmittedDataLength(36354),
    InstructionNotSupportedByThisReader(36356),
    InvalidParameters(36357),
    CommandNotValidAtThisPoint(36361),
    TimeoutExpired(36362),
    CommandCancelledUponReceiptOfACancelWaitCommand(36363),
    CardReaderGeneralError(36481),
    CardInterfaceGeneralError(36486),
    BackgroundMagneticCardReadingIsInTheWrongStateForTheCommandThatWasIssued(36364),
    NoBackgroundMagneticCardDataAvailable(36365),
    MandatoryEMVTLVDataMissing(49408),
    StorageFull(49409),
    NonEMVCardOrCardError(49410),
    NoMutuallySupportedAIDs(49411),
    AIDNotInListOfMutuallySupportedAIDs(49412),
    DOLNotConfigured(49413),
    RSAKeyNotFound(49414),
    NoRSAKeysAvailable(49415),
    DuplicateRSAKey(49416),
    DuplicateAID(49417),
    ApplicationBlocked(49418),
    CardBlocked(49419),
    ExceededAllowedCardInsertions(49420),
    NonCertifiedEMVKernelConfiguration(49421),
    RevertedContactlessTransactionHasFailedButMayBeAttemptedOverAContactInterface(49540),
    ICCHasBeenInsertedButInsertionWasDisabled(49541),
    ContactlessNotPermitted(49542),
    ContactlessApplicationError(49543),
    ExternalDeviceShouldUpdateTheDisplayAndRestartContactlessProcessing(49544),
    ErrorsExistInTheRiskParameterRecordsSubmittedUsingTagDF6B(49545),
    RevertedContactlessTransactionHasFailedAndMayBeAttemptedUsingContactICCOnlyButPINPadICCProcessingIsNotEnabled(49546),
    BatteryTooLowError(49568),
    CardExpired(36496),
    CardNotYetValid(36497),
    InvalidTrackData(36498),
    CommandNotValidAtThisPointE2E(36499),
    FleetCardPINVerificationFailed(36609),
    FleetCardEncryptionKeyNotAvailable(36610),
    TDESDUKPTKeyNotFound(36611),
    TDESDUKPTPINEncryptionORMACCalculationFailed(36612),
    TDESDUKPTKeyInjectionFailed(36613),
    TDESDUKPTPINChangeFailedToCompleteSuccessfully(36614),
    SecureAreaAlreadyExists(36615),
    MasterOrSessionKeyNotFound(36618),
    MasterOrSessionPINEncryptionFailed(36619),
    MasterOrSessionKCVDoesnotMatch(36620),
    SHA1ChecksumDoesnotMatch(36621),
    SHA1CalculationFailed(36622),
    PANDecryptionFailed(36624),
    TRACK_READ_ERROR(39200),
    PIN_PAD_FAILURE(36352),
    PIN_ENTRY_ABORTED(65535),
    NO_SSAHANDLE(49537),
    TIMEOUT_SSAHANDLE(49536),
    PIN_VERIFICATION_FAILED(25551),
    PIN_TRY_LIMIT_EXCEEDED1(27011),
    PIN_TRY_LIMIT_EXCEEDED2(27012),
    PIN_ENTRY_CANCELLED(36363),
    StopContactlessInterface(27014),
    P2PEncryptionError(36514),
    DOWNLOAD_ERROR_NOT_SURPPORT_FILE_TYPE(-1),
    DOWNLOAD_ERROR_NOT_SURPPORT_FILE_TYPE_IN_UNS(-2),
    DOWNLOAD_ERROR_HANDSHAKE_FAILED(-3),
    DOWNLOAD_ERROR_FILEPATH_WRONG(-4),
    DOWNLOAD_ERROR_FILE_OPERATE_FAILED(-5),
    DOWNLOAD_ERROR_DEVICE_NOT_OPEN(-6),
    DOWNLOAD_ERROR_IS_DOWNLOADING_STATE(-7),
    DOWNLOAD_ERROR_NO_RESPOND_ACK(-8),
    DOWNLOAD_ERROR_WRONG_FRAM(-9),
    DOWNLOAD_ERROR_EXCHANGE_ERROR_STATE(-10),
    DOWNLOAD_ERROR_BLUETOOTH_DISCONNECTED(-11),
    DOWNLOAD_ERROR_HANDSHAKE_TIMEOUT(-12),
    DOWNLOAD_ERROR_UNS_FILE_CRC_ERROR(-13),
    DOWNLOAD_ERROR_SUSPEND_OK(-14),
    DOWNLOAD_ERROR_SUSPEND_FAILED(-15),
    DOWNLOAD_ERROR_UNKNOWN_ERROR(-100),
    RkiModeNotEnabled(-200),
    TriggerRkiFailed(-201),
    CertificateFilesVersionInfoNotAvailable(-202),
    PIN_BY_PASS(-203),
    VasBadValue(-204),
    VasBadLength(-205),
    VasParameterNotSet(-206),
    VasMaxMerchantLimitReached(-207),
    CardReaderBusy(-208);

    private long a;

    private ErrorCode(int value) {
        this.a = value;
    }

    public long getErrorCodeValue() {
        return this.a;
    }

    public static ErrorCode getEnum(long value) {
        for (ErrorCode errorCode : ErrorCode.values()) {
            if (errorCode.getErrorCodeValue() != value) continue;
            return errorCode;
        }
        LogUtils.write(ErrorCode.class.getSimpleName(), "ErrorCode not found for value::" + value);
        return CardReaderGeneralError;
    }

    public static ErrorCode getEnum(String value) {
        if (value != null) {
            long l2 = Long.parseLong(value, 16);
            for (ErrorCode errorCode : ErrorCode.values()) {
                if (errorCode.getErrorCodeValue() != l2) continue;
                return errorCode;
            }
        }
        return UnknownError;
    }

    public String getValue() {
        if (this.a > 255L) {
            return String.format("%04X", this.a);
        }
        return String.format("%02X", this.a);
    }
}

