/*
 * Decompiled with CFR 0.152.
 */
package com.roam.roamreaderunifiedapi.data;

import android.bluetooth.BluetoothDevice;
import android.hardware.usb.UsbDevice;
import com.roam.roamreaderunifiedapi.constants.CommunicationType;
import com.roam.roamreaderunifiedapi.constants.DeviceType;
import com.roam.roamreaderunifiedapi.constants.Parameter;
import java.io.Serializable;
import java.util.EnumMap;

public final class Device
implements Serializable {
    private DeviceType a;
    private CommunicationType b;
    private String c;
    private String d;
    private EnumMap e;

    public Device(DeviceType deviceType, CommunicationType communicationType, String name, String identifier) {
        this.a = deviceType;
        this.b = communicationType;
        this.c = name;
        this.d = identifier;
        this.e = new EnumMap(Parameter.class);
    }

    public Device(DeviceType deviceType, CommunicationType communicationType, String name, String identifier, EnumMap deviceInfo) {
        this(deviceType, communicationType, name, identifier);
        this.e = deviceInfo;
    }

    public static Device newUsbDeviceInstance(DeviceType deviceType, UsbDevice usbDevice) {
        EnumMap<Parameter, UsbDevice> enumMap = new EnumMap<Parameter, UsbDevice>(Parameter.class);
        enumMap.put(Parameter.UsbDeviceInfo, usbDevice);
        return new Device(deviceType, CommunicationType.Usb, usbDevice.getDeviceName(), Integer.toString(usbDevice.getDeviceId()), enumMap);
    }

    public static Device newBluetoothDeviceInstance(DeviceType deviceType, int rssi, BluetoothDevice bluetoothDevice) {
        EnumMap<Parameter, Integer> enumMap = new EnumMap<Parameter, Integer>(Parameter.class);
        enumMap.put(Parameter.BluetoothDeviceRssi, rssi);
        return new Device(deviceType, CommunicationType.Bluetooth, bluetoothDevice.getName(), bluetoothDevice.getAddress(), enumMap);
    }

    public static Device newAudioJackDeviceInstance(DeviceType deviceType) {
        return new Device(deviceType, CommunicationType.AudioJack, "AUDIOJACK", "AUDIOJACK");
    }

    public DeviceType getDeviceType() {
        return this.a;
    }

    public CommunicationType getConnectionType() {
        return this.b;
    }

    public String getName() {
        return this.c;
    }

    public String getIdentifier() {
        return this.d;
    }

    public EnumMap getDeviceInfo() {
        return this.e;
    }

    @Deprecated
    public void setName(String name) {
        this.c = name;
    }

    @Deprecated
    public void setIdentifier(String identifier) {
        this.d = identifier;
    }

    @Deprecated
    public void setDeviceType(DeviceType mDeviceType) {
        this.a = mDeviceType;
    }

    public String toString() {
        return (Object)((Object)this.getDeviceType()) + ": " + this.getName() + "\n(" + this.getIdentifier() + ") " + (Object)((Object)this.getConnectionType()) + (this.getConnectionType() == CommunicationType.Bluetooth ? " - RSSI(" + this.getDeviceInfo().get((Object)Parameter.BluetoothDeviceRssi) + ")\n" : "\n");
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.b == null ? 0 : this.b.hashCode());
        n3 = 31 * n3 + (this.a == null ? 0 : this.a.hashCode());
        n3 = 31 * n3 + (this.d == null ? 0 : this.d.hashCode());
        n3 = 31 * n3 + (this.c == null ? 0 : this.c.hashCode());
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Device device = (Device)obj;
        if (this.b != device.b) {
            return false;
        }
        if (this.a != device.a) {
            return false;
        }
        if (this.d == null ? device.d != null : !this.d.equals(device.d)) {
            return false;
        }
        return !(this.c == null ? device.c != null : !this.c.equals(device.c));
    }
}

