/*
 * Decompiled with CFR 0.152.
 */
package com.roam.roamreaderunifiedapi.data;

import com.landicorp.uns.FILE_VersionInfo;
import com.roam.roamreaderunifiedapi.utils.LogUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

public final class FileVersionInfo
implements Serializable {
    private static final String a = FileVersionInfo.class.getSimpleName();
    public static final String UNSPECIFIED_VALUE = "";
    public static final String PLATFORM = "platform";
    public static final String SUBPLATFORM = "subplatform";
    public static final String FILE_TYPE = "file_type";
    public static final String FILE_LEVEL = "file_level";
    public static final String YEAR = "year";
    public static final String MONTH = "month";
    public static final String DAY = "day";
    public static final String VERSION = "version";
    public static final String VERSION_FLAG = "verflag";
    public static final String MAINTAINER_ID = "maintainer_id";
    public static final String DEPEND_VERSION = "depend_ver";
    public static final String FILE_SN = "file_sn";
    public static final String CUSTOMER_ID = "customer_id";
    public static final String COMPATIBILITY_MATRIX = "compatibility_matrix";
    public final String platform;
    public final String subPlatform;
    public final String fileType;
    public final String fileLevel;
    public final String year;
    public final String month;
    public final String day;
    public final String version;
    public final String verFlag;
    public final String maintainerId;
    public final String dependVer;
    public final String fileSN;
    public final String customerId;
    public final String compatibilityMatrix;

    public static FileVersionInfo newInstance(FILE_VersionInfo info) {
        return info == null ? null : new FileVersionInfo(info);
    }

    private FileVersionInfo(FILE_VersionInfo info) {
        this.platform = this.a(info.ucPlatform);
        this.subPlatform = this.a(info.ucSubPlatform);
        this.fileType = this.a(info.ucFileType);
        this.fileLevel = this.a(info.ucFileLevel);
        this.year = this.a(info.Year);
        this.month = this.a(info.Month);
        this.day = this.a(info.Day);
        this.version = this.a(info.ucVersion);
        this.verFlag = this.a(info.ucVerFlag);
        this.maintainerId = this.a(info.ucMaintainerID);
        this.dependVer = this.a(info.ucDependVer);
        this.fileSN = this.a(info.ucFileSN);
        this.customerId = UNSPECIFIED_VALUE;
        this.compatibilityMatrix = UNSPECIFIED_VALUE;
    }

    public static FileVersionInfo newInstance(String infoFromReadVersion) {
        return FileVersionInfo.a(infoFromReadVersion) ? new FileVersionInfo(infoFromReadVersion) : null;
    }

    private FileVersionInfo(String infoFromReadVersion) {
        LogUtils.write("READERVERSIONINFO", infoFromReadVersion);
        this.platform = infoFromReadVersion.substring(0, 5);
        this.subPlatform = infoFromReadVersion.substring(6, 10);
        this.fileType = infoFromReadVersion.substring(11, 16);
        this.customerId = infoFromReadVersion.substring(16, 20);
        this.fileLevel = infoFromReadVersion.substring(21, 22);
        this.fileSN = infoFromReadVersion.substring(23, 26);
        switch (this.fileLevel) {
            case "F": 
            case "B": {
                this.version = infoFromReadVersion.substring(32, 36);
                this.compatibilityMatrix = infoFromReadVersion.substring(37, 41);
                this.verFlag = infoFromReadVersion.substring(42, 44);
                this.year = UNSPECIFIED_VALUE;
                this.month = UNSPECIFIED_VALUE;
                this.day = UNSPECIFIED_VALUE;
                this.maintainerId = UNSPECIFIED_VALUE;
                this.dependVer = UNSPECIFIED_VALUE;
                break;
            }
            case "P": {
                this.version = infoFromReadVersion.substring(32, 36);
                this.verFlag = infoFromReadVersion.substring(37, 39);
                this.compatibilityMatrix = UNSPECIFIED_VALUE;
                this.year = UNSPECIFIED_VALUE;
                this.month = UNSPECIFIED_VALUE;
                this.day = UNSPECIFIED_VALUE;
                this.maintainerId = UNSPECIFIED_VALUE;
                this.dependVer = UNSPECIFIED_VALUE;
                break;
            }
            case "D": {
                this.version = UNSPECIFIED_VALUE;
                this.verFlag = UNSPECIFIED_VALUE;
                this.compatibilityMatrix = UNSPECIFIED_VALUE;
                this.year = UNSPECIFIED_VALUE;
                this.month = UNSPECIFIED_VALUE;
                this.day = UNSPECIFIED_VALUE;
                this.maintainerId = UNSPECIFIED_VALUE;
                this.dependVer = UNSPECIFIED_VALUE;
                break;
            }
            default: {
                this.version = UNSPECIFIED_VALUE;
                this.verFlag = UNSPECIFIED_VALUE;
                this.compatibilityMatrix = UNSPECIFIED_VALUE;
                this.year = UNSPECIFIED_VALUE;
                this.month = UNSPECIFIED_VALUE;
                this.day = UNSPECIFIED_VALUE;
                this.maintainerId = UNSPECIFIED_VALUE;
                this.dependVer = UNSPECIFIED_VALUE;
            }
        }
    }

    public static FileVersionInfo newInstanceFromJson(String jsonString) throws JSONException {
        FileVersionInfo fileVersionInfo = null;
        try {
            fileVersionInfo = new FileVersionInfo(new JSONObject(jsonString));
        }
        catch (JSONException jSONException) {
            throw new JSONException("Parse failed. Invalid JSON format.");
        }
        return fileVersionInfo;
    }

    private FileVersionInfo(JSONObject json) throws JSONException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        if (json.has(PLATFORM)) {
            string = json.getString(PLATFORM);
        }
        if (json.has(SUBPLATFORM)) {
            string2 = json.getString(SUBPLATFORM);
        }
        if (json.has(FILE_TYPE)) {
            string3 = json.getString(FILE_TYPE);
        }
        if (json.has(FILE_LEVEL)) {
            string4 = json.getString(FILE_LEVEL);
        }
        if (json.has(YEAR)) {
            string5 = json.getString(YEAR);
        }
        if (json.has(MONTH)) {
            string6 = json.getString(MONTH);
        }
        if (json.has(DAY)) {
            string7 = json.getString(DAY);
        }
        if (json.has(VERSION)) {
            string8 = json.getString(VERSION);
        }
        if (json.has(VERSION_FLAG)) {
            string9 = json.getString(VERSION_FLAG);
        }
        if (json.has(MAINTAINER_ID)) {
            string10 = json.getString(MAINTAINER_ID);
        }
        if (json.has(DEPEND_VERSION)) {
            string11 = json.getString(DEPEND_VERSION);
        }
        if (json.has(FILE_SN)) {
            string12 = json.getString(FILE_SN);
        }
        if (json.has(CUSTOMER_ID)) {
            string13 = json.getString(CUSTOMER_ID);
        }
        if (json.has(COMPATIBILITY_MATRIX)) {
            string14 = json.getString(COMPATIBILITY_MATRIX);
        }
        this.platform = string;
        this.subPlatform = string2;
        this.fileType = string3;
        this.fileLevel = string4;
        this.year = string5;
        this.month = string6;
        this.day = string7;
        this.version = string8;
        this.verFlag = string9;
        this.maintainerId = string10;
        this.dependVer = string11;
        this.fileSN = string12;
        this.customerId = string13;
        this.compatibilityMatrix = string14;
    }

    public boolean namePortionMatches(FileVersionInfo info) {
        return info != null && info.fileType.trim().equals(this.fileType.trim());
    }

    public int compareWith(FileVersionInfo info) {
        if (info != null) {
            int n2 = this.version.trim().compareTo(info.version.trim());
            if (n2 > 0) {
                return 1;
            }
            if (n2 == 0) {
                return this.verFlag.trim().compareTo(info.verFlag.trim());
            }
            return -1;
        }
        return 1;
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.platform != null) {
                jSONObject.put(PLATFORM, (Object)this.platform);
            }
            if (this.subPlatform != null) {
                jSONObject.put(SUBPLATFORM, (Object)this.subPlatform);
            }
            if (this.fileType != null) {
                jSONObject.put(FILE_TYPE, (Object)this.fileType);
            }
            if (this.fileLevel != null) {
                jSONObject.put(FILE_LEVEL, (Object)this.fileLevel);
            }
            if (this.year != null) {
                jSONObject.put(YEAR, (Object)this.year);
            }
            if (this.month != null) {
                jSONObject.put(MONTH, (Object)this.month);
            }
            if (this.day != null) {
                jSONObject.put(DAY, (Object)this.day);
            }
            if (this.version != null) {
                jSONObject.put(VERSION, (Object)this.version);
            }
            if (this.verFlag != null) {
                jSONObject.put(VERSION_FLAG, (Object)this.verFlag);
            }
            if (this.maintainerId != null) {
                jSONObject.put(MAINTAINER_ID, (Object)this.maintainerId);
            }
            if (this.dependVer != null) {
                jSONObject.put(DEPEND_VERSION, (Object)this.dependVer);
            }
            if (this.fileSN != null) {
                jSONObject.put(FILE_SN, (Object)this.fileSN);
            }
            if (this.customerId != null) {
                jSONObject.put(CUSTOMER_ID, (Object)this.customerId);
            }
            if (this.compatibilityMatrix != null) {
                jSONObject.put(COMPATIBILITY_MATRIX, (Object)this.compatibilityMatrix);
            }
        }
        catch (JSONException jSONException) {
            LogUtils.write(a, (Exception)((Object)jSONException));
        }
        return jSONObject.toString();
    }

    private static boolean a(String string) {
        return string != null && string.length() == 64;
    }

    private String a(byte[] byArray) {
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LogUtils.write(a, unsupportedEncodingException);
            return UNSPECIFIED_VALUE;
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.compatibilityMatrix == null ? 0 : this.compatibilityMatrix.hashCode());
        n3 = 31 * n3 + (this.customerId == null ? 0 : this.customerId.hashCode());
        n3 = 31 * n3 + (this.day == null ? 0 : this.day.hashCode());
        n3 = 31 * n3 + (this.dependVer == null ? 0 : this.dependVer.hashCode());
        n3 = 31 * n3 + (this.fileLevel == null ? 0 : this.fileLevel.hashCode());
        n3 = 31 * n3 + (this.fileSN == null ? 0 : this.fileSN.hashCode());
        n3 = 31 * n3 + (this.fileType == null ? 0 : this.fileType.hashCode());
        n3 = 31 * n3 + (this.maintainerId == null ? 0 : this.maintainerId.hashCode());
        n3 = 31 * n3 + (this.month == null ? 0 : this.month.hashCode());
        n3 = 31 * n3 + (this.platform == null ? 0 : this.platform.hashCode());
        n3 = 31 * n3 + (this.subPlatform == null ? 0 : this.subPlatform.hashCode());
        n3 = 31 * n3 + (this.verFlag == null ? 0 : this.verFlag.hashCode());
        n3 = 31 * n3 + (this.version == null ? 0 : this.version.hashCode());
        n3 = 31 * n3 + (this.year == null ? 0 : this.year.hashCode());
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileVersionInfo fileVersionInfo = (FileVersionInfo)obj;
        if (this.compatibilityMatrix == null ? fileVersionInfo.compatibilityMatrix != null : !this.compatibilityMatrix.equals(fileVersionInfo.compatibilityMatrix)) {
            return false;
        }
        if (this.customerId == null ? fileVersionInfo.customerId != null : !this.customerId.equals(fileVersionInfo.customerId)) {
            return false;
        }
        if (this.day == null ? fileVersionInfo.day != null : !this.day.equals(fileVersionInfo.day)) {
            return false;
        }
        if (this.dependVer == null ? fileVersionInfo.dependVer != null : !this.dependVer.equals(fileVersionInfo.dependVer)) {
            return false;
        }
        if (this.fileLevel == null ? fileVersionInfo.fileLevel != null : !this.fileLevel.equals(fileVersionInfo.fileLevel)) {
            return false;
        }
        if (this.fileSN == null ? fileVersionInfo.fileSN != null : !this.fileSN.equals(fileVersionInfo.fileSN)) {
            return false;
        }
        if (this.fileType == null ? fileVersionInfo.fileType != null : !this.fileType.equals(fileVersionInfo.fileType)) {
            return false;
        }
        if (this.maintainerId == null ? fileVersionInfo.maintainerId != null : !this.maintainerId.equals(fileVersionInfo.maintainerId)) {
            return false;
        }
        if (this.month == null ? fileVersionInfo.month != null : !this.month.equals(fileVersionInfo.month)) {
            return false;
        }
        if (this.platform == null ? fileVersionInfo.platform != null : !this.platform.equals(fileVersionInfo.platform)) {
            return false;
        }
        if (this.subPlatform == null ? fileVersionInfo.subPlatform != null : !this.subPlatform.equals(fileVersionInfo.subPlatform)) {
            return false;
        }
        if (this.verFlag == null ? fileVersionInfo.verFlag != null : !this.verFlag.equals(fileVersionInfo.verFlag)) {
            return false;
        }
        if (this.version == null ? fileVersionInfo.version != null : !this.version.equals(fileVersionInfo.version)) {
            return false;
        }
        return !(this.year == null ? fileVersionInfo.year != null : !this.year.equals(fileVersionInfo.year));
    }
}

