/*
 * Decompiled with CFR 0.152.
 */
package com.roam.roamreaderunifiedapi.data;

import android.text.TextUtils;
import java.io.Serializable;

public final class PublicKey
implements Serializable {
    private String a;
    private String b;
    private String c;
    private String d;
    private String e;

    public PublicKey() {
    }

    public PublicKey(String RID, String CAPublicKeyIndex, String key, String exponentOfPublicKey) {
        this(RID, CAPublicKeyIndex, key, exponentOfPublicKey, null);
    }

    public PublicKey(String RID, String CAPublicKeyIndex, String key, String exponentOfPublicKey, String checksum) {
        this.a = RID;
        this.b = CAPublicKeyIndex;
        this.c = key;
        this.d = exponentOfPublicKey;
        this.e = checksum;
    }

    public String getRID() {
        return this.a;
    }

    public String getCAPublicKeyIndex() {
        return this.b;
    }

    public String getKey() {
        return this.c;
    }

    public String getExponentOfPublicKey() {
        return this.d;
    }

    public String getChecksum() {
        return this.e;
    }

    public String getFormattedString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getRID());
        stringBuilder.append(this.getCAPublicKeyIndex());
        stringBuilder.append(String.format("%02X", this.getKey().length() / 2));
        stringBuilder.append(this.getKey());
        if ("010001".equals(this.d) || "10001".equals(this.d)) {
            stringBuilder.append("FF");
        } else {
            stringBuilder.append(this.getExponentOfPublicKey());
        }
        if (!TextUtils.isEmpty((CharSequence)this.getChecksum())) {
            stringBuilder.append(this.getChecksum());
        } else {
            stringBuilder.append("0000000000000000000000000000000000000000");
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.b == null ? 0 : this.b.hashCode());
        n3 = 31 * n3 + (this.e == null ? 0 : this.e.hashCode());
        n3 = 31 * n3 + (this.d == null ? 0 : this.d.hashCode());
        n3 = 31 * n3 + (this.c == null ? 0 : this.c.hashCode());
        n3 = 31 * n3 + (this.a == null ? 0 : this.a.hashCode());
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PublicKey publicKey = (PublicKey)obj;
        if (this.b == null ? publicKey.b != null : !this.b.equals(publicKey.b)) {
            return false;
        }
        if (this.e == null ? publicKey.e != null : !this.e.equals(publicKey.e)) {
            return false;
        }
        if (this.d == null ? publicKey.d != null : !this.d.equals(publicKey.d)) {
            return false;
        }
        if (this.c == null ? publicKey.c != null : !this.c.equals(publicKey.c)) {
            return false;
        }
        return !(this.a == null ? publicKey.a != null : !this.a.equals(publicKey.a));
    }
}

