/*
 * Decompiled with CFR 0.152.
 */
package com.roam.roamreaderunifiedapi.data;

import com.roam.roamreaderunifiedapi.data.FileVersionInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ReaderVersionInfo
implements Serializable {
    public static final String BOOT_FILE = "BOOT";
    public static final String CTRL_FILE = "CTRL";
    public static final String USER_FILE = "USER";
    private String a;
    private FileVersionInfo b;
    private FileVersionInfo c;
    private List<FileVersionInfo> d;
    private List<FileVersionInfo> e;
    private String f;
    private String g;
    private String h;
    private String i;
    private String j;
    private String k;

    private ReaderVersionInfo() {
    }

    private ReaderVersionInfo(Builder builder) {
        this.a(builder.a.getHardwareType());
        this.a(builder.a.getBootFileVersion());
        this.b(builder.a.getControlFileVersion());
        this.a(builder.a.getUserFileVersions());
        this.b(builder.a.getParameterFileVersions());
        this.b(builder.a.getKeyVersion());
        this.c(builder.a.getPedVersion());
        this.d(builder.a.getFontFileVersion());
        this.e(builder.a.getProductSerialNumber());
        this.f(builder.a.getBluetoothMacAddress());
        this.g(builder.a.getEmvKernelVersion());
    }

    public FileVersionInfo getFileVersionInfoFor(FileVersionInfo info) {
        if (info.namePortionMatches(this.b)) {
            return this.b;
        }
        if (info.namePortionMatches(this.c)) {
            return this.c;
        }
        for (FileVersionInfo fileVersionInfo : this.d) {
            if (!info.namePortionMatches(fileVersionInfo)) continue;
            return fileVersionInfo;
        }
        for (FileVersionInfo fileVersionInfo : this.e) {
            if (!info.namePortionMatches(fileVersionInfo)) continue;
            return fileVersionInfo;
        }
        return null;
    }

    public String getHardwareType() {
        return this.a;
    }

    public FileVersionInfo getBootFileVersion() {
        return this.b;
    }

    public FileVersionInfo getControlFileVersion() {
        return this.c;
    }

    public List<FileVersionInfo> getUserFileVersions() {
        return this.d;
    }

    public List<FileVersionInfo> getParameterFileVersions() {
        return this.e;
    }

    public String getKeyVersion() {
        return this.f;
    }

    public String getPedVersion() {
        return this.g;
    }

    public String getFontFileVersion() {
        return this.i;
    }

    public String getProductSerialNumber() {
        return this.j;
    }

    public String getBluetoothMacAddress() {
        return this.k;
    }

    public String getEmvKernelVersion() {
        return this.h;
    }

    private void a(String string) {
        this.a = string;
    }

    private void a(FileVersionInfo fileVersionInfo) {
        this.b = fileVersionInfo;
    }

    private void b(FileVersionInfo fileVersionInfo) {
        this.c = fileVersionInfo;
    }

    private void a(List<FileVersionInfo> list) {
        this.d = list;
    }

    private void b(List<FileVersionInfo> list) {
        this.e = list;
    }

    private void b(String string) {
        this.f = string;
    }

    private void c(String string) {
        this.g = string;
    }

    private void d(String string) {
        this.i = string;
    }

    private void e(String string) {
        this.j = string;
    }

    private void f(String string) {
        this.k = string;
    }

    private void g(String string) {
        this.h = string;
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray;
            if (this.getEmvKernelVersion() != null) {
                jSONObject.put("emv_kernel_version", (Object)this.getEmvKernelVersion());
            }
            if (this.getHardwareType() != null) {
                jSONObject.put("hardware_type", (Object)this.getHardwareType());
            }
            if (this.getPedVersion() != null) {
                jSONObject.put("ped_version", (Object)this.getPedVersion());
            }
            if (this.getKeyVersion() != null) {
                jSONObject.put("key_version", (Object)this.getKeyVersion());
            }
            if (this.getFontFileVersion() != null) {
                jSONObject.put("font_file_version", (Object)this.getFontFileVersion());
            }
            if (this.getProductSerialNumber() != null) {
                jSONObject.put("product_serial_number", (Object)this.getProductSerialNumber());
            }
            if (this.getBluetoothMacAddress() != null) {
                jSONObject.put("bluetooth_mac_address", (Object)this.getBluetoothMacAddress());
            }
            if (this.getBootFileVersion() != null) {
                jSONObject.put("boot_file_version", (Object)new JSONObject(this.getBootFileVersion().toString()));
            }
            if (this.getControlFileVersion() != null) {
                jSONObject.put("control_file_version", (Object)new JSONObject(this.getControlFileVersion().toString()));
            }
            if (null != this.getUserFileVersions() && this.getUserFileVersions().size() != 0) {
                jSONArray = new JSONArray();
                for (FileVersionInfo fileVersionInfo : this.getUserFileVersions()) {
                    if (fileVersionInfo == null) continue;
                    jSONArray.put((Object)new JSONObject(fileVersionInfo.toString()));
                }
                if (jSONArray.length() != 0) {
                    jSONObject.put("user_file_version", (Object)jSONArray);
                }
            }
            if (null != this.getParameterFileVersions() && this.getParameterFileVersions().size() != 0) {
                jSONArray = new JSONArray();
                for (FileVersionInfo fileVersionInfo : this.getParameterFileVersions()) {
                    if (fileVersionInfo == null) continue;
                    jSONArray.put((Object)new JSONObject(fileVersionInfo.toString()));
                }
                if (jSONArray.length() != 0) {
                    jSONObject.put("parameter_file_version", (Object)jSONArray);
                }
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject.toString();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.k == null ? 0 : this.k.hashCode());
        n3 = 31 * n3 + (this.b == null ? 0 : this.b.hashCode());
        n3 = 31 * n3 + (this.c == null ? 0 : this.c.hashCode());
        n3 = 31 * n3 + (this.h == null ? 0 : this.h.hashCode());
        n3 = 31 * n3 + (this.i == null ? 0 : this.i.hashCode());
        n3 = 31 * n3 + (this.a == null ? 0 : this.a.hashCode());
        n3 = 31 * n3 + (this.f == null ? 0 : this.f.hashCode());
        n3 = 31 * n3 + (this.e == null ? 0 : this.e.hashCode());
        n3 = 31 * n3 + (this.g == null ? 0 : this.g.hashCode());
        n3 = 31 * n3 + (this.j == null ? 0 : this.j.hashCode());
        n3 = 31 * n3 + (this.d == null ? 0 : this.d.hashCode());
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReaderVersionInfo readerVersionInfo = (ReaderVersionInfo)obj;
        if (this.k == null ? readerVersionInfo.k != null : !this.k.equals(readerVersionInfo.k)) {
            return false;
        }
        if (this.b == null ? readerVersionInfo.b != null : !this.b.equals(readerVersionInfo.b)) {
            return false;
        }
        if (this.c == null ? readerVersionInfo.c != null : !this.c.equals(readerVersionInfo.c)) {
            return false;
        }
        if (this.h == null ? readerVersionInfo.h != null : !this.h.equals(readerVersionInfo.h)) {
            return false;
        }
        if (this.i == null ? readerVersionInfo.i != null : !this.i.equals(readerVersionInfo.i)) {
            return false;
        }
        if (this.a == null ? readerVersionInfo.a != null : !this.a.equals(readerVersionInfo.a)) {
            return false;
        }
        if (this.f == null ? readerVersionInfo.f != null : !this.f.equals(readerVersionInfo.f)) {
            return false;
        }
        if (this.e == null ? readerVersionInfo.e != null : !this.e.containsAll(readerVersionInfo.e) || !readerVersionInfo.e.containsAll(this.e)) {
            return false;
        }
        if (this.g == null ? readerVersionInfo.g != null : !this.g.equals(readerVersionInfo.g)) {
            return false;
        }
        if (this.j == null ? readerVersionInfo.j != null : !this.j.equals(readerVersionInfo.j)) {
            return false;
        }
        return !(this.d == null ? readerVersionInfo.d != null : !this.d.containsAll(readerVersionInfo.d) || !readerVersionInfo.d.containsAll(this.d));
    }

    public static class Builder {
        private ReaderVersionInfo a = new ReaderVersionInfo();

        public Builder(String hardwareType) {
            this.a.a(hardwareType);
        }

        public Builder bootFileVersion(String bootFileVersion) {
            this.a.a(FileVersionInfo.newInstance(bootFileVersion));
            return this;
        }

        public Builder controlFileVersion(String controlFileVersion) {
            this.a.b(FileVersionInfo.newInstance(controlFileVersion));
            return this;
        }

        public Builder userFileVersions(List<String> userFileVersions) {
            this.a.a(this.a(userFileVersions));
            return this;
        }

        public Builder parameterFileVersions(List<String> parameterFileVersions) {
            this.a.b(this.a(parameterFileVersions));
            return this;
        }

        public Builder keyVersion(String keyVersion) {
            this.a.b(keyVersion);
            return this;
        }

        public Builder pedVersion(String pedVersion) {
            this.a.c(pedVersion);
            return this;
        }

        public Builder emvKernelVersion(String emvKernelVersion) {
            this.a.g(emvKernelVersion);
            return this;
        }

        public Builder fontFileVersion(String fontFileVersion) {
            this.a.d(fontFileVersion);
            return this;
        }

        public Builder productSerialNumber(String productSerialNumber) {
            this.a.e(productSerialNumber);
            return this;
        }

        public Builder bluetoothMacAddress(String bluetoothMacAddress) {
            this.a.f(bluetoothMacAddress);
            return this;
        }

        private ArrayList<FileVersionInfo> a(List<String> list) {
            ArrayList<FileVersionInfo> arrayList = new ArrayList<FileVersionInfo>(list.size());
            for (String string : list) {
                arrayList.add(FileVersionInfo.newInstance(string));
            }
            return arrayList;
        }

        public ReaderVersionInfo build() {
            return new ReaderVersionInfo(this);
        }
    }
}

