/*
 * Decompiled with CFR 0.152.
 */
package com.roam.roamreaderunifiedapi.emvreaders;

import android.text.TextUtils;
import com.roam.roamreaderunifiedapi.DisplayControl;
import com.roam.roamreaderunifiedapi.KeyPadControl;
import com.roam.roamreaderunifiedapi.callback.DeviceResponseHandler;
import com.roam.roamreaderunifiedapi.constants.Command;
import com.roam.roamreaderunifiedapi.constants.DisplayTextCharset;
import com.roam.roamreaderunifiedapi.constants.ErrorCode;
import com.roam.roamreaderunifiedapi.constants.LanguageCode;
import com.roam.roamreaderunifiedapi.constants.Parameter;
import com.roam.roamreaderunifiedapi.constants.ResponseCode;
import com.roam.roamreaderunifiedapi.emvreaders.LandiReader;
import com.roam.roamreaderunifiedapi.emvreaders.a;
import com.roam.roamreaderunifiedapi.emvreaders.g;
import com.roam.roamreaderunifiedapi.emvreaders.h;
import com.roam.roamreaderunifiedapi.utils.HexUtils;
import java.util.EnumMap;

abstract class BaseBluetoothDeviceManagerWithKeypadAndDisplay
extends a {
    BaseBluetoothDeviceManagerWithKeypadAndDisplay() {
    }

    @Override
    public DisplayControl getDisplayControl() {
        if (this.mDisplayControl == null) {
            this.mDisplayControl = new BaseDisplayControl(this);
        }
        return this.mDisplayControl;
    }

    @Override
    public KeyPadControl getKeypadControl() {
        if (this.mKeyPadControl == null) {
            this.mKeyPadControl = new BaseKeypadControl(this);
        }
        return this.mKeyPadControl;
    }

    protected class BaseDisplayControl
    implements DisplayControl {
        private LandiReader b;

        public BaseDisplayControl(LandiReader landiReader) {
            this.b = landiReader;
        }

        @Override
        public void enableBackLight(boolean enable, DeviceResponseHandler handler) {
            LandiReader.d d2 = new LandiReader.d(handler);
            String string = enable ? "FF04000300" : "FF04000200";
            new g(Command.DisplayControl, string, BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.mTimeout).a(BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.shouldSetupConnection(), this.b, (h)d2);
        }

        @Override
        public void clearDisplay(DeviceResponseHandler handler) {
            LandiReader.d d2 = new LandiReader.d(handler);
            String string = "FF04000000";
            new g(Command.DisplayControl, string, BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.mTimeout).a(BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.shouldSetupConnection(), this.b, (h)d2);
        }

        @Override
        public void writeText(Integer row, Integer column, DisplayTextCharset charset, String text, DeviceResponseHandler handler) {
            LandiReader.d d2 = new LandiReader.d(handler);
            if (row == null || column == null) {
                EnumMap<Parameter, Enum> enumMap = new EnumMap<Parameter, Enum>(Parameter.class);
                enumMap.put(Parameter.Command, Command.DisplayControl);
                enumMap.put(Parameter.ResponseCode, ResponseCode.Error);
                enumMap.put(Parameter.ErrorCode, ErrorCode.InvalidParameters);
                BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.postResponseOnUiThread(handler, enumMap);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder("FF0500");
            if (charset == DisplayTextCharset.EMVL1) {
                stringBuilder.append("00");
            } else if (charset == DisplayTextCharset.EMVL2) {
                stringBuilder.append("01");
            }
            stringBuilder.append(String.format("%02X", 2 + text.length() / 2));
            stringBuilder.append(String.format("%02X%02X", (int)column, (int)row));
            stringBuilder.append(text);
            stringBuilder.append("00");
            new g(Command.DisplayText, stringBuilder.toString(), BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.mTimeout).a(BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.shouldSetupConnection(), this.b, (h)d2);
        }
    }

    protected class BaseKeypadControl
    extends KeyPadControl {
        private final LandiReader b;

        BaseKeypadControl(LandiReader landiReader) {
            this.b = landiReader;
        }

        @Override
        public void promptPinTDESBlockWithEncryptedPAN(LanguageCode languageCode, String pinBlockFormat, String keyLocator, String cardLast4Digits, String macData, Boolean clearOnlyLastDigitEntered, Integer interDigitTimeout, DeviceResponseHandler handler) {
            if (interDigitTimeout > 65535 || TextUtils.isEmpty((CharSequence)pinBlockFormat) || TextUtils.isEmpty((CharSequence)pinBlockFormat) || TextUtils.isEmpty((CharSequence)keyLocator) || TextUtils.isEmpty((CharSequence)cardLast4Digits)) {
                EnumMap<Parameter, Enum> enumMap = new EnumMap<Parameter, Enum>(Parameter.class);
                enumMap.put(Parameter.Command, Command.DisplayControl);
                enumMap.put(Parameter.ResponseCode, ResponseCode.Error);
                enumMap.put(Parameter.ErrorCode, ErrorCode.InvalidParameters);
                BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.postResponseOnUiThread(handler, enumMap);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder("FF080008");
            String string = !TextUtils.isEmpty((CharSequence)macData) ? String.format("%s%s%s000000000000000000000000000000000000%s%02X%04X%02X%s", languageCode.getISO689CodeInHex(), pinBlockFormat, keyLocator, cardLast4Digits, clearOnlyLastDigitEntered != false ? 1 : 0, interDigitTimeout, macData.length() / 2, macData) : String.format("%s%s%s000000000000000000000000000000000000%s%02X%04X0000", languageCode.getISO689CodeInHex(), pinBlockFormat, keyLocator, cardLast4Digits, clearOnlyLastDigitEntered != false ? 1 : 0, interDigitTimeout);
            stringBuilder.append(String.format("%02X%s00", string.length() / 2, string));
            LandiReader.d d2 = new LandiReader.d(handler);
            this.setPinType(KeyPadControl.PIN_TYPE.TDES_BLOCK_PIN);
            BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.canCallCancelWait = true;
            new g(Command.KeyPadControl, stringBuilder.toString(), BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.mTimeout).a(BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.shouldSetupConnection(), this.b, (h)d2);
        }

        @Override
        public void promptPinMasterSessionKeyWithEncryptedPAN(LanguageCode languageCode, String pinBlockFormat, String keyLocator, String cardLast4Digits, Boolean clearOnlyLastDigitEntered, Integer interDigitTimeout, DeviceResponseHandler handler) {
            StringBuilder stringBuilder = new StringBuilder("FF080009");
            String string = String.format("%s%s%s000000000000000000000000000000000000%s%02X%04X", languageCode.getISO689CodeInHex(), pinBlockFormat, keyLocator, cardLast4Digits, clearOnlyLastDigitEntered != false ? 1 : 0, interDigitTimeout);
            stringBuilder.append(String.format("%02X%s00", string.length() / 2, string));
            LandiReader.d d2 = new LandiReader.d(handler);
            this.setPinType(KeyPadControl.PIN_TYPE.MASTER_SESSION_PIN);
            new g(Command.KeyPadControl, stringBuilder.toString(), BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.mTimeout).a(BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.shouldSetupConnection(), this.b, (h)d2);
            BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.canCallCancelWait = true;
        }

        @Override
        public void collectKeyedCardData(DeviceResponseHandler handler) {
            new g(Command.CollectKeyedCardData, "FF84010000", BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.mTimeout).a(BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.shouldSetupConnection(), this.b, (h)new LandiReader.d(handler));
        }

        @Override
        public void collectZipCode(DeviceResponseHandler handler) {
            new g(Command.CollectZipCode, this.a(Command.CollectZipCode), BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.mTimeout).a(BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.shouldSetupConnection(), this.b, (h)new LandiReader.d(handler));
        }

        private String a(Command command) {
            StringBuilder stringBuilder = new StringBuilder("FF880300");
            String string = "Unknown";
            switch (command) {
                case CollectZipCode: {
                    string = HexUtils.convertASCII2HexaDecimal("ENTER_INFO_ZIPCODE");
                    break;
                }
                default: {
                    string = "Unknown";
                }
            }
            String string2 = Integer.toHexString(BaseBluetoothDeviceManagerWithKeypadAndDisplay.this.mTimeout * 1000);
            stringBuilder.append(Integer.toHexString(string2.length() / 2 + string.length() / 2));
            stringBuilder.append(string2);
            stringBuilder.append(string);
            stringBuilder.append("00");
            return stringBuilder.toString();
        }
    }
}

