/*
 * Decompiled with CFR 0.152.
 */
package com.roam.roamreaderunifiedapi.emvreaders;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Base64;
import com.landicorp.emv.comm.api.AudioJackManager;
import com.landicorp.emv.comm.api.BluetoothManager;
import com.landicorp.emv.comm.api.CalibrateParamCallback;
import com.landicorp.emv.comm.api.CommParameter;
import com.landicorp.emv.comm.api.CommunicationCallBack;
import com.landicorp.emv.comm.api.CommunicationManagerBase;
import com.landicorp.emv.comm.api.UsbManager_TLV;
import com.landicorp.liu.comm.api.BluetoothCommParam;
import com.landicorp.rkmssrc.RKMSInjection;
import com.roam.roamreaderunifiedapi.BaseDeviceManager;
import com.roam.roamreaderunifiedapi.ConfigurationManager;
import com.roam.roamreaderunifiedapi.KeyPadControl;
import com.roam.roamreaderunifiedapi.RoamReaderUnifiedAPI;
import com.roam.roamreaderunifiedapi.TransactionManager;
import com.roam.roamreaderunifiedapi.callback.AudioJackPairingListener;
import com.roam.roamreaderunifiedapi.callback.AudioJackPairingListenerWithDevice;
import com.roam.roamreaderunifiedapi.callback.CalibrationListener;
import com.roam.roamreaderunifiedapi.callback.DeviceResponseHandler;
import com.roam.roamreaderunifiedapi.callback.DeviceStatusHandler;
import com.roam.roamreaderunifiedapi.callback.ReleaseHandler;
import com.roam.roamreaderunifiedapi.callback.TurnOnDeviceCallback;
import com.roam.roamreaderunifiedapi.constants.CalibrationResult;
import com.roam.roamreaderunifiedapi.constants.CardType;
import com.roam.roamreaderunifiedapi.constants.Command;
import com.roam.roamreaderunifiedapi.constants.CommunicationType;
import com.roam.roamreaderunifiedapi.constants.DeviceStatus;
import com.roam.roamreaderunifiedapi.constants.DeviceType;
import com.roam.roamreaderunifiedapi.constants.ErrorCode;
import com.roam.roamreaderunifiedapi.constants.FirmwareChecksumType;
import com.roam.roamreaderunifiedapi.constants.FirmwareComponentType;
import com.roam.roamreaderunifiedapi.constants.LanguageCode;
import com.roam.roamreaderunifiedapi.constants.Parameter;
import com.roam.roamreaderunifiedapi.constants.ProgressMessage;
import com.roam.roamreaderunifiedapi.constants.ResponseCode;
import com.roam.roamreaderunifiedapi.constants.ResponseType;
import com.roam.roamreaderunifiedapi.constants.ValueFormat;
import com.roam.roamreaderunifiedapi.constants.VasMode;
import com.roam.roamreaderunifiedapi.data.ApplicationIdentifier;
import com.roam.roamreaderunifiedapi.data.CalibrationParameters;
import com.roam.roamreaderunifiedapi.data.CertificateFilesVersionInfo;
import com.roam.roamreaderunifiedapi.data.Device;
import com.roam.roamreaderunifiedapi.data.KeyMappingInfo;
import com.roam.roamreaderunifiedapi.data.PublicKey;
import com.roam.roamreaderunifiedapi.data.ReaderVersionInfo;
import com.roam.roamreaderunifiedapi.data.VasData;
import com.roam.roamreaderunifiedapi.emvreaders.m;
import com.roam.roamreaderunifiedapi.emvreaders.n;
import com.roam.roamreaderunifiedapi.emvreaders.o;
import com.roam.roamreaderunifiedapi.emvreaders.p;
import com.roam.roamreaderunifiedapi.utils.HexUtils;
import com.roam.roamreaderunifiedapi.utils.LogUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class LandiReader
extends BaseDeviceManager
implements ConfigurationManager,
TransactionManager {
    private static final String a = LandiReader.class.getSimpleName();
    private static final Set<ApplicationIdentifier> b = new HashSet<ApplicationIdentifier>();
    private byte[] c = null;
    private String d;
    private Device e;
    private h f;
    private b g;
    private i h;
    private long i = -1L;
    private boolean j;
    private com.roam.roamreaderunifiedapi.emvreaders.f k;
    private EnumMap<Parameter, Object> l;
    private EnumMap<Parameter, Object> m;
    private List<ApplicationIdentifier> n;
    protected Context context;
    protected List<Parameter> amountDOL;
    protected List<Parameter> onlineDOL;
    protected List<Parameter> responseDOL;
    protected List<Parameter> contactlessOnlineDOL;
    protected List<Parameter> contactlessResponseDOL;
    protected int mTimeout = 10;
    protected CommunicationManagerBase mCommManager;
    protected DeviceStatusHandler currentDeviceStatusHandler;
    private DeviceStatusHandler o;
    protected com.roam.roamreaderunifiedapi.emvreaders.i deviceStatus = com.roam.roamreaderunifiedapi.emvreaders.i.c;
    protected CommunicationManagerBase.DeviceCommunicationChannel commChannel = CommunicationManagerBase.DeviceCommunicationChannel.AUDIOJACK;
    protected final c mHeadsetPlugStateReceiver = new c();
    protected boolean isRegisteredForHeadsetPlugStateUpdates;
    protected final e connectionHandler = new e();
    protected boolean isRkiModeEnabled;
    protected boolean canCallCancelWait;
    private boolean p;
    protected CalibrationParameters calibrationParams;
    protected BluetoothCommParam bluetoothCommParam;
    private ReleaseHandler q;
    private boolean r;
    private CommunicationManagerBase s;
    private TurnOnDeviceCallback t;

    protected abstract boolean supportsNFC();

    protected abstract boolean supportsAudioJackInterface();

    protected abstract boolean supportsUSBInterface();

    protected abstract boolean supportsBluetoothInterface();

    protected abstract boolean supportsRKI();

    @Override
    public boolean initialize(Context ctx, DeviceStatusHandler statusHandler) {
        this.isInitialized = true;
        return true;
    }

    @Override
    public boolean initialize(Context context, DeviceStatusHandler deviceStatusHandler, CalibrationParameters calibrationParams) {
        this.calibrationParams = calibrationParams;
        return this.initialize(context, deviceStatusHandler);
    }

    @Override
    public boolean initialize(Context context, boolean noDelay, DeviceStatusHandler statusHandler) {
        return this.initialize(context, statusHandler);
    }

    @Override
    public boolean release() {
        this.o = this.currentDeviceStatusHandler;
        LogUtils.write(a, "release::setting status handler to null");
        this.currentDeviceStatusHandler = null;
        this.startCloseDeviceTask(null);
        this.commChannel = CommunicationManagerBase.DeviceCommunicationChannel.AUDIOJACK;
        this.calibrationParams = null;
        this.k = null;
        this.isInitialized = false;
        this.a();
        return true;
    }

    @Override
    public void release(ReleaseHandler releaseHandler) {
        this.q = releaseHandler;
        this.release();
    }

    private void a() {
        this.m = null;
        this.l = null;
    }

    CommunicationManagerBase b() {
        return this.mCommManager;
    }

    private CommunicationManagerBase.DeviceCommunicationChannel f() {
        return this.commChannel;
    }

    @Override
    public ConfigurationManager getConfigurationManager() {
        return this;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this;
    }

    @Override
    public DeviceStatus getStatus() {
        return DeviceStatus.STATE_IDLE;
    }

    @Override
    public void requestPairing(AudioJackPairingListener listener) {
        listener.onPairNotSupported();
    }

    @Override
    public void requestPairing(AudioJackPairingListenerWithDevice listener) {
        listener.onPairNotSupported();
    }

    @Override
    public void confirmPairing(Boolean isMatching) {
    }

    @Override
    public void cancelSearch() {
    }

    int a(CommunicationManagerBase communicationManagerBase, CommunicationCallBack communicationCallBack, CommParameter commParameter) {
        if (communicationManagerBase != null) {
            if (commParameter != null) {
                return communicationManagerBase.openDevice(this.getActivatedDeviceIdentifier(), commParameter, communicationCallBack, CommunicationManagerBase.CommunicationMode.MODE_DUPLEX);
            }
            return communicationManagerBase.openDevice(this.getActivatedDeviceIdentifier(), communicationCallBack, CommunicationManagerBase.CommunicationMode.MODE_DUPLEX);
        }
        return -1;
    }

    int c() {
        if (null != this.calibrationParams) {
            return this.a(this.mCommManager, this.connectionHandler, this.calibrationParams.getParams());
        }
        if (null != this.bluetoothCommParam && null != this.e && CommunicationType.Bluetooth == this.e.getConnectionType()) {
            return this.a(this.mCommManager, this.connectionHandler, new CommParameter(this.bluetoothCommParam, CommParameter.CommParamType.TYPE_BLUETOOTH));
        }
        return this.a(this.mCommManager, this.connectionHandler, null);
    }

    private void g() {
        if (this.mCommManager != null) {
            try {
                ((AudioJackManager)this.mCommManager).closeAudioResource();
            }
            catch (Exception exception) {
                LogUtils.write(a, exception);
            }
            this.mCommManager = null;
        }
    }

    private void h() {
        LogUtils.write(a, "closeDevice");
        if (this.mCommManager != null) {
            this.mCommManager.closeDevice();
            this.mCommManager = null;
        }
    }

    protected void startOpenDeviceTask(f callback) {
        this.startOpenDeviceTask(callback, false);
    }

    protected void startOpenDeviceTask(f callback, boolean switchUsbMode) {
        if (this.f == null || this.f.getStatus() == AsyncTask.Status.FINISHED) {
            this.f = new h(callback, switchUsbMode);
        }
        if (this.f.getStatus() == AsyncTask.Status.PENDING) {
            LogUtils.write(a, "OpenDeviceTask started");
            this.f.a();
        } else {
            LogUtils.write(a, "OpenDeviceTask is already running");
        }
    }

    protected void startCloseDeviceTask(String errorMessage) {
        if (this.g == null || this.g.getStatus() == AsyncTask.Status.FINISHED) {
            this.g = new b(errorMessage);
        }
        if (this.g.getStatus() == AsyncTask.Status.PENDING) {
            LogUtils.write(a, "CloseDeviceTask started");
            this.g.a();
        } else {
            LogUtils.write(a, "CloseDeviceTask is already running");
        }
    }

    protected void startTriggerRkiTask(String deviceGroupName, DeviceResponseHandler handler) {
        if (this.h == null || this.h.getStatus() == AsyncTask.Status.FINISHED) {
            this.h = new i(deviceGroupName, handler);
        }
        if (this.h.getStatus() == AsyncTask.Status.PENDING) {
            LogUtils.write(a, "CloseDeviceTask started");
            this.h.a();
        } else {
            LogUtils.write(a, "CloseDeviceTask is already running");
        }
    }

    @Override
    public boolean isReady() {
        return this.deviceStatus == com.roam.roamreaderunifiedapi.emvreaders.i.g;
    }

    @Override
    public Boolean activateDevice(Device reader) {
        LogUtils.write(a, "activateReader::" + reader);
        this.e = reader;
        switch (this.e.getConnectionType()) {
            case AudioJack: {
                this.commChannel = CommunicationManagerBase.DeviceCommunicationChannel.AUDIOJACK;
                break;
            }
            case Bluetooth: {
                if (this.j) {
                    this.j = false;
                }
                this.commChannel = CommunicationManagerBase.DeviceCommunicationChannel.BLUETOOTH;
                break;
            }
            case Usb: {
                if (this.getType() == DeviceType.RP450c) {
                    this.commChannel = CommunicationManagerBase.DeviceCommunicationChannel.USB_HID;
                    break;
                }
                this.commChannel = CommunicationManagerBase.DeviceCommunicationChannel.USB_TLV;
                break;
            }
        }
        return true;
    }

    @Override
    public List<Device> getAvailableDevices() {
        return new ArrayList<Device>();
    }

    @Override
    public void generateBeep(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.GenerateBeep, this.getGenerateBeepCommand(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void clearAIDSList(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ClearAIDsList, this.k(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void clearPublicKeys(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ClearPublicKeys, this.l(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void resetDevice(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ResetDevice, this.q(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void retrieveKSN(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.RetrieveKSN, this.r(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void revokePublicKey(PublicKey publicKey, DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.RevokePublicKey, this.b(publicKey), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void setAmountDOL(List<Parameter> list, DeviceResponseHandler handler) {
        this.setExpectedAmountDOL(list);
        String string = this.getConfigureDOLListCommand(Command.ConfigureAmountDOLData, list);
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ConfigureAmountDOLData, string, this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void setCommandTimeout(Integer timeout) {
        this.mTimeout = timeout;
    }

    @Override
    public void setOnlineDOL(List<Parameter> list, DeviceResponseHandler handler) {
        this.setExpectedOnlineDOL(list);
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ConfigureOnlineDOLData, this.getConfigureDOLListCommand(Command.ConfigureOnlineDOLData, list), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void setResponseDOL(List<Parameter> list, DeviceResponseHandler handler) {
        this.setExpectedResponseDOL(list);
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ConfigureResponseDOLData, this.getConfigureDOLListCommand(Command.ConfigureResponseDOLData, list), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void setUserInterfaceOptions(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ConfigureUserInterfaceOptions, "FF81060000063A980000000100", this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void setEnergySaverModeTime(Integer seconds, DeviceResponseHandler handler) {
        if (seconds < 0 || seconds > 1800) {
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.Command, (Object)Command.EnergySaverModeTime);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.InvalidParameters);
            this.postResponseOnUiThread(handler, enumMap);
            return;
        }
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.EnergySaverModeTime, this.a(seconds), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void setShutDownModeTime(Integer seconds, DeviceResponseHandler handler) {
        if (seconds < 0 || seconds > 255) {
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.Command, (Object)Command.ShutDownModeTime);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.InvalidParameters);
            this.postResponseOnUiThread(handler, enumMap);
            return;
        }
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ShutDownModeTime, this.b(seconds), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void submitAIDList(Set<ApplicationIdentifier> applicationIdentifiers, DeviceResponseHandler handler) {
        this.n = new ArrayList<ApplicationIdentifier>(applicationIdentifiers);
        this.a(Command.SubmitAIDsList, handler);
    }

    @Override
    public void submitAIDWithTLVDataList(Set<ApplicationIdentifier> applicationIdentifiers, DeviceResponseHandler handler) {
        this.n = new ArrayList<ApplicationIdentifier>(applicationIdentifiers);
        this.a(Command.SubmitAIDsWithTLVDataList, handler);
    }

    private boolean i() {
        return this.n != null && this.n.size() > 0;
    }

    private List<ApplicationIdentifier> a(Command command) {
        ArrayList<ApplicationIdentifier> arrayList;
        int n2;
        switch (command) {
            case SubmitAIDsWithTLVDataList: {
                n2 = 10;
                break;
            }
            case SubmitContactlessAIDsList: {
                n2 = 5;
                break;
            }
            default: {
                n2 = 25;
            }
        }
        int n3 = this.n.size();
        if (n3 <= n2) {
            arrayList = new ArrayList<ApplicationIdentifier>(this.n);
            this.n.clear();
        } else {
            arrayList = new ArrayList(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(this.n.remove(0));
            }
        }
        return arrayList;
    }

    private void a(Command command, DeviceResponseHandler deviceResponseHandler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(command, this.a(command, this.a(command)), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(deviceResponseHandler));
    }

    @Override
    public void submitContactlessAIDList(Set<ApplicationIdentifier> contactlessApplicationIds, DeviceResponseHandler handler) {
        this.n = new ArrayList<ApplicationIdentifier>(contactlessApplicationIds);
        this.a(Command.SubmitContactlessAIDsList, handler);
    }

    @Override
    public void submitPublicKey(PublicKey publicKey, DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.SubmitPublicKey, this.a(publicKey), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void registerDeviceStatusHandler(DeviceStatusHandler handler) {
        this.currentDeviceStatusHandler = handler;
    }

    @Override
    public void setExpectedAmountDOL(List<Parameter> list) {
        this.amountDOL = list;
        this.amountDOL.remove((Object)Parameter.KSN);
        this.amountDOL.remove((Object)Parameter.EncryptedTrack);
    }

    @Override
    public void setExpectedOnlineDOL(List<Parameter> list) {
        this.onlineDOL = list;
        this.onlineDOL.remove((Object)Parameter.KSN);
        this.onlineDOL.remove((Object)Parameter.EncryptedTrack);
        if (DeviceType.RP350x == this.getType()) {
            this.onlineDOL.add(Parameter.KSN);
            this.onlineDOL.add(Parameter.EncryptedTrack);
        }
    }

    @Override
    public void setExpectedResponseDOL(List<Parameter> list) {
        this.responseDOL = list;
        this.responseDOL.remove((Object)Parameter.KSN);
        this.responseDOL.remove((Object)Parameter.EncryptedTrack);
        if (DeviceType.RP350x == this.getType()) {
            this.responseDOL.add(Parameter.KSN);
            this.responseDOL.add(Parameter.EncryptedTrack);
        }
    }

    @Override
    public void sendRawcommand(String command, DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.j(command, this.mTimeout).a(this.shouldSetupConnection(), this, new d(handler));
    }

    @Override
    public void getDeviceCapabilities(DeviceResponseHandler handler) {
        if (null != this.m) {
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.Command, (Object)Command.ReadCapabilities);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Success);
            enumMap.putAll(this.m);
            this.postResponseOnUiThread(handler, enumMap);
        } else {
            new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ReadCapabilities, this.getReadCapabilitiesCommand(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
        }
    }

    @Override
    public void readVersion(DeviceResponseHandler handler) {
        if (null != this.l) {
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.Command, (Object)Command.ReadVersion);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Success);
            enumMap.putAll(this.l);
            this.postResponseOnUiThread(handler, enumMap);
        } else {
            new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ReadVersion, this.n(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
        }
    }

    @Override
    public void readKeyMappingInfo(DeviceResponseHandler handler) {
        if (!this.supportsRKI()) {
            this.sendCommandNotSupportedError(Command.ReadKeyMappingInfo, handler);
            return;
        }
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ReadKeyMappingInfo, this.o(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void readCertificateFilesVersion(DeviceResponseHandler handler) {
        if (!this.supportsRKI()) {
            this.sendCommandNotSupportedError(Command.ReadCertificateFilesVersion, handler);
            return;
        }
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ReadCertificateFilesVersion, this.p(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void loadSessionKey(Integer keyLength, String sessionKeyLocator, String masterKeyLocator, String encryptedKey, String checkValue, String id, DeviceResponseHandler handler) {
        if (TextUtils.isEmpty((CharSequence)sessionKeyLocator) || 1 < keyLength || 0 > keyLength || TextUtils.isEmpty((CharSequence)masterKeyLocator) || TextUtils.isEmpty((CharSequence)encryptedKey) || 1 == keyLength && TextUtils.isEmpty((CharSequence)checkValue)) {
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.Command, (Object)Command.LoadSessionKey);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.InvalidParameters);
            this.postResponseOnUiThread(handler, enumMap);
            return;
        }
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.LoadSessionKey, this.a(keyLength, sessionKeyLocator, masterKeyLocator, encryptedKey, checkValue, id), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void sendCommand(Map<Parameter, Object> input, DeviceResponseHandler handler) {
        LogUtils.write(a, "sendCommand");
        Parameter parameter = com.roam.roamreaderunifiedapi.emvreaders.p.a(input);
        Command command = (Command)((Object)input.get((Object)Parameter.Command));
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        if (parameter != null) {
            enumMap.put(Parameter.Command, (Object)command);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.MISSING_MANDATORY_PARAMETERS);
            enumMap.put(Parameter.ErrorDetails, "Missing mandatory paramerter " + parameter.toString());
            this.postResponseOnUiThread(handler, enumMap);
        } else {
            switch (command) {
                case EMVStartTransaction: {
                    this.canCallCancelWait = true;
                    this.k = null;
                    new com.roam.roamreaderunifiedapi.emvreaders.g(command, this.b(input), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
                    break;
                }
                case EMVTransactionData: {
                    new com.roam.roamreaderunifiedapi.emvreaders.g(command, this.b(input), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
                    break;
                }
                case EMVCompleteTransaction: {
                    new com.roam.roamreaderunifiedapi.emvreaders.g(command, this.b(input), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
                    break;
                }
                case EMVTransactionStop: {
                    if (this.getType() == DeviceType.RP350x && this.c != null) {
                        this.c = null;
                        this.d = null;
                    }
                    new com.roam.roamreaderunifiedapi.emvreaders.g(command, this.c(input), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
                    break;
                }
                case EMVFinalApplicationSelection: {
                    if (this.getType() == DeviceType.RP350x && this.c != null && input.containsKey((Object)Parameter.ApplicationIdentifier) && input.get((Object)Parameter.ApplicationIdentifier).toString().equals(this.d)) {
                        d d2 = new d(handler);
                        d2.a(command, (String)null);
                        d2.a(Command.EMVFinalApplicationSelection, ProgressMessage.ApplicationSelectionCompleted, "C002");
                        d2.a(Command.EMVFinalApplicationSelection, this.c);
                        this.c = null;
                        this.d = null;
                        return;
                    }
                    new com.roam.roamreaderunifiedapi.emvreaders.g(command, this.a(input), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
                    break;
                }
            }
        }
    }

    @Override
    public void stopWaitingForMagneticCardSwipe() {
        this.j();
    }

    @Override
    public void cancelLastCommand() {
        this.j();
    }

    private void j() {
        LogUtils.write(a, "cancelWait");
        if (this.canCallCancelWait) {
            if (this.mCommManager != null) {
                this.mCommManager.cancelExchange();
                this.r = true;
            }
        } else {
            LogUtils.write(a, "Cannot cancel at this point");
        }
    }

    @Override
    public void waitForMagneticCardSwipe(DeviceResponseHandler handler) {
        LogUtils.write(a, "startMagStripeTransaction");
        this.canCallCancelWait = true;
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.WaitForMagneticCardSwipe, this.getReadMagStripeCommand(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void waitForCardRemoval(Integer cardRemovalTimeout, DeviceResponseHandler handler) {
        if (null == cardRemovalTimeout || cardRemovalTimeout * 1000 > 65535) {
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.Command, (Object)Command.WaitForCardRemoval);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.InvalidParameters);
            this.postResponseOnUiThread(handler, enumMap);
            return;
        }
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.WaitForCardRemoval, this.c(cardRemovalTimeout * 1000), cardRemovalTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void getVasVersion(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.GetVasVersion, this.s(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void getVasMerchantCount(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.GetVasMerchantCount, this.t(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void clearVasMerchants(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ClearVasMerchants, this.u(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void getVasErrorMessage(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.GetVasErrorMessage, this.v(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void activateVasExchangedMessageLog(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ActivateVasExchangedMessageLog, this.w(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void deactivateVasExchangedMessageLog(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.DeactivateVasExchangedMessageLog, this.x(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void getVasExchangedMessageLog(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.GetVasExchangedMessageLog, this.y(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void enableVasMode(VasMode vasMode, DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.EnableVasMode, this.a(vasMode), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void enableVasPlseState(Boolean isEnabled, DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.EnableVasPlseState, this.a(isEnabled), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void getVasDataForMerchant(Integer merchantIndex, DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.GetVasDataForMerchant, this.d(merchantIndex), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void setVasApplicationVersion(String applicationVersion, DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.SetVasApplicationVersion, this.b(applicationVersion), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void setVasUnpredictableNumber(String unpredictableNumber, DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.SetVasUnpredictableNumber, this.a(unpredictableNumber), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void enableVasModeForMerchant(VasMode vasMode, String merchantId, DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.EnableVasModeForMerchant, this.a(vasMode, merchantId), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void addVasMerchant(VasMode vasMode, String merchantId, String merchantUrl, String categoryFilter, DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.AddVasMerchant, this.a(vasMode, merchantId, merchantUrl, categoryFilter), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void getFirmwareChecksumInfo(FirmwareChecksumType type, DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.GetFirmwareChecksumInfo, this.a(type), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void configureBeep(Boolean disableReadMagneticCardBeep, Boolean disableRemoveCardBeep, Boolean disableEMVStartTransactionBeep, DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ConfigureBeep, this.a(disableReadMagneticCardBeep, disableRemoveCardBeep, disableEMVStartTransactionBeep), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void setFirmwareVersion(FirmwareComponentType type, String version, DeviceResponseHandler handler) {
        if (version != null && version.length() > 10) {
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.Command, (Object)Command.SetFirmwareVersion);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.InvalidParameters);
            this.postResponseOnUiThread(handler, enumMap);
        } else {
            new com.roam.roamreaderunifiedapi.emvreaders.g(Command.SetFirmwareVersion, this.a(type, version), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
        }
    }

    @Override
    public void getFirmwareVersion(FirmwareComponentType type, DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.GetFirmwareVersion, this.a(type), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void enableRkiMode(DeviceResponseHandler handler) {
        if (!this.supportsRKI()) {
            this.sendCommandNotSupportedError(Command.EnableRkiMode, handler);
            return;
        }
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.EnableRkiMode, this.z(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void triggerRki(String deviceGroupName, DeviceResponseHandler handler) {
        if (!this.supportsRKI()) {
            this.sendCommandNotSupportedError(Command.TriggerRki, handler);
            return;
        }
        if (this.isRkiModeEnabled) {
            this.startTriggerRkiTask(deviceGroupName, handler);
        } else {
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.Command, (Object)Command.TriggerRki);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.RkiModeNotEnabled);
            this.postResponseOnUiThread(handler, enumMap);
        }
    }

    private void a(Command command, EnumMap<Parameter, Object> enumMap, DeviceResponseHandler deviceResponseHandler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.EncryptedDataStatus, this.m(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(command, enumMap, deviceResponseHandler));
    }

    private boolean a(EnumMap<Parameter, Object> enumMap) {
        return enumMap.containsKey((Object)Parameter.KSN);
    }

    private com.roam.roamreaderunifiedapi.emvreaders.f b(EnumMap<Parameter, Object> enumMap) {
        return new com.roam.roamreaderunifiedapi.emvreaders.f((String)enumMap.get((Object)Parameter.KSN), (String)enumMap.get((Object)Parameter.EncryptedTrack));
    }

    @Override
    protected void postDeviceStatusOnStatusHandler(DeviceStatusHandler statusHandler, boolean connected, String errorMessage) {
        this.a();
        super.postDeviceStatusOnStatusHandler(statusHandler, connected, errorMessage);
    }

    protected void raiseVolume() {
        AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
        int n2 = audioManager.getStreamMaxVolume(3);
        int n3 = audioManager.getStreamVolume(3);
        int n4 = n2 - n3;
        for (int i2 = 0; i2 < n4; ++i2) {
            audioManager.adjustStreamVolume(3, 1, 16);
        }
    }

    protected String getActivatedDeviceIdentifier() {
        return this.e != null ? this.e.getIdentifier() : null;
    }

    private String k() {
        return "FF810100000000";
    }

    protected String getBatteryStatusCommand() {
        return "FF88000000";
    }

    protected String getBatteryLevelWithChargingStatusCommand() {
        return "FF88000100";
    }

    protected String getDeviceStatisticsCommand() {
        return "FF88010000";
    }

    private String l() {
        return "FF810400000000";
    }

    protected String getConfigureDOLListCommand(Command cmd, List<Parameter> dols) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder.append("FF8107");
        for (Parameter parameter : dols) {
            stringBuilder2.append(parameter.getTagString());
            if (parameter.getMaxLength() > 255) {
                stringBuilder2.append("FF");
                continue;
            }
            stringBuilder2.append(String.format("%02X", parameter.getMaxLength()));
        }
        switch (cmd) {
            case ConfigureAmountDOLData: {
                stringBuilder.append("00");
                break;
            }
            case ConfigureOnlineDOLData: {
                stringBuilder.append("01");
                break;
            }
            case ConfigureResponseDOLData: {
                stringBuilder.append("02");
                break;
            }
            case ConfigureContactlessResponseDOLData: {
                stringBuilder.append("03");
                break;
            }
            case ConfigureContactlessOnlineDOLData: {
                stringBuilder.append("04");
                break;
            }
            default: {
                return null;
            }
        }
        stringBuilder.append(String.format("%04X", stringBuilder2.length() / 2));
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("00");
        LogUtils.write(a, "getConfigureDOLListCommand::" + stringBuilder.toString());
        return stringBuilder.toString();
    }

    private String m() {
        return "FF84000000";
    }

    private String a(Map<Parameter, Object> map) {
        String string = (String)map.get((Object)Parameter.ApplicationIdentifier);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FF811200");
        stringBuilder.append(String.format("%04X", string.length() / 2));
        stringBuilder.append(string);
        stringBuilder.append("00");
        return stringBuilder.toString();
    }

    protected String getGenerateBeepCommand() {
        return "FF0A000000";
    }

    protected String getReadCapabilitiesCommand() {
        return "FF00020000";
    }

    protected String getReadMagStripeCommand() {
        return "FF03020003FFFF0000";
    }

    private String n() {
        return "FF00010000";
    }

    private String o() {
        return "FF870000000330303000";
    }

    private String p() {
        return "FF88050000";
    }

    private String q() {
        return "FF00000000";
    }

    private String r() {
        return "FF8500050008000000010000000000";
    }

    protected String getEnableContactlessCommand(boolean enable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FF8802");
        if (enable) {
            stringBuilder.append("01");
        } else {
            stringBuilder.append("00");
        }
        stringBuilder.append("00");
        return stringBuilder.toString();
    }

    protected String getEnableFirmwareUpdateCommand() {
        return "FF89020000";
    }

    private String a(Command command, List<ApplicationIdentifier> list) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder.append("FF8100");
        if (command == Command.SubmitContactlessAIDsList) {
            stringBuilder.append("02");
        } else if (command == Command.SubmitAIDsWithTLVDataList) {
            stringBuilder.append("03");
        } else {
            stringBuilder.append("00");
        }
        int n2 = list.size();
        stringBuilder2.append(String.format("%02X", n2));
        for (ApplicationIdentifier applicationIdentifier : list) {
            stringBuilder2.append(applicationIdentifier.getFormattedString());
        }
        stringBuilder.append(String.format("%04X", stringBuilder2.length() / 2));
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("00");
        return stringBuilder.toString();
    }

    private String a(PublicKey publicKey) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = publicKey.getFormattedString();
        stringBuilder.append("FF810200");
        stringBuilder.append(String.format("%04X", string.length() / 2));
        stringBuilder.append(string);
        stringBuilder.append("00");
        return stringBuilder.toString();
    }

    private String b(PublicKey publicKey) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = publicKey.getRID() + publicKey.getCAPublicKeyIndex();
        stringBuilder.append("FF810300");
        stringBuilder.append(String.format("%04X", string.length() / 2));
        stringBuilder.append(string);
        stringBuilder.append("00");
        return stringBuilder.toString();
    }

    private String b(Map<Parameter, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        Command command = (Command)((Object)map.get((Object)Parameter.Command));
        Set<com.roam.roamreaderunifiedapi.emvreaders.e> set = com.roam.roamreaderunifiedapi.emvreaders.p.a(command);
        String string = "00";
        if (map.containsKey((Object)Parameter.P2Field) && null != map.get((Object)Parameter.P2Field)) {
            string = map.get((Object)Parameter.P2Field).toString();
        }
        switch (command) {
            case EMVStartTransaction: {
                stringBuilder.append("FF8110").append(string);
                break;
            }
            case EMVTransactionData: {
                stringBuilder.append("FF811300");
                break;
            }
            case EMVCompleteTransaction: {
                stringBuilder.append("FF811500");
                if (this.getType() == DeviceType.RP350x && map.containsKey((Object)Parameter.ResultofOnlineProcess) && map.get((Object)Parameter.ResultofOnlineProcess).equals("01") && !map.containsKey((Object)Parameter.AuthorizationCode)) {
                    map.put(Parameter.AuthorizationCode, "123456");
                }
                if (this.getType() != DeviceType.RP350x || !map.containsKey((Object)Parameter.AuthorizationResponseCode) || !map.get((Object)Parameter.AuthorizationResponseCode).equals("3130")) break;
                map.put(Parameter.AuthorizationResponseCode, "3030");
                break;
            }
            default: {
                return null;
            }
        }
        for (com.roam.roamreaderunifiedapi.emvreaders.e e2 : set) {
            Parameter parameter = e2.a();
            Object object = map.get((Object)parameter);
            if (parameter == null || parameter == Parameter.Command || parameter == Parameter.P2Field || object == null) continue;
            stringBuilder2.append(parameter.getTagString());
            int n2 = object.toString().length() / 2;
            if (n2 > 255) {
                stringBuilder2.append(String.format("%04X", n2));
            } else {
                stringBuilder2.append(String.format("%02X", n2));
            }
            stringBuilder2.append(object);
        }
        stringBuilder.append(String.format("%04X", stringBuilder2.length() / 2));
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("00");
        LogUtils.write(a, "getTransactionCommand::" + command.toString() + "::" + stringBuilder.toString());
        return stringBuilder.toString();
    }

    private String c(Map<Parameter, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        Command command = (Command)((Object)map.get((Object)Parameter.Command));
        stringBuilder.append("FF811600");
        Set<com.roam.roamreaderunifiedapi.emvreaders.e> set = com.roam.roamreaderunifiedapi.emvreaders.p.a(command);
        for (com.roam.roamreaderunifiedapi.emvreaders.e e2 : set) {
            Parameter parameter = e2.a();
            Object object = map.get((Object)parameter);
            if (parameter == null || parameter == Parameter.Command || object == null) continue;
            stringBuilder2.append(parameter.getTagString());
            int n2 = object.toString().length() / 2;
            if (n2 > 127) {
                stringBuilder2.append(String.format("%04X", n2));
            } else {
                stringBuilder2.append(String.format("%02X", n2));
            }
            stringBuilder2.append(object);
        }
        stringBuilder.append(String.format("%04X", stringBuilder2.length() / 2));
        if (stringBuilder2.length() > 0) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append("00");
        LogUtils.write(a, "getTransactionStopCommand::" + stringBuilder.toString());
        return stringBuilder.toString();
    }

    private String a(int n2, String string, String string2, String string3, String string4, String string5) {
        StringBuilder stringBuilder = new StringBuilder("FF8701");
        String string6 = null;
        if (TextUtils.isEmpty((CharSequence)string5)) {
            string5 = "00000000";
        }
        if (n2 == 0) {
            string6 = String.format("%s00000000%s00000000%s%s", string, string2, string3, string5);
        } else if (n2 == 1) {
            string6 = String.format("%s00000000%s00000000%s%s%s", string, string2, string3, string4, string5);
        }
        stringBuilder.append(String.format("%02X%04X%s00", n2, string6.length() / 2, string6));
        return stringBuilder.toString();
    }

    private String a(int n2) {
        if (n2 > 255) {
            return String.format("FF88040002%04X00", n2);
        }
        return String.format("FF88040001%02X00", n2);
    }

    private String b(int n2) {
        return String.format("FF88040101%02X00", n2);
    }

    private String c(int n2) {
        if (n2 != 0) {
            return String.format("FF01020002%04X00", n2);
        }
        return String.format("FF01020002%04X00", 65535);
    }

    private String s() {
        return "FF900000000000";
    }

    private String t() {
        return "FF900200000000";
    }

    private String u() {
        return "FF900500000000";
    }

    private String v() {
        return "FF900900000000";
    }

    private String w() {
        return "FF900D00000000";
    }

    private String x() {
        return "FF900E00000000";
    }

    private String y() {
        return "FF900F00000000";
    }

    private String d(int n2) {
        return String.format("FF9008000001%02X00", n2);
    }

    private String a(Boolean bl) {
        return String.format("FF900A000001%02X00", bl != false ? 1 : 0);
    }

    private String a(VasMode vasMode) {
        StringBuilder stringBuilder = new StringBuilder("FF9001000001");
        switch (vasMode) {
            case VASOnly: {
                stringBuilder.append("00");
                break;
            }
            case DualMode: {
                stringBuilder.append("01");
                break;
            }
            case PayOnly: {
                stringBuilder.append("02");
                break;
            }
            case SignUp: {
                stringBuilder.append("03");
                break;
            }
            case Single: {
                stringBuilder.append("04");
                break;
            }
        }
        stringBuilder.append("00");
        return stringBuilder.toString();
    }

    private String a(String string) {
        String string2 = HexUtils.convertASCII2HexaDecimal(string);
        int n2 = string2.length() / 2;
        int n3 = 1 + n2;
        StringBuilder stringBuilder = new StringBuilder("FF900B00");
        stringBuilder.append(String.format("%04X", n3));
        stringBuilder.append(String.format("%02X", n2));
        stringBuilder.append(string2);
        stringBuilder.append("00");
        return stringBuilder.toString();
    }

    private String b(String string) {
        String string2 = HexUtils.convertASCII2HexaDecimal(string);
        int n2 = string2.length() / 2;
        int n3 = 1 + n2;
        StringBuilder stringBuilder = new StringBuilder("FF900C00");
        stringBuilder.append(String.format("%04X", n3));
        stringBuilder.append(String.format("%02X", n2));
        stringBuilder.append(string2);
        stringBuilder.append("00");
        return stringBuilder.toString();
    }

    private String a(VasMode vasMode, String string) {
        StringBuilder stringBuilder = new StringBuilder("FF900300");
        String string2 = HexUtils.convertASCII2HexaDecimal(string);
        int n2 = string2.length() / 2;
        int n3 = 2 + n2;
        stringBuilder.append(String.format("%04X", n3));
        switch (vasMode) {
            case VASOnly: {
                stringBuilder.append("00");
                break;
            }
            case DualMode: {
                stringBuilder.append("01");
                break;
            }
            case PayOnly: {
                stringBuilder.append("02");
                break;
            }
            case SignUp: {
                stringBuilder.append("03");
                break;
            }
            case Single: {
                stringBuilder.append("04");
                break;
            }
        }
        stringBuilder.append(String.format("%02X", n2));
        stringBuilder.append(string2);
        stringBuilder.append("00");
        return stringBuilder.toString();
    }

    private String a(VasMode vasMode, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder("FF900400");
        String string4 = HexUtils.convertASCII2HexaDecimal(string);
        String string5 = HexUtils.convertASCII2HexaDecimal(string2);
        String string6 = HexUtils.convertASCII2HexaDecimal(string3);
        int n2 = string4.length() / 2;
        int n3 = string5.length() / 2;
        int n4 = string6.length() / 2;
        int n5 = 2 + n2 + 1 + n3 + 1 + n4;
        stringBuilder.append(String.format("%04X", n5));
        switch (vasMode) {
            case VASOnly: {
                stringBuilder.append("00");
                break;
            }
            case DualMode: {
                stringBuilder.append("01");
                break;
            }
            case PayOnly: {
                stringBuilder.append("02");
                break;
            }
            case SignUp: {
                stringBuilder.append("03");
                break;
            }
            case Single: {
                stringBuilder.append("04");
                break;
            }
        }
        stringBuilder.append(String.format("%02X", n2));
        stringBuilder.append(string4);
        stringBuilder.append(String.format("%02X", n3));
        stringBuilder.append(string5);
        stringBuilder.append(String.format("%02X", n4));
        stringBuilder.append(string6);
        stringBuilder.append("00");
        return stringBuilder.toString();
    }

    private String z() {
        return "FF89000000";
    }

    private String a(FirmwareChecksumType firmwareChecksumType) {
        if (firmwareChecksumType == FirmwareChecksumType.StaticSoftware) {
            return "FF88090600";
        }
        return "FF88090700";
    }

    private String a(Boolean bl, Boolean bl2, Boolean bl3) {
        String string = "FF88070001";
        int n2 = 0;
        if (bl.booleanValue()) {
            n2 |= 8;
        }
        if (bl2.booleanValue()) {
            n2 |= 4;
        }
        if (bl3.booleanValue()) {
            n2 |= 2;
        }
        string = string.concat(String.format("%02X", n2));
        string = string.concat("00");
        return string;
    }

    private String a(FirmwareComponentType firmwareComponentType, String string) {
        StringBuilder stringBuilder = new StringBuilder("FF8809");
        switch (firmwareComponentType) {
            case Overall: {
                stringBuilder.append("00");
                break;
            }
            case StaticSoftware: {
                stringBuilder.append("01");
                break;
            }
            case DynamicConfiguration: {
                stringBuilder.append("02");
            }
        }
        stringBuilder.append("0A");
        stringBuilder.append(HexUtils.convertASCII2HexaDecimal(string));
        int n2 = 10 - string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append("20");
        }
        stringBuilder.append("00");
        return stringBuilder.toString();
    }

    private String a(FirmwareComponentType firmwareComponentType) {
        StringBuilder stringBuilder = new StringBuilder("FF8809");
        switch (firmwareComponentType) {
            case Overall: {
                stringBuilder.append("03");
                break;
            }
            case StaticSoftware: {
                stringBuilder.append("04");
                break;
            }
            case DynamicConfiguration: {
                stringBuilder.append("05");
            }
        }
        stringBuilder.append("00");
        return stringBuilder.toString();
    }

    private int a(byte[] byArray, int n2, EnumMap<Parameter, Object> enumMap) {
        int n3 = n2;
        try {
            byte by = byArray[n3];
            boolean bl = byArray[++n3] == 0 && byArray[n3 + 1] == 0;
            int n4 = 256 * byArray[n3 += 2] + byArray[n3 + 1];
            if (bl && n4 > 0 && n4 + (n3 += 2) <= byArray.length) {
                byte[] byArray2 = new byte[n4];
                System.arraycopy(byArray, n3, byArray2, 0, n4);
                switch (by) {
                    case 1: {
                        enumMap.put(Parameter.Track1Data, (Object)com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray2));
                        break;
                    }
                    case 2: {
                        enumMap.put(Parameter.Track2Data, (Object)com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray2));
                        break;
                    }
                    case 3: {
                        enumMap.put(Parameter.Track3Data, (Object)com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray2));
                        break;
                    }
                    case 4: {
                        enumMap.put(Parameter.VirtualTrackData, (Object)com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray2));
                        break;
                    }
                    case 5: {
                        enumMap.put(Parameter.VirtualTrack5Data, (Object)com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray2));
                    }
                    default: {
                        n3 = byArray.length;
                    }
                }
                n3 += n4;
            } else if (by < 1 || by > 4) {
                n3 = byArray.length;
            }
        }
        catch (Exception exception) {
            LogUtils.write("Exception", exception.getMessage());
            n3 = byArray.length;
        }
        return n3;
    }

    private EnumMap<Parameter, Object> a(byte[] byArray) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        int n2 = 1;
        try {
            int n3 = byArray.length;
            while (n2 < n3) {
                n2 = this.a(byArray, n2, enumMap);
            }
            int n4 = this.a(byArray, new byte[]{-33, -126, 37});
            if (-1 != n4) {
                n2 = n4 + 3;
                int n5 = byArray[n2];
                byte[] byArray2 = new byte[n5];
                System.arraycopy(byArray, ++n2, byArray2, 0, n5);
                enumMap.put(Parameter.KSN, (Object)new String(byArray2, "UTF-8").substring(0, 20));
                n2 += n5;
                n2 += 3;
                n5 = byArray[n2++];
                if ((n5 & 0x80) > 0) {
                    int n6 = 0x7F & n5;
                    byte[] byArray3 = new byte[n6];
                    System.arraycopy(byArray, n2, byArray3, 0, n6);
                    n5 = HexUtils.byteArrayToInt(byArray3);
                    n2 += n6;
                }
                byte[] byArray4 = new byte[n5];
                System.arraycopy(byArray, n2, byArray4, 0, n5);
                enumMap.put(Parameter.EncryptedTrack, (Object)com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray4));
            }
            enumMap.put(Parameter.CardType, (Object)CardType.MagneticStripe);
            this.c(enumMap);
        }
        catch (Exception exception) {
            LogUtils.write(a, exception);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
        }
        return enumMap;
    }

    private EnumMap<Parameter, Object> b(byte[] byArray) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        enumMap.put(Parameter.FormatID, "77");
        if (byArray != null) {
            int n2 = 3;
            int n3 = 4;
            boolean bl = true;
            int n4 = 4;
            int n5 = byArray.length - 3 - 1;
            if (n5 >= 0) {
                byte[] byArray2 = new byte[4];
                byte[] byArray3 = new byte[4];
                int n6 = 0;
                while (n6 <= n5) {
                    System.arraycopy(byArray, n6, byArray2, 1, 3);
                    int n7 = new BigInteger(byArray2).intValue();
                    System.arraycopy(byArray, n6 += 3, byArray3, 3, 1);
                    int n8 = new BigInteger(byArray3).intValue();
                    byte[] byArray4 = new byte[n8];
                    System.arraycopy(byArray, ++n6, byArray4, 0, n8);
                    n6 += n8;
                    try {
                        if (Parameter.RoamEncryptedEMVdata.getTag() == (long)n7) {
                            enumMap.put(Parameter.RoamEncryptedEMVdata, (Object)com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray4));
                            continue;
                        }
                        if (Parameter.KSN.getTag() == (long)n7) {
                            enumMap.put(Parameter.KSN, (Object)new String(byArray4, "UTF-8"));
                            continue;
                        }
                        if (Parameter.ManuallyEnteredPAN.getTag() == (long)n7) {
                            enumMap.put(Parameter.ManuallyEnteredPAN, (Object)new String(byArray4, "UTF-8"));
                            continue;
                        }
                        if (Parameter.ManuallyEnteredExpiryDate.getTag() != (long)n7) continue;
                        enumMap.put(Parameter.ManuallyEnteredExpiryDate, (Object)new String(byArray4, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        LogUtils.write(a, unsupportedEncodingException);
                    }
                }
                if (enumMap.containsKey((Object)Parameter.RoamEncryptedEMVdata)) {
                    this.d(enumMap);
                }
            }
        }
        return enumMap;
    }

    private int a(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length - byArray2.length + 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl = true;
            int n3 = byArray2.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (byArray[i2 + i3] == byArray2[i3]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i2;
        }
        return -1;
    }

    protected EnumMap<Parameter, Object> parseReadMagneticCardDataCommandResponse(byte[] response) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        int n2 = 0;
        try {
            int n3 = response.length;
            if (response[n2] == 0) {
                int n4;
                int n5 = 256 * response[++n2] + response[n2 + 1];
                n2 += 2;
                byte[] byArray = new byte[n5];
                for (n4 = 0; n4 < n5; ++n4) {
                    byArray[n4] = (byte)(response[n2 + n4] + 32);
                }
                enumMap.put(Parameter.Track1Data, (Object)com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray));
                if ((n2 += n5) < n3 && response[n2] == 0) {
                    n5 = 256 * response[++n2] + response[n2 + 1];
                    n2 += 2;
                    byArray = new byte[n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        byArray[n4] = (byte)(response[n2 + n4] + 48);
                    }
                    enumMap.put(Parameter.Track2Data, (Object)com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray));
                    if ((n2 += n5) < n3 && response[n2] == 0) {
                        n5 = 256 * response[++n2] + response[n2 + 1];
                        n2 += 2;
                        byArray = new byte[n5];
                        for (n4 = 0; n4 < n5; ++n4) {
                            byArray[n4] = (byte)(response[n2 + n4] + 48);
                        }
                        enumMap.put(Parameter.Track3Data, (Object)com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray));
                        if ((n2 += n5) < n3 && response[n2] == 0) {
                            n5 = 256 * response[++n2] + response[n2 + 1];
                            byArray = new byte[n5];
                            System.arraycopy(response, n2 += 2, byArray, 0, n5);
                            enumMap.put(Parameter.VirtualTrackData, (Object)com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray));
                        }
                    }
                }
            } else {
                enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.TRACK_READ_ERROR);
            }
            enumMap.put(Parameter.FormatID, (Object)"97");
            enumMap.put(Parameter.CardType, (Object)CardType.MagneticStripe);
            this.c(enumMap);
        }
        catch (Exception exception) {
            LogUtils.write(a, exception);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
        }
        return enumMap;
    }

    private boolean a(List<Parameter> list, EnumMap<Parameter, Object> enumMap) {
        if (list.contains((Object)Parameter.KSN) && list.contains((Object)Parameter.EncryptedTrack)) {
            for (Parameter parameter : list) {
                if (Parameter.KSN == parameter || Parameter.EncryptedTrack == parameter || enumMap.containsKey((Object)parameter)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private EnumMap<Parameter, Object> a(List<Parameter> list, byte[] byArray) {
        return this.a(list, byArray, true);
    }

    private EnumMap<Parameter, Object> b(List<Parameter> list, byte[] byArray) {
        return this.a(list, byArray, false);
    }

    private EnumMap<Parameter, Object> a(List<Parameter> list, byte[] byArray, boolean bl) {
        EnumMap<Parameter, Object> enumMap;
        block14: {
            enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 1;
            try {
                for (Parameter parameter : list) {
                    int n3;
                    LogUtils.write("LandiReader", "parsing param " + parameter.toString());
                    if (bl || parameter.isProprietary() || parameter.isVariableLength() && parameter.getTagValueFormat() == ValueFormat.BINARY) {
                        n3 = byArray[n2] << 8 | byArray[n2 + 1] & 0xFF;
                        n2 += 2;
                        if (n3 == 0 || n3 >= parameter.getMinLength() && n3 <= parameter.getMaxLength()) {
                            LogUtils.write("LandiReader", "param variableLength:: " + n3);
                        } else {
                            LogUtils.write("LandiReader", "param length is inconsistent");
                        }
                    } else {
                        n3 = parameter.getMaxLength();
                        LogUtils.write("LandiReader", "param isFixedLength:: " + n3);
                    }
                    if (n3 > 0) {
                        String string;
                        String string2;
                        byte[] byArray2 = new byte[n3];
                        System.arraycopy(byArray, n2, byArray2, 0, n3);
                        if (parameter.getTagValueFormat() == ValueFormat.ALPHABETIC || parameter.getTagValueFormat() == ValueFormat.ALPHANUMERIC || parameter.getTagValueFormat() == ValueFormat.ALPHANUMERIC_SPECIALCHARACTERS) {
                            byte[] byArray3 = com.roam.roamreaderunifiedapi.emvreaders.d.c(byArray2);
                            if (byArray3 != null) {
                                string2 = this.c(new String(byArray3, "UTF-8"));
                                string = com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray3);
                            } else {
                                string2 = "";
                                string = com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray2);
                            }
                        } else {
                            string = string2 = com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray2);
                        }
                        LogUtils.write("LandiReader", "tag-" + parameter.toString() + "::value-" + string2);
                        if (this.a(parameter, string)) {
                            enumMap.put(parameter, (Object)string2);
                        }
                        n2 += n3;
                        if (parameter.isProprietary() || !this.a(parameter, string)) continue;
                        if (n3 > 255) {
                            stringBuilder.append(String.format("%s%04X%s", parameter.getTagString(), string.length() / 2, string));
                            continue;
                        }
                        stringBuilder.append(String.format("%s%02X%s", parameter.getTagString(), string.length() / 2, string));
                        continue;
                    }
                    enumMap.put(parameter, (Object)"");
                }
                enumMap.put(Parameter.EMVTLVData, (Object)stringBuilder.toString());
                LogUtils.write("LandiReader", "input length" + byArray.length + " currIndex " + n2);
            }
            catch (Exception exception) {
                if (this.a(list, enumMap)) break block14;
                LogUtils.write(a, exception);
                enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.InvalidCommandResponse);
            }
        }
        this.c(enumMap);
        return enumMap;
    }

    private boolean a(Parameter parameter, String string) {
        switch (parameter) {
            case PANSequenceNumber: {
                return !string.matches("^[F]*$");
            }
        }
        return true;
    }

    private String c(String string) {
        if (null == string) {
            return null;
        }
        return string.replaceAll("[^\\x00-\\x7F]", "").trim();
    }

    private String a(List<ApplicationIdentifier> list) {
        for (ApplicationIdentifier applicationIdentifier : list) {
            for (ApplicationIdentifier applicationIdentifier2 : b) {
                if (!applicationIdentifier2.getAID().equals(applicationIdentifier.getAID())) continue;
                return applicationIdentifier2.getAID();
            }
        }
        return null;
    }

    private List<ApplicationIdentifier> c(byte[] byArray) {
        ArrayList<ApplicationIdentifier> arrayList = new ArrayList<ApplicationIdentifier>();
        int n2 = 1;
        try {
            int n3 = byArray[n2];
            ++n2;
            for (int i2 = 0; i2 < n3; ++i2) {
                byte by = byArray[n2];
                byte[] byArray2 = new byte[by];
                System.arraycopy(byArray, ++n2, byArray2, 0, by);
                String string = com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray2);
                n2 += by;
                by = byArray[n2];
                byArray2 = new byte[by];
                System.arraycopy(byArray, ++n2, byArray2, 0, by);
                String string2 = new String(byArray2, "UTF-8");
                String string3 = String.format("%02X", 0xFF & byArray[n2 += by]);
                ++n2;
                arrayList.add(new ApplicationIdentifier(string, string3, string2));
            }
        }
        catch (Exception exception) {
            LogUtils.write(a, exception);
        }
        return arrayList;
    }

    private EnumMap<Parameter, Object> d(byte[] byArray) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        try {
            int n2 = 0;
            byte by = byArray[n2];
            byte[] byArray2 = new byte[by];
            System.arraycopy(byArray, ++n2, byArray2, 0, by);
            n2 += by;
            by = byArray[n2];
            byte[] byArray3 = new byte[by];
            System.arraycopy(byArray, ++n2, byArray3, 0, by);
            n2 += by;
            by = byArray[n2];
            byte[] byArray4 = new byte[by];
            System.arraycopy(byArray, ++n2, byArray4, 0, by);
            n2 += by;
            enumMap.put(Parameter.VasData, (Object)new VasData(this.c(new String(byArray2, "UTF-8")), this.c(new String(byArray3, "UTF-8")), this.c(new String(byArray4, "UTF-8"))));
        }
        catch (Exception exception) {
            LogUtils.write(a, exception);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
        }
        return enumMap;
    }

    protected EnumMap<Parameter, Object> parseEncryptedDataStatusCommandResponse(byte[] response) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        try {
            byte[] byArray = new byte[41];
            int n2 = 0;
            System.arraycopy(response, n2 += 2, byArray, 0, 41);
            if (response[0] == 2) {
                enumMap.put(Parameter.KSN, (Object)new String(byArray, "UTF-8").substring(0, 20));
                n2 += 41;
                n2 += 3;
                int n3 = response[n2++];
                if ((n3 & 0x80) > 0) {
                    int n4 = 0x7F & n3;
                    byte[] byArray2 = new byte[n4];
                    System.arraycopy(response, n2, byArray2, 0, n4);
                    n3 = HexUtils.byteArrayToInt(byArray2);
                    n2 += n4;
                }
                byte[] byArray3 = new byte[n3];
                System.arraycopy(response, n2, byArray3, 0, n3);
                enumMap.put(Parameter.EncryptedTrack, (Object)com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray3));
            } else if (response[0] == 1) {
                enumMap.put(Parameter.KSN, (Object)this.c(new String(byArray, "UTF-8")));
            }
        }
        catch (Exception exception) {
            LogUtils.write(a, exception);
        }
        return enumMap;
    }

    private EnumMap<Parameter, Object> d(String string) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        int n2 = string.length();
        if (n2 < 36) {
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.InvalidCommandResponse);
        } else {
            enumMap.put(Parameter.EncryptedIsoPinBlock, string.substring(0, 16));
            enumMap.put(Parameter.KSN, (Object)string.substring(16, 36));
            if (n2 > 36) {
                enumMap.put(Parameter.MACData, (Object)string.substring(37));
            }
        }
        return enumMap;
    }

    private EnumMap<Parameter, Object> e(String string) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        int n2 = string.length();
        if (n2 < 16) {
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.InvalidCommandResponse);
        } else {
            enumMap.put(Parameter.EncryptedIsoPinBlock, string);
        }
        return enumMap;
    }

    private EnumMap<Parameter, Object> a(Command command, List<Parameter> list, List<Parameter> list2, List<Parameter> list3, List<Parameter> list4, List<Parameter> list5, byte[] byArray) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        try {
            ResponseType responseType = ResponseType.UNKNOWN;
            CardType cardType = CardType.ContactEMV;
            if (null != byArray && 0 < byArray.length) {
                switch (command) {
                    case EMVStartTransaction: {
                        if (byArray[0] == 0) {
                            responseType = ResponseType.CONTACT_AMOUNT_DOL;
                            enumMap.put(Parameter.FormatID, (Object)"77");
                            enumMap.putAll(this.b(list, byArray));
                        } else if (byArray[0] == 1) {
                            responseType = ResponseType.LIST_OF_AIDS;
                            enumMap.put(Parameter.ListOfApplicationIdentifiers, this.c(byArray));
                        } else if (byArray[0] == 2) {
                            responseType = ResponseType.MAGNETIC_CARD_DATA;
                            cardType = CardType.MagneticStripe;
                            enumMap.put(Parameter.FormatID, (Object)"77");
                            enumMap.putAll(this.a(byArray));
                        } else if (byArray[0] == 3) {
                            responseType = ResponseType.CONTACTLESS_RESPONSE_DOL;
                            cardType = CardType.ContactlessEMV;
                            enumMap.put(Parameter.FormatID, (Object)"77");
                            enumMap.putAll(this.a(list4, byArray));
                        } else if (byArray[0] == 4) {
                            responseType = ResponseType.CONTACTLESS_ONLINE_DOL;
                            cardType = CardType.ContactlessEMV;
                            enumMap.put(Parameter.FormatID, (Object)"77");
                            enumMap.putAll(this.a(list5, byArray));
                        } else if (byArray[0] == 6) {
                            responseType = ResponseType.CONTACT_RESPONSE_DOL;
                            enumMap.put(Parameter.FormatID, (Object)"77");
                            enumMap.putAll(this.b(list2, byArray));
                        }
                        enumMap.put(Parameter.ResponseType, (Object)responseType);
                        enumMap.put(Parameter.CardType, (Object)cardType);
                        break;
                    }
                    case EMVFinalApplicationSelection: {
                        if (byArray[0] == 0) {
                            responseType = ResponseType.CONTACT_AMOUNT_DOL;
                            enumMap.put(Parameter.FormatID, (Object)"77");
                            enumMap.putAll(this.b(list, byArray));
                        } else if (byArray[0] == 1) {
                            responseType = ResponseType.LIST_OF_AIDS;
                            enumMap.put(Parameter.ListOfApplicationIdentifiers, this.c(byArray));
                        } else if (byArray[0] == 2) {
                            responseType = ResponseType.MAGNETIC_CARD_DATA;
                            cardType = CardType.MagneticStripe;
                            enumMap.put(Parameter.FormatID, (Object)"77");
                            enumMap.putAll(this.a(byArray));
                        }
                        enumMap.put(Parameter.ResponseType, (Object)responseType);
                        enumMap.put(Parameter.CardType, (Object)cardType);
                        break;
                    }
                    case EMVTransactionData: {
                        if (byArray[0] == 0) {
                            responseType = ResponseType.CONTACT_RESPONSE_DOL;
                            enumMap.put(Parameter.FormatID, (Object)"77");
                            enumMap.putAll(this.b(list2, byArray));
                        } else if (byArray[0] == 1) {
                            responseType = ResponseType.CONTACT_ONLINE_DOL;
                            enumMap.put(Parameter.FormatID, (Object)"77");
                            enumMap.putAll(this.b(list3, byArray));
                        } else if (byArray[0] == 2) {
                            responseType = ResponseType.CONTACT_RESPONSE_DOL;
                            enumMap.put(Parameter.FormatID, (Object)"77");
                            enumMap.putAll(this.b(list2, byArray));
                        }
                        enumMap.put(Parameter.ResponseType, (Object)responseType);
                        enumMap.put(Parameter.CardType, (Object)cardType);
                        break;
                    }
                    case EMVCompleteTransaction: {
                        if (byArray[0] == 0) {
                            responseType = ResponseType.CONTACT_RESPONSE_DOL;
                            enumMap.put(Parameter.FormatID, (Object)"77");
                            enumMap.putAll(this.b(list2, byArray));
                        } else if (byArray[0] == 1) {
                            cardType = CardType.ContactlessEMV;
                            responseType = ResponseType.CONTACTLESS_RESPONSE_DOL;
                            enumMap.put(Parameter.FormatID, (Object)"77");
                            enumMap.putAll(this.a(list4, byArray));
                        }
                        enumMap.put(Parameter.ResponseType, (Object)responseType);
                        enumMap.put(Parameter.CardType, (Object)cardType);
                        break;
                    }
                }
            } else {
                LogUtils.write(a, "empty response");
                enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            }
        }
        catch (Exception exception) {
            LogUtils.write(a, exception);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
        }
        return enumMap;
    }

    private EnumMap<Parameter, Object> e(byte[] byArray) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        try {
            String string = "";
            try {
                JSONObject jSONObject = new JSONObject(com.roam.roamreaderunifiedapi.emvreaders.d.a(byArray));
                Iterator iterator = jSONObject.keys();
                if (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    JSONObject jSONObject2 = new JSONObject(jSONObject.getString(string2));
                    string = jSONObject2.getString("name");
                    string = HexUtils.convertHexToString(string);
                    string = string.replaceAll(" +$", "");
                }
            }
            catch (JSONException jSONException) {
                LogUtils.write(a, (Exception)((Object)jSONException));
            }
            enumMap.put(Parameter.FirmwareVersion, (Object)string);
            enumMap.put(Parameter.Command, (Object)Command.GetFirmwareVersion);
        }
        catch (Exception exception) {
            LogUtils.write(a, exception);
        }
        return enumMap;
    }

    private EnumMap<Parameter, Object> f(byte[] byArray) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        try {
            int n2 = 13;
            if (this.getType() == DeviceType.RP750x) {
                n2 += 2;
            }
            int n3 = byArray.length - n2;
            enumMap.put(Parameter.TerminalCapabilities, (Object)com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray));
            if (n3 > 0) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                byArray2 = com.roam.roamreaderunifiedapi.emvreaders.d.c(byArray2);
                enumMap.put(Parameter.Command, (Object)Command.ReadCapabilities);
                enumMap.put(Parameter.InterfaceDeviceSerialNumber, (Object)this.c(new String(byArray2, "UTF-8")));
            } else {
                LogUtils.write("parseReaderCapabilities", "corrupt data");
            }
        }
        catch (Exception exception) {
            LogUtils.write(a, exception);
        }
        return enumMap;
    }

    private EnumMap<Parameter, Object> g(byte[] byArray) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            boolean bl = byArray.length > 190;
            enumMap.put(Parameter.ReaderVersion, (Object)new String(byArray, "UTF-8"));
            int n3 = 16;
            ReaderVersionInfo.Builder builder = new ReaderVersionInfo.Builder(this.getStringFromByteArrayFromIndexWithLength(byArray, n2, n3).trim());
            n2 += n3;
            n3 = bl ? 64 : 48;
            builder = builder.bootFileVersion(this.getStringFromByteArrayFromIndexWithLength(byArray, n2, n3));
            n2 += n3;
            n3 = bl ? 64 : 48;
            builder = builder.controlFileVersion(this.getStringFromByteArrayFromIndexWithLength(byArray, n2, n3));
            n2 += n3;
            n3 = bl ? 64 : 48;
            arrayList.add(this.getStringFromByteArrayFromIndexWithLength(byArray, n2, n3));
            n2 += n3;
            n3 = 10;
            builder = builder.emvKernelVersion(this.getStringFromByteArrayFromIndexWithLength(byArray, n2, n3).trim());
            n2 += n3;
            n3 = 10;
            builder = builder.keyVersion(this.getStringFromByteArrayFromIndexWithLength(byArray, n2, n3));
            n2 += n3;
            n3 = 10;
            builder = builder.pedVersion(this.getStringFromByteArrayFromIndexWithLength(byArray, n2, n3));
            n2 += n3;
            if (bl) {
                n3 = 64;
                builder = builder.fontFileVersion(this.getStringFromByteArrayFromIndexWithLength(byArray, n2, n3));
                String string = this.getStringFromByteArrayFromIndexWithLength(byArray, n2 += n3, n3 = 64);
                if (this.f(string)) {
                    arrayList2.add(string);
                } else {
                    arrayList.add(string);
                }
                string = this.getStringFromByteArrayFromIndexWithLength(byArray, n2 += n3, n3);
                if (this.f(string)) {
                    arrayList2.add(string);
                } else {
                    arrayList.add(string);
                }
                string = this.getStringFromByteArrayFromIndexWithLength(byArray, n2 += n3, n3);
                if (this.f(string)) {
                    arrayList2.add(string);
                } else {
                    arrayList.add(string);
                }
                string = this.getStringFromByteArrayFromIndexWithLength(byArray, n2 += n3, n3);
                if (this.f(string)) {
                    arrayList2.add(string);
                } else {
                    arrayList.add(string);
                }
                n2 += n3;
                n3 = 32;
                builder = builder.productSerialNumber(this.c(this.getStringFromByteArrayFromIndexWithLength(byArray, n2, n3)));
                n2 += n3;
                n3 = 19;
                builder = builder.bluetoothMacAddress(this.c(this.getStringFromByteArrayFromIndexWithLength(byArray, n2, n3)));
            }
            builder = builder.userFileVersions(arrayList);
            builder = builder.parameterFileVersions(arrayList2);
            enumMap.put(Parameter.ReaderVersionInfo, (Object)builder.build());
        }
        catch (Exception exception) {
            LogUtils.write(a, exception);
        }
        return enumMap;
    }

    private EnumMap<Parameter, Object> h(byte[] byArray) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        int n2 = 0;
        int n3 = 64;
        CertificateFilesVersionInfo.Builder builder = new CertificateFilesVersionInfo.Builder();
        try {
            boolean bl;
            boolean bl2 = bl = byArray.length > 448;
            if (!bl) {
                enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.CertificateFilesVersionInfoNotAvailable);
                return enumMap;
            }
            builder = builder.flrcVersion(this.getStringFromByteArrayFromIndexWithLength(byArray, n2, n3));
            builder = builder.fsrcVersion(this.getStringFromByteArrayFromIndexWithLength(byArray, n2 += n3, n3));
            builder = builder.alrcVersion(this.getStringFromByteArrayFromIndexWithLength(byArray, n2 += n3, n3));
            builder = builder.asrcVersion(this.getStringFromByteArrayFromIndexWithLength(byArray, n2 += n3, n3));
            builder = builder.brcVersion(this.getStringFromByteArrayFromIndexWithLength(byArray, n2 += n3, n3));
            builder = builder.ercVersion(this.getStringFromByteArrayFromIndexWithLength(byArray, n2 += n3, n3));
            builder = builder.tarcVersion(this.getStringFromByteArrayFromIndexWithLength(byArray, n2 += n3, n3));
            n2 += n3;
            if (bl) {
                builder = builder.imsRootCa(this.c(this.getStringFromByteArrayFromIndexWithLength(byArray, n2, n3)));
                builder = builder.rkmsSigningCertificate(this.c(this.getStringFromByteArrayFromIndexWithLength(byArray, n2 += n3, n3)));
                builder = builder.rkmsEncryptionCertificate(this.c(this.getStringFromByteArrayFromIndexWithLength(byArray, n2 += n3, n3)));
                builder = builder.customerCertificate(this.c(this.getStringFromByteArrayFromIndexWithLength(byArray, n2 += n3, n3)));
            }
            enumMap.put(Parameter.CertificateFilesVersionInfo, (Object)builder.build());
        }
        catch (Exception exception) {
            LogUtils.write(a, exception);
        }
        return enumMap;
    }

    private EnumMap<Parameter, Object> i(byte[] byArray) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        enumMap.put(Parameter.KeyMappingInfo, new KeyMappingInfo(byArray));
        return enumMap;
    }

    private boolean f(String string) {
        char c2 = string.charAt(21);
        return c2 == 'P' || c2 == 'p';
    }

    protected String getStringFromByteArrayFromIndexWithLength(byte[] response, int currIndex, int length) {
        byte[] byArray = new byte[length];
        System.arraycopy(response, currIndex, byArray, 0, byArray.length);
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private void a(com.roam.roamreaderunifiedapi.emvreaders.c c2, EnumMap<Parameter, Object> enumMap) {
        if (!enumMap.containsKey((Object)Parameter.Last4PANDigits) && !TextUtils.isEmpty((CharSequence)c2.c())) {
            enumMap.put(Parameter.Last4PANDigits, (Object)c2.c());
        }
        if (!enumMap.containsKey((Object)Parameter.PAN) && !TextUtils.isEmpty((CharSequence)c2.b())) {
            enumMap.put(Parameter.PAN, (Object)c2.b());
        }
        if (!enumMap.containsKey((Object)Parameter.RedactedCardNumber) && !TextUtils.isEmpty((CharSequence)c2.f())) {
            enumMap.put(Parameter.RedactedCardNumber, (Object)c2.f());
        }
        if (!enumMap.containsKey((Object)Parameter.CardHolderName) && !TextUtils.isEmpty((CharSequence)c2.d())) {
            enumMap.put(Parameter.CardHolderName, (Object)c2.d());
        }
        if (!enumMap.containsKey((Object)Parameter.CardExpDate) && !TextUtils.isEmpty((CharSequence)c2.e())) {
            enumMap.put(Parameter.CardExpDate, (Object)c2.e());
        }
    }

    private void c(EnumMap<Parameter, Object> enumMap) {
        String string;
        m m2 = com.roam.roamreaderunifiedapi.emvreaders.m.a(enumMap.get((Object)Parameter.Track1Data) != null ? enumMap.get((Object)Parameter.Track1Data).toString() : null);
        n n2 = com.roam.roamreaderunifiedapi.emvreaders.n.a(enumMap.get((Object)Parameter.Track2Data) != null ? enumMap.get((Object)Parameter.Track2Data).toString() : null);
        o o2 = com.roam.roamreaderunifiedapi.emvreaders.o.a(enumMap.get((Object)Parameter.Track2EquivalentData) != null ? enumMap.get((Object)Parameter.Track2EquivalentData).toString() : null);
        String string2 = string = enumMap.containsKey((Object)Parameter.VirtualTrack5Data) ? enumMap.get((Object)Parameter.VirtualTrack5Data).toString() : null;
        if (n2 != null) {
            this.a(n2, enumMap);
        }
        if (m2 != null) {
            this.a(m2, enumMap);
        }
        if (o2 != null) {
            this.a(o2, enumMap);
        }
        if (string != null && enumMap.get((Object)Parameter.PAN).toString().isEmpty()) {
            if (string.length() >= 12) {
                enumMap.put(Parameter.PAN, (Object)HexUtils.convertHexToString(string.substring(0, 12)));
            }
            if (string.length() >= 18) {
                enumMap.put(Parameter.ServiceCode, (Object)HexUtils.convertHexToString(string.substring(12, 18)));
            }
            if (string.length() > 18) {
                enumMap.put(Parameter.CardHolderName, (Object)HexUtils.convertHexToString(string.substring(18)));
            }
        }
    }

    private void d(EnumMap<Parameter, Object> enumMap) {
        byte[] byArray = null;
        if (enumMap.containsKey((Object)Parameter.EncryptedTrack)) {
            byArray = HexUtils.convertHexToByteArray(enumMap.get((Object)Parameter.EncryptedTrack).toString());
        } else if (enumMap.containsKey((Object)Parameter.RoamEncryptedEMVdata)) {
            byArray = HexUtils.convertHexToByteArray(enumMap.get((Object)Parameter.RoamEncryptedEMVdata).toString());
        }
        if (null != byArray) {
            String string = String.format("$%s$%s", enumMap.get((Object)Parameter.FormatID), Base64.encodeToString((byte[])byArray, (int)2));
            enumMap.put(Parameter.PackedEncryptedTrack, (Object)string);
        }
    }

    protected void openDeviceInUsbHidMode(DeviceStatusHandler handler) {
        boolean bl = false;
        if (this.commChannel == CommunicationManagerBase.DeviceCommunicationChannel.USB_TLV) {
            bl = true;
        }
        this.startOpenDeviceTask(new g(handler), bl);
    }

    @Override
    public void updateFirmware(String updateFilePath, DeviceResponseHandler handler) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        enumMap.put(Parameter.Command, (Object)Command.UpdateFirmware);
        enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
        enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.NOT_SUPPORTED_BY_READER);
        handler.onResponse(enumMap);
    }

    @Override
    public void getBatteryStatus(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.BatteryInfo, this.getBatteryStatusCommand(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void getBatteryLevelWithChargingStatus(DeviceResponseHandler handler) {
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.BatteryInfoWithChargingStatus, this.getBatteryLevelWithChargingStatusCommand(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void getDeviceStatistics(DeviceResponseHandler handler) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        enumMap.put(Parameter.Command, (Object)Command.DeviceStatistics);
        enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
        enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.NOT_SUPPORTED_BY_READER);
        handler.onResponse(enumMap);
    }

    private EnumMap<Parameter, Object> a(byte[] byArray, Parameter parameter) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        int n2 = 0;
        byte by = byArray[n2];
        String string = this.getStringFromByteArrayFromIndexWithLength(byArray, ++n2, by);
        enumMap.put(parameter, string);
        return enumMap;
    }

    private EnumMap<Parameter, Object> j(byte[] byArray) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        int n2 = 0;
        byte[] byArray2 = new byte[4];
        try {
            System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountPowerON, Integer.valueOf(HexUtils.byteArrayToInt(byArray2)));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountKeyHit, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountTotalSwipes, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountAudioJackInsertions, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountUSBEvent, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountBadSwipes, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountFallbackSwipes, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountChipInsertions, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountPowerOnFailForChipCards, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountAPDUFailForChipCards, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountRFWupa, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountClessActivateFail, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountClessAPDUFail, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountCharges, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountBluetoothConnectionsLost, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountOutOfBattery, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountCompleteCharge, (Object)HexUtils.byteArrayToInt(byArray2));
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            enumMap.put(Parameter.SystemCountCommands, (Object)HexUtils.byteArrayToInt(byArray2));
        }
        catch (Exception exception) {
            LogUtils.write("parseDeviceStatistics", exception);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.InvalidCommandResponse);
        }
        return enumMap;
    }

    @Override
    public void enableFirmwareUpdateMode(DeviceResponseHandler deviceResponseHandler) {
        EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
        enumMap.put(Parameter.Command, (Object)Command.EnableFirmwareUpdateMode);
        enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
        enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.NOT_SUPPORTED_BY_READER);
        deviceResponseHandler.onResponse(enumMap);
    }

    protected void setLastSuccessfulInteractionTimestamp() {
        this.i = System.nanoTime();
    }

    protected boolean shouldSetupConnection() {
        return System.nanoTime() - this.i > 170000000000L;
    }

    @Override
    public void startCalibration(Context context, CalibrationListener listener) {
        CommunicationManagerBase.getInstance(CommunicationManagerBase.DeviceCommunicationChannel.AUDIOJACK, context.getApplicationContext()).calibrateCommParameter("", new a(listener));
    }

    @Override
    public void stopCalibration(Context context) {
        CommunicationManagerBase.getInstance(CommunicationManagerBase.DeviceCommunicationChannel.AUDIOJACK, context.getApplicationContext()).stopCalibrate();
    }

    @Override
    public void configureContactlessTransactionOptions(Boolean isCVMSupported, Boolean isAMEXSupported, Boolean enableCryptogram17, Boolean enableOnlineCryptogram, Boolean enableOnline, Boolean enableMagStripe, Boolean enableMagChip, Boolean enableQVSDC, Boolean enableMSD, DeviceResponseHandler handler) {
        this.configureContactlessTransactionOptions(isCVMSupported, isAMEXSupported, enableCryptogram17, enableOnlineCryptogram, enableOnline, enableMagStripe, enableMagChip, enableQVSDC, enableMSD, -1, handler);
    }

    @Override
    public void configureContactlessTransactionOptions(Boolean isCVMSupported, Boolean isAMEXSupported, Boolean enableCryptogram17, Boolean enableOnlineCryptogram, Boolean enableOnline, Boolean enableMagStripe, Boolean enableMagChip, Boolean enableQVSDC, Boolean enableMSD, Integer contactlessOutcomeDisplayTime, DeviceResponseHandler handler) {
        this.configureContactlessTransactionOptions(isCVMSupported, isAMEXSupported, enableCryptogram17, enableOnlineCryptogram, enableOnline, enableMagStripe, enableMagChip, enableQVSDC, enableMSD, false, false, contactlessOutcomeDisplayTime, handler);
    }

    @Override
    public void configureContactlessTransactionOptions(Boolean isCVMSupported, Boolean isAMEXSupported, Boolean enableCryptogram17, Boolean enableOnlineCryptogram, Boolean enableOnline, Boolean enableMagStripe, Boolean enableMagChip, Boolean enableQVSDC, Boolean enableMSD, Boolean isDPASEmvSupported, Boolean isDPASMsrSupported, Integer contactlessOutcomeDisplayTime, DeviceResponseHandler handler) {
        if (!this.supportsNFC()) {
            this.sendCommandNotSupportedError(Command.ConfigureContactlessTransaction, handler);
            return;
        }
        if (contactlessOutcomeDisplayTime > 65535) {
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.Command, (Object)Command.ConfigureContactlessTransaction);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.InvalidParameters);
            this.postResponseOnUiThread(handler, enumMap);
            return;
        }
        int n2 = 0;
        if (isDPASEmvSupported.booleanValue()) {
            n2 = (byte)(n2 | 0x10);
        }
        if (isDPASMsrSupported.booleanValue()) {
            n2 = (byte)(n2 | 8);
        }
        if (isCVMSupported.booleanValue()) {
            n2 = (byte)(n2 | 0x40);
        }
        if (isAMEXSupported.booleanValue()) {
            n2 = (byte)(n2 | 4);
        }
        if (enableCryptogram17.booleanValue()) {
            n2 = (byte)(n2 | 2);
        }
        if (enableOnlineCryptogram.booleanValue()) {
            n2 = (byte)(n2 | 1);
        }
        int n3 = 0;
        if (enableOnline.booleanValue()) {
            n3 = (byte)(n3 | 0x80);
        }
        if (enableMagStripe.booleanValue()) {
            n3 = (byte)(n3 | 0x10);
        }
        if (enableMagChip.booleanValue()) {
            n3 = (byte)(n3 | 8);
        }
        if (enableQVSDC.booleanValue()) {
            n3 = (byte)(n3 | 4);
        }
        if (enableMSD.booleanValue()) {
            n3 = (byte)(n3 | 1);
        }
        String string = -1 < contactlessOutcomeDisplayTime ? String.format("FF8124000004%02X%02X%04X00", n2 & 0xFF, n3 & 0xFF, contactlessOutcomeDisplayTime) : String.format("FF8124000002%02X%02X00", n2 & 0xFF, n3 & 0xFF);
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ConfigureContactlessTransaction, string, this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void setExpectedContactlessOnlineDOL(List<Parameter> paramList) {
        this.contactlessOnlineDOL = paramList;
        this.contactlessOnlineDOL.remove((Object)Parameter.KSN);
        this.contactlessOnlineDOL.remove((Object)Parameter.EncryptedTrack);
    }

    @Override
    public void setExpectedContactlessResponseDOL(List<Parameter> paramList) {
        this.contactlessResponseDOL = paramList;
        this.contactlessResponseDOL.remove((Object)Parameter.KSN);
        this.contactlessResponseDOL.remove((Object)Parameter.EncryptedTrack);
    }

    @Override
    public void setContactlessOnlineDOL(List<Parameter> paramList, DeviceResponseHandler handler) {
        if (!this.supportsNFC()) {
            this.sendCommandNotSupportedError(Command.ConfigureContactlessOnlineDOLData, handler);
            return;
        }
        this.setExpectedContactlessOnlineDOL(paramList);
        String string = this.getConfigureDOLListCommand(Command.ConfigureContactlessOnlineDOLData, paramList);
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ConfigureContactlessOnlineDOLData, string, this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void setContactlessResponseDOL(List<Parameter> paramList, DeviceResponseHandler handler) {
        if (!this.supportsNFC()) {
            this.sendCommandNotSupportedError(Command.ConfigureContactlessResponseDOLData, handler);
            return;
        }
        this.setExpectedContactlessResponseDOL(paramList);
        String string = this.getConfigureDOLListCommand(Command.ConfigureContactlessResponseDOLData, paramList);
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ConfigureContactlessResponseDOLData, string, this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void enableContactless(DeviceResponseHandler handler) {
        if (!this.supportsNFC()) {
            this.sendCommandNotSupportedError(Command.EnableContactless, handler);
            return;
        }
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.EnableContactless, this.getEnableContactlessCommand(true), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void disableContactless(DeviceResponseHandler handler) {
        if (!this.supportsNFC()) {
            this.sendCommandNotSupportedError(Command.DisableContactless, handler);
            return;
        }
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.DisableContactless, this.getEnableContactlessCommand(false), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public void setUserInterfaceOptions(Integer cardInsertionTimeout, LanguageCode merchantLanguageCode, Byte pinPadOptions, Byte backlightControl, DeviceResponseHandler handler) {
        if (cardInsertionTimeout * 1000 > 65535 || null == merchantLanguageCode || backlightControl != 0 && backlightControl != 1) {
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.Command, (Object)Command.DisplayControl);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.InvalidParameters);
            this.postResponseOnUiThread(handler, enumMap);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("FF810600");
        cardInsertionTimeout = cardInsertionTimeout * 1000;
        String string = String.format("%04X%s%02X%02X", cardInsertionTimeout, merchantLanguageCode.getISO689CodeInHex(), pinPadOptions, backlightControl);
        stringBuilder.append(String.format("%04X%s00", string.length() / 2, string));
        new com.roam.roamreaderunifiedapi.emvreaders.g(Command.ConfigureUserInterfaceOptions, stringBuilder.toString(), this.mTimeout).a(this.shouldSetupConnection(), this, (com.roam.roamreaderunifiedapi.emvreaders.h)new d(handler));
    }

    @Override
    public CommunicationType getActiveCommunicationType() {
        if (null != this.b() && this.isReady()) {
            if (this.b() instanceof BluetoothManager) {
                return CommunicationType.Bluetooth;
            }
            if (this.b() instanceof AudioJackManager) {
                return CommunicationType.AudioJack;
            }
            if (this.b() instanceof UsbManager_TLV) {
                return CommunicationType.Usb;
            }
        }
        return CommunicationType.UNKNOWN;
    }

    boolean d() {
        return this.j;
    }

    boolean a(Context context) {
        AudioManager audioManager = null;
        if (null != context) {
            audioManager = (AudioManager)context.getSystemService("audio");
        }
        if (null != audioManager) {
            return audioManager.isWiredHeadsetOn();
        }
        return false;
    }

    @Override
    public void turnOnDeviceViaAudioJack(Context context, TurnOnDeviceCallback turnOnDeviceCallback) {
        this.t = turnOnDeviceCallback;
        DeviceType deviceType = this.getType();
        if (DeviceType.RP450c != deviceType) {
            this.postTurnOnDeviceStatusOnUiThread(false, false, null);
            return;
        }
        boolean bl = this.a(context);
        if (!bl) {
            this.postTurnOnDeviceStatusOnUiThread(true, false, "No audiojack device detected");
            return;
        }
        this.s = CommunicationManagerBase.getInstance(CommunicationManagerBase.DeviceCommunicationChannel.AUDIOJACK, context);
        j j2 = new j();
        new k(this.s, j2).a();
    }

    protected void postTurnOnDeviceStatus(boolean supported, boolean success, String errorMessage) {
        if (!supported) {
            this.t.notSupported();
        } else if (success) {
            this.t.success();
        } else {
            this.t.failed(errorMessage);
        }
        this.t = null;
    }

    protected void postTurnOnDeviceStatusOnUiThread(final boolean supported, final boolean success, final String errorMessage) {
        if (null == this.t) {
            LogUtils.write(a, "null turnOnDeviceCallback cannot post status::" + this.t + "::error::" + errorMessage);
            return;
        }
        if (RoamReaderUnifiedAPI.postResponseOnUIThread().booleanValue() && !this.isUiThread()) {
            this.postRunnableOnUiThread(new Runnable(){

                @Override
                public void run() {
                    LandiReader.this.postTurnOnDeviceStatus(supported, success, errorMessage);
                }
            });
        } else {
            this.postTurnOnDeviceStatus(supported, success, errorMessage);
        }
    }

    @Override
    public void stopInitialization() {
        if (this.mCommManager != null) {
            this.mCommManager.breakOpenProcess();
        }
    }

    @Override
    public void cancelFirmwareUpdate() {
        if (this.mCommManager != null) {
            this.mCommManager.cancelDownload();
        }
    }

    static /* synthetic */ byte[] d(LandiReader landiReader, byte[] byArray) {
        landiReader.c = byArray;
        return byArray;
    }

    static {
        b.add(new ApplicationIdentifier("A0000001524010", null, null));
        b.add(new ApplicationIdentifier("A0000000042203", null, null));
        b.add(new ApplicationIdentifier("A0000000980840", null, null));
    }

    private class j
    implements CommunicationCallBack {
        private j() {
        }

        @Override
        public void onError(int arg0, String arg1) {
            LogUtils.write(a, "TurnOnDeviceCommunicationCallback::onError::" + (Object)((Object)ErrorCode.getEnum(arg0)) + "::message::" + arg1);
            LandiReader.this.postTurnOnDeviceStatusOnUiThread(true, false, arg1);
        }

        @Override
        public void onProgress(byte[] arg0) {
            String string = com.roam.roamreaderunifiedapi.emvreaders.d.b(arg0);
            LogUtils.write(a, "TurnOnDeviceCommunicationCallback::onProgress::" + string);
        }

        @Override
        public void onReceive(byte[] data) {
            LogUtils.write(a, "TurnOnDeviceCommunicationCallback::onReceive::");
            try {
                com.roam.roamreaderunifiedapi.emvreaders.k k2 = new com.roam.roamreaderunifiedapi.emvreaders.k(data);
                if (k2.d()) {
                    LandiReader.this.postTurnOnDeviceStatusOnUiThread(true, true, null);
                    LogUtils.write(a, "TurnOnDeviceCommunicationCallback::onReceive::" + k2.c());
                } else {
                    LandiReader.this.postTurnOnDeviceStatusOnUiThread(true, false, k2.a());
                    LogUtils.write(a, "TurnOnDeviceCommunicationCallback::onReceive::" + k2.a());
                }
            }
            catch (Exception exception) {
                LogUtils.write(a, exception);
            }
        }

        @Override
        public void onSendOK() {
            LogUtils.write(a, "TurnOnDeviceCommunicationCallback::onSendOK::");
        }

        @Override
        public void onTimeout() {
            LogUtils.write(a, "TurnOnDeviceCommunicationCallback::onTimeout::");
        }
    }

    private class k
    extends AsyncTask<Void, Void, Integer> {
        final CommunicationManagerBase a;
        final CommunicationCallBack b;

        public k(CommunicationManagerBase communicationManagerBase, CommunicationCallBack communicationCallBack) {
            this.a = communicationManagerBase;
            this.b = communicationCallBack;
        }

        protected Integer a(Void ... voidArray) {
            return LandiReader.this.a(LandiReader.this.s, this.b, null);
        }

        protected void a(Integer n2) {
            boolean bl = false;
            String string = null;
            com.roam.roamreaderunifiedapi.emvreaders.i i2 = com.roam.roamreaderunifiedapi.emvreaders.i.a(n2);
            LogUtils.write(a, "OpenDeviceTask:onPostExecute::deviceStatus::" + i2.toString());
            switch (i2) {
                case a: 
                case b: 
                case c: 
                case d: 
                case e: 
                case f: {
                    string = "Landi OpenDevice Error::" + i2.toString();
                    bl = false;
                    break;
                }
                case g: {
                    bl = true;
                    break;
                }
            }
            LandiReader.this.postTurnOnDeviceStatusOnUiThread(true, bl, string);
        }

        @SuppressLint(value={"NewApi"})
        public void a() {
            this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((Integer)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Void[])objectArray);
        }
    }

    static interface f {
        public void a(com.roam.roamreaderunifiedapi.emvreaders.i var1);
    }

    private static class a
    implements CalibrateParamCallback {
        private final CalibrationListener a;

        a(CalibrationListener calibrationListener) {
            this.a = calibrationListener;
        }

        private CalibrationResult a(int n2) {
            switch (n2) {
                case 0: {
                    return CalibrationResult.Succeeded;
                }
                case -1: {
                    return CalibrationResult.Failed;
                }
                case -2: {
                    return CalibrationResult.Interrupted;
                }
            }
            return CalibrationResult.Failed;
        }

        @Override
        public void onComplete(int result2, CommParameter params) {
            this.a.onComplete(this.a(result2), new CalibrationParameters(params));
        }

        @Override
        public void onInformation(String info) {
            this.a.onInformation(info);
        }

        @Override
        public void onProgress(double progress) {
            this.a.onProgress(progress);
        }
    }

    private class i
    extends AsyncTask<Void, Void, Byte> {
        RKMSInjection a = new RKMSInjection();
        DeviceResponseHandler b;
        String c;

        i(String string, DeviceResponseHandler deviceResponseHandler) {
            this.b = deviceResponseHandler;
            this.c = string;
        }

        protected Byte a(Void ... voidArray) {
            return this.a.InjectionJob(LandiReader.this.mCommManager, this.c, null);
        }

        protected void a(Byte by) {
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.Command, (Object)Command.TriggerRki);
            if (by == 0) {
                enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Success);
            } else {
                enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.TriggerRkiFailed);
                enumMap.put(Parameter.ErrorDetails, (Object)String.format("0x%02X ", by));
                LogUtils.write(a, "RKI failed with error::" + String.format("0x%02X ", by));
            }
            LandiReader.this.isRkiModeEnabled = false;
            this.b.onResponse(enumMap);
        }

        @SuppressLint(value={"NewApi"})
        public void a() {
            this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((Byte)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Void[])objectArray);
        }
    }

    private class h
    extends AsyncTask<Void, Void, Integer> {
        private final f b;
        private boolean c;

        private h(f f2, boolean bl) {
            this.b = f2;
            this.c = bl;
        }

        protected Integer a(Void ... voidArray) {
            if (this.c) {
                LandiReader.this.h();
                if (LandiReader.this.commChannel == CommunicationManagerBase.DeviceCommunicationChannel.USB_HID) {
                    LogUtils.write(a, "Close device in HID mode");
                    LandiReader.this.commChannel = CommunicationManagerBase.DeviceCommunicationChannel.USB_TLV;
                } else {
                    LogUtils.write(a, "Close device in TLV mode");
                    LandiReader.this.commChannel = CommunicationManagerBase.DeviceCommunicationChannel.USB_HID;
                }
                LandiReader.this.mCommManager = CommunicationManagerBase.getInstance(LandiReader.this.commChannel, LandiReader.this.context);
            }
            return LandiReader.this.c();
        }

        protected void a(Integer n2) {
            boolean bl = false;
            String string = null;
            LandiReader.this.deviceStatus = com.roam.roamreaderunifiedapi.emvreaders.i.a(n2);
            LogUtils.write(a, "OpenDeviceTask:onPostExecute::deviceStatus::" + LandiReader.this.deviceStatus.toString());
            if (null != this.b) {
                this.b.a(LandiReader.this.deviceStatus);
            } else {
                switch (LandiReader.this.deviceStatus) {
                    case a: 
                    case b: 
                    case c: 
                    case d: 
                    case e: 
                    case f: {
                        string = "Landi OpenDevice Error::" + LandiReader.this.deviceStatus.toString();
                        bl = false;
                        break;
                    }
                    case g: {
                        LandiReader.this.setLastSuccessfulInteractionTimestamp();
                        bl = true;
                        LogUtils.write(a, "Open device in " + LandiReader.this.commChannel.toString() + " success");
                        break;
                    }
                }
                LandiReader.this.postDeviceStatusOnUiThread(LandiReader.this.currentDeviceStatusHandler, bl, string);
            }
        }

        @SuppressLint(value={"NewApi"})
        public void a() {
            this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((Integer)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Void[])objectArray);
        }
    }

    private class b
    extends AsyncTask<Void, Void, Boolean> {
        private String b = null;

        private b(String string) {
            this.b = string;
        }

        protected Boolean a(Void ... voidArray) {
            LandiReader.this.h();
            if (LandiReader.this.f() == CommunicationManagerBase.DeviceCommunicationChannel.AUDIOJACK) {
                LandiReader.this.g();
            }
            LandiReader.this.deviceStatus = com.roam.roamreaderunifiedapi.emvreaders.i.c;
            LogUtils.write(a, "CloseDeviceTask::doInBackground::deviceStatus::" + (Object)((Object)LandiReader.this.deviceStatus));
            return true;
        }

        protected void a(Boolean bl) {
            LogUtils.write(a, "CloseDeviceTask::onPostExecute::isHeadsetPluggedIn::" + LandiReader.this.j);
            if (LandiReader.this.currentDeviceStatusHandler != null) {
                LandiReader.this.postDeviceStatusOnUiThread(LandiReader.this.currentDeviceStatusHandler, false, LandiReader.this.j ? this.b : null);
                if (null != this.b && LandiReader.this.f() == CommunicationManagerBase.DeviceCommunicationChannel.AUDIOJACK) {
                    LandiReader.this.initialize(LandiReader.this.context, LandiReader.this.currentDeviceStatusHandler);
                }
            } else if (LandiReader.this.o != null) {
                LogUtils.write(a, "CloseDeviceTask::onPostExecute::posting status on internal release handler");
                LandiReader.this.postDeviceStatusOnUiThread(LandiReader.this.o, false, LandiReader.this.j ? this.b : null);
                LandiReader.this.o = null;
            }
            if (LandiReader.this.q != null) {
                LandiReader.this.q.done();
                LandiReader.this.q = null;
            }
        }

        @SuppressLint(value={"NewApi"})
        public void a() {
            this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((Boolean)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Void[])objectArray);
        }
    }

    private class g
    implements f {
        private final DeviceStatusHandler b;

        g(DeviceStatusHandler deviceStatusHandler) {
            this.b = deviceStatusHandler;
        }

        @Override
        public void a(com.roam.roamreaderunifiedapi.emvreaders.i i2) {
            boolean bl = false;
            String string = null;
            if (i2 == com.roam.roamreaderunifiedapi.emvreaders.i.g) {
                LandiReader.this.setLastSuccessfulInteractionTimestamp();
                LogUtils.write(a, "Open device in " + LandiReader.this.commChannel.toString() + " success");
                bl = true;
            } else {
                bl = false;
                string = "Landi OpenDevice Error::" + i2.toString();
            }
            if (this.b != null) {
                LandiReader.this.postDeviceStatusOnStatusHandler(this.b, bl, string);
            }
        }
    }

    private class c
    extends BroadcastReceiver {
        private c() {
        }

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if ("android.intent.action.HEADSET_PLUG".equals(string)) {
                int n2 = intent.getIntExtra("state", -1);
                switch (n2) {
                    case 0: {
                        LogUtils.write(a, "Headset is unplugged");
                        LandiReader.this.j = false;
                        break;
                    }
                    case 1: {
                        LogUtils.write(a, "Headset is plugged");
                        LandiReader.this.j = true;
                        if (!LandiReader.this.isInitialized) break;
                        LandiReader.this.startOpenDeviceTask(null);
                        break;
                    }
                }
            }
        }
    }

    private class e
    implements CommunicationCallBack {
        private e() {
        }

        @Override
        public void onError(int arg0, String arg1) {
            LogUtils.write(a, "LandiReaderConnectionHandler::onError::" + (Object)((Object)ErrorCode.getEnum(arg0)) + "::message::" + arg1);
            LandiReader.this.startCloseDeviceTask(arg1);
        }

        @Override
        public void onProgress(byte[] arg0) {
            String string = com.roam.roamreaderunifiedapi.emvreaders.d.b(arg0);
            LogUtils.write(a, "LandiReaderConnectionHandler::onProgress::" + string);
        }

        @Override
        public void onReceive(byte[] data) {
            LogUtils.write(a, "LandiReaderConnectionHandler::onReceive::");
            LandiReader.this.setLastSuccessfulInteractionTimestamp();
            try {
                com.roam.roamreaderunifiedapi.emvreaders.k k2 = new com.roam.roamreaderunifiedapi.emvreaders.k(data);
                if (k2.d()) {
                    LogUtils.write(a, "LandiReaderConnectionHandler::onReceive::" + k2.c());
                } else {
                    LogUtils.write(a, "LandiReaderConnectionHandler::onReceive::" + k2.a());
                }
            }
            catch (Exception exception) {
                LogUtils.write(a, exception);
            }
        }

        @Override
        public void onSendOK() {
            LogUtils.write(a, "LandiReaderConnectionHandler::onSendOK::");
        }

        @Override
        public void onTimeout() {
            LogUtils.write(a, "LandiReaderConnectionHandler::onTimeout::");
        }
    }

    class d
    implements com.roam.roamreaderunifiedapi.emvreaders.h {
        private DeviceResponseHandler b;
        private final Command c;
        private EnumMap<Parameter, Object> d = null;

        private void a(Command command, EnumMap<Parameter, Object> enumMap) {
            if (LandiReader.this.a(enumMap)) {
                LandiReader.this.k = LandiReader.this.b(enumMap);
                if (LandiReader.this.k.c()) {
                    LandiReader.this.d(enumMap);
                }
                LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                this.b = null;
            } else if (null != LandiReader.this.k) {
                enumMap.put(Parameter.KSN, (Object)LandiReader.this.k.a());
                if (LandiReader.this.k.c()) {
                    enumMap.put(Parameter.EncryptedTrack, (Object)LandiReader.this.k.b());
                    LandiReader.this.d(enumMap);
                }
                LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                this.b = null;
            } else {
                LandiReader.this.a(command, enumMap, this.b);
            }
        }

        private d(Command command, EnumMap<Parameter, Object> enumMap, DeviceResponseHandler deviceResponseHandler) {
            this.b = deviceResponseHandler;
            this.c = command;
            this.d = enumMap;
        }

        d(DeviceResponseHandler deviceResponseHandler) {
            this(null, null, deviceResponseHandler);
        }

        @Override
        public void a(Command command, String string) {
            LogUtils.write(a, "LandiCommandHandler::onCaseSent::Command::" + command.toString() + "::message::" + string);
            if (this.b != null) {
                switch (command) {
                    case EMVStartTransaction: {
                        LandiReader.this.postProgressOnUiThread(this.b, ProgressMessage.PleaseInsertCard, " Command " + command.toString() + " sent. Please Insert Card after beep.");
                        break;
                    }
                    case EMVTransactionStop: {
                        LandiReader.this.postProgressOnUiThread(this.b, ProgressMessage.PleaseRemoveCard, " Command " + command.toString() + " sent. Please remove Card after beep.");
                        break;
                    }
                    case WaitForMagneticCardSwipe: {
                        LandiReader.this.postProgressOnUiThread(this.b, ProgressMessage.WaitingforCardSwipe, " Command " + command.toString() + " sent. Please swipe the card.");
                        break;
                    }
                    case EMVFinalApplicationSelection: {
                        if (LandiReader.this.p) break;
                        LandiReader.this.postProgressOnUiThread(this.b, ProgressMessage.CommandSent, " Command " + command.toString() + " sent. Waiting for response.");
                        break;
                    }
                    default: {
                        LandiReader.this.postProgressOnUiThread(this.b, ProgressMessage.CommandSent, " Command " + command.toString() + " sent. Waiting for response.");
                    }
                }
            }
        }

        @Override
        public void b(Command command, String string) {
            LogUtils.write(a, "LandiCommandHandler::onCaseTimeout::Command::" + command.toString() + "::message::" + string);
            if (command.equals((Object)Command.EnableRkiMode)) {
                LandiReader.this.isRkiModeEnabled = false;
            }
            LandiReader.this.canCallCancelWait = false;
            EnumMap<Parameter, Enum> enumMap = new EnumMap<Parameter, Enum>(Parameter.class);
            enumMap.put(Parameter.Command, command);
            enumMap.put(Parameter.ResponseCode, ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, ErrorCode.ReaderTimeout);
            LandiReader.this.postResponseOnUiThread(this.b, enumMap);
            this.b = null;
        }

        @Override
        public void a(Command command, ProgressMessage progressMessage, String string) {
            if (ProgressMessage.SwipeDetected == progressMessage || ProgressMessage.CardInserted == progressMessage || ProgressMessage.TapDetected == progressMessage) {
                LandiReader.this.canCallCancelWait = false;
            }
            LogUtils.write(a, "LandiCommandHandler::onProgress::Command::" + command.toString() + "::message::" + string);
            LandiReader.this.postProgressOnUiThread(this.b, progressMessage, string);
        }

        @Override
        public void a(Command command, byte[] byArray) {
            if (LogUtils.isEnabled()) {
                if (null != byArray && 0 < byArray.length) {
                    LogUtils.write(a, "LandiCommandHandler::onSuccess::Command::" + command.toString() + "::message::" + com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray));
                } else {
                    LogUtils.write(a, "LandiCommandHandler::onSuccess::Command::" + command.toString());
                }
            }
            LandiReader.this.canCallCancelWait = false;
            LandiReader.this.setLastSuccessfulInteractionTimestamp();
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.Command, (Object)command);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Success);
            block0 : switch (command) {
                case RawCommand: {
                    if (byArray != null && byArray.length > 0) {
                        enumMap.put(Parameter.RawResponse, com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray));
                        enumMap.put(Parameter.RawResponseWithResponseCode, com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray) + "9000");
                    }
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case ReadVersion: {
                    LandiReader.this.l = LandiReader.this.g(byArray);
                    ReaderVersionInfo readerVersionInfo = (ReaderVersionInfo)LandiReader.this.l.get((Object)Parameter.ReaderVersionInfo);
                    if (byArray.length < 190 || readerVersionInfo == null || TextUtils.isEmpty((CharSequence)readerVersionInfo.getHardwareType())) {
                        LandiReader.this.l = null;
                        LandiReader.this.postResponseOnUiThread(this.b, LandiReader.this.createErrorResponseMap((Object)Command.ReadVersion, ErrorCode.UnknownError));
                    } else {
                        enumMap.putAll(LandiReader.this.l);
                        LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    }
                    this.b = null;
                    break;
                }
                case ReadKeyMappingInfo: {
                    enumMap.putAll(LandiReader.this.i(byArray));
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case ReadCertificateFilesVersion: {
                    enumMap.putAll(LandiReader.this.h(byArray));
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case WaitForMagneticCardSwipe: {
                    enumMap.put(Parameter.ResponseType, (Object)ResponseType.MAGNETIC_CARD_DATA);
                    enumMap.putAll(LandiReader.this.parseReadMagneticCardDataCommandResponse(byArray));
                    LandiReader.this.postProgressOnUiThread(this.b, ProgressMessage.SwipeDetected, "Card swipe detected. Sending encrypted data status command...");
                    LandiReader.this.a(command, enumMap, this.b);
                    break;
                }
                case EncryptedDataStatus: {
                    enumMap.put(Parameter.Command, (Object)this.c);
                    if (null != this.d) {
                        enumMap.putAll(this.d);
                    }
                    enumMap.putAll(LandiReader.this.parseEncryptedDataStatusCommandResponse(byArray));
                    LandiReader.this.k = LandiReader.this.b(enumMap);
                    if (LandiReader.this.k.c()) {
                        LandiReader.this.d(enumMap);
                    }
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case EMVStartTransaction: 
                case EMVFinalApplicationSelection: {
                    enumMap.putAll(LandiReader.this.a(command, LandiReader.this.amountDOL, LandiReader.this.responseDOL, LandiReader.this.onlineDOL, LandiReader.this.contactlessResponseDOL, LandiReader.this.contactlessOnlineDOL, byArray));
                    if (enumMap.containsKey((Object)Parameter.ResponseType)) {
                        ResponseType responseType = (ResponseType)((Object)enumMap.get((Object)Parameter.ResponseType));
                        switch (responseType) {
                            case CONTACTLESS_ONLINE_DOL: 
                            case CONTACTLESS_RESPONSE_DOL: {
                                LandiReader.this.postProgressOnUiThread(this.b, ProgressMessage.TapDetected, null);
                                this.a(command, enumMap);
                                break block0;
                            }
                            case CONTACT_ONLINE_DOL: 
                            case CONTACT_RESPONSE_DOL: {
                                this.a(command, enumMap);
                                break block0;
                            }
                            case MAGNETIC_CARD_DATA: {
                                LandiReader.this.postProgressOnUiThread(this.b, ProgressMessage.SwipeDetected, "Card swipe detected. Sending encrypted data status command...");
                                this.a(command, enumMap);
                                break block0;
                            }
                            case LIST_OF_AIDS: {
                                String string = LandiReader.this.a((List)enumMap.get((Object)Parameter.ListOfApplicationIdentifiers));
                                if (LandiReader.this.getType() == DeviceType.RP350x && string != null) {
                                    LandiReader.this.p = true;
                                    HashMap<Parameter, Object> hashMap = new HashMap<Parameter, Object>();
                                    hashMap.put(Parameter.Command, (Object)Command.EMVFinalApplicationSelection);
                                    hashMap.put(Parameter.ApplicationIdentifier, string);
                                    LandiReader.this.sendCommand(hashMap, this.b);
                                    break block0;
                                }
                                LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                                this.b = null;
                                break block0;
                            }
                            case CONTACT_AMOUNT_DOL: {
                                if (LandiReader.this.getType() == DeviceType.RP350x) {
                                    switch (command) {
                                        case EMVStartTransaction: {
                                            if (!enumMap.containsKey((Object)Parameter.ApplicationIdentifier) || !enumMap.containsKey((Object)Parameter.ApplicationLabel) || !enumMap.containsKey((Object)Parameter.ApplicationPriorityIndicator)) break;
                                            byte[] byArray2 = HexUtils.convertHexToByteArray(enumMap.get((Object)Parameter.ApplicationPriorityIndicator).toString());
                                            ArrayList<ApplicationIdentifier> arrayList = new ArrayList<ApplicationIdentifier>();
                                            arrayList.add(new ApplicationIdentifier(enumMap.get((Object)Parameter.ApplicationIdentifier).toString(), enumMap.get((Object)Parameter.ApplicationPriorityIndicator).toString(), enumMap.get((Object)Parameter.ApplicationLabel).toString()));
                                            if ((byArray2[0] & 0x80) <= 0 || LandiReader.this.a(arrayList) != null) break;
                                            LandiReader.this.d = enumMap.get((Object)Parameter.ApplicationIdentifier).toString();
                                            LandiReader.d(LandiReader.this, byArray);
                                            enumMap.clear();
                                            enumMap.put(Parameter.Command, (Object)Command.EMVStartTransaction);
                                            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Success);
                                            enumMap.put(Parameter.ResponseType, (Object)ResponseType.LIST_OF_AIDS);
                                            enumMap.put(Parameter.CardType, (Object)CardType.ContactEMV);
                                            enumMap.put(Parameter.ListOfApplicationIdentifiers, arrayList);
                                            this.a(Command.EMVStartTransaction, ProgressMessage.ApplicationSelectionStarted, "C001");
                                            break;
                                        }
                                        case EMVFinalApplicationSelection: {
                                            if (!LandiReader.this.p) break;
                                            enumMap.put(Parameter.Command, (Object)Command.EMVStartTransaction);
                                            LandiReader.this.p = false;
                                        }
                                    }
                                }
                                LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                                this.b = null;
                                break block0;
                            }
                        }
                        LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                        this.b = null;
                        break;
                    }
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case EMVTransactionData: 
                case EMVCompleteTransaction: {
                    enumMap.putAll(LandiReader.this.a(command, LandiReader.this.amountDOL, LandiReader.this.responseDOL, LandiReader.this.onlineDOL, LandiReader.this.contactlessResponseDOL, LandiReader.this.contactlessOnlineDOL, byArray));
                    this.a(command, enumMap);
                    break;
                }
                case ReadCapabilities: {
                    LandiReader.this.m = LandiReader.this.f(byArray);
                    if (byArray.length < 31 || !LandiReader.this.m.containsKey((Object)Parameter.InterfaceDeviceSerialNumber) || !LandiReader.this.m.containsKey((Object)Parameter.TerminalCapabilities)) {
                        LandiReader.this.m = null;
                        LandiReader.this.postResponseOnUiThread(this.b, LandiReader.this.createErrorResponseMap((Object)Command.ReadCapabilities, ErrorCode.UnknownError));
                    } else {
                        enumMap.putAll(LandiReader.this.m);
                        LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    }
                    this.b = null;
                    break;
                }
                case RetrieveKSN: {
                    enumMap.put(Parameter.KSN, com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray));
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case CollectKeyedCardData: {
                    enumMap.putAll(LandiReader.this.b(byArray));
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case KeyPadControl: {
                    if (byArray == null || byArray.length == 0) {
                        enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                        enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.PIN_BY_PASS);
                    } else {
                        if (LandiReader.this.getKeypadControl() != null && LandiReader.this.getKeypadControl().getPinType() == KeyPadControl.PIN_TYPE.TDES_BLOCK_PIN) {
                            enumMap.putAll(LandiReader.this.d(com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray)));
                        }
                        if (LandiReader.this.getKeypadControl() != null && LandiReader.this.getKeypadControl().getPinType() == KeyPadControl.PIN_TYPE.MASTER_SESSION_PIN) {
                            enumMap.putAll(LandiReader.this.e(com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray)));
                        }
                    }
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case BatteryInfo: {
                    enumMap.put(Parameter.BatteryLevel, Integer.valueOf(HexUtils.byteArrayToInt(byArray)));
                }
                case BatteryInfoWithChargingStatus: {
                    int n2 = HexUtils.byteArrayToInt(byArray);
                    if (n2 == 255) {
                        enumMap.put(Parameter.IsDeviceCharging, Boolean.valueOf(true));
                        enumMap.put(Parameter.BatteryLevel, Integer.valueOf(-1));
                    } else {
                        enumMap.put(Parameter.IsDeviceCharging, Boolean.valueOf(false));
                        enumMap.put(Parameter.BatteryLevel, Integer.valueOf(n2));
                    }
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case DeviceStatistics: {
                    enumMap.putAll(LandiReader.this.j(byArray));
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case SubmitAIDsWithTLVDataList: 
                case SubmitContactlessAIDsList: 
                case SubmitAIDsList: {
                    if (LandiReader.this.i()) {
                        LandiReader.this.a(command, this.b);
                        break;
                    }
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case EnableRkiMode: {
                    LandiReader.this.isRkiModeEnabled = true;
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case GetVasVersion: {
                    enumMap.putAll(LandiReader.this.a(byArray, Parameter.VasVersion));
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case GetVasMerchantCount: {
                    enumMap.put(Parameter.VasMerchantCount, Integer.valueOf(HexUtils.byteArrayToInt(byArray)));
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case GetVasErrorMessage: {
                    enumMap.putAll(LandiReader.this.a(byArray, Parameter.LastVasErrorMessage));
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case GetVasExchangedMessageLog: {
                    enumMap.putAll(LandiReader.this.a(byArray, Parameter.VasExchangedMessageLog));
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case SetVasApplicationVersion: 
                case SetVasUnpredictableNumber: {
                    if (byArray[0] == 0 || byArray[0] != 3) break;
                    enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                    enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.VasBadLength);
                    break;
                }
                case EnableVasMode: 
                case EnableVasPlseState: {
                    if (byArray[0] == 0 || byArray[0] != 2) break;
                    enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                    enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.VasBadValue);
                    break;
                }
                case GetFirmwareChecksumInfo: {
                    enumMap.put(Parameter.FirmwareChecksum, com.roam.roamreaderunifiedapi.emvreaders.d.a(byArray));
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case GetFirmwareVersion: {
                    enumMap.putAll(LandiReader.this.e(byArray));
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case GetVasDataForMerchant: {
                    boolean bl = false;
                    if (bl) {
                        enumMap.putAll(LandiReader.this.d(byArray));
                    }
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case EnableVasModeForMerchant: {
                    if (byArray[0] != 0) {
                        if (byArray[0] == 2) {
                            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.VasBadValue);
                        } else if (byArray[0] == 32) {
                            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.VasParameterNotSet);
                        }
                    }
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case AddVasMerchant: {
                    if (byArray[0] != 0) {
                        if (byArray[0] == 2) {
                            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.VasBadValue);
                        } else if (byArray[0] == 32) {
                            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.VasParameterNotSet);
                        }
                    }
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                case CollectZipCode: {
                    enumMap.put(Parameter.ZipCode, com.roam.roamreaderunifiedapi.emvreaders.d.a(byArray));
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                    break;
                }
                default: {
                    LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                    this.b = null;
                }
            }
        }

        @Override
        public void a(Command command, ErrorCode errorCode, String string, byte[] byArray) {
            if (LandiReader.this.r && errorCode == ErrorCode.CommandCancelFailedUponReceiptOfACancelWaitCommand) {
                LandiReader.this.r = false;
                LogUtils.write(a, "Ignoring cancelWait error::" + (Object)((Object)errorCode));
                return;
            }
            if (LogUtils.isEnabled()) {
                if (null != byArray && 0 < byArray.length) {
                    LogUtils.write(a, "LandiCommandHandler::onError::Command::" + command.toString() + "::errorCode::" + (Object)((Object)errorCode) + "::message::" + string + "::response::" + com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray));
                } else {
                    LogUtils.write(a, "LandiCommandHandler::onError::Command::" + command.toString() + "::errorCode::" + (Object)((Object)errorCode) + "::message::" + string);
                }
            }
            LandiReader.this.canCallCancelWait = false;
            LandiReader.this.setLastSuccessfulInteractionTimestamp();
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            if (Command.EncryptedDataStatus == command && this.d != null) {
                enumMap.put(Parameter.Command, (Object)this.c);
                enumMap.putAll(this.d);
            }
            if (Command.EncryptedDataStatus != command) {
                enumMap.put(Parameter.Command, (Object)command);
                enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
                enumMap.put(Parameter.ErrorCode, (Object)errorCode);
            }
            if (ErrorCode.CardReaderNotConnected == errorCode) {
                LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                this.b = null;
                LandiReader.this.startCloseDeviceTask(string);
            } else {
                switch (command) {
                    case RawCommand: {
                        if (byArray != null && byArray.length > 0) {
                            enumMap.put(Parameter.RawResponse, com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray));
                            enumMap.put(Parameter.RawResponseWithResponseCode, (Object)(com.roam.roamreaderunifiedapi.emvreaders.d.b(byArray) + errorCode.getValue()));
                        }
                        LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                        this.b = null;
                        break;
                    }
                    case WaitForMagneticCardSwipe: {
                        enumMap.put(Parameter.ResponseType, (Object)ResponseType.MAGNETIC_CARD_DATA);
                        enumMap.putAll(LandiReader.this.parseReadMagneticCardDataCommandResponse(byArray));
                        this.a(enumMap, errorCode, string, command);
                        break;
                    }
                    case EMVStartTransaction: 
                    case EMVTransactionData: 
                    case EMVCompleteTransaction: 
                    case EMVFinalApplicationSelection: {
                        try {
                            enumMap.putAll(LandiReader.this.a(command, LandiReader.this.amountDOL, LandiReader.this.responseDOL, LandiReader.this.onlineDOL, LandiReader.this.contactlessResponseDOL, LandiReader.this.contactlessOnlineDOL, byArray));
                        }
                        catch (Exception exception) {
                            LogUtils.write(a, exception);
                        }
                        this.a(enumMap, errorCode, string, command);
                        break;
                    }
                    case EnableRkiMode: {
                        LandiReader.this.isRkiModeEnabled = false;
                        LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                        this.b = null;
                        break;
                    }
                    default: {
                        LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                        this.b = null;
                    }
                }
            }
        }

        private void a(EnumMap<Parameter, Object> enumMap, ErrorCode errorCode, String string, Command command) {
            if (errorCode == ErrorCode.CommandCancelledUponReceiptOfACancelWaitCommand) {
                LandiReader.this.postResponseOnUiThread(this.b, enumMap);
                this.b = null;
            } else {
                LandiReader.this.a(command, enumMap, this.b);
            }
        }
    }
}

