/*
 * Decompiled with CFR 0.152.
 */
package com.roam.roamreaderunifiedapi.emvreaders;

import android.content.Context;
import com.landicorp.emv.comm.api.AudioJackManager;
import com.landicorp.emv.comm.api.CommunicationManagerBase;
import com.roam.roamreaderunifiedapi.DeviceManager;
import com.roam.roamreaderunifiedapi.DisplayControl;
import com.roam.roamreaderunifiedapi.KeyPadControl;
import com.roam.roamreaderunifiedapi.TransactionManager;
import com.roam.roamreaderunifiedapi.callback.DeviceResponseHandler;
import com.roam.roamreaderunifiedapi.callback.DeviceStatusHandler;
import com.roam.roamreaderunifiedapi.callback.SearchListener;
import com.roam.roamreaderunifiedapi.constants.Command;
import com.roam.roamreaderunifiedapi.constants.CommunicationType;
import com.roam.roamreaderunifiedapi.constants.DeviceType;
import com.roam.roamreaderunifiedapi.constants.ErrorCode;
import com.roam.roamreaderunifiedapi.constants.LanguageCode;
import com.roam.roamreaderunifiedapi.constants.Parameter;
import com.roam.roamreaderunifiedapi.constants.ResponseCode;
import com.roam.roamreaderunifiedapi.data.Device;
import com.roam.roamreaderunifiedapi.emvreaders.LandiReader;
import com.roam.roamreaderunifiedapi.emvreaders.g;
import com.roam.roamreaderunifiedapi.emvreaders.h;
import com.roam.roamreaderunifiedapi.utils.LogUtils;
import java.util.EnumMap;

public final class RP350XDeviceManager
extends LandiReader
implements TransactionManager {
    private static DeviceManager a = null;

    private RP350XDeviceManager() {
        LogUtils.write("RP350XDeviceManager", "RP350x API version::" + CommunicationManagerBase.getLibVersion());
    }

    public static DeviceManager getInstance() {
        if (a == null) {
            a = new RP350XDeviceManager();
        }
        return a;
    }

    @Override
    public boolean initialize(Context ctx, DeviceStatusHandler statusHandler) {
        LogUtils.write("RP350XDeviceManager", "initialize");
        if (null != this.context && this.isRegisteredForHeadsetPlugStateUpdates) {
            this.unregisterAudioJackListener(this.context, this.mHeadsetPlugStateReceiver);
        }
        this.context = ctx.getApplicationContext();
        this.currentDeviceStatusHandler = statusHandler;
        this.raiseVolume();
        this.mCommManager = AudioJackManager.getInstance(this.context);
        this.registerAudioJackListener(this.context, this.mHeadsetPlugStateReceiver);
        this.isRegisteredForHeadsetPlugStateUpdates = true;
        return super.initialize(ctx, statusHandler);
    }

    @Override
    protected boolean supportsNFC() {
        return false;
    }

    @Override
    protected boolean supportsAudioJackInterface() {
        return true;
    }

    @Override
    protected boolean supportsBluetoothInterface() {
        return false;
    }

    @Override
    protected boolean supportsUSBInterface() {
        return false;
    }

    @Override
    protected boolean supportsRKI() {
        return false;
    }

    @Override
    public boolean release() {
        LogUtils.write("RP350XDeviceManager", "release");
        if (this.isRegisteredForHeadsetPlugStateUpdates) {
            this.unregisterAudioJackListener(this.context, this.mHeadsetPlugStateReceiver);
        }
        this.isRegisteredForHeadsetPlugStateUpdates = false;
        return super.release();
    }

    @Override
    public DeviceType getType() {
        return DeviceType.RP350x;
    }

    @Override
    public void searchDevices(Context ctx, Boolean includeBondedDevices, Long durationInMilliseconds, SearchListener listener) {
        this.searchDevices(ctx, true, listener);
    }

    @Override
    public void searchDevices(Context ctx, Boolean includeBondedDevices, SearchListener searchListener) {
        searchListener.onDeviceDiscovered(new Device(this.getType(), CommunicationType.AudioJack, "RP350x", "Audio Jack"));
        searchListener.onDiscoveryComplete();
    }

    @Override
    public void searchDevices(Context ctx, SearchListener searchListener) {
        this.searchDevices(ctx, true, searchListener);
    }

    @Override
    public void searchDevices(Context ctx, Boolean includeBondedDevices, Long durationInMilliseconds, Short lowRssi, Short highRssi, SearchListener searchListener) {
        this.searchDevices(ctx, true, searchListener);
    }

    @Override
    public void generateBeep(DeviceResponseHandler handler) {
        new g(Command.GenerateBeep, this.getGenerateBeepCommand(), this.mTimeout).a(this.shouldSetupConnection(), this, (h)new LandiReader.d(handler));
    }

    @Override
    public void getDeviceCapabilities(DeviceResponseHandler handler) {
        new g(Command.ReadCapabilities, this.getReadCapabilitiesCommand(), this.mTimeout).a(this.shouldSetupConnection(), this, (h)new LandiReader.d(handler));
    }

    @Override
    public DisplayControl getDisplayControl() {
        return this.getNotSupportedDisplayControl();
    }

    @Override
    public KeyPadControl getKeypadControl() {
        return this.getNotSupportedKeyPadControl();
    }

    @Override
    public void setUserInterfaceOptions(Integer cardInsertionTimeout, LanguageCode merchantLanguageCode, Byte pinPadOptions, Byte backlightControl, DeviceResponseHandler handler) {
        if (cardInsertionTimeout * 1000 > 65535 || null == merchantLanguageCode || backlightControl != 0 && backlightControl != 1) {
            EnumMap<Parameter, Object> enumMap = new EnumMap<Parameter, Object>(Parameter.class);
            enumMap.put(Parameter.Command, (Object)Command.DisplayControl);
            enumMap.put(Parameter.ResponseCode, (Object)ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, (Object)ErrorCode.InvalidParameters);
            this.postResponseOnUiThread(handler, enumMap);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("FF810600");
        cardInsertionTimeout = cardInsertionTimeout * 1000;
        String string = null;
        string = String.format("%04X%s%02X%02X", cardInsertionTimeout, merchantLanguageCode.getISO689CodeInHex(), pinPadOptions, backlightControl);
        stringBuilder.append(String.format("%04X%s00", string.length() / 2, string));
        new g(Command.ConfigureUserInterfaceOptions, stringBuilder.toString(), this.mTimeout).a(this.shouldSetupConnection(), this, (h)new LandiReader.d(handler));
    }
}

