/*
 * Decompiled with CFR 0.152.
 */
package com.roam.roamreaderunifiedapi.emvreaders;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.AsyncTask;
import com.landicorp.download.download;
import com.landicorp.emv.comm.api.CommunicationManagerBase;
import com.landicorp.emv.comm.api.DeviceInfo;
import com.landicorp.emv.comm.api.DownloadCallback;
import com.landicorp.liu.comm.api.BluetoothCommParam;
import com.roam.roamreaderunifiedapi.DisplayControl;
import com.roam.roamreaderunifiedapi.KeyPadControl;
import com.roam.roamreaderunifiedapi.callback.DeviceResponseHandler;
import com.roam.roamreaderunifiedapi.callback.DeviceStatusHandler;
import com.roam.roamreaderunifiedapi.callback.SearchListener;
import com.roam.roamreaderunifiedapi.constants.Command;
import com.roam.roamreaderunifiedapi.constants.CommunicationType;
import com.roam.roamreaderunifiedapi.constants.ErrorCode;
import com.roam.roamreaderunifiedapi.constants.Parameter;
import com.roam.roamreaderunifiedapi.constants.ProgressMessage;
import com.roam.roamreaderunifiedapi.constants.ResponseCode;
import com.roam.roamreaderunifiedapi.data.Device;
import com.roam.roamreaderunifiedapi.emvreaders.LandiReader;
import com.roam.roamreaderunifiedapi.emvreaders.g;
import com.roam.roamreaderunifiedapi.emvreaders.h;
import com.roam.roamreaderunifiedapi.utils.LogUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;

abstract class a
extends LandiReader
implements CommunicationManagerBase.DeviceSearchListener {
    private static final String a = a.class.getSimpleName();
    private SearchListener b;
    protected DisplayControl mDisplayControl;
    protected KeyPadControl mKeyPadControl;
    protected List<Device> availableDevices;

    protected a() {
        LogUtils.write(a, "Landi API version::" + CommunicationManagerBase.getLibVersion());
    }

    @Override
    public boolean initialize(Context ctx, DeviceStatusHandler statusHandler) {
        if (this.supportsAudioJackInterface() && null != this.context && this.isRegisteredForHeadsetPlugStateUpdates) {
            this.unregisterAudioJackListener(this.context, this.mHeadsetPlugStateReceiver);
        }
        this.context = ctx.getApplicationContext();
        this.currentDeviceStatusHandler = statusHandler;
        LogUtils.write(a, "initialize::communicationChannel::" + this.commChannel.toString());
        this.mCommManager = CommunicationManagerBase.getInstance(this.commChannel, this.context);
        this.mDisplayControl = this.getDisplayControl();
        this.mKeyPadControl = this.getKeypadControl();
        if (this.commChannel == CommunicationManagerBase.DeviceCommunicationChannel.BLUETOOTH || this.commChannel == CommunicationManagerBase.DeviceCommunicationChannel.USB_TLV) {
            this.startOpenDeviceTask(null);
        } else if (this.supportsAudioJackInterface()) {
            this.registerAudioJackListener(this.context, this.mHeadsetPlugStateReceiver);
            this.isRegisteredForHeadsetPlugStateUpdates = true;
        }
        return super.initialize(ctx, statusHandler);
    }

    @Override
    public boolean initialize(Context context, boolean noDelay, DeviceStatusHandler statusHandler) {
        if (noDelay) {
            this.bluetoothCommParam = new BluetoothCommParam(13);
        }
        return this.initialize(context, statusHandler);
    }

    @Override
    public boolean release() {
        LogUtils.write(a, "release::" + this.commChannel.toString());
        if (this.supportsAudioJackInterface() && this.commChannel == CommunicationManagerBase.DeviceCommunicationChannel.AUDIOJACK && this.isRegisteredForHeadsetPlugStateUpdates) {
            this.unregisterAudioJackListener(this.context, this.mHeadsetPlugStateReceiver);
        }
        this.isRegisteredForHeadsetPlugStateUpdates = false;
        this.b = null;
        return super.release();
    }

    @Override
    public void searchDevices(Context ctx, Boolean includeBondedDevices, Long durationInMilliseconds, SearchListener listener) {
        this.searchDevices(ctx, includeBondedDevices, DEFAULT_DISCOVERY_DURATION_IN_MILLISECONDS, null, null, listener);
    }

    @Override
    public void searchDevices(Context ctx, Boolean includeBondedDevices, SearchListener listener) {
        this.searchDevices(ctx, includeBondedDevices, DEFAULT_DISCOVERY_DURATION_IN_MILLISECONDS, listener);
    }

    @Override
    public void searchDevices(Context ctx, SearchListener listener) {
        this.searchDevices(ctx, true, listener);
    }

    @Override
    public void searchDevices(Context ctx, Boolean includeBondedDevices, Long durationInMilliseconds, Short lowRssi, Short highRssi, SearchListener listener) {
        if (this.context == null) {
            this.context = ctx.getApplicationContext();
        }
        if (null != this.availableDevices) {
            this.availableDevices.clear();
        } else {
            this.availableDevices = new ArrayList<Device>();
        }
        this.b = listener;
        if (includeBondedDevices.booleanValue()) {
            new b().a();
        }
        CommunicationManagerBase.SearchMode searchMode = CommunicationManagerBase.SearchMode.AUDIOJACK;
        if (this.supportsAudioJackInterface() && this.supportsBluetoothInterface() && this.supportsUSBInterface()) {
            searchMode = CommunicationManagerBase.SearchMode.AUDIOJACK_BLUETOOTH_USB;
        } else if (this.supportsAudioJackInterface() && this.supportsBluetoothInterface()) {
            searchMode = CommunicationManagerBase.SearchMode.AUDIOJACK_BLUETOOTH;
        } else if (this.supportsAudioJackInterface() && this.supportsUSBInterface()) {
            searchMode = CommunicationManagerBase.SearchMode.AUDIOJACK_USB;
        } else if (this.supportsBluetoothInterface() && this.supportsUSBInterface()) {
            searchMode = CommunicationManagerBase.SearchMode.BLUETOOTH_USB;
        } else if (this.supportsBluetoothInterface()) {
            searchMode = CommunicationManagerBase.SearchMode.BLUETOOTH;
        } else if (this.supportsUSBInterface()) {
            searchMode = CommunicationManagerBase.SearchMode.USB;
        } else if (this.supportsAudioJackInterface()) {
            searchMode = CommunicationManagerBase.SearchMode.AUDIOJACK;
        }
        if (lowRssi != null && highRssi != null) {
            CommunicationManagerBase.searchDevices(this, searchMode, ctx, durationInMilliseconds, lowRssi, highRssi);
        } else {
            CommunicationManagerBase.searchDevices(this, searchMode, ctx, durationInMilliseconds);
        }
    }

    @Override
    public void cancelSearch() {
        this.b = null;
        CommunicationManagerBase.stopSearchDevices();
    }

    @Override
    public List<Device> getAvailableDevices() {
        ArrayList<Device> arrayList = new ArrayList<Device>();
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (null != bluetoothAdapter) {
            for (BluetoothDevice bluetoothDevice : bluetoothAdapter.getBondedDevices()) {
                Device device = new Device(this.getType(), CommunicationType.Bluetooth, bluetoothDevice.getName(), bluetoothDevice.getAddress());
                arrayList.add(device);
            }
        }
        return arrayList;
    }

    @Override
    public void discoverComplete() {
        if (this.b != null) {
            this.b.onDiscoveryComplete();
        }
    }

    @Override
    public void discoverOneDevice(DeviceInfo deviceInfo) {
        Device device = null;
        EnumMap<Parameter, Integer> enumMap = new EnumMap<Parameter, Integer>(Parameter.class);
        if (this.supportsAudioJackInterface() && deviceInfo.getDevChannel() == CommunicationManagerBase.DeviceCommunicationChannel.AUDIOJACK) {
            device = new Device(this.getType(), CommunicationType.AudioJack, "AUDIOJACK", "AUDIOJACK");
        } else if (deviceInfo.getDevChannel() == CommunicationManagerBase.DeviceCommunicationChannel.BLUETOOTH) {
            if (null != deviceInfo.getIdentifier()) {
                enumMap.put(Parameter.BluetoothDeviceRssi, deviceInfo.getRSSI());
                device = new Device(this.getType(), CommunicationType.Bluetooth, deviceInfo.getName(), deviceInfo.getIdentifier(), enumMap);
            }
        } else {
            UsbManager usbManager = (UsbManager)this.context.getSystemService("usb");
            UsbDevice usbDevice = (UsbDevice)usbManager.getDeviceList().get(deviceInfo.getName());
            enumMap.put(Parameter.UsbDeviceInfo, (Integer)usbDevice);
            device = new Device(this.getType(), CommunicationType.Usb, deviceInfo.getName(), deviceInfo.getIdentifier(), enumMap);
        }
        this.postAvailableDevice(device);
    }

    @Override
    public void updateFirmware(final String updateFilePath, final DeviceResponseHandler handler) {
        LogUtils.write(a, "Updating firmware via commChannel::" + (Object)((Object)this.commChannel));
        if (this.commChannel == CommunicationManagerBase.DeviceCommunicationChannel.USB_TLV) {
            this.openDeviceInUsbHidMode(new a(updateFilePath, handler));
        } else {
            new Thread(){

                @Override
                public void run() {
                    if (a.this.mCommManager != null) {
                        if (a.this.commChannel == CommunicationManagerBase.DeviceCommunicationChannel.USB_HID) {
                            new download().downLoad(a.this.mCommManager, updateFilePath, (DownloadCallback)new c(handler), true);
                        } else {
                            a.this.mCommManager.downLoad(updateFilePath, new c(handler));
                        }
                    } else {
                        a.this.postResponseOnUiThread(handler, a.this.createErrorResponseMap((Object)Command.UpdateFirmware, ErrorCode.ReaderNotInitialized));
                    }
                }
            }.start();
        }
    }

    @Override
    public void getDeviceStatistics(DeviceResponseHandler handler) {
        LandiReader.d d2 = new LandiReader.d(handler);
        new g(Command.DeviceStatistics, this.getDeviceStatisticsCommand(), this.mTimeout).a(this.shouldSetupConnection(), this, (h)d2);
    }

    @Override
    public void enableFirmwareUpdateMode(DeviceResponseHandler handler) {
        LandiReader.d d2 = new LandiReader.d(handler);
        new g(Command.EnableFirmwareUpdateMode, this.getEnableFirmwareUpdateCommand(), this.mTimeout).a(this.shouldSetupConnection(), this, (h)d2);
    }

    protected void postAvailableDevice(Device device) {
        if (null != device && !this.availableDevices.contains(device)) {
            LogUtils.write(a, "postAvailableDevice::" + device.toString());
            this.availableDevices.add(device);
            if (null != this.b) {
                this.b.onDeviceDiscovered(device);
            }
        }
    }

    private class a
    implements DeviceStatusHandler {
        String a;
        DeviceResponseHandler b;

        a(String string, DeviceResponseHandler deviceResponseHandler) {
            this.a = string;
            this.b = deviceResponseHandler;
        }

        @Override
        public void onConnected() {
            if (a.this.commChannel == CommunicationManagerBase.DeviceCommunicationChannel.USB_HID) {
                a.this.updateFirmware(this.a, this.b);
            } else {
                a.this.postResponseOnUiThread(this.b, a.this.createErrorResponseMap((Object)Command.UpdateFirmware, ErrorCode.ReaderNotInitialized));
            }
        }

        @Override
        public void onDisconnected() {
            a.this.postResponseOnUiThread(this.b, a.this.createErrorResponseMap((Object)Command.UpdateFirmware, ErrorCode.CardReaderNotConnected));
        }

        @Override
        public void onError(String message) {
            a.this.postResponseOnUiThread(this.b, a.this.createErrorResponseMap((Object)Command.UpdateFirmware, ErrorCode.CardReaderNotConnected));
        }
    }

    private class b
    extends AsyncTask<Void, Void, List<Device>> {
        private b() {
        }

        protected List<Device> a(Void ... voidArray) {
            ArrayList<Device> arrayList = new ArrayList<Device>();
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (null != bluetoothAdapter) {
                Set set = bluetoothAdapter.getBondedDevices();
                for (BluetoothDevice bluetoothDevice : set) {
                    if (null == bluetoothDevice.getAddress()) continue;
                    Device device = new Device(a.this.getType(), CommunicationType.Bluetooth, bluetoothDevice.getName(), bluetoothDevice.getAddress());
                    arrayList.add(device);
                }
            }
            return arrayList;
        }

        protected void a(List<Device> list) {
            for (Device device : list) {
                a.this.postAvailableDevice(device);
            }
        }

        @SuppressLint(value={"NewApi"})
        protected void a() {
            this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((List)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Void[])objectArray);
        }
    }

    private class c
    implements DownloadCallback {
        private DeviceResponseHandler b;

        private c(DeviceResponseHandler deviceResponseHandler) {
            this.b = deviceResponseHandler;
        }

        @Override
        public void onDownloadProgress(int arg0, int arg1) {
            LogUtils.write(a, "onDownloadProgress::" + arg0 + "/" + arg1);
            a.this.postProgressOnUiThread(this.b, ProgressMessage.UpdatingFirmware, arg0 + "/" + arg1);
        }

        @Override
        public void onDownloadError(int arg0) {
            ErrorCode errorCode;
            LogUtils.write(a, "onDownloadError::" + arg0);
            switch (arg0) {
                case -11: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_BLUETOOTH_DISCONNECTED;
                    a.this.postDeviceStatusOnUiThread(a.this.currentDeviceStatusHandler, false, null);
                    break;
                }
                case -6: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_DEVICE_NOT_OPEN;
                    break;
                }
                case -10: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_EXCHANGE_ERROR_STATE;
                    break;
                }
                case -5: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_FILE_OPERATE_FAILED;
                    break;
                }
                case -4: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_FILEPATH_WRONG;
                    break;
                }
                case -3: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_HANDSHAKE_FAILED;
                    break;
                }
                case -12: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_HANDSHAKE_TIMEOUT;
                    break;
                }
                case -1: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_NOT_SURPPORT_FILE_TYPE;
                    break;
                }
                case -7: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_IS_DOWNLOADING_STATE;
                    break;
                }
                case -8: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_NO_RESPOND_ACK;
                    break;
                }
                case -2: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_NOT_SURPPORT_FILE_TYPE_IN_UNS;
                    break;
                }
                case -15: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_SUSPEND_FAILED;
                    break;
                }
                case -14: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_SUSPEND_OK;
                    break;
                }
                case -13: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_UNS_FILE_CRC_ERROR;
                    break;
                }
                case -9: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_WRONG_FRAM;
                    break;
                }
                default: {
                    errorCode = ErrorCode.DOWNLOAD_ERROR_UNKNOWN_ERROR;
                }
            }
            EnumMap<Parameter, Enum> enumMap = new EnumMap<Parameter, Enum>(Parameter.class);
            enumMap.put(Parameter.Command, Command.UpdateFirmware);
            enumMap.put(Parameter.ResponseCode, ResponseCode.Error);
            enumMap.put(Parameter.ErrorCode, errorCode);
            a.this.postResponseOnUiThread(this.b, enumMap);
            this.b = null;
        }

        @Override
        public void onDownloadComplete() {
            LogUtils.write(a, "onDownloadComplete");
            EnumMap<Parameter, Enum> enumMap = new EnumMap<Parameter, Enum>(Parameter.class);
            enumMap.put(Parameter.Command, Command.UpdateFirmware);
            enumMap.put(Parameter.ResponseCode, ResponseCode.Success);
            a.this.postResponseOnUiThread(this.b, enumMap);
            this.b = null;
            a.this.postDeviceStatusOnUiThread(a.this.currentDeviceStatusHandler, false, null);
        }
    }
}

